/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.rat.ConfigurationException;
import org.apache.rat.DeprecationReporter;
import org.apache.rat.ImplementationException;
import org.apache.rat.OptionCollection;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.anttasks.BaseAntTask;
import org.apache.rat.anttasks.Family;
import org.apache.rat.anttasks.License;
import org.apache.rat.anttasks.ResourceCollectionContainer;
import org.apache.rat.commandline.Arg;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.document.DocumentName;
import org.apache.rat.help.Licenses;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;

public class Report
extends BaseAntTask {
    @Deprecated
    private final List<License> licenses = new ArrayList<License>();
    @Deprecated
    private final List<Family> families = new ArrayList<Family>();
    private final DeprecatedConfig deprecatedConfig = new DeprecatedConfig();
    private Union nestedResources;

    public Report() {
        Log oldLog = DefaultLog.getInstance();
        if (oldLog instanceof DefaultLog) {
            DefaultLog.setInstance(new Logger());
            DefaultLog.getInstance().setLevel(oldLog.getLevel());
        }
    }

    public void add(ResourceCollection rc) {
        if (this.nestedResources == null) {
            this.nestedResources = new Union();
        }
        this.nestedResources.add(rc);
    }

    @Deprecated
    public void setInputFileFilter(IOFileFilter inputFileFilter) {
        DeprecationReporter.logDeprecated("element inputFileFilter", "0.17", true, "outputFile element");
        this.deprecatedConfig.inputFileFilter = inputFileFilter;
    }

    @Deprecated
    public void setReportFile(File reportFile) {
        DeprecationReporter.logDeprecated("element reportFile", "0.17", true, "outputFile element");
        this.addArg("output-file", reportFile.getAbsolutePath());
    }

    @Deprecated
    public void addLicense(License license) {
        this.licenses.add(license);
    }

    @Deprecated
    public void addFamily(Family family) {
        this.families.add(family);
    }

    @Deprecated
    public void addStylesheet(Resource styleSheet) {
        DeprecationReporter.logDeprecated("element stylesheet", "0.17", true, "<outputStyle> element");
        this.setStylesheet(styleSheet.getName());
    }

    @Deprecated
    public void addStyleSheet(Resource styleSheet) {
        DeprecationReporter.logDeprecated("attribute styleSheet", "0.17", true, "<outputStyle> element");
        this.setOutputStyle(styleSheet.getName());
    }

    @Deprecated
    public void setStyleReport(boolean styleReport) {
        this.setOutputStyle(styleReport ? "xml" : "plain-rat");
    }

    @Deprecated
    public void setFormat(String style) {
        DeprecationReporter.logDeprecated("attribute format", "0.17", true, "outputStyle element");
        if ("styled".equalsIgnoreCase(style)) {
            this.setOutputStyle("plain-rat");
        } else {
            this.setOutputStyle(style);
        }
    }

    @Deprecated
    public void setLicenses(File fileName) {
        DeprecationReporter.logDeprecated("attribute licenses", "0.17", true, "<licences> element");
        this.setArg(Arg.CONFIGURATION.option().getLongOpt(), fileName.getAbsolutePath());
    }

    @Deprecated
    public void setUseDefaultLicenses(boolean useDefaultLicenses) {
        DeprecationReporter.logDeprecated("attribute useDefaultLicenses", "0.17", true, "noDefaultLicenses attribute");
        this.setNoDefaultLicenses(!useDefaultLicenses);
    }

    @Deprecated
    public void setAddApprovedLicense(String familyCategory) {
        DeprecationReporter.logDeprecated("attribute addApprovedLicense", "0.17", true, "<licensesApproved> element");
        this.deprecatedConfig.approvedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void addAddApprovedLicense(String familyCategory) {
        DeprecationReporter.logDeprecated("element <addApprovedLicense>", "0.17", true, "<licenseFamiliesApproved> element");
        this.deprecatedConfig.approvedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void setRemoveApprovedLicense(String familyCategory) {
        DeprecationReporter.logDeprecated("attribute addApprovedLicense", "0.17", true, "<licenseFamiliesApproved> element");
        this.deprecatedConfig.removedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void addRemoveApprovedLicense(String familyCategory) {
        DeprecationReporter.logDeprecated("element <removeApprovedLicense>", "0.17", true, "<licenseFamiliesDenied> element");
        this.deprecatedConfig.removedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void setRemoveApprovedLicense(String[] familyCategory) {
        DeprecationReporter.logDeprecated("attribute removeApprovedLicense", "0.17", true, "<licenseFamiliesDenied> element");
        this.deprecatedConfig.removedLicenseCategories.addAll(Arrays.asList(familyCategory));
    }

    @Deprecated
    public void addRemoveApprovedLicense(String[] familyCategory) {
        DeprecationReporter.logDeprecated("element <removeApprovedLicense>", "0.17", true, "<licenseFamiliesDenied> element");
        this.deprecatedConfig.removedLicenseCategories.addAll(Arrays.asList(familyCategory));
    }

    @Deprecated
    public void setCopyrightMessage(String copyrightMessage) {
        this.setCopyright(copyrightMessage);
    }

    @Deprecated
    public void setAddLicenseHeaders(AddLicenseHeaders setting) {
        DeprecationReporter.logDeprecated("attribute addLicenseHeaders", "0.17", true, "editLicense and editOverwrite attributes");
        switch (setting.getNative()) {
            case TRUE: {
                this.setEditLicense(true);
                break;
            }
            case FALSE: {
                this.setEditLicense(false);
                break;
            }
            case FORCED: {
                this.setEditLicense(true);
                this.setEditOverwrite(true);
            }
        }
    }

    @Deprecated
    public void setAddDefaultDefinitions(File fileName) {
        DeprecationReporter.logDeprecated("element <addDefaultDefinitions>", "0.17", true, "<config> element");
        this.setArg(Arg.CONFIGURATION.option().getLongOpt(), fileName.getAbsolutePath());
    }

    protected List<String> getValues(Arg arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (Option option : arg.group().getOptions()) {
            List<String> args;
            if (option.getLongOpt() == null || (args = this.getArg(option.getLongOpt())) == null) continue;
            result.addAll(args);
        }
        return result;
    }

    protected void removeKey(Arg arg) {
        for (Option option : arg.group().getOptions()) {
            if (option.getLongOpt() == null) continue;
            this.removeArg(option.getLongOpt());
        }
    }

    public ReportConfiguration getConfiguration() {
        try {
            boolean helpLicenses = !this.getValues(Arg.HELP_LICENSES).isEmpty();
            this.removeKey(Arg.HELP_LICENSES);
            ReportConfiguration configuration = OptionCollection.parseCommands(new File("."), this.args().toArray(new String[0]), o -> DefaultLog.getInstance().warn("Help option not supported"), true);
            if (this.getValues(Arg.OUTPUT_FILE).isEmpty()) {
                configuration.setOut(() -> new LogOutputStream((Task)this, 2));
            }
            DocumentName name = DocumentName.builder(this.getProject().getBaseDir()).build();
            configuration.addSource(new ResourceCollectionContainer(name, configuration, (ResourceCollection)this.nestedResources));
            configuration.addApprovedLicenseCategories(this.deprecatedConfig.approvedLicenseCategories);
            configuration.removeApprovedLicenseCategories(this.deprecatedConfig.removedLicenseCategories);
            if (this.deprecatedConfig.inputFileFilter != null) {
                configuration.addExcludedFilter(this.deprecatedConfig.inputFileFilter);
            }
            this.families.stream().map(Family::build).forEach(configuration::addFamily);
            this.licenses.stream().map(License::asBuilder).forEach(l -> configuration.addApprovedLicenseCategory(configuration.addLicense((ILicense.Builder)l).getLicenseFamily()));
            if (helpLicenses) {
                new Licenses(configuration, new PrintWriter(DefaultLog.getInstance().asWriter())).printHelp();
            }
            return configuration;
        }
        catch (IOException | ImplementationException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void execute() {
        try {
            Reporter r = new Reporter(this.validate(this.getConfiguration()));
            r.output(StyleSheets.PLAIN.getStyleSheet(), () -> new ReportConfiguration.NoCloseOutputStream(System.out));
            r.output();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception ioex) {
            throw new BuildException((Throwable)ioex);
        }
    }

    protected ReportConfiguration validate(ReportConfiguration cfg) {
        try {
            cfg.validate((String s) -> this.log((String)s, 1));
        }
        catch (ConfigurationException e) {
            throw new BuildException(e.getMessage(), e.getCause());
        }
        if (this.nestedResources == null) {
            throw new BuildException("You must specify at least one file to create the report for.");
        }
        return cfg;
    }

    public void log(String msg, int msgLevel) {
        if (this.getProject() != null) {
            this.getProject().log(msg, msgLevel);
        } else {
            DefaultLog.createDefault().log(Report.fromProjectLevel(msgLevel), msg);
        }
    }

    public void log(String msg, Throwable t, int msgLevel) {
        if (this.getProject() == null) {
            this.log(Log.formatLogEntry(msg, t), msgLevel);
        } else {
            this.getProject().log((Task)this, msg, t, msgLevel);
        }
    }

    public static Log.Level fromProjectLevel(int level) {
        switch (level) {
            case 3: 
            case 4: {
                return Log.Level.DEBUG;
            }
            case 2: {
                return Log.Level.INFO;
            }
            case 1: {
                return Log.Level.WARN;
            }
            case 0: {
                return Log.Level.ERROR;
            }
        }
        return Log.Level.OFF;
    }

    static int toProjectLevel(Log.Level level) {
        switch (level) {
            case DEBUG: {
                return 4;
            }
            case INFO: {
                return 2;
            }
            case WARN: {
                return 1;
            }
            case ERROR: {
                return 0;
            }
        }
        return -1;
    }

    private static final class DeprecatedConfig {
        private IOFileFilter inputFileFilter;
        private final Set<String> approvedLicenseCategories = new HashSet<String>();
        private final Set<String> removedLicenseCategories = new HashSet<String>();

        private DeprecatedConfig() {
        }
    }

    private final class Logger
    implements Log {
        private Logger() {
        }

        @Override
        public Log.Level getLevel() {
            return Log.Level.DEBUG;
        }

        @Override
        public void log(Log.Level level, String message, Throwable throwable) {
            this.log(level, Log.formatLogEntry(message, throwable));
        }

        @Override
        public void log(Log.Level level, String msg) {
            Report.this.log(msg, Report.toProjectLevel(level));
        }
    }

    @Deprecated
    public static class AddLicenseHeaders
    extends EnumeratedAttribute {
        static final String TRUE = "true";
        static final String FALSE = "false";
        static final String FORCED = "forced";

        public AddLicenseHeaders() {
        }

        public AddLicenseHeaders(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{TRUE, FALSE, FORCED};
        }

        public org.apache.rat.config.AddLicenseHeaders getNative() {
            return org.apache.rat.config.AddLicenseHeaders.valueOf(this.getValue().toUpperCase());
        }
    }

    @Deprecated
    public static class ApprovalFilter
    extends EnumeratedAttribute {
        public ApprovalFilter() {
        }

        public ApprovalFilter(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return Arrays.stream(LicenseSetFactory.LicenseFilter.values()).map(Enum::name).collect(Collectors.toList()).toArray(new String[LicenseSetFactory.LicenseFilter.values().length]);
        }

        public LicenseSetFactory.LicenseFilter internalFilter() {
            return LicenseSetFactory.LicenseFilter.valueOf(this.getValue());
        }
    }
}

