/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.configuration.Format;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.DefaultLog;

public final class Defaults {
    private static final URI DEFAULT_CONFIG_URI;
    private static final String DEFAULT_CONFIG_PATH = "/org/apache/rat/default.xml";
    public static final ReportConfiguration.Processing ARCHIVE_PROCESSING;
    public static final ReportConfiguration.Processing STANDARD_PROCESSING;
    public static final LicenseSetFactory.LicenseFilter LIST_FAMILIES;
    public static final LicenseSetFactory.LicenseFilter LIST_LICENSES;
    private final LicenseSetFactory setFactory;

    public static void init() {
        Format fmt = Format.from(DEFAULT_CONFIG_URI);
        MatcherReader mReader = fmt.matcherReader();
        if (mReader != null) {
            mReader.addMatchers(DEFAULT_CONFIG_URI);
            mReader.readMatcherBuilders();
        } else {
            DefaultLog.getInstance().error("Unable to construct MatcherReader from " + DEFAULT_CONFIG_URI);
        }
    }

    private Defaults(Set<URI> uris) {
        this.setFactory = Defaults.readConfigFiles(uris);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static LicenseSetFactory readConfigFiles(Collection<URI> uris) {
        TreeSet<ILicense> licenses = new TreeSet<ILicense>();
        TreeSet approvedLicenseCategories = new TreeSet();
        for (URI uri : uris) {
            LicenseReader lReader;
            Format fmt = Format.from(uri);
            MatcherReader mReader = fmt.matcherReader();
            if (mReader != null) {
                mReader.addMatchers(uri);
                mReader.readMatcherBuilders();
            }
            if ((lReader = fmt.licenseReader()) == null) continue;
            lReader.addLicenses(uri);
            licenses.addAll(lReader.readLicenses());
            lReader.approvedLicenseId().stream().map(ILicenseFamily::makeCategory).forEach(approvedLicenseCategories::add);
        }
        LicenseSetFactory result = new LicenseSetFactory(licenses);
        approvedLicenseCategories.forEach(result::addLicenseCategory);
        return result;
    }

    public LicenseSetFactory getLicenseSetFactory() {
        return this.setFactory;
    }

    public Collection<StandardCollection> getStandardExclusion() {
        return Arrays.asList(StandardCollection.MISC, StandardCollection.HIDDEN_DIR);
    }

    static {
        ARCHIVE_PROCESSING = ReportConfiguration.Processing.NOTIFICATION;
        STANDARD_PROCESSING = ReportConfiguration.Processing.ABSENCE;
        LIST_FAMILIES = LicenseSetFactory.LicenseFilter.NONE;
        LIST_LICENSES = LicenseSetFactory.LicenseFilter.NONE;
        URL url = Defaults.class.getResource(DEFAULT_CONFIG_PATH);
        URI uri = null;
        if (url == null) {
            DefaultLog.getInstance().error(String.format("Unable to read '%s'", DEFAULT_CONFIG_PATH));
        } else {
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                DefaultLog.getInstance().error("Unable to read " + url, e);
            }
        }
        DEFAULT_CONFIG_URI = uri;
    }

    public static final class Builder {
        private final Set<URI> fileNames = new TreeSet<URI>();

        private Builder() {
            if (DEFAULT_CONFIG_URI == null) {
                DefaultLog.getInstance().error("Unable to read default.xml");
            } else {
                this.fileNames.add(DEFAULT_CONFIG_URI);
            }
        }

        public Builder add(URI uri) {
            this.fileNames.add(uri);
            return this;
        }

        public Builder add(String fileName) throws MalformedURLException {
            return this.add(new File(fileName));
        }

        public Builder add(File file) {
            return this.add(file.toURI());
        }

        public Builder remove(URI uri) {
            this.fileNames.remove(uri);
            return this;
        }

        public Builder remove(String fileName) throws MalformedURLException {
            return this.remove(new File(fileName));
        }

        public Builder remove(File file) {
            return this.remove(file.toURI());
        }

        public Builder noDefault() {
            return this.remove(DEFAULT_CONFIG_URI);
        }

        public Defaults build() {
            return new Defaults(this.fileNames);
        }
    }
}

