/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.guesser;

import java.util.Arrays;
import java.util.Locale;
import org.apache.rat.api.Document;

public final class NoteGuesser {
    private static final String DOT = ".";
    private static final String[] NOTE_FILE_NAMES = new String[]{"NOTICE", "LICENSE", "LICENSE.TXT", "NOTICE.TXT", "INSTALL", "INSTALL.TXT", "README", "README.TXT", "NEWS", "NEWS.TXT", "AUTHOR", "AUTHOR.TXT", "AUTHORS", "AUTHORS.txt", "CHANGELOG", "CHANGELOG.TXT", "DISCLAIMER", "DISCLAIMER.TXT", "KEYS", "KEYS.TXT", "RELEASE-NOTES", "RELEASE-NOTES.TXT", "RELEASE_NOTES", "RELEASE_NOTES.TXT", "UPGRADE", "UPGRADE.TXT", "STATUS", "STATUS.TXT", "THIRD_PARTY_NOTICES", "THIRD_PARTY_NOTICES.TXT", "COPYRIGHT", "COPYRIGHT.TXT", "BUILDING", "BUILDING.TXT", "BUILD", "BUILT.TXT", "DEPENDENCIES"};
    private static final String[] NOTE_FILE_EXTENSIONS = new String[]{"LICENSE", "LICENSE.TXT", "NOTICE", "NOTICE.TXT"};

    private NoteGuesser() {
    }

    public static boolean isNote(Document document) {
        if (document == null) {
            return false;
        }
        String normalisedName = document.getName().getShortName().toUpperCase(Locale.US);
        if (Arrays.asList(NOTE_FILE_NAMES).contains(normalisedName)) {
            return true;
        }
        for (String extension : NOTE_FILE_EXTENSIONS) {
            if (!normalisedName.endsWith(DOT + extension)) continue;
            return true;
        }
        return false;
    }
}

