/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.rat.api.Document;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.license.ILicenseFamily;

public class DefaultPolicy
implements IDocumentAnalyser {
    private final SortedSet<ILicenseFamily> approvedLicenseFamilies = new TreeSet<ILicenseFamily>();

    public DefaultPolicy(Collection<ILicenseFamily> approvedLicenseFamilies) {
        this.approvedLicenseFamilies.addAll(approvedLicenseFamilies);
    }

    public void add(ILicenseFamily approvedLicense) {
        this.approvedLicenseFamilies.add(approvedLicense);
    }

    @Override
    public void analyse(Document document) {
        if (document != null) {
            document.getMetaData().setApprovedLicenses(this.getApprovedLicenseFamilies());
        }
    }

    public SortedSet<ILicenseFamily> getApprovedLicenseFamilies() {
        return Collections.unmodifiableSortedSet(this.approvedLicenseFamilies);
    }
}

