/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IntArray
implements Externalizable,
Comparable {
    private int[] _data;

    public IntArray() {
    }

    public IntArray(int[] data) {
        this._data = data;
    }

    public static IntArray makeIntArray(int ... values) {
        return new IntArray(values);
    }

    public static IntArray makeIntArray(int length) {
        return new IntArray(new int[length]);
    }

    public static IntArray setCell(IntArray array, int cellNumber, int cellValue) {
        array._data[cellNumber] = cellValue;
        return array;
    }

    public static int getCell(IntArray array, int cellNumber) {
        return array._data[cellNumber];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int length = this._data.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = in.readInt();
        this._data = new int[length];
        for (int i = 0; i < length; ++i) {
            this._data[i] = in.readInt();
        }
    }

    public int compareTo(Object other) {
        int result;
        if (other == null) {
            return -1;
        }
        if (!(other instanceof IntArray)) {
            return -1;
        }
        IntArray that = (IntArray)other;
        int minLength = this._data.length <= that._data.length ? this._data.length : that._data.length;
        for (int i = 0; i < minLength; ++i) {
            result = this._data[i] - that._data[i];
            if (result == 0) continue;
            return result;
        }
        result = this._data.length - that._data.length;
        return result;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int secondValue;
        int firstValue;
        if (this._data.length == 0) {
            firstValue = 1;
            secondValue = 1;
        } else {
            firstValue = this._data[0];
            secondValue = this._data[this._data.length - 1];
        }
        return firstValue ^ secondValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int length = this._data.length;
        buffer.append("[ ");
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this._data[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

