/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;

public class SysinfoCPCheckTest
extends BaseJDBCTestCase {
    private static boolean isClient = true;
    private static boolean isServer = true;

    public SysinfoCPCheckTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        if (!Derby.hasServer()) {
            isServer = false;
        }
        if (!Derby.hasClient()) {
            isClient = false;
        }
        BaseTestSuite suite = new BaseTestSuite(SysinfoCPCheckTest.class, "Sysinfo ClassPath Checker");
        return new LocaleTestSetup((Test)suite, Locale.ENGLISH);
    }

    public void testClassPathChecker() throws IOException {
        String Success = "Success: All Derby related classes found in class path.";
        String thisclass = "org.apache.derbyTesting.functionTests.tests.tools.SysinfoCPCheckTest.class";
        String[][] tstargs = new String[][]{{null, "0", "Testing for presence of all Derby-related libraries; typically, only some are needed.", null}, {"a", "0", "Usage: java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [ anyClass.class ] ]", null}, {"embedded", "6", Success, "derby.jar"}, {"server", "10", Success, "derbynet.jar"}, {"tools", "6", Success, "derbytools.jar"}, {"client", "6", Success, "derbyclient.jar"}, {thisclass, "6", Success, "SysinfoCPCheckTest"}, {"nonexist.class", "6", "    (nonexist not found.)", null}};
        PrintStream out = System.out;
        int tst = 0;
        for (tst = 0; tst < tstargs.length; ++tst) {
            ByteArrayOutputStream rawBytes = this.getOutputStream();
            PrintStream testOut = new PrintStream(rawBytes, false);
            SysinfoCPCheckTest.setSystemOut(testOut);
            if (!this.checkClientOrServer(tstargs[tst][0])) continue;
            if (tstargs[tst][0] == null) {
                sysinfo.main((String[])new String[]{"-cp"});
            } else {
                sysinfo.main((String[])new String[]{"-cp", tstargs[tst][0]});
            }
            SysinfoCPCheckTest.setSystemOut(out);
            rawBytes.flush();
            rawBytes.close();
            byte[] testRawBytes = rawBytes.toByteArray();
            String s = null;
            try {
                BufferedReader sysinfoOutput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(testRawBytes)));
                if (tstargs[tst][0] == null) {
                    s = sysinfoOutput.readLine();
                    SysinfoCPCheckTest.assertEquals((String)tstargs[tst][2], (String)s);
                    while (s != null) {
                        s = sysinfoOutput.readLine();
                    }
                    continue;
                }
                if (!this.checkClientOrServer(tstargs[tst][0])) continue;
                int linenumber = Integer.parseInt(tstargs[tst][1]);
                boolean found = false;
                for (int i = 0; i < linenumber; ++i) {
                    s = sysinfoOutput.readLine();
                    if (tstargs[tst][3] == null || s.indexOf(tstargs[tst][3]) <= 0) continue;
                    found = true;
                }
                if (tstargs[tst][3] != null && !found) {
                    SysinfoCPCheckTest.fail((String)("did not find the string searched for: " + tstargs[tst][3] + " for command -cp: " + tstargs[tst][0]));
                }
                if ((s = sysinfoOutput.readLine()) == null) {
                    SysinfoCPCheckTest.fail((String)"encountered unexpected null strings");
                } else {
                    SysinfoCPCheckTest.assertEquals((String)tstargs[tst][2], (String)s);
                }
                s = sysinfoOutput.readLine();
                sysinfoOutput.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkClientOrServer(String kind) {
        if (kind == null) {
            return true;
        }
        if ((kind.equals("server") || kind.equals("client")) && JDBC.vmSupportsJSR169()) {
            return false;
        }
        if (kind.equals("server")) {
            return isServer;
        }
        if (kind.equals("client")) {
            return isClient;
        }
        return true;
    }

    ByteArrayOutputStream getOutputStream() {
        return new ByteArrayOutputStream(20480);
    }

    public void testjavaVersion() {
        SysinfoCPCheckTest.assertEquals((int)9, (int)JVMInfo.JDK_ID);
    }

    public void testderbyVMLevel() {
        switch (JVMInfo.JDK_ID) {
            case 9: {
                SysinfoCPCheckTest.assertEquals((String)"Java SE 8 - JDBC 4.2", (String)JVMInfo.derbyVMLevel());
                break;
            }
            default: {
                SysinfoCPCheckTest.assertEquals((String)"?-?", (String)JVMInfo.derbyVMLevel());
            }
        }
    }

    public void testisSunJVM() {
        if (JVMInfo.isSunJVM()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.isSunJVM());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.isSunJVM());
        }
    }

    public void testisIBMJVM() {
        if (JVMInfo.isIBMJVM()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.isIBMJVM());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.isIBMJVM());
        }
    }

    public void testhasJNDI() {
        if (JVMInfo.hasJNDI()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.hasJNDI());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.hasJNDI());
        }
    }
}

