/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.impl.tools.sysinfo.Main;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;
import org.apache.derby.shared.common.info.JVMInfo;

public abstract class jvm {
    private static final String JAVA_CLASS_VERSION = "java.class.version";
    private static final int JDK_18_CLASS_VERSION = 62;
    public String flags = null;
    public boolean noasyncgc = false;
    public boolean verbosegc = false;
    public boolean noclassgc = false;
    public long ss = -1L;
    public long oss = -1L;
    public long ms = -1L;
    public long mx = -1L;
    public String classpath = null;
    public String prof = null;
    public boolean verify = false;
    public boolean noverify = false;
    public boolean nojit = false;
    public Vector<String> D = null;
    public String javaCmd = "java";
    public String majorVersion = "";
    public String minorVersion = "";
    public int imajor = 0;
    public int iminor = 0;
    String hostName;
    private static String DEFAULT_CODEBASE = "/classes";
    int verboselevel = -1;

    public jvm() {
    }

    public jvm(boolean bl, boolean bl2, boolean bl3, long l, long l2, long l3, long l4, String string, String string2, boolean bl4, boolean bl5, boolean bl6, Vector<String> vector) {
        this.noasyncgc = bl;
        this.noclassgc = bl3;
        this.verbosegc = bl2;
        this.ss = l;
        this.oss = l2;
        this.ms = l3;
        this.mx = l4;
        this.classpath = string;
        this.prof = string2;
        this.verify = bl4;
        this.noverify = bl5;
        this.nojit = bl6;
        this.D = vector;
    }

    public jvm(String string, Vector<String> vector) {
        this.classpath = string;
        this.D = vector;
    }

    public jvm(long l, long l2, String string, Vector<String> vector) {
        this.ms = l;
        this.mx = l2;
        this.classpath = string;
        this.D = vector;
    }

    public abstract String getDintro();

    public abstract String getName();

    public void setNoasyncgc(boolean bl) {
        this.noasyncgc = bl;
    }

    public void setNoclassgc(boolean bl) {
        this.noclassgc = bl;
    }

    public void setVerbosegc(boolean bl) {
        this.verbosegc = bl;
    }

    public void setSs(long l) {
        this.ss = l;
    }

    public void setOss(long l) {
        this.oss = l;
    }

    public void setMs(long l) {
        this.ms = l;
    }

    public void setMx(long l) {
        this.mx = l;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setProf(String string) {
        this.prof = string;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public void setNoverify(boolean bl) {
        this.noverify = bl;
    }

    public void setNojit(boolean bl) {
        this.nojit = bl;
    }

    public void setD(Vector<String> vector) {
        this.D = vector;
    }

    public void setFlags(String string) {
        this.flags = string;
    }

    public void setJavaCmd(String string) {
        this.javaCmd = string;
    }

    public static boolean isAtLeastJDK18() {
        int n = Double.valueOf(System.getProperty(JAVA_CLASS_VERSION)).intValue();
        return n >= 62;
    }

    public Vector<String> getCommandLine() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.javaCmd);
        vector.addElement("-Duser.language=en");
        vector.addElement("-Duser.country=US");
        if (this.flags != null && this.flags.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.flags);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public void warn(String string) {
        if (this.verboselevel == -1) {
            try {
                this.verboselevel = Integer.parseInt(System.getProperty("verbose"));
            }
            catch (Exception exception) {
                this.verboselevel = 0;
            }
        }
        if (this.verboselevel > 0) {
            System.out.println("jvm: " + string);
        }
    }

    public static jvm getJvm(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        jvm jvm2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            jvm2 = (jvm)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = Class.forName("org.apache.derbyTesting.functionTests.harness." + string);
            jvm2 = (jvm)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return jvm2;
    }

    public static jvm getCurrentJvm() throws Exception {
        String string = System.getProperty("jvm");
        if (string == null || string.length() == 0) {
            String string2 = System.getProperty("java.version");
            string = string2.startsWith("1.2") ? "jdk12" : "currentjvm";
        }
        return jvm.getJvm(string);
    }

    public int getMajorVersion() {
        return this.imajor;
    }

    public int getMinorVersion() {
        return this.iminor;
    }

    public void setVersion() throws Exception {
        String string = System.getProperty("java.version");
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        this.majorVersion = string.substring(0, n);
        this.minorVersion = string.substring(n + 1, n2);
        Integer n3 = Integer.valueOf(this.minorVersion);
        this.iminor = n3;
        Integer n4 = Integer.valueOf(this.majorVersion);
        this.imajor = n4;
        Object object = System.getProperty("jvm");
        if (object == null || ((String)object).length() == 0) {
            object = this.iminor < 2 ? "currentjvm" : "jdk" + this.majorVersion + this.minorVersion;
        }
    }

    protected static String guessWSHome() {
        String string;
        String string2 = "";
        String string3 = System.getProperty("java.home");
        int n = string3.indexOf((string = System.getProperty("file.separator")) + "jre");
        if (n > 0 && (string2 = string3.substring(0, string3.indexOf(string + "jre"))).lastIndexOf(string) >= 0) {
            string2 = string2.substring(0, string2.lastIndexOf(string));
        }
        if (string3.lastIndexOf(string) >= 0) {
            string2 = string3.substring(0, string3.lastIndexOf(string));
        }
        return string2;
    }

    public static String findCodeBase(boolean[] blArray) {
        String string = JVMInfo.isModuleAware() ? JVMInfo.getSystemModulePath() : System.getProperty("java.class.path");
        int n = 47;
        ZipInfoProperties[] zipInfoPropertiesArray = Main.getAllInfo((String)string);
        for (int i = 0; i < zipInfoPropertiesArray.length; ++i) {
            String string2 = zipInfoPropertiesArray[i].getLocation().replace('\\', '/');
            if (string2.indexOf("derbynet.jar") != -1) {
                blArray[0] = true;
                return string2.substring(0, string2.lastIndexOf(n));
            }
            if (string2.indexOf("classes") == -1 || string2.indexOf(".jar") != -1) continue;
            blArray[0] = false;
            return string2;
        }
        return null;
    }

    protected void setSecurityProps() throws IOException, ClassNotFoundException {
        this.D = jvm.getSecurityProps(this.D);
    }

    static Vector<String> getSecurityProps(Vector<String> vector) throws ClassNotFoundException, IOException {
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    private static String baseName(String string) {
        return string.substring(string.lastIndexOf("/"), string.length());
    }
}

