/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AutoGenJDBC30Test
extends BaseJDBCTestCase {
    private static final String[] ROUTINES = new String[]{"CREATE FUNCTION MMWNI() RETURNS VARCHAR(20) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + AutoGenJDBC30Test.class.getName() + ".MyMethodWithNoInsert'", "CREATE FUNCTION AddMe(P1 INT) RETURNS INT READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + AutoGenJDBC30Test.class.getName() + ".addMe'"};
    private static final String[][] TABLES = new String[][]{{"t11_AutoGen", "create table t11_AutoGen (c11 int, c12 int generated always as identity (increment by 1))"}, {"t31_AutoGen", "create table t31_AutoGen (c31 int, c32 int generated always as identity (increment by 1), c33 int default 2)"}, {"t21_noAutoGen", "create table t21_noAutoGen (c21 int not null unique, c22 char(5))"}, {"t21_feed_table", "create table t21_feed_table (c21 int not null unique, c22 char(5))"}};

    public AutoGenJDBC30Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AutoGenJDBC30Test");
        baseTestSuite.addTest(AutoGenJDBC30Test.baseSuite("AutoGenJDBC30Test:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(AutoGenJDBC30Test.baseSuite("AutoGenJDBC30Test:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        if (!JDBC.vmSupportsJDBC3()) {
            return baseTestSuite;
        }
        baseTestSuite.addTestSuite(AutoGenJDBC30Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                for (n = 0; n < ROUTINES.length; ++n) {
                    statement.execute(ROUTINES[n]);
                }
                for (n = 0; n < TABLES.length; ++n) {
                    statement.execute(TABLES[n][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            statement.execute("DELETE FROM " + TABLES[i][0]);
        }
        statement.execute("ALTER TABLE t11_AutoGen ALTER COLUMN c12 RESTART WITH 1");
        statement.execute("ALTER TABLE t31_AutoGen ALTER COLUMN c32 RESTART WITH 1");
        statement.close();
        connection.commit();
    }

    public void testNoSql() throws SQLException {
        Statement statement = this.createStatement();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet", (Object)statement.getGeneratedKeys());
        statement.close();
    }

    public void testSelect() throws SQLException {
        String string = "select * from t11_AutoGen";
        Statement statement = this.createStatement();
        statement.execute(string, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testInsertManyRowsNoPriorKey() throws SQLException {
        String string = "insert into t31_AutoGen(c31) values (99), (98), (97)";
        this.runInsertFourWaysKeyIsNull(string);
    }

    public void testUpdateManyRowsAfterOneRowKey() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values (99)", 1);
        int n = 1;
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.execute("update t11_AutoGen set c12=default where c11=99", 1);
        n = 2;
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        String string = "insert into t11_AutoGen(c11) values (99), (98), (97)";
        statement.execute(string, 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.execute("update t11_AutoGen set c12=default where c11=97", 1);
        n = 6;
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.execute("update t11_AutoGen set c12=default where c11=99", 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
    }

    public void testInsertManyRowsAfterOneRowKey() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values (99)");
        int n = 1;
        String string = "insert into t31_AutoGen(c31) values (99), (98), (97)";
        statement.execute(string, 1);
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.executeUpdate(string, 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)n, (int)n2);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)n, (int)n2);
        preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.executeUpdate();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)n, (int)n2);
        preparedStatement.close();
    }

    public void testInsertNoAutoGen() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen values(21, 'true')");
        statement.execute("insert into t21_noAutoGen values(22, 'true')");
        statement.execute("insert into t21_noAutoGen values(23, 'true')", 1);
        this.verifyNullKey("s.execute()", statement.getGeneratedKeys());
        statement.executeUpdate("insert into t21_noAutoGen values(24, 'true')", 1);
        this.verifyNullKey("s.executeUpdate()", statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(25, 'true')", 1);
        preparedStatement.execute();
        this.verifyNullKey("PreparedStatement.execute()", preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(26, 'true')", 1);
        preparedStatement.executeUpdate();
        this.verifyNullKey("ps.executeUpdate()", preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testDerby5823() throws SQLException {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t21_feed_table values (?,?)");
        preparedStatement.setString(2, "false");
        for (int i = 0; i < 250; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen select * from t21_feed_table", 1);
        this.verifyNullKey("s.execute()", statement.getGeneratedKeys());
        statement.execute("delete from t21_noAutoGen");
        preparedStatement = this.prepareStatement("insert into t21_noAutoGen select * from t21_feed_table", 1);
        preparedStatement.executeUpdate();
        this.verifyNullKey("ps.executeUpdate()", preparedStatement.getGeneratedKeys());
    }

    public void testInsertSubqueryNoWhereClause() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen values(21, 'true')");
        statement.close();
        String string = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen";
        this.runInsertFourWaysKeyIsNull(string);
    }

    public void testInsertSubqueryWhere1is2() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen values(21, 'true')");
        statement.close();
        String string = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen where 1=2";
        this.runInsertFourWaysKeyIsNull(string);
    }

    public void testInsertSubqueryWhereClause() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen(c21,c22) values(23, 'true')");
        statement.close();
        String string = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen where c21=23";
        this.runInsertFourWaysKeyIsNull(string);
    }

    public void testInsertOneRowKey() throws SQLException {
        String string = "insert into t11_AutoGen(c11) values (99)";
        Statement statement = this.createStatement();
        statement.execute(string, 1);
        int n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)1, (int)n);
        statement.executeUpdate(string, 1);
        n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)2, (int)n);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)3, (int)n);
        preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.executeUpdate();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)4, (int)n);
        preparedStatement.close();
    }

    public void testInsertNoGenColAfterOneRowKey() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values (99)");
        int n = 1;
        statement.execute("insert into t21_noAutoGen values(27, 'true')", 1);
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.executeUpdate("insert into t21_noAutoGen values(28, 'true')", 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)n, (int)n2);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(29, 'true')", 1);
        preparedStatement.execute();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)n, (int)n2);
        preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(30, 'true')", 1);
        preparedStatement.executeUpdate();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)n, (int)n2);
        preparedStatement.close();
    }

    public void testUpdateOneRowKey() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values(999)");
        String string = "update t11_AutoGen set c12=default where c11=999";
        statement.execute(string, 1);
        int n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)2, (int)n);
        statement.executeUpdate(string, 1);
        n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)3, (int)n);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)4, (int)n);
        preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.executeUpdate();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)5, (int)n);
        preparedStatement.close();
    }

    public void testDelete() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values(999)");
        String string = "delete from t11_AutoGen";
        statement.execute(string, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testGetKeyAfterCommit() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values(999)");
        Connection connection = this.getConnection();
        connection.commit();
        int n = 1;
        statement.execute("insert into t21_noAutoGen values(31, 'true')", 1);
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.executeUpdate("insert into t21_noAutoGen values(32, 'true')", 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)n, (int)n2);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(33, 'true')", 1);
        preparedStatement.execute();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)n, (int)n2);
        preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(34, 'true')", 1);
        preparedStatement.executeUpdate();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)n, (int)n2);
        preparedStatement.close();
    }

    public void testGetKeyAfterRollback() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("insert into t11_AutoGen(c11) values(999)");
        connection.rollback();
        int n = 1;
        statement.execute("insert into t21_noAutoGen values(35, 'true')", 1);
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n, (int)n2);
        statement.executeUpdate("insert into t21_noAutoGen values(36, 'true')", 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)n, (int)n2);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(37, 'true')", 1);
        preparedStatement.execute();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)n, (int)n2);
        preparedStatement = this.prepareStatement("insert into t21_noAutoGen values(38, 'true')", 1);
        preparedStatement.executeUpdate();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"key value after ps.executeUpdate()", (int)n, (int)n2);
        preparedStatement.close();
    }

    public void testGetKeyAfterSavepointRollback() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        Savepoint savepoint = connection.setSavepoint();
        int n = 1;
        statement.execute("insert into t11_AutoGen(c11) values(99)", 1);
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value before rollback", (int)n, (int)n2);
        connection.rollback(savepoint);
        statement.execute("insert into t21_noAutoGen values(39, 'true')", 1);
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after rollback", (int)n, (int)n2);
        statement.close();
    }

    public void testGetKeyMetadataAfterInsert() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t31_AutoGen(c31) values (99)", 1);
        ResultSet resultSet = statement.getGeneratedKeys();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AutoGenJDBC30Test.assertEquals((String)"ResultSet column count", (int)1, (int)resultSetMetaData.getColumnCount());
        AutoGenJDBC30Test.assertEquals((String)"Column type", (String)"DECIMAL", (String)resultSetMetaData.getColumnTypeName(1));
        AutoGenJDBC30Test.assertEquals((String)"Column precision", (int)31, (int)resultSetMetaData.getPrecision(1));
        AutoGenJDBC30Test.assertEquals((String)"Column scale", (int)0, (int)resultSetMetaData.getScale(1));
        int n = this.getKeyValue(resultSet);
        AutoGenJDBC30Test.assertEquals((String)"Key value", (int)1, (int)n);
        resultSet.close();
        statement.close();
    }

    public void testInsertNoGenKeys() throws SQLException {
        Statement statement = this.createStatement();
        String string = "insert into t31_AutoGen(c31) values (99)";
        statement.execute(string, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 2);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, 2);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testInsertJDBC20syntax() throws SQLException {
        Statement statement = this.createStatement();
        String string = "insert into t31_AutoGen(c31) values (99)";
        statement.execute(string);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testUpdateAutoGenNoGenKeys() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t31_AutoGen(c31) values (99)");
        String string = "update t31_AutoGen set c31=98";
        statement.execute(string, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 2);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, 2);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testDeleteAutoGenNoGenKeysJDBC20syntax() throws SQLException {
        Statement statement = this.createStatement();
        String string = "delete from t31_AutoGen";
        statement.execute(string);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void testInsertNoAutoGenExecuteSQLfunc() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t21_noAutoGen values(40, MMWNI())", 1);
        this.verifyNullKey("First insert", statement.getGeneratedKeys());
        this.assertTableRowCount("T21_NOAUTOGEN", 1);
        statement.execute("insert into t31_AutoGen(c31) values (99)", 1);
        int n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after insert into t31_AutoGen", (int)1, (int)n);
        statement.execute("insert into t21_noAutoGen values(42, MMWNI())", 1);
        n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after insert into t21_noAutoGen", (int)1, (int)n);
        this.assertTableRowCount("T21_NOAUTOGEN", 2);
        statement.close();
    }

    public void testInsertAutoGenExecuteSQLfunc() throws SQLException {
        String string = "insert into t31_AutoGen(c31) values (AddMe(1))";
        Statement statement = this.createStatement();
        statement.execute(string, 1);
        int n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)1, (int)n);
        statement.executeUpdate(string, 1);
        n = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)2, (int)n);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)3, (int)n);
        preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.executeUpdate();
        n = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)4, (int)n);
        preparedStatement.close();
    }

    public void testResultSetGarbageCollection() throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t11_AutoGen(c11) values(?)", 1);
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, 100 + i);
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
            resultSet.close();
            connection.commit();
            System.runFinalization();
            System.gc();
            System.runFinalization();
            System.gc();
        }
    }

    public void testColumnIndexes() throws SQLException {
        int[] nArray = new int[]{2};
        this.testUserGivenColumns(nArray, null, 1);
        nArray = new int[]{1, 2};
        this.testUserGivenColumnsError(nArray, null);
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        nArray = new int[]{100};
        this.testUserGivenColumnsError(nArray, null);
        nArray[0] = 1;
        this.testUserGivenColumnsError(nArray, null);
        nArray = new int[]{2, 2, 2};
        this.testUserGivenColumns(nArray, null, 5);
        nArray[1] = 100;
        this.testUserGivenColumnsError(nArray, null);
        nArray[2] = 100;
        this.testUserGivenColumnsError(nArray, null);
        nArray[1] = 100;
        nArray[2] = 1;
        this.testUserGivenColumnsError(nArray, null);
    }

    public void testColumnNames() throws SQLException {
        String[] stringArray = new String[]{"C12"};
        this.testUserGivenColumns(null, stringArray, 1);
        stringArray = new String[]{"C12", "C13"};
        this.testUserGivenColumnsError(null, stringArray);
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        stringArray = new String[]{"NOTTHERE"};
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[0] = "C11";
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[0] = null;
        this.testUserGivenColumnsError(null, stringArray);
        stringArray = new String[]{"C12", "C12", "C12"};
        this.testUserGivenColumns(null, stringArray, 5);
        stringArray[1] = "NOTTHERE";
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[1] = "C11";
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[1] = null;
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[1] = "C11";
        stringArray[2] = "NOTTHERE";
        this.testUserGivenColumnsError(null, stringArray);
        stringArray[1] = "NOTTHERE";
        stringArray[2] = "C11";
        this.testUserGivenColumnsError(null, stringArray);
    }

    public void testUserGivenColumnsEmpty() throws SQLException {
        Statement statement = this.createStatement();
        String string = "insert into t11_AutoGen(c11) values (99)";
        statement.execute(string, new String[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, new String[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)statement.getGeneratedKeys());
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareStatement(string, new String[0]);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, new String[0]);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)preparedStatement.getGeneratedKeys());
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        statement.execute(string, new int[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, new int[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)statement.getGeneratedKeys());
        if (!AutoGenJDBC30Test.usingEmbedded()) {
            preparedStatement = this.prepareStatement(string, new int[0]);
            preparedStatement.execute();
            AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
            preparedStatement = this.prepareStatement(string, new int[0]);
            preparedStatement.executeUpdate();
            AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)preparedStatement.getGeneratedKeys());
        }
    }

    public void testUserGivenColumnsNull() throws SQLException {
        Statement statement = this.createStatement();
        String string = "insert into t11_AutoGen(c11) values (99)";
        statement.execute(string, (String[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, (String[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)statement.getGeneratedKeys());
        PreparedStatement preparedStatement = this.prepareStatement(string, (String[])null);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, (String[])null);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)preparedStatement.getGeneratedKeys());
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        statement.execute(string, (int[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)statement.getGeneratedKeys());
        statement.executeUpdate(string, (int[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)statement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, (int[])null);
        preparedStatement.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, (int[])null);
        preparedStatement.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    private void testUserGivenColumns(int[] nArray, String[] stringArray, int n) throws SQLException {
        AutoGenJDBC30Test.assertTrue((String)"Exactly one of colIndexes or colNames should be null", (boolean)(nArray != null ^ stringArray != null));
        boolean bl = nArray != null;
        Statement statement = this.createStatement();
        String string = "insert into t11_AutoGen(c11) values (99)";
        if (bl) {
            statement.execute(string, nArray);
        } else {
            statement.execute(string, stringArray);
        }
        int n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)n++, (int)n2);
        if (bl) {
            statement.executeUpdate(string, nArray);
        } else {
            statement.executeUpdate(string, stringArray);
        }
        n2 = this.getKeyValue(statement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)n++, (int)n2);
        statement.close();
        PreparedStatement preparedStatement = null;
        preparedStatement = bl ? this.prepareStatement(string, nArray) : this.prepareStatement(string, stringArray);
        preparedStatement.execute();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)n++, (int)n2);
        preparedStatement = bl ? this.prepareStatement(string, nArray) : this.prepareStatement(string, stringArray);
        preparedStatement.executeUpdate();
        n2 = this.getKeyValue(preparedStatement.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)n++, (int)n2);
        preparedStatement.close();
    }

    private void testUserGivenColumnsError(int[] nArray, String[] stringArray) throws SQLException {
        String string;
        AutoGenJDBC30Test.assertTrue((String)"Exactly one of colIndexes or colNames should be null.", (boolean)(nArray != null ^ stringArray != null));
        boolean bl = nArray != null;
        String string2 = string = bl ? "X0X0E" : "X0X0F";
        if (AutoGenJDBC30Test.usingDerbyNetClient() && stringArray != null && stringArray.length != 1) {
            string = "X0X0D";
        }
        Statement statement = this.createStatement();
        String string3 = "insert into t11_AutoGen(c11) values (99)";
        try {
            if (bl) {
                statement.execute(string3, nArray);
            } else {
                statement.execute(string3, stringArray);
            }
            AutoGenJDBC30Test.fail((String)"Expected s.execute() to fail, but it did not.");
        }
        catch (SQLException sQLException) {
            AutoGenJDBC30Test.assertSQLState(string, sQLException.getSQLState(), sQLException);
        }
        try {
            if (bl) {
                statement.executeUpdate(string3, nArray);
            } else {
                statement.executeUpdate(string3, stringArray);
            }
            AutoGenJDBC30Test.fail((String)"Expected s.executeUpdate() to fail, but it did not.");
        }
        catch (SQLException sQLException) {
            AutoGenJDBC30Test.assertSQLState(string, sQLException.getSQLState(), sQLException);
        }
        statement.close();
        PreparedStatement preparedStatement = null;
        preparedStatement = bl ? this.prepareStatement(string3, nArray) : this.prepareStatement(string3, stringArray);
        try {
            preparedStatement.execute();
            AutoGenJDBC30Test.fail((String)"Expected ps.execute() to fail, but it did not.");
        }
        catch (SQLException sQLException) {
            AutoGenJDBC30Test.assertSQLState(string, sQLException.getSQLState(), sQLException);
        }
        try {
            preparedStatement.executeUpdate();
            AutoGenJDBC30Test.fail((String)"Expected ps.executeUpdate() to fail, but it did not.");
        }
        catch (SQLException sQLException) {
            AutoGenJDBC30Test.assertSQLState(string, sQLException.getSQLState(), sQLException);
        }
        preparedStatement.close();
    }

    public void runInsertFourWaysKeyIsNull(String string) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute(string, 1);
        this.verifyNullKey("After s.execute()", statement.getGeneratedKeys());
        statement.executeUpdate(string, 1);
        this.verifyNullKey("After s.executeUpdate()", statement.getGeneratedKeys());
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.execute();
        this.verifyNullKey("After ps.execute()", preparedStatement.getGeneratedKeys());
        preparedStatement = this.prepareStatement(string, 1);
        preparedStatement.executeUpdate();
        this.verifyNullKey("ps.executeUpdate()", preparedStatement.getGeneratedKeys());
        preparedStatement.close();
    }

    public void verifyNullKey(String string, ResultSet resultSet) throws SQLException {
        JDBC.assertGeneratedKeyResultSet(string, resultSet);
        int n = 0;
        while (resultSet.next()) {
            AutoGenJDBC30Test.assertNull((String)string, (Object)resultSet.getString(1));
            ++n;
        }
        AutoGenJDBC30Test.assertEquals((String)string, (int)1, (int)n);
    }

    public int getKeyValue(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            System.out.println("it is null");
        }
        JDBC.assertGeneratedKeyResultSet("AutoGenJDBC30Test.getKeyValue", resultSet);
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            AutoGenJDBC30Test.assertNotNull((String)"Key value is NULL", (Object)resultSet.getString(1));
            n2 = resultSet.getInt(1);
            ++n;
        }
        AutoGenJDBC30Test.assertEquals((String)"ResultSet rows", (int)1, (int)n);
        return n2;
    }

    public static String MyMethodWithNoInsert() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeQuery("select * from t11_AutoGen");
        statement.close();
        connection.close();
        return "true";
    }

    public static int addMe(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeQuery("select * from t11_AutoGen");
        statement.close();
        connection.close();
        return n + n;
    }
}

