/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SpaceTableTest
extends BaseJDBCTestCase {
    public SpaceTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(SpaceTableTest.class);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                connection.setAutoCommit(false);
                String string = "CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA";
                statement.executeUpdate(string);
                connection.commit();
                connection.setAutoCommit(true);
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        this.dropTable("IDELETEU");
        this.dropTable("PLATYPUS");
        this.dropTable("\"platypus2\"");
        this.dropFooTables(statement);
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        this.commit();
        super.tearDown();
    }

    public void testIDeleteu() throws SQLException, InterruptedException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.executeUpdate("create table ideleteu (a varchar(2000), b varchar(2000))");
        String string = "insert into ideleteu values ('" + Formatters.padString("rrrrrrrrrr", 2000) + "', '" + Formatters.padString("ssssssssssssssss", 2000) + "')";
        for (int i = 0; i < 5; ++i) {
            statement.executeUpdate(string);
        }
        this.assertSpaceTableOK("IDELETEU", new String[][]{{"IDELETEU", "0", "6", "0", "4096", "0"}}, false);
        statement.executeUpdate("delete from ideleteu");
        this.commit();
        statement.execute("call WAIT_FOR_POST_COMMIT()");
        this.assertSpaceTableOK("IDELETEU", new String[][]{{"IDELETEU", "0", "1", "5", "4096", "20480"}}, true);
        statement.executeUpdate("drop table ideleteu");
        this.commit();
    }

    public void testPlatypi() throws SQLException, InterruptedException {
        int n;
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        JDBC.assertEmpty(this.doSpaceTableSelect("PLATYPUS"));
        statement.executeUpdate("create table platypus (a varchar(1000), b varchar(3500), c varchar(400), d varchar(100))");
        statement.executeUpdate("create index kookaburra on platypus (a)");
        statement.executeUpdate("create index echidna on platypus (c)");
        statement.executeUpdate("create index wallaby on platypus (a,c,d)");
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "1", "0", "4096", "0"}, {"PLATYPUS", "0", "1", "0", "4096", "0"}, {"WALLABY", "1", "1", "0", "4096", "0"}}, false);
        String string = "insert into platypus values ('" + Formatters.padString("wwwwwww", 1000) + "', '" + Formatters.padString("xxx", 3500) + "', '" + Formatters.padString("yy", 400) + "', '" + Formatters.padString("zzz", 100) + "')";
        for (n = 0; n < 6; ++n) {
            statement.executeUpdate(string);
        }
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "4", "0", "4096", "0"}, {"PLATYPUS", "0", "13", "0", "4096", "0"}, {"WALLABY", "1", "8", "0", "4096", "0"}}, false);
        for (n = 0; n < 4; ++n) {
            statement.executeUpdate(string);
        }
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "3", "0", "4096", "0"}, {"KOOKABURRA", "1", "8", "0", "4096", "0"}, {"PLATYPUS", "0", "21", "0", "4096", "0"}, {"WALLABY", "1", "16", "0", "4096", "0"}}, false);
        statement.executeUpdate("delete from platypus");
        statement.execute("call WAIT_FOR_POST_COMMIT()");
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "2", "4096", "8192"}, {"KOOKABURRA", "1", "1", "7", "4096", "28672"}, {"PLATYPUS", "0", "1", "20", "4096", "81920"}, {"WALLABY", "1", "15", "1", "4096", "4096"}}, true);
        statement.executeUpdate("create table \"platypus2\" (a varchar(10), b varchar(1500), c varchar(400), d varchar(100))");
        string = "insert into \"platypus2\" values ('" + Formatters.padString("wwwwwww", 10) + "', '" + Formatters.padString("xxx", 1500) + "', '" + Formatters.padString("yy", 400) + "', '" + Formatters.padString("zzz", 100) + "')";
        for (n = 0; n < 6; ++n) {
            statement.executeUpdate(string);
        }
        statement.executeUpdate("create index kookaburra2 on \"platypus2\" (a)");
        statement.executeUpdate("create index echidna2 on \"platypus2\" (c)");
        statement.executeUpdate("create index wallaby2 on \"platypus2\" (a,c,d)");
        this.assertSpaceTableOK("platypus2", new String[][]{{"ECHIDNA2", "1", "1", "0", "4096", "0"}, {"KOOKABURRA2", "1", "1", "0", "4096", "0"}, {"WALLABY2", "1", "1", "0", "4096", "0"}, {"platypus2", "0", "6", "0", "4096", "0"}}, false);
        ResultSet resultSet = statement.executeQuery("select conglomeratename, isindex, numallocatedpages, numfreepages, pagesize, estimspacesaving from SYS.SYSSCHEMAS s, SYS.SYSTABLES t, new org.apache.derby.diag.SpaceTable(SCHEMANAME,TABLENAME) v where s.SCHEMAID = t.SCHEMAID and s.SCHEMANAME = 'APP' order by conglomeratename");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ECHIDNA", "1", "1", "2", "4096", "8192"}, {"ECHIDNA2", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "1", "7", "4096", "28672"}, {"KOOKABURRA2", "1", "1", "0", "4096", "0"}, {"PLATYPUS", "0", "1", "20", "4096", "81920"}, {"WALLABY", "1", "15", "1", "4096", "4096"}, {"WALLABY2", "1", "1", "0", "4096", "0"}, {"platypus2", "0", "6", "0", "4096", "0"}});
        statement.executeUpdate("drop table platypus");
        statement.executeUpdate("drop table \"platypus2\"");
    }

    public void testReservedSpace() throws SQLException, InterruptedException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        this.setAutoCommit(false);
        statement.executeUpdate("create table foo_int (a int)");
        statement.executeUpdate("create table foo_char (a char(100))");
        statement.executeUpdate("create table foo_varchar (a varchar(32000))");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        statement.executeUpdate("create table foo_longvarchar (a long varchar)");
        statement.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.executeUpdate("create table foo_bit (a char(100) for bit data)");
        statement.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "32768"}, {"FOO_LONGVARCHAR", "32768"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.dropFooTables(statement);
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.ReservedSpace', '65')");
        statement.executeUpdate("create table foo_int (a int)");
        statement.executeUpdate("create table foo_char (a char(100))");
        statement.executeUpdate("create table foo_varchar (a varchar(32000))");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        statement.executeUpdate("create table foo_longvarchar (a long varchar)");
        statement.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.executeUpdate("create table foo_bit (a char(100) for bit data)");
        statement.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.ReservedSpace', NULL)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "32768"}, {"FOO_LONGVARCHAR", "32768"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.dropFooTables(statement);
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '8192')");
        statement.executeUpdate("create table foo_int (a int)");
        statement.executeUpdate("create table foo_char (a char(100))");
        statement.executeUpdate("create table foo_varchar (a varchar(32000))");
        statement.executeUpdate("create table foo_longvarchar (a long varchar)");
        statement.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        statement.executeUpdate("create table foo_bit (a char(100) for bit data)");
        statement.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "8192"}, {"FOO_CHAR", "8192"}, {"FOO_INT", "8192"}, {"FOO_LONGVARBINARY", "8192"}, {"FOO_LONGVARCHAR", "8192"}, {"FOO_VARBINARY", "8192"}, {"FOO_VARCHAR", "8192"}});
        this.dropFooTables(statement);
        statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        this.commit();
        statement.executeUpdate("create table foo_int (a int)");
        statement.executeUpdate("create table foo_char (a char(100))");
        statement.executeUpdate("create table foo_varchar (a varchar(32000))");
        statement.executeUpdate("create table foo_longvarchar (a long varchar)");
        statement.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        statement.executeUpdate("create table foo_bit (a char(100) for bit data)");
        statement.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "4096"}, {"FOO_LONGVARCHAR", "4096"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.commit();
        this.dropFooTables(statement);
        this.commit();
    }

    private ResultSet doSpaceTableSelect(String string) throws SQLException {
        ResultSet resultSet = null;
        String string2 = "select conglomeratename, isindex, numallocatedpages, numfreepages, pagesize, estimspacesaving from new org.apache.derby.diag.SpaceTable('" + string + "') t order by conglomeratename";
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    private ResultSet doSpaceTableSelect2() throws SQLException {
        ResultSet resultSet = null;
        String string = "select v.conglomeratename, pagesize from SYS.SYSSCHEMAS s, SYS.SYSTABLES t, new org.apache.derby.diag.SpaceTable(schemaname, tablename) v where s.schemaid=t.schemaid and conglomeratename in ('FOO_INT', 'FOO_VARCHAR', 'FOO_CHAR', 'FOO_LONGVARCHAR','FOO_VARBINARY', 'FOO_LONGVARBINARY', 'FOO_BIT') order by 1";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    private void assertSpaceTableOK(String string, String[][] stringArray, boolean bl) throws SQLException, InterruptedException {
        ResultSet resultSet = this.doSpaceTableSelect(string);
        try {
            JDBC.assertFullResultSet(resultSet, stringArray);
        }
        catch (AssertionFailedError assertionFailedError) {
            if (bl) {
                this.assertSpaceTableOK(string, stringArray, false);
            }
            throw assertionFailedError;
        }
    }

    public void dropFooTables(Statement statement) throws SQLException {
        this.dropTable("FOO_INT");
        this.dropTable("FOO_CHAR");
        this.dropTable("FOO_VARCHAR");
        this.dropTable("FOO_LONGVARCHAR");
        this.dropTable("FOO_LONGVARBINARY");
        this.dropTable("FOO_BIT");
        this.dropTable("FOO_VARBINARY");
    }
}

