/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.reference.ModuleUtil;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamDrainer;
import org.apache.derbyTesting.functionTests.harness.HandleResult;
import org.apache.derbyTesting.functionTests.harness.NetServer;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.Sed;
import org.apache.derbyTesting.functionTests.harness.SimpleDiff;

public class FileCompare {
    private String testBase;
    private String framework;
    private String jvmName;
    private String jvmString;
    private String serverJvm;
    private int iminor;
    private boolean searchJdk12 = false;
    private boolean searchJdk13 = false;
    private boolean searchJdk14 = false;
    private int driverVersionMajor = 0;
    private int driverVersionMinor = 0;
    private boolean searchFrame;
    private boolean searchDriverVersion;
    private InputStream master = null;
    private boolean verbose = Boolean.getBoolean("verbose");

    public boolean exec(String outfile, File outDir, PrintWriter pwDiff, String testBaseOrig, String framework, String jvmName, int iminor, boolean useprocess, boolean usesysdiff, String canondir, String canonpath, String serverJvm) throws IOException, ClassNotFoundException {
        this.testBase = testBaseOrig;
        this.framework = framework;
        this.jvmName = jvmName;
        this.iminor = iminor;
        this.jvmString = jvmName;
        this.serverJvm = serverJvm;
        StringBuffer sb = new StringBuffer();
        if (framework.startsWith("DerbyNet")) {
            try {
                Class<?> c = Class.forName(NetServer.getDriverName(framework));
                Object o = c.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.driverVersionMajor = (Integer)c.getMethod("getMajorVersion", new Class[0]).invoke(o, new Object[0]);
                this.driverVersionMinor = (Integer)c.getMethod("getMinorVersion", new Class[0]).invoke(o, new Object[0]);
                if (framework.startsWith("DerbyNet")) {
                    this.searchDriverVersion = true;
                }
            }
            catch (Exception e) {
                System.out.println("Cannot determine driver version:" + e);
                this.driverVersionMinor = 0;
                this.driverVersionMajor = 0;
                this.searchDriverVersion = false;
            }
        }
        String topdir = "";
        if (canondir != null && canondir.length() > 0) {
            topdir = canondir;
        } else {
            InputStream is;
            String resourceName = "/org/apache/derby/info/engine/info.properties";
            if (JVMInfo.isModuleAware()) {
                Module engineModule = ModuleUtil.derbyModule((String)"org.apache.derby.engine");
                is = engineModule.getResourceAsStream(resourceName);
            } else {
                Class<FileCompare> c = FileCompare.class;
                is = c.getResourceAsStream(resourceName);
            }
            Properties dbprop = new Properties();
            dbprop.load(is);
            is.close();
            String filename = dbprop.getProperty("derby.product.file");
            if (filename != null) {
                if (filename.startsWith("derby") && filename.endsWith(".jar")) {
                    canondir = "product_master";
                    topdir = "product_master";
                } else {
                    topdir = "master";
                }
            } else {
                topdir = "master";
            }
        }
        Object subdir = "";
        boolean searchDefault = true;
        boolean searchBoth = false;
        boolean searchJvm = false;
        if (framework != null && framework.length() > 0) {
            this.searchFrame = true;
            subdir = framework;
        }
        if (jvmName != null && jvmName.length() > 0 & !jvmName.equals("currentjvm")) {
            searchJvm = true;
            if (this.searchFrame) {
                searchBoth = true;
            }
            if (iminor >= 2) {
                this.jvmString = "jdk12";
            }
            if (iminor >= 2) {
                this.searchJdk12 = true;
            }
            if (iminor >= 3) {
                this.searchJdk13 = true;
            }
            if (iminor >= 4) {
                this.searchJdk14 = true;
            }
            subdir = (String)subdir + jvmName;
        }
        if (this.searchFrame || searchJvm || searchBoth) {
            searchDefault = false;
        }
        sb.append(topdir);
        if (((String)subdir).length() > 0) {
            sb.append((String)subdir + "/");
        }
        sb.append(this.testBase + ".out");
        String masterfilename = sb.toString();
        InputStream is = null;
        if (is == null) {
            this.searchCanondir(topdir);
            is = this.master;
        }
        if (is == null) {
            is = new ByteArrayInputStream(new byte[0]);
        }
        if (NetServer.isClientConnection(framework)) {
            try {
                Sed sed = new Sed();
                File JCCOutFile = new File(outDir, this.testBase + ".tmpmstr");
                sed.execJCC(is, JCCOutFile);
                is = new FileInputStream(JCCOutFile);
            }
            catch (ClassFormatError cfe) {
                System.out.println("SED Error: " + cfe.getMessage());
            }
        } else {
            int c;
            File EncodedOutFile = new File(outDir, this.testBase + ".tmpmstr");
            BufferedReader inFile = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new FileWriter(EncodedOutFile), 10000), true);
            while ((c = inFile.read()) != -1) {
                pw.write(c);
            }
            pw.flush();
            pw.close();
            is = new FileInputStream(EncodedOutFile);
        }
        BufferedReader outFile = new BufferedReader(new FileReader(outfile));
        BufferedReader masterFile = new BufferedReader(new InputStreamReader(is));
        if (usesysdiff) {
            return this.doSysDiff(is, this.testBase, outfile, outDir, pwDiff);
        }
        return this.doDiff2(outFile, masterFile, pwDiff);
    }

    public boolean doDiff2(BufferedReader outFile, BufferedReader masterFile, PrintWriter pwDiff) throws IOException {
        return new SimpleDiff().doWork(masterFile, outFile, pwDiff);
    }

    public boolean doSysDiff(InputStream masterIS, String testBase, String outfile, File outDir, PrintWriter pwDiff) throws IOException {
        String diffs;
        File tempMaster;
        block3: {
            BufferedReader in = new BufferedReader(new InputStreamReader(masterIS));
            tempMaster = new File(new File(outDir, testBase + ".master").getCanonicalPath());
            PrintWriter pwMaster = new PrintWriter((Writer)new BufferedWriter(new FileWriter(tempMaster.getPath()), 10000), true);
            String str = "";
            while ((str = in.readLine()) != null) {
                pwMaster.println(str);
            }
            pwMaster.close();
            pwMaster = null;
            in = null;
            diffs = "0";
            Process pr = null;
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("diff ");
                sb.append(tempMaster.getCanonicalPath());
                sb.append(" ");
                sb.append(outfile);
                String diffCmd = sb.toString();
                pr = Runtime.getRuntime().exec(diffCmd);
                BackgroundStreamDrainer stdout = new BackgroundStreamDrainer(pr.getInputStream(), null);
                BackgroundStreamDrainer stderr = new BackgroundStreamDrainer(pr.getErrorStream(), null);
                pr.waitFor();
                String result = HandleResult.handleResult(pr.exitValue(), stdout.getData(), stderr.getData(), pwDiff);
                diffs = result.substring(result.lastIndexOf(44) + 1);
                pr.destroy();
                pr = null;
            }
            catch (Throwable t) {
                System.out.println("Process exception: " + t);
                if (pr == null) break block3;
                pr.destroy();
                pr = null;
            }
        }
        tempMaster.delete();
        return !diffs.equals("0");
    }

    public boolean doDiff(BufferedReader outFile, BufferedReader masterFile, PrintWriter pwDiff) throws IOException {
        String str1;
        boolean diff = false;
        int line = 0;
        int diffnum = 0;
        boolean diffline = false;
        while ((str1 = outFile.readLine()) != null) {
            ++line;
            str1 = str1.trim();
            String str2 = masterFile.readLine();
            if (str2 == null) continue;
            if (!str1.equals(str2 = str2.trim())) {
                StringBuffer sb1 = new StringBuffer();
                StringBuffer sb2 = new StringBuffer();
                StringTokenizer st1 = new StringTokenizer(str1);
                while (st1.hasMoreTokens()) {
                    sb1.append(st1.nextToken());
                }
                StringTokenizer st2 = new StringTokenizer(str2);
                while (st2.hasMoreTokens()) {
                    sb2.append(st2.nextToken());
                }
                if (sb1.toString().equals(sb2.toString())) {
                    diff = false;
                    continue;
                }
                if (str1.startsWith("-----") && str1.endsWith("-----")) {
                    if (!str2.startsWith("-----") || !str2.endsWith("-----")) continue;
                    diff = false;
                    continue;
                }
                diff = true;
                ++diffnum;
                System.out.println("Diff occurred at line: " + line);
                pwDiff.println("Diff occurred  at line: " + line);
                pwDiff.flush();
                break;
            }
            diff = false;
        }
        outFile.close();
        masterFile.close();
        return diff;
    }

    private void searchCanondir(String canondir) {
        String prefix = canondir + "/";
        if (this.master == null && this.searchFrame) {
            this.searchFramework(prefix);
        }
        if (this.master == null) {
            this.searchJvm(prefix);
        }
        if (this.master == null && this.searchDriverVersion) {
            this.searchDriverVersion(prefix);
        }
        if (this.master == null) {
            this.getmaster(prefix);
        }
        if (this.master == null && canondir != "master") {
            this.searchCanondir("master");
        }
    }

    private void searchJvm(String prefix) {
        int i;
        String newprefix;
        if ((this.jvmName.startsWith("j9") || this.serverJvm != null && this.serverJvm.startsWith("j9")) && !this.jvmName.startsWith("j9dee")) {
            if (this.jvmName.startsWith("j9_foundation")) {
                newprefix = prefix + "j9_foundation/";
                if (this.master == null && this.searchDriverVersion) {
                    this.searchDriverVersion(newprefix);
                }
                if (this.master == null) {
                    this.getmaster(newprefix);
                }
            } else {
                newprefix = prefix + this.jvmName + "/";
                if (!this.jvmName.equals("j9_13") && this.iminor > 1) {
                    for (i = this.iminor; i > 1; --i) {
                        if (this.master != null) continue;
                        newprefix = prefix + "j9_2" + i + "/";
                        this.getmaster(newprefix);
                    }
                }
                if (this.master == null) {
                    newprefix = prefix + "j9_13/";
                }
            }
            if (this.master == null && this.searchDriverVersion) {
                this.searchDriverVersion(newprefix);
            }
            if (this.master == null) {
                this.getmaster(newprefix);
            }
        }
        for (i = this.iminor; i >= 2; --i) {
            if (this.jvmName.startsWith("ibm")) {
                newprefix = prefix + "ibm1" + i + "/";
                if (this.master == null && this.searchDriverVersion) {
                    this.searchDriverVersion(newprefix);
                }
                if (this.master == null) {
                    this.getmaster(newprefix);
                }
            }
            newprefix = prefix + "jdk1" + i + "/";
            if (this.master == null && this.searchDriverVersion) {
                this.searchDriverVersion(newprefix);
            }
            if (this.master != null) continue;
            this.getmaster(newprefix);
        }
    }

    private void searchFramework(String prefix) {
        String newprefix = prefix + this.framework + "/";
        if (this.master == null) {
            this.searchJvm(newprefix);
        }
        if (this.master == null && this.searchDriverVersion) {
            this.searchDriverVersion(newprefix);
        }
        if (this.master == null) {
            this.getmaster(newprefix);
        }
    }

    private void searchDriverVersion(String prefix) {
        for (int j = this.driverVersionMajor * 10 + this.driverVersionMinor; j >= 10; --j) {
            String newprefix = prefix + "ver" + j / 10 + "." + j % 10 + "/";
            if (this.master != null) continue;
            this.getmaster(newprefix);
        }
    }

    private void getmaster(String prefix) {
        String fullname = prefix + this.testBase + ".out";
        this.master = RunTest.loadTestResource(fullname);
        if (this.master != null && this.verbose) {
            System.out.println("MasterFileName = " + fullname);
        }
    }
}

