/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.BaseTest;

public class OnlineCompressTest
extends BaseTest {
    boolean verbose = false;

    protected void callCompress(Connection conn, String schemaName, String tableName, boolean purgeRows, boolean defragmentRows, boolean truncateEnd, boolean commit_operation) throws SQLException {
        CallableStatement cstmt = conn.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        cstmt.setString(1, schemaName);
        cstmt.setString(2, tableName);
        cstmt.setInt(3, purgeRows ? 1 : 0);
        cstmt.setInt(4, defragmentRows ? 1 : 0);
        cstmt.setInt(5, truncateEnd ? 1 : 0);
        cstmt.execute();
        if (commit_operation) {
            conn.commit();
        }
    }

    protected void createAndLoadTable(Connection conn, boolean create_table, String tblname, int num_rows, int start_value) throws SQLException {
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create table " + tblname + "(keycol int, indcol1 int, indcol2 int, indcol3 int, data1 varchar(2000), data2 varchar(2000))");
            s.close();
        }
        PreparedStatement insert_stmt = conn.prepareStatement("insert into " + tblname + " values(?, ?, ?, ?, ?, ?)");
        char[] data1_data = new char[500];
        char[] data2_data = new char[500];
        for (int i = 0; i < data1_data.length; ++i) {
            data1_data[i] = 97;
            data2_data[i] = 98;
        }
        String data1_str = new String(data1_data);
        String data2_str = new String(data2_data);
        int row_count = 0;
        try {
            int i = start_value;
            while (row_count < num_rows) {
                insert_stmt.setInt(1, i);
                insert_stmt.setInt(2, i * 10);
                insert_stmt.setInt(3, i * 100);
                insert_stmt.setInt(4, -i);
                insert_stmt.setString(5, data1_str);
                insert_stmt.setString(6, data2_str);
                insert_stmt.execute();
                ++row_count;
                ++i;
            }
        }
        catch (SQLException sqle) {
            System.out.println("Exception while trying to insert row number: " + row_count);
            throw sqle;
        }
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create index " + tblname + "_idx_keycol on " + tblname + "(keycol)");
            s.execute("create index " + tblname + "_idx_indcol1 on " + tblname + "(indcol1)");
            s.execute("create index " + tblname + "_idx_indcol2 on " + tblname + "(indcol2)");
            s.execute("create unique index " + tblname + "_idx_indcol3 on " + tblname + "(indcol3)");
            s.close();
        }
        conn.commit();
    }

    protected void createAndLoadLargeTable(Connection conn, boolean create_table, String tblname, int num_rows, int start_value) throws SQLException {
        int i;
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create table " + tblname + "(keycol int, indcol1 int, indcol2 int, data1 char(24), data2 char(24), data3 char(24),data4 char(24), data5 char(24), data6 char(24), data7 char(24), data8 char(24),data9 char(24), data10 char(24), inddec1 decimal(8), indcol3 int, indcol4 int, data11 varchar(50))");
            s.close();
        }
        PreparedStatement insert_stmt = conn.prepareStatement("insert into " + tblname + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] data1_data = new char[24];
        char[] data2_data = new char[24];
        char[] data3_data = new char[24];
        char[] data4_data = new char[24];
        char[] data5_data = new char[24];
        char[] data6_data = new char[24];
        char[] data7_data = new char[24];
        char[] data8_data = new char[24];
        char[] data9_data = new char[24];
        char[] data10_data = new char[24];
        char[] data11_data = new char[50];
        for (i = 0; i < data1_data.length; ++i) {
            data1_data[i] = 97;
            data2_data[i] = 98;
            data3_data[i] = 99;
            data4_data[i] = 100;
            data5_data[i] = 101;
            data6_data[i] = 102;
            data7_data[i] = 103;
            data8_data[i] = 104;
            data9_data[i] = 105;
            data10_data[i] = 106;
        }
        for (i = 0; i < data11_data.length; ++i) {
            data11_data[i] = 122;
        }
        String data1_str = new String(data1_data);
        String data2_str = new String(data2_data);
        String data3_str = new String(data3_data);
        String data4_str = new String(data4_data);
        String data5_str = new String(data5_data);
        String data6_str = new String(data6_data);
        String data7_str = new String(data7_data);
        String data8_str = new String(data8_data);
        String data9_str = new String(data9_data);
        String data10_str = new String(data10_data);
        String data11_str = new String(data11_data);
        int row_count = 0;
        try {
            int i2 = start_value;
            while (row_count < num_rows) {
                insert_stmt.setInt(1, i2);
                insert_stmt.setInt(2, i2 * 10);
                insert_stmt.setInt(3, i2 * 100);
                insert_stmt.setString(4, data1_str);
                insert_stmt.setString(5, data2_str);
                insert_stmt.setString(6, data3_str);
                insert_stmt.setString(7, data4_str);
                insert_stmt.setString(8, data5_str);
                insert_stmt.setString(9, data6_str);
                insert_stmt.setString(10, data7_str);
                insert_stmt.setString(11, data8_str);
                insert_stmt.setString(12, data9_str);
                insert_stmt.setString(13, data10_str);
                insert_stmt.setInt(14, i2 * 20);
                insert_stmt.setInt(15, i2 * 200);
                insert_stmt.setInt(16, i2 * 50);
                insert_stmt.setString(17, data11_str);
                insert_stmt.execute();
                ++row_count;
                ++i2;
            }
        }
        catch (SQLException sqle) {
            System.out.println("Exception while trying to insert row number: " + row_count);
            throw sqle;
        }
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create index " + tblname + "_idx_keycol on " + tblname + "(keycol)");
            s.execute("create index " + tblname + "_idx_indcol1 on " + tblname + "(indcol1)");
            s.execute("create index " + tblname + "_idx_indcol2 on " + tblname + "(indcol2)");
            s.execute("create unique index " + tblname + "_idx_indcol3 on " + tblname + "(indcol3)");
            s.close();
        }
        conn.commit();
    }

    private void createAndLoadLongTable(Connection conn, boolean create_table, String tblname, int num_rows) throws SQLException {
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create table " + tblname + " (keycol   int, longcol1 clob(200k), longrow1 varchar(10000), longrow2 varchar(10000), longrow3 varchar(10000), longrow4 varchar(10000), indcol1  int, indcol2  int, indcol3  int, data1    varchar(2000), data2    varchar(2000), longrow5 varchar(10000), longrow6 varchar(10000), longrow7 varchar(10000), longrow8 varchar(10000), longcol2 clob(200k))");
            s.close();
        }
        PreparedStatement insert_stmt = conn.prepareStatement("insert into " + tblname + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] data1_data = new char[500];
        char[] data2_data = new char[500];
        for (int i = 0; i < data1_data.length; ++i) {
            data1_data[i] = 97;
            data2_data[i] = 98;
        }
        String data1_str = new String(data1_data);
        String data2_str = new String(data2_data);
        char[] data3_data = new char[10000];
        char[] data4_data = new char[10000];
        for (int i = 0; i < data3_data.length; ++i) {
            data3_data[i] = 99;
            data4_data[i] = 100;
        }
        String data3_str = new String(data3_data);
        String data4_str = new String(data4_data);
        char[] data5_data = new char[200000];
        char[] data6_data = new char[200000];
        for (int i = 0; i < data5_data.length; ++i) {
            data5_data[i] = 101;
            data6_data[i] = 102;
        }
        String data5_str = new String(data5_data);
        String data6_str = new String(data6_data);
        for (int i = 0; i < num_rows; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setString(2, data5_str);
            insert_stmt.setString(3, data3_str);
            insert_stmt.setString(4, data3_str);
            insert_stmt.setString(5, data3_str);
            insert_stmt.setString(6, data3_str);
            insert_stmt.setInt(7, i * 10);
            insert_stmt.setInt(8, i * 100);
            insert_stmt.setInt(9, -i);
            insert_stmt.setString(10, data1_str);
            insert_stmt.setString(11, data2_str);
            insert_stmt.setString(12, data4_str);
            insert_stmt.setString(13, data4_str);
            insert_stmt.setString(14, data4_str);
            insert_stmt.setString(15, data4_str);
            insert_stmt.setString(16, data5_str);
            insert_stmt.execute();
        }
        if (create_table) {
            Statement s = conn.createStatement();
            s.execute("create index " + tblname + "_idx_keycol on " + tblname + "(keycol)");
            s.execute("create index " + tblname + "_idx_indcol1 on " + tblname + "(indcol1)");
            s.execute("create index " + tblname + "_idx_indcol2 on " + tblname + "(indcol2)");
            s.execute("create unique index " + tblname + "_idx_indcol3 on " + tblname + "(indcol3)");
            s.close();
        }
        conn.commit();
    }

    private void log_wrong_count(String error_msg, String table_name, int num_rows, int expected_val, int actual_val, int[] before_info, int[] after_info) {
        System.out.println(error_msg);
        System.out.println("ERROR: for " + num_rows + " row  test. Expected " + expected_val + ", but got " + actual_val);
        System.out.println("before_info:");
        System.out.println("    IS_INDEX         =" + before_info[0] + "\n    NUM_ALLOC        =" + before_info[1] + "\n    NUM_FREE         =" + before_info[2] + "\n    NUM_UNFILLED     =" + before_info[3] + "\n    PAGE_SIZE        =" + before_info[4] + "\n    ESTIMSPACESAVING =" + before_info[5]);
        System.out.println("after_info:");
        System.out.println("    IS_INDEX         =" + after_info[0] + "\n    NUM_ALLOC        =" + after_info[1] + "\n    NUM_FREE         =" + after_info[2] + "\n    NUM_UNFILLED     =" + after_info[3] + "\n    PAGE_SIZE        =" + after_info[4] + "\n    ESTIMSPACESAVING =" + after_info[5]);
    }

    private void deleteAllRows(Connection conn, boolean create_table, boolean long_table, String schemaName, String table_name, int num_rows) throws SQLException {
        this.testProgress("begin deleteAllRows," + num_rows + " row test, create = " + create_table + ".");
        if (long_table) {
            this.createAndLoadLongTable(conn, create_table, table_name, num_rows);
        } else {
            this.createAndLoadTable(conn, create_table, table_name, num_rows, 0);
        }
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        int[] ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change.", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("no delete case complete.");
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name, true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted all rows, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (ret_after[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("delete all rows case succeeded.");
        conn.commit();
        this.testProgress("end deleteAllRows," + num_rows + " row test.");
    }

    private void simpleDeleteAllRows(Connection conn, boolean create_table, boolean long_table, String schemaName, String table_name, int num_rows) throws SQLException {
        this.testProgress("begin simpleDeleteAllRows," + num_rows + " row test, create = " + create_table + ".");
        if (long_table) {
            this.createAndLoadLongTable(conn, create_table, table_name, num_rows);
        } else {
            this.createAndLoadTable(conn, create_table, table_name, num_rows, 0);
        }
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        int[] ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change.", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        this.testProgress("no delete case complete.");
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name, true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted all rows, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (ret_after[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        this.testProgress("delete all rows case succeeded.");
        conn.commit();
        this.testProgress("end simple deleteAllRows," + num_rows + " row test.");
    }

    private void checkPurgePhase(Connection conn, boolean create_table, boolean long_table, String schemaName, String table_name, int num_rows) throws SQLException {
        this.testProgress("begin checkPurgePhase" + num_rows + " row test, create = " + create_table + ".");
        if (long_table) {
            this.createAndLoadLongTable(conn, create_table, table_name, num_rows);
        } else {
            this.createAndLoadTable(conn, create_table, table_name, num_rows, 0);
        }
        int[] ret_before = this.getSpaceInfo(conn, "APP", table_name, false);
        this.executeQuery(conn, "delete from " + table_name, false);
        this.callCompress(conn, "APP", table_name, true, false, false, false);
        int[] ret_after = this.getSpaceInfo(conn, "APP", table_name, false);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change(1).", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (ret_after[2] != ret_before[2]) {
            this.log_wrong_count("Expected no free page change(1).", table_name, num_rows, ret_before[2], ret_after[2], ret_before, ret_after);
        }
        this.callCompress(conn, "APP", table_name, true, false, false, false);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, false);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change(2).", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (ret_after[2] != ret_before[2]) {
            this.log_wrong_count("Expected no free page change(2).", table_name, num_rows, ret_before[2], ret_after[2], ret_before, ret_after);
        }
        try {
            this.callCompress(conn, "APP", table_name, false, true, false, false);
            this.logError("Defragment pass did not get a lock timeout.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ret_after = this.getSpaceInfo(conn, "APP", table_name, false);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change(3).", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (ret_after[2] != ret_before[2]) {
            this.log_wrong_count("Expected no free page change(3).", table_name, num_rows, ret_before[2], ret_after[2], ret_before, ret_after);
        }
        this.executeQuery(conn, "delete from " + table_name, true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        if (long_table) {
            this.createAndLoadLongTable(conn, create_table, table_name, num_rows);
        } else {
            this.createAndLoadTable(conn, create_table, table_name, num_rows, 0);
        }
        conn.commit();
        this.executeQuery(conn, "delete from " + table_name, false);
        ret_before = this.getSpaceInfo(conn, "APP", table_name, false);
        this.callCompress(conn, "APP", table_name, false, false, true, false);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, false);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change(4).", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (ret_after[2] > ret_before[2]) {
            this.log_wrong_count("Expected no increase in free pages(4).", table_name, num_rows, ret_before[2], ret_after[2], ret_before, ret_after);
        }
        conn.commit();
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        this.callCompress(conn, "APP", table_name, true, false, false, false);
        this.callCompress(conn, "APP", table_name, false, true, false, false);
        this.callCompress(conn, "APP", table_name, false, false, true, false);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, false);
        if (ret_after[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (ret_after[2] != 0) {
            this.log_wrong_count("Expected no free page after all pages truncated.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("end checkPurgePhase" + num_rows + " row test.");
    }

    private void test1(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] test_cases = new int[]{0, 1, 50, 4000};
        for (int i = 0; i < test_cases.length; ++i) {
            this.deleteAllRows(conn, true, false, "APP", table_name, test_cases[i]);
            this.deleteAllRows(conn, false, false, "APP", table_name, test_cases[i]);
            this.checkPurgePhase(conn, false, false, "APP", table_name, test_cases[i]);
            this.executeQuery(conn, "drop table " + table_name, true);
        }
        this.endTest(conn, test_name);
    }

    private void test2(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] test_cases = new int[]{4000};
        for (int i = 0; i < test_cases.length; ++i) {
            this.simpleDeleteAllRows(conn, true, false, "APP", table_name, test_cases[i]);
            for (int j = 0; j < 100; ++j) {
                this.deleteAllRows(conn, false, false, "APP", table_name, test_cases[i]);
            }
            this.executeQuery(conn, "drop table " + table_name, true);
        }
        this.endTest(conn, test_name);
    }

    private void test3(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] test_cases = new int[]{1, 2, 50};
        for (int i = 0; i < test_cases.length; ++i) {
            this.deleteAllRows(conn, true, true, "APP", table_name, test_cases[i]);
            this.deleteAllRows(conn, false, true, "APP", table_name, test_cases[i]);
            this.checkPurgePhase(conn, false, true, "APP", table_name, test_cases[i]);
            this.executeQuery(conn, "drop table " + table_name, true);
        }
        this.endTest(conn, test_name);
    }

    private void test4(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] test_cases = new int[]{4000};
        for (int i = 0; i < test_cases.length; ++i) {
            for (int j = 0; j < 100; ++j) {
                this.simpleDeleteAllRows(conn, true, false, "APP", table_name, test_cases[i]);
                this.deleteAllRows(conn, false, false, "APP", table_name, test_cases[i]);
                this.executeQuery(conn, "drop table " + table_name, true);
            }
        }
        this.endTest(conn, test_name);
    }

    private void test5_load(Connection conn, String schemaName, String table_name, int num_rows) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table " + table_name + " (keycol integer primary key, onehalf integer, onethird integer, c varchar(300))");
        s.close();
        PreparedStatement insert_stmt = conn.prepareStatement("insert into " + table_name + " values(?, ?, ?, ?)");
        char[] data1_data = new char[200];
        for (int i = 0; i < data1_data.length; ++i) {
            data1_data[i] = 98;
        }
        String data1_str = new String(data1_data);
        for (int i = 0; i < num_rows; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setInt(2, i % 2);
            insert_stmt.setInt(3, i % 3);
            insert_stmt.setString(4, data1_str);
            insert_stmt.execute();
        }
        conn.commit();
    }

    private void test5_run(Connection conn, String schemaName, String table_name, int num_rows) throws SQLException {
        this.testProgress("begin test5: " + num_rows + " row test.");
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        int[] ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (ret_after[1] != ret_before[1]) {
            this.log_wrong_count("Expected no alloc page change.", table_name, num_rows, ret_before[1], ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name + " where onehalf = 0", true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted every other row, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (this.total_pages(ret_after) != this.total_pages(ret_before)) {
            this.log_wrong_count("Expected no truncation.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name + " where onethird = 0", true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted every third row, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (this.total_pages(ret_after) != this.total_pages(ret_before)) {
            this.log_wrong_count("Expected no truncation.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name + " where keycol > " + num_rows / 2, true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted top half of the rows, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (this.verbose) {
            this.log_wrong_count("deleted top half keys, spaceinfo:", table_name, num_rows, this.total_pages(ret_before) / 2 + 2, ret_after[1], ret_before, ret_after);
        }
        if (this.total_pages(ret_after) > this.total_pages(ret_before) / 2 + 2) {
            this.log_wrong_count("Expected at least " + (ret_before[1] / 2 + 2) + " pages to be truncated.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
        this.executeQuery(conn, "delete from " + table_name + " where keycol < 500 ", true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        if (this.verbose) {
            this.testProgress("deleted keys < 500, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
        if (this.verbose) {
            this.log_wrong_count("deleted bottom 500 keys, spaceinfo:", table_name, num_rows, this.total_pages(ret_before) - 33, ret_after[1], ret_before, ret_after);
        }
        if (this.total_pages(ret_after) > this.total_pages(ret_before) - 33) {
            this.log_wrong_count("Expected at least 33 pages reclaimed.", table_name, num_rows, 1, ret_after[1], ret_before, ret_after);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(conn, schemaName, table_name)) {
            this.logError("conistency check failed.");
        }
        conn.commit();
        this.testProgress("end test5: " + num_rows + " row test.");
    }

    private void test5_cleanup(Connection conn, String schemaName, String table_name, int num_rows) throws SQLException {
        this.executeQuery(conn, "drop table " + table_name, true);
    }

    private void test5(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] test_cases = new int[]{2000, 10000};
        for (int i = 0; i < test_cases.length; ++i) {
            this.test5_load(conn, "APP", table_name, test_cases[i]);
            this.test5_run(conn, "APP", table_name, test_cases[i]);
            this.test5_cleanup(conn, "APP", table_name, test_cases[i]);
        }
        this.endTest(conn, test_name);
    }

    private void test6(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        int[] noRows = new int[]{104000};
        for (int i = 0; i < noRows.length; ++i) {
            this.createAndLoadLargeTable(conn, true, table_name, noRows[i], 0);
            if (this.verbose) {
                this.testProgress("Calling compress.");
            }
            int[] ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
            this.callCompress(conn, "APP", table_name, true, true, true, true);
            int[] ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
            if (ret_after[1] != ret_before[1]) {
                this.log_wrong_count("Expected no alloc page change.", table_name, noRows[i], ret_before[1], ret_after[1], ret_before, ret_after);
            }
            this.testProgress("no delete case complete.");
            ret_before = this.getSpaceInfo(conn, "APP", table_name, true);
            this.executeQuery(conn, "delete from " + table_name, true);
            OnlineCompressTest.callWaitForPostCommit(conn);
            conn.commit();
            if (this.verbose) {
                this.testProgress("deleted all rows, now calling compress.");
            }
            this.callCompress(conn, "APP", table_name, true, true, true, true);
            ret_after = this.getSpaceInfo(conn, "APP", table_name, true);
            if (ret_after[1] != 1) {
                this.log_wrong_count("Expected all pages to be truncated.", table_name, noRows[i], 1, ret_after[1], ret_before, ret_after);
            }
            this.testProgress("delete all rows case succeeded.");
            this.testProgress("end simple deleteAllRows," + noRows[i] + " row test.");
            this.executeQuery(conn, "drop table " + table_name, true);
        }
        this.endTest(conn, test_name);
    }

    private void test7(Connection conn, String test_name, String table_name) throws SQLException {
        this.beginTest(conn, test_name);
        Statement s = conn.createStatement();
        s.execute("create table " + table_name + "(keycol int)");
        s.close();
        PreparedStatement insert_stmt = conn.prepareStatement("insert into " + table_name + " values(?)");
        try {
            for (int i = 0; i < 1200; ++i) {
                insert_stmt.setInt(1, i);
                insert_stmt.execute();
            }
        }
        catch (SQLException sqle) {
            System.out.println("Exception while trying to insert a row");
            throw sqle;
        }
        conn.commit();
        this.executeQuery(conn, "delete from " + table_name + " where keycol < 1000", true);
        OnlineCompressTest.callWaitForPostCommit(conn);
        conn.commit();
        if (this.verbose) {
            this.testProgress("deleted first 1000 rows, now calling compress.");
        }
        this.callCompress(conn, "APP", table_name, true, true, true, true);
        this.testProgress("delete rows case succeeded.");
        this.executeQuery(conn, "drop table " + table_name, true);
        this.endTest(conn, test_name);
    }

    @Override
    public void testList(Connection conn) throws SQLException {
        this.test1(conn, "test1", "TEST1");
        this.test3(conn, "test3", "TEST3");
        this.test5(conn, "test5", "TEST5");
        this.test6(conn, "test6", "TEST6");
        this.test7(conn, "test7", "TEST7");
    }

    public static void callWaitForPostCommit(Connection conn) throws SQLException {
        CallableStatement cstmt = conn.prepareCall("call wait_for_post_commit()");
        cstmt.execute();
        cstmt.close();
    }

    public static void main(String[] argv) throws Throwable {
        OnlineCompressTest test = new OnlineCompressTest();
        ij.getPropertyArg((String[])argv);
        Connection conn = ij.startJBMS();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
        conn.setAutoCommit(false);
        stmt.close();
        try {
            test.testList(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

