/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.vti.StringColumnVTI;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;

public class StringArrayVTI
extends StringColumnVTI {
    public static final double FAKE_ROW_COUNT = 13.0;
    public static final double FAKE_INSTANTIATION_COST = 3149.0;
    private static final String[] EXPECTED_STACK = new String[]{"deduceGetXXXCaller", "getRawColumn", "getString"};
    private int _rowIdx = -1;
    private String[][] _rows;
    private static StringBuffer _callers;

    public StringArrayVTI(String[] stringArray, String[][] stringArray2) {
        super(stringArray);
        this._rows = stringArray2;
    }

    public static String getXXXrecord() {
        if (_callers == null) {
            return null;
        }
        return _callers.toString();
    }

    protected String getRawColumn(int n) throws SQLException {
        String string = this.deduceGetXXXCaller();
        _callers.append(string);
        _callers.append(' ');
        return this._rows[this._rowIdx][n - 1];
    }

    private String deduceGetXXXCaller() throws SQLException {
        StackTraceElement[] stackTraceElementArray = null;
        try {
            stackTraceElementArray = new Throwable().getStackTrace();
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return this.locateGetXXXCaller(stackTraceElementArray);
    }

    public boolean next() throws SQLException {
        if (++this._rowIdx >= this._rows.length) {
            return false;
        }
        _callers = new StringBuffer();
        return true;
    }

    public void close() throws SQLException {
    }

    private String locateGetXXXCaller(StackTraceElement[] stackTraceElementArray) throws SQLException {
        String string;
        String[] stringArray = this.squeezeMethodNames(stackTraceElementArray);
        String[] stringArray2 = EXPECTED_STACK;
        int n = this.findIndex("getString", stringArray);
        if (n < 0) {
            throw this.badStack(EXPECTED_STACK, stringArray);
        }
        if (!(string = stringArray[++n]).startsWith("get")) {
            string = "getString";
        }
        return string;
    }

    private SQLException badStack(String[] stringArray, String[] stringArray2) {
        return new SQLException("Expected stack to include " + this.stringify(stringArray) + ", but the stack was actually this: " + this.stringify(stringArray2));
    }

    private int findIndex(String string, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] squeezeMethodNames(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            stackTraceElementArray = new StackTraceElement[]{};
        }
        int n = stackTraceElementArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stackTraceElementArray[i].getMethodName();
        }
        return stringArray;
    }

    private String stringify(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        return Arrays.asList(objectArray).toString();
    }

    public static class GoodVTICosting
    extends ZeroArgConstructorNotPublic {
    }

    public static class ConstructorException
    extends ZeroArgConstructorNotPublic {
        public ConstructorException() {
            Object object = null;
            object.hashCode();
        }
    }

    public static class ZeroArgConstructorNotPublic
    extends MissingConstructor {
        ZeroArgConstructorNotPublic() {
            super(new String[]{"foo"}, new String[][]{{"bar"}});
        }
    }

    public static class MissingConstructor
    extends StringArrayVTI
    implements VTICosting {
        private MissingConstructor(String[] stringArray, String[][] stringArray2) {
            super(stringArray, stringArray2);
        }

        public static ResultSet dummyVTI() {
            return new StringArrayVTI(new String[]{"foo"}, new String[][]{{"bar"}});
        }

        public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) throws SQLException {
            return 13.0;
        }

        public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) throws SQLException {
            return 3149.0;
        }

        public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) throws SQLException {
            return false;
        }
    }
}

