/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class ReplicationRun_Local_3_p6
extends ReplicationRun_Local_3 {
    String getDerbyServerPID = null;

    public ReplicationRun_Local_3_p6(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_3_p6 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_3_p6.class);
        return baseTestSuite;
    }

    public void testReplication_Local_3_p6_autocommit_OK() throws Exception {
        this.derby_3896(true);
    }

    private void derby_3896(boolean bl) throws Exception {
        Connection connection;
        Connection connection2;
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        Object object = this.masterURL(replicatedDb) + ";create=true" + this.useEncryption(true);
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            this.util.DEBUG("bootMasterDatabase getConnection(" + (String)object + ")");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            connection2 = DriverManager.getConnection((String)object);
            connection2.close();
        } else {
            ReplicationRun_Local_3_p6.assertTrue((String)"NOT IMPLEMENTED for non-local host!", (boolean)false);
        }
        connection2 = this._getConnection(masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort);
        if (!bl) {
            connection2.setAutoCommit(false);
        }
        PreparedStatement preparedStatement = connection2.prepareStatement("create table t(i integer)");
        preparedStatement.execute();
        preparedStatement = connection2.prepareStatement("insert into t values 0,1,2,3");
        int n = 4;
        preparedStatement.execute();
        this._verifyTable(connection2, n);
        this.util.DEBUG("************************** DERBY-???? Preliminary needs to freeze db before copying to slave and setting replication mode.");
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            object = this.masterURL(replicatedDb);
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            this.util.DEBUG("bootMasterDatabase getConnection(" + (String)object + ")");
            connection = DriverManager.getConnection((String)object);
            Statement statement = connection.createStatement();
            statement.execute("call syscs_util.syscs_freeze_database()");
            connection.close();
        } else {
            ReplicationRun_Local_3_p6.assertTrue((String)"NOT IMPLEMENTED for non-local host!", (boolean)false);
        }
        this.util.DEBUG("bootMasterDatabase done.");
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        connection2.commit();
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        connection = this._getConnection(slaveDatabasePath, slaveDbSubPath, replicatedDb, slaveServerHost, slaveServerPort);
        this._verifyTable(connection, n);
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private Connection _getConnection(String string, String string2, String string3, String string4, int n) throws Exception {
        ClientDataSourceInterface clientDataSourceInterface;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string + FS + string2 + FS + string3);
        clientDataSourceInterface.setServerName(string4);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes(this.useEncryption(false));
        return clientDataSourceInterface.getConnection();
    }

    private void _verifyTable(Connection connection, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n2 = resultSet.getInt(1);
        resultSet = statement.executeQuery("select max(i) from t");
        resultSet.next();
        int n3 = resultSet.getInt(1);
        this.util.DEBUG("_verify: " + n2 + "/" + n + " " + n3 + "/" + (n - 1));
        ReplicationRun_Local_3_p6.assertEquals((String)("Expected " + n + " tuples, got " + n2 + "."), (int)n, (int)n2);
        ReplicationRun_Local_3_p6.assertEquals((String)("Expected " + (n - 1) + " max, got " + n3 + "."), (int)(n - 1), (int)n3);
    }
}

