/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BadConnectionTest
extends BaseJDBCTestCase {
    public void setUp() throws SQLException {
        this.getConnection().close();
    }

    public void testNoUserOrPassword() {
        try {
            Connection connection = DriverManager.getConnection("jdbc:derby://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/testbase");
            BadConnectionTest.fail((String)"Connection with no user or password succeeded");
        }
        catch (SQLException sQLException) {
            BadConnectionTest.assertSQLState("08004", sQLException);
            BadConnectionTest.assertErrorCode(40000, sQLException);
        }
    }

    public void testDatabaseNotFound() {
        try {
            Properties properties = new Properties();
            properties.put("user", "admin");
            properties.put("password", "admin");
            Connection connection = DriverManager.getConnection("jdbc:derby://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/testbase", properties);
            BadConnectionTest.fail((String)"Connection with no database succeeded");
        }
        catch (SQLException sQLException) {
            BadConnectionTest.assertSQLState("08004", sQLException);
            BadConnectionTest.assertErrorCode(40000, sQLException);
        }
    }

    public void testBadConnectionAttribute() {
        try {
            Connection connection = DriverManager.getConnection("jdbc:derby://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/badAttribute;upgrade=notValidValue");
            BadConnectionTest.fail((String)"Connection with bad atttributes succeeded");
        }
        catch (SQLException sQLException) {
            BadConnectionTest.assertSQLState("XJ05B", sQLException);
            BadConnectionTest.assertErrorCode(40000, sQLException);
        }
    }

    public BadConnectionTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(BadConnectionTest.class);
    }
}

