/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OutBufferedStreamTest
extends BaseJDBCTestCase {
    public OutBufferedStreamTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.drda.streamOutBufferSize", "131072");
        Object object = TestConfiguration.clientServerSuite(OutBufferedStreamTest.class);
        object = new SystemPropertyTestSetup((Test)object, properties);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table TEST_TABLE( TEST_COL blob( 65536 ))");
                this.getConnection().commit();
            }
        };
    }

    public void testOutBufferStream() {
        try {
            int n;
            int n2;
            PreparedStatement preparedStatement = this.prepareStatement("insert into TEST_TABLE( TEST_COL ) values(?)");
            preparedStatement.setBinaryStream(1, (InputStream)OutBufferedStreamTest.createOriginalDataInputStream(65536), 65536);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this.commit();
            PreparedStatement preparedStatement2 = this.prepareStatement("select TEST_COL from TEST_TABLE");
            ResultSet resultSet = preparedStatement2.executeQuery();
            resultSet.next();
            InputStream inputStream = resultSet.getBinaryStream(1);
            int[][] nArray = new int[256][256];
            int[][] nArray2 = new int[256][256];
            for (n2 = 0; n2 < 256; ++n2) {
                for (n = 0; n < 256; ++n) {
                    nArray[n2][n] = n;
                }
            }
            for (n2 = 0; n2 < 256; ++n2) {
                for (n = 0; n < 256; ++n) {
                    nArray2[n2][n] = inputStream.read();
                }
            }
            for (n2 = 0; n2 < 256; ++n2) {
                for (n = 0; n < 256; ++n) {
                    OutBufferedStreamTest.assertEquals((String)("Not correct: Line " + n2 + " pos " + n), (int)nArray[n2][n], (int)nArray2[n2][n]);
                }
            }
            inputStream.close();
            resultSet.close();
            preparedStatement2.close();
            this.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static ByteArrayInputStream createOriginalDataInputStream(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i % 256);
        }
        return new ByteArrayInputStream(byArray);
    }
}

