/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derbyTesting.functionTests.tests.jdbc4.StatementTest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PreparedStatementTest
extends BaseJDBCTestCase {
    private static final String BLOBTBL = "BlobTestTable";
    private static final String CLOBTBL = "ClobTestTable";
    private static final String LONGVARCHAR = "LongVarcharTestTable";
    private static int globalKey = 1;
    private static final byte[] BYTES = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private int key;
    private PreparedStatement ps = null;
    private PreparedStatement psFetchBlob = null;
    private PreparedStatement psInsertBlob = null;
    private PreparedStatement psFetchClob = null;
    private PreparedStatement psInsertClob = null;
    private PreparedStatement psInsertLongVarchar = null;
    private Statement s = null;

    public PreparedStatementTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        this.key = PreparedStatementTest.requestKey();
        this.s = this.createStatement();
        this.ps = this.prepareStatement("select count(*) from sys.systables");
        this.psFetchBlob = this.prepareStatement("SELECT dBlob FROM BlobTestTable WHERE sno = ?");
        this.psInsertBlob = this.prepareStatement("INSERT INTO BlobTestTable VALUES (?, ?)");
        this.psFetchClob = this.prepareStatement("SELECT dClob FROM ClobTestTable WHERE sno = ?");
        this.psInsertClob = this.prepareStatement("INSERT INTO ClobTestTable VALUES (?, ?)");
        this.psInsertLongVarchar = this.prepareStatement("INSERT INTO LongVarcharTestTable VALUES (?, ?)");
    }

    @Override
    public void tearDown() throws Exception {
        this.s.close();
        this.ps.close();
        this.s = null;
        this.ps = null;
        this.psFetchBlob.close();
        this.psFetchClob.close();
        this.psInsertBlob.close();
        this.psInsertClob.close();
        this.psInsertLongVarchar.close();
        this.psFetchBlob = null;
        this.psFetchClob = null;
        this.psInsertBlob = null;
        this.psInsertClob = null;
        this.psInsertLongVarchar = null;
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PreparedStatementTest suite");
        baseTestSuite.addTest(PreparedStatementTest.baseSuite("PreparedStatementTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.connectionXADecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:embedded XADataSource")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:client")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:logical"))));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(PreparedStatementTest.statementCachingSuite()));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionXADecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:client XXXXADataSource"))));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(PreparedStatementTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table BlobTestTable (sno int, dBlob BLOB(1M))");
                statement.execute("create table ClobTestTable (sno int, dClob CLOB(1M))");
                statement.execute("create table LongVarcharTestTable (sno int, dLongVarchar LONG VARCHAR)");
            }
        };
    }

    private static Test statementCachingSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("JDBC statement caching suite");
        baseTestSuite.addTest((Test)new PreparedStatementTest("cpTestIsPoolableHintFalse"));
        baseTestSuite.addTest((Test)new PreparedStatementTest("cpTestIsPoolableHintTrue"));
        return TestConfiguration.connectionCPDecorator((Test)new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table BlobTestTable (sno int, dBlob BLOB(1M))");
                statement.execute("create table ClobTestTable (sno int, dClob CLOB(1M))");
                statement.execute("create table LongVarcharTestTable (sno int, dLongVarchar LONG VARCHAR)");
            }
        });
    }

    public void testSetRowId() throws SQLException {
        try {
            RowId rowId = null;
            this.ps.setRowId(0, rowId);
            PreparedStatementTest.fail((String)"setRowId should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNString() throws SQLException {
        try {
            String string = null;
            this.ps.setNString(0, string);
            PreparedStatementTest.fail((String)"setNString should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStream() throws SQLException {
        try {
            Reader reader = null;
            this.ps.setNCharacterStream(0, reader, 0L);
            PreparedStatementTest.fail((String)"setNCharacterStream should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStreamLengthlessNotImplemented() throws SQLException {
        try {
            this.ps.setNCharacterStream(1, new StringReader("A string"));
            PreparedStatementTest.fail((String)"setNCharacterStream(int,Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobLengthlessNotImplemented() throws SQLException {
        try {
            this.ps.setNClob(1, new StringReader("A string"));
            PreparedStatementTest.fail((String)"setNClob(int,Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClob1() throws SQLException {
        try {
            NClob nClob = null;
            this.ps.setNClob(0, nClob);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClob2() throws SQLException {
        try {
            Reader reader = null;
            this.ps.setNClob(0, reader, 0L);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetSQLXML() throws SQLException {
        try {
            SQLXML sQLXML = null;
            this.ps.setSQLXML(0, sQLXML);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testIsWrapperForStatement() throws SQLException {
        PreparedStatementTest.assertTrue((boolean)this.ps.isWrapperFor(Statement.class));
    }

    public void testIsWrapperForPreparedStatement() throws SQLException {
        PreparedStatementTest.assertTrue((boolean)this.ps.isWrapperFor(PreparedStatement.class));
    }

    public void testIsNotWrapperForCallableStatement() throws SQLException {
        PreparedStatementTest.assertFalse((boolean)this.ps.isWrapperFor(CallableStatement.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        PreparedStatementTest.assertFalse((boolean)this.ps.isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperForSelf() throws SQLException {
        PreparedStatementTest.assertTrue((boolean)this.ps.isWrapperFor(this.ps.getClass()));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement statement = this.ps.unwrap(Statement.class);
        PreparedStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ps, (Object)statement);
    }

    public void testUnwrapPreparedStatement() throws SQLException {
        PreparedStatement preparedStatement = this.ps.unwrap(PreparedStatement.class);
        PreparedStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ps, (Object)preparedStatement);
    }

    public void testUnwrapAsSelf() throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.ps.unwrap(this.ps.getClass());
        PreparedStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ps, (Object)preparedStatement);
    }

    public void testUnwrapCallableStatement() {
        try {
            CallableStatement callableStatement = this.ps.unwrap(CallableStatement.class);
            PreparedStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet resultSet = this.ps.unwrap(ResultSet.class);
            PreparedStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testSetClob() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        String string = "Test data for the Clob object";
        StringReader stringReader = new StringReader("Test data for the Clob object");
        stringReader.reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setClob(2, stringReader, string.length());
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        int n = PreparedStatementTest.requestKey();
        this.psInsertClob.setInt(1, n);
        this.psInsertClob.setClob(2, clob);
        this.psInsertClob.execute();
        this.psInsertClob.close();
        this.psFetchClob.setInt(1, n);
        resultSet = this.psFetchClob.executeQuery();
        resultSet.next();
        Clob clob2 = resultSet.getClob(1);
        PreparedStatementTest.assertEquals(clob, clob2);
    }

    public void testSetClobLengthless() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        Clob clob = this.getConnection().createClob();
        OutputStream outputStream = clob.setAsciiStream(1L);
        outputStream.write(BYTES);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setClob(2, clob);
        this.psInsertClob.execute();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)resultSet.next());
        Clob clob2 = resultSet.getClob(1);
        PreparedStatementTest.assertEquals(clob, clob2);
    }

    public void testSetBlob() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES);
        ((InputStream)byteArrayInputStream).reset();
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBlob(2, byteArrayInputStream, BYTES.length);
        this.psInsertBlob.executeUpdate();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        int n = PreparedStatementTest.requestKey();
        this.psInsertBlob.setInt(1, n);
        this.psInsertBlob.setBlob(2, blob);
        this.psInsertBlob.execute();
        this.psInsertBlob.close();
        this.psFetchBlob.setInt(1, n);
        resultSet = this.psFetchBlob.executeQuery();
        resultSet.next();
        Blob blob2 = resultSet.getBlob(1);
        PreparedStatementTest.assertEquals(blob, blob2);
    }

    public void testSetBlobLengthless() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        Blob blob = this.getConnection().createBlob();
        OutputStream outputStream = blob.setBinaryStream(1L);
        outputStream.write(BYTES);
        int n = PreparedStatementTest.requestKey();
        this.psInsertBlob.setInt(1, n);
        this.psInsertBlob.setBlob(2, blob);
        this.psInsertBlob.execute();
        outputStream.close();
        this.psInsertBlob.close();
        this.psFetchBlob.setInt(1, n);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)resultSet.next());
        Blob blob2 = resultSet.getBlob(1);
        PreparedStatementTest.assertEquals(blob, blob2);
    }

    public void testSetPoolable() throws SQLException {
        this.ps.setPoolable(false);
        PreparedStatementTest.assertFalse((String)"Expected a non-poolable statement", (boolean)this.ps.isPoolable());
        this.ps.setPoolable(true);
        PreparedStatementTest.assertTrue((String)"Expected a non-poolable statement", (boolean)this.ps.isPoolable());
    }

    public void testSetPoolableOnClosed() throws SQLException {
        block2: {
            try {
                this.ps.close();
                this.ps.setPoolable(false);
                PreparedStatementTest.fail((String)"Expected an exception on closed statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("XJ012") || sQLException.getSQLState().equals("XCL31")) break block2;
                PreparedStatementTest.fail((String)("Unexpected SQLException " + String.valueOf(sQLException)));
            }
        }
    }

    public void testIsPoolableDefault() throws SQLException {
        PreparedStatementTest.assertTrue((String)"Expected a poolable statement", (boolean)this.ps.isPoolable());
    }

    public void cpTestIsPoolableHintFalse() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table testispoolablehint (id int)");
        statement.executeUpdate("insert into testispoolablehint values 1");
        PreparedStatement preparedStatement = this.prepareStatement("select * from testispoolablehint");
        preparedStatement.setPoolable(false);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
        statement.executeUpdate("drop table testispoolablehint");
        statement.close();
        try {
            preparedStatement = this.prepareStatement("select * from testispoolablehint");
            PreparedStatementTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest.assertSQLState("42X05", sQLException);
        }
    }

    public void cpTestIsPoolableHintTrue() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table testispoolablehint (id int)");
        statement.executeUpdate("insert into testispoolablehint values 1");
        PreparedStatement preparedStatement = this.prepareStatement("select * from testispoolablehint");
        preparedStatement.setPoolable(true);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
        statement.executeUpdate("drop table testispoolablehint");
        statement.close();
        preparedStatement = this.prepareStatement("select * from testispoolablehint");
        try {
            preparedStatement.executeQuery();
            PreparedStatementTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest.assertSQLState("42X05", sQLException);
        }
    }

    public void testIsPoolableOnClosed() throws SQLException {
        block2: {
            try {
                this.ps.close();
                boolean bl = this.ps.isPoolable();
                PreparedStatementTest.fail((String)"Should throw exception on closed statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("XJ012") || sQLException.getSQLState().equals("XCL31")) break block2;
                PreparedStatementTest.fail((String)("Unexpected SQLException " + String.valueOf(sQLException)));
            }
        }
    }

    public void testSetCharacterStream() throws Exception {
        String string = "Test data for the Clob object";
        StringReader stringReader = new StringReader("Test data for the Clob object");
        stringReader.reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setCharacterStream(2, (Reader)stringReader, string.length());
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        String string2 = clob.getSubString(1L, (int)clob.length());
        PreparedStatementTest.assertEquals((String)"Error in inserting data into the Clob object", (String)string, (String)string2);
        this.psInsertClob.close();
        resultSet.close();
    }

    public void testSetCharacterStreamLengthless() throws IOException, SQLException {
        String string = "Test string for setCharacterStream\u1a00";
        StringReader stringReader = new StringReader(string);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setCharacterStream(2, stringReader);
        this.psInsertClob.execute();
        ((Reader)stringReader).close();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)resultSet.next());
        Clob clob = resultSet.getClob(1);
        PreparedStatementTest.assertEquals((String)"Mismatch test data in/out", (String)string, (String)clob.getSubString(1L, string.length()));
    }

    public void testSetAsciiStream() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES);
        ((InputStream)byteArrayInputStream).reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES.length);
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        try {
            InputStream inputStream = clob.getAsciiStream();
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            PreparedStatementTest.fail((String)"IOException while reading the Clob from the database");
        }
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Error in inserting data into the Clob", (byte)BYTES[i], (byte)byArray[i]);
        }
        this.psInsertClob.close();
        resultSet.close();
    }

    public void testSetAsciiStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setAsciiStream(2, byteArrayInputStream);
        this.psInsertClob.execute();
        ((InputStream)byteArrayInputStream).close();
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)resultSet.next());
        Clob clob = resultSet.getClob(1);
        byte[] byArray = new byte[10];
        InputStream inputStream = clob.getAsciiStream();
        PreparedStatementTest.assertEquals((String)"Unexpected number of bytes read", (int)BYTES.length, (int)inputStream.read(byArray));
        PreparedStatementTest.assertEquals((String)"Stream should be exhausted", (int)-1, (int)inputStream.read());
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Byte mismatch in/out", (byte)BYTES[i], (byte)byArray[i]);
        }
        inputStream.close();
        this.psInsertClob.close();
    }

    public void testSetBinaryStream() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES);
        ((InputStream)byteArrayInputStream).reset();
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES.length);
        this.psInsertBlob.executeUpdate();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            InputStream inputStream = blob.getBinaryStream();
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            PreparedStatementTest.fail((String)"IOException while reading the Clob from the database");
        }
        resultSet.close();
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Error in inserting data into the Blob", (byte)BYTES[i], (byte)byArray[i]);
        }
        this.psInsertBlob.close();
    }

    public void testSetBinaryStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES);
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBinaryStream(2, byteArrayInputStream);
        this.psInsertBlob.execute();
        ((InputStream)byteArrayInputStream).close();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)resultSet.next());
        Blob blob = resultSet.getBlob(1);
        byte[] byArray = new byte[10];
        InputStream inputStream = blob.getBinaryStream();
        PreparedStatementTest.assertEquals((String)"Unexpected number of bytes read", (int)BYTES.length, (int)inputStream.read(byArray));
        PreparedStatementTest.assertEquals((String)"Stream should be exhausted", (int)-1, (int)inputStream.read());
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Byte mismatch in/out", (byte)BYTES[i], (byte)byArray[i]);
        }
        inputStream.close();
        this.psInsertBlob.close();
    }

    public void testSetBinaryStreamLengthLess1KOnBlob() throws IOException, SQLException {
        int n = 1024;
        this.setBinaryStreamOnBlob(this.key, n, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetBinaryStreamLengthLess32KOnBlob() throws IOException, SQLException {
        int n = 32768;
        this.setBinaryStreamOnBlob(this.key, n, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetBinaryStreamLengthLess65KOnBlob() throws IOException, SQLException {
        int n = 66560;
        this.setBinaryStreamOnBlob(this.key, n, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n);
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetBinaryStreamLengthLessOnBlobTooLong() {
        int n = 0x100200;
        try {
            this.setBinaryStreamOnBlob(this.key, n, -1, 0, true);
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded() || PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XSDA4", sQLException);
            }
            PreparedStatementTest.assertSQLState("22001", sQLException);
        }
    }

    public void testExceptionPathOnePage_bs() throws SQLException {
        int n = 11;
        try {
            this.setBinaryStreamOnBlob(this.key, n - 1, n, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with fewer bytes than specified");
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sQLException);
            }
            PreparedStatementTest.assertSQLState("XN017", sQLException);
        }
    }

    public void testExceptionPathMultiplePages_bs() throws SQLException {
        int n = 0x100000;
        try {
            this.setBinaryStreamOnBlob(this.key, n - 1, n, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with fewer bytes than specified");
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sQLException);
            }
            PreparedStatementTest.assertSQLState("XN017", sQLException);
        }
    }

    public void testBlobExceptionDoesNotRollbackOtherStatements() throws IOException, SQLException {
        ResultSet resultSet;
        int n;
        int n2;
        this.getConnection().setAutoCommit(false);
        int[] nArray = new int[]{this.key, PreparedStatementTest.requestKey(), PreparedStatementTest.requestKey()};
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.psInsertBlob.setInt(1, nArray[n2]);
            this.psInsertBlob.setNull(2, 2004);
            PreparedStatementTest.assertEquals((int)1, (int)this.psInsertBlob.executeUpdate());
        }
        n2 = PreparedStatementTest.requestKey();
        int n3 = 0x100000;
        try {
            this.setBinaryStreamOnBlob(n2, n3 - 1, n3, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with less data than specified");
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sQLException);
            }
            PreparedStatementTest.assertSQLState("XN017", sQLException);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.psFetchBlob.setInt(1, nArray[n]);
            resultSet = this.psFetchBlob.executeQuery();
            PreparedStatementTest.assertTrue((boolean)resultSet.next());
            PreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        this.psFetchBlob.setInt(1, n2);
        resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        this.rollback();
        for (n = 0; n < nArray.length; ++n) {
            this.psFetchBlob.setInt(1, nArray[n]);
            resultSet = this.psFetchBlob.executeQuery();
            PreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        this.psFetchBlob.setInt(1, n2);
        resultSet = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertFalse((boolean)resultSet.next());
    }

    public void testSetAsciiStreamLengthLess1KOnClob() throws IOException, SQLException {
        int n = 1024;
        this.setAsciiStream(this.psInsertClob, this.key, n, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetAsciiStreamLengthLess32KOnClob() throws IOException, SQLException {
        int n = 32768;
        this.setAsciiStream(this.psInsertClob, this.key, n, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetAsciiStreamLengthLess65KOnClob() throws IOException, SQLException {
        int n = 66560;
        this.setAsciiStream(this.psInsertClob, this.key, n, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet resultSet = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)resultSet.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(n), resultSet.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testSetAsciiStreamLengthLessOnClobTooLong() {
        int n = 0x100200;
        try {
            this.setAsciiStream(this.psInsertClob, this.key, n, -1, 0, true);
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded() || PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XSDA4", sQLException);
            }
            PreparedStatementTest.assertSQLState("22001", sQLException);
        }
    }

    public void testSetAsciiStreamLengthLessOnClobTooLongTruncate() throws SQLException {
        int n = 512;
        int n2 = 0x100000 + n;
        this.setAsciiStream(this.psInsertClob, this.key, n2, -1, n, true);
    }

    public void testSetAsciiStreamLengthlessOnLongVarCharTooLong() {
        int n = 33212;
        try {
            this.setAsciiStream(this.psInsertLongVarchar, this.key, n, -1, 0, true);
            PreparedStatementTest.fail((String)"Inserted a LONG VARCHAR that is too long");
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded()) {
                this.assertInternalDerbyIOExceptionState("XCL30", "22001", sQLException);
            }
            if (PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XCL30", sQLException);
            }
            PreparedStatementTest.assertSQLState("22001", sQLException);
        }
    }

    public void testSetAsciiStreamLengthlessOnLongVarCharDontTruncate() {
        int n = 2000;
        int n2 = 32000 + n;
        try {
            this.setAsciiStream(this.psInsertLongVarchar, this.key, n2, -1, n, true);
            PreparedStatementTest.fail((String)"Truncation is not allowed for LONG VARCHAR");
        }
        catch (SQLException sQLException) {
            if (PreparedStatementTest.usingEmbedded()) {
                this.assertInternalDerbyIOExceptionState("XCL30", "22001", sQLException);
            }
            if (PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XCL30", sQLException);
            }
            PreparedStatementTest.assertSQLState("22001", sQLException);
        }
    }

    public void testLargeUpdate_jdbc4_2() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatementTest.largeUpdate_jdbc4_2(connection);
    }

    public static void largeUpdate_jdbc4_2(Connection connection) throws Exception {
    }

    private static void largeUpdateTest(Statement statement, PreparedStatementWrapper preparedStatementWrapper, long l) throws Exception {
        StatementTest.setRowCountBase(statement, false, l);
        PreparedStatementTest.assertEquals((long)(l + 5L), (long)preparedStatementWrapper.executeLargeUpdate());
    }

    private void setBinaryStreamOnBlob(int n, int n2, int n3, int n4, boolean bl) throws SQLException {
        this.psInsertBlob.setInt(1, n);
        if (bl) {
            this.psInsertBlob.setBinaryStream(2, new LoopingAlphabetStream((long)n2, n4));
        } else {
            this.psInsertBlob.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)n2, n4), n3);
        }
        PreparedStatementTest.assertEquals((String)"Insert with setBinaryStream failed", (int)1, (int)this.psInsertBlob.executeUpdate());
    }

    private void setAsciiStream(PreparedStatement preparedStatement, int n, int n2, int n3, int n4, boolean bl) throws SQLException {
        preparedStatement.setInt(1, n);
        if (bl) {
            preparedStatement.setAsciiStream(2, new LoopingAlphabetStream((long)n2, n4));
        } else {
            preparedStatement.setAsciiStream(2, (InputStream)new LoopingAlphabetStream((long)n2, n4), n3);
        }
        PreparedStatementTest.assertEquals((String)"Insert with setAsciiStream failed", (int)1, (int)preparedStatement.executeUpdate());
    }

    private static int requestKey() {
        return globalKey++;
    }

    private void assertInternalDerbyIOExceptionState(String string, String string2, SQLException sQLException) {
        PreparedStatementTest.assertSQLState("Outer/public SQL state incorrect", string, sQLException);
        Throwable throwable = this.getLastSQLException(sQLException).getCause();
        PreparedStatementTest.assertEquals((String)"org.apache.derby.shared.common.error.StandardException", (String)throwable.getClass().getName());
        throwable = throwable.getCause();
        PreparedStatementTest.assertTrue((String)"Exception not a DerbyIOException", (boolean)(throwable instanceof DerbyIOException));
        DerbyIOException derbyIOException = (DerbyIOException)throwable;
        PreparedStatementTest.assertEquals((String)"Incorrect internal SQL state", (String)string2, (String)derbyIOException.getSQLState());
    }

    public static class PreparedStatementWrapper
    extends StatementTest.StatementWrapper {
        private PreparedStatement _wrappedPreparedStatement;

        public PreparedStatementWrapper(PreparedStatement preparedStatement) {
            super(preparedStatement);
        }

        PreparedStatement getWrappedPreparedStatement() {
            return (PreparedStatement)this.getWrappedStatement();
        }

        public long executeLargeUpdate() throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[0], new Object[0]);
        }
    }
}

