/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.DeadlockWatchdog;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;
import org.apache.derbyTesting.junit.XATestUtil;

public class XATest
extends BaseJDBCTestCase {
    public static final String LOCKTIMEOUT = "40XL1";

    public XATest(String string) {
        super(string);
    }

    public void testSingleConnectionOnePhaseCommit() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(0, 32, 46);
        xAResource.start(xid, 0);
        Connection connection = xAConnection.getConnection();
        XATest.assertEquals((int)2, (int)connection.getHoldability());
        Statement statement = connection.createStatement();
        XATest.assertEquals((int)2, (int)statement.getResultSetHoldability());
        statement.execute("create table foo (a int)");
        statement.executeUpdate("insert into foo values (0)");
        ResultSet resultSet = statement.executeQuery("select * from foo");
        JDBC.assertDrainResults(resultSet, 1);
        String[][] stringArray = new String[][]{{"(0", "ACTIVE", "false", "APP", "UserTransaction"}};
        XATestUtil.checkXATransactionView(connection, stringArray);
        statement.close();
        xAResource.end(xid, 0x4000000);
        xAResource.commit(xid, true);
        connection.close();
        xAConnection.close();
    }

    public void testInterleavingTransactions() throws SQLException, XAException {
        Statement statement;
        Connection connection;
        XAConnection xAConnection;
        block9: {
            Object object;
            String[][] stringArray;
            Xid xid;
            Xid xid2;
            XAResource xAResource;
            block8: {
                Statement statement2 = this.getConnection().createStatement();
                statement2.execute("create table fooInterleaving (a int)");
                statement2.execute("insert into fooInterleaving values (0)");
                statement2.close();
                XADataSource xADataSource = J2EEDataSource.getXADataSource();
                xAConnection = xADataSource.getXAConnection("sku", "testxa");
                xAResource = xAConnection.getXAResource();
                xid2 = XATestUtil.getXid(1, 93, 18);
                xid = XATestUtil.getXid(2, 45, 77);
                xAResource.start(xid2, 0);
                connection = xAConnection.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate("insert into APP.fooInterleaving values (1)");
                xAResource.end(xid2, 0x2000000);
                xAResource.start(xid, 0);
                statement.executeUpdate("insert into APP.fooInterleaving values (2)");
                xAResource.end(xid, 0x2000000);
                xAResource.start(xid2, 0x8000000);
                statement.executeUpdate("insert into APP.fooInterleaving values (3)");
                xAResource.end(xid2, 0x2000000);
                xAResource.start(xid, 0x8000000);
                statement.executeUpdate("insert into APP.fooInterleaving values (4)");
                stringArray = new String[][]{{"(1", "ACTIVE", "false", "SKU", "UserTransaction"}, {"(2", "ACTIVE", "false", "SKU", "UserTransaction"}};
                XATestUtil.checkXATransactionView(connection, stringArray);
                try {
                    xAResource.prepare(xid2);
                    XATest.fail((String)"FAIL - prepare on suspended transaction");
                }
                catch (XAException xAException) {
                    if (xAException.errorCode == -6) break block8;
                    XATestUtil.dumpXAException("FAIL - prepare on suspended transaction", xAException);
                }
            }
            XATestUtil.checkXATransactionView(connection, stringArray);
            xAResource.end(xid, 0x4000000);
            xAResource.end(xid2, 0x4000000);
            xAResource.prepare(xid2);
            xAResource.prepare(xid);
            stringArray = new String[][]{{"(1", "PREPARED", "false", "SKU", "UserTransaction"}, {"(2", "PREPARED", "false", "SKU", "UserTransaction"}};
            XATestUtil.checkXATransactionView(connection, stringArray);
            Xid[] xidArray = xAResource.recover(0x1000000);
            XATest.assertEquals((int)2, (int)xidArray.length);
            Xid[] xidArray2 = xAResource.recover(0);
            XATest.assertEquals((int)0, (int)xidArray2.length);
            Xid[] xidArray3 = xAResource.recover(0x800000);
            XATest.assertEquals((int)0, (int)xidArray3.length);
            for (int i = 0; i < xidArray.length; ++i) {
                object = xidArray[i];
                if (object.getFormatId() == 1) {
                    xAResource.commit((Xid)object, false);
                    continue;
                }
                if (object.getFormatId() == 2) {
                    xAResource.rollback((Xid)object);
                    continue;
                }
                XATest.fail((String)"FAIL: unknown xact");
            }
            Xid xid3 = XATestUtil.getXid(3, 2, 101);
            xAResource.start(xid3, 0);
            stringArray = new String[][]{{"(3", "IDLE", "NULL", "SKU", "UserTransaction"}};
            XATestUtil.checkXATransactionView(connection, stringArray);
            object = statement.executeQuery("select * from APP.fooInterleaving");
            stringArray = new String[][]{{"0"}, {"1"}, {"3"}};
            JDBC.assertFullResultSet((ResultSet)object, stringArray);
            object.close();
            xAResource.end(xid3, 0x4000000);
            int n = xAResource.prepare(xid3);
            if (n != 3) {
                XATest.fail((String)("FAIL - prepare on read only xact returned " + n));
            }
            try {
                xAResource.commit(xid3, true);
                XATest.fail((String)"FAIL - 2pc commit on read-only xact");
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -4) break block9;
                throw xAException;
            }
        }
        statement.close();
        connection.close();
        xAConnection.close();
    }

    public void testNoTransaction() throws SQLException, XAException {
        block29: {
            Xid xid;
            XAResource xAResource;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                XADataSource xADataSource = J2EEDataSource.getXADataSource();
                                                XAConnection xAConnection = xADataSource.getXAConnection();
                                                xAResource = xAConnection.getXAResource();
                                                xid = XATestUtil.getXid(11, 3, 128);
                                                try {
                                                    xAResource.start(xid, 0x200000);
                                                }
                                                catch (XAException xAException) {
                                                    if (xAException.errorCode == -4) break block20;
                                                    throw xAException;
                                                }
                                            }
                                            try {
                                                xAResource.start(xid, 0x8000000);
                                            }
                                            catch (XAException xAException) {
                                                if (xAException.errorCode == -4) break block21;
                                                throw xAException;
                                            }
                                        }
                                        try {
                                            xAResource.end(xid, 0x4000000);
                                        }
                                        catch (XAException xAException) {
                                            if (xAException.errorCode == -4) break block22;
                                            throw xAException;
                                        }
                                    }
                                    try {
                                        xAResource.end(xid, 0x20000000);
                                    }
                                    catch (XAException xAException) {
                                        if (xAException.errorCode == -4) break block23;
                                        throw xAException;
                                    }
                                }
                                try {
                                    xAResource.end(xid, 0x2000000);
                                }
                                catch (XAException xAException) {
                                    if (xAException.errorCode == -4) break block24;
                                    throw xAException;
                                }
                            }
                            try {
                                xAResource.prepare(xid);
                            }
                            catch (XAException xAException) {
                                if (xAException.errorCode == -4) break block25;
                                throw xAException;
                            }
                        }
                        try {
                            xAResource.commit(xid, false);
                        }
                        catch (XAException xAException) {
                            if (xAException.errorCode == -4) break block26;
                            throw xAException;
                        }
                    }
                    try {
                        xAResource.commit(xid, true);
                    }
                    catch (XAException xAException) {
                        if (xAException.errorCode == -4) break block27;
                        throw xAException;
                    }
                }
                try {
                    xAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    if (xAException.errorCode == -4) break block28;
                    throw xAException;
                }
            }
            try {
                xAResource.forget(xid);
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -4) break block29;
                throw xAException;
            }
        }
    }

    public void testMorph() throws SQLException, XAException {
        Xid xid;
        ResultSet resultSet;
        String[][] stringArray;
        Statement statement;
        Connection connection;
        XAResource xAResource;
        XAConnection xAConnection;
        block27: {
            block26: {
                Xid xid2;
                block25: {
                    Statement statement2 = this.getConnection().createStatement();
                    statement2.execute("create table fooMorph (a int)");
                    statement2.executeUpdate("insert into APP.fooMorph values (0)");
                    statement2.executeUpdate("insert into APP.fooMorph values (1)");
                    statement2.executeUpdate("insert into APP.fooMorph values (2)");
                    statement2.executeUpdate("insert into APP.fooMorph values (3)");
                    statement2.executeUpdate("insert into APP.fooMorph values (4)");
                    statement2.close();
                    XADataSource xADataSource = J2EEDataSource.getXADataSource();
                    xAConnection = xADataSource.getXAConnection();
                    xAResource = xAConnection.getXAResource();
                    connection = xAConnection.getConnection();
                    connection.setAutoCommit(false);
                    statement = connection.createStatement();
                    statement.executeUpdate("insert into APP.fooMorph values (2001)");
                    XATestUtil.checkXATransactionView(connection, null);
                    connection.commit();
                    connection.setAutoCommit(true);
                    statement.executeUpdate("insert into APP.fooMorph values (2002)");
                    XATestUtil.checkXATransactionView(connection, null);
                    xid2 = XATestUtil.getXid(1001, 66, 13);
                    xAResource.start(xid2, 0);
                    stringArray = new String[][]{{"(1", "IDLE", "NULL", "APP", "UserTransaction"}};
                    XATestUtil.checkXATransactionView(connection, stringArray);
                    statement.executeUpdate("insert into APP.fooMorph values (2003)");
                    try {
                        connection.commit();
                        XATest.fail((String)"FAIL: commit allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        connection.rollback();
                        XATest.fail((String)"FAIL: roll back allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        connection.setAutoCommit(true);
                        XATest.fail((String)"FAIL: setAutoCommit(true) allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        connection.setSavepoint();
                        XATest.fail((String)"FAIL: setSavepoint() allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        connection.setSavepoint("badsavepoint");
                        XATest.fail((String)"FAIL: setSavepoint(String) allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    connection.setAutoCommit(false);
                    statement.executeQuery("select * from APP.fooMorph where A >= 2000").close();
                    statement.close();
                    statement = connection.createStatement();
                    XATest.assertEquals((int)2, (int)statement.getResultSetHoldability());
                    resultSet = statement.executeQuery("select * from APP.fooMorph where A >= 2000");
                    stringArray = new String[][]{{"2001"}, {"2002"}, {"2003"}};
                    resultSet.close();
                    xAResource.end(xid2, 0x4000000);
                    xAResource.prepare(xid2);
                    try {
                        xAResource.start(xid2, 0);
                        XATest.fail((String)"FAIL - start with duplicate XID");
                    }
                    catch (XAException xAException) {
                        if (xAException.errorCode == -8) break block25;
                        throw xAException;
                    }
                }
                Xid xid3 = XATestUtil.getXid(1002, 23, 3);
                xAResource.start(xid3, 0);
                try {
                    connection.commit();
                    XATest.fail((String)"FAIL: commit allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    connection.rollback();
                    XATest.fail((String)"FAIL: roll back allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    connection.setAutoCommit(true);
                    XATest.fail((String)"FAIL: setAutoCommit(true) allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                connection.setAutoCommit(false);
                xAResource.end(xid3, 0x2000000);
                connection = xAConnection.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate("insert into APP.fooMorph values (2005)");
                connection.commit();
                connection.setAutoCommit(false);
                statement.executeUpdate("insert into APP.fooMorph values (2006)");
                connection.rollback();
                statement.executeUpdate("insert into APP.fooMorph values (2007)");
                connection.commit();
                stringArray = new String[][]{{"(1", "PREPARED", "false", "APP", "UserTransaction"}, {"(1", "IDLE", "NULL", "APP", "UserTransaction"}};
                XATestUtil.checkXATransactionView(connection, stringArray);
                xAResource.commit(xid2, false);
                xAResource.end(xid3, 0x4000000);
                xAResource.rollback(xid3);
                XATestUtil.checkXATransactionView(connection, null);
                resultSet = statement.executeQuery("select * from APP.fooMorph where A >= 2000");
                stringArray = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
                JDBC.assertFullResultSet(resultSet, stringArray);
                resultSet.close();
                connection.rollback();
                connection.close();
                connection = xAConnection.getConnection();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                statement.executeUpdate("delete from app.fooMorph");
                resultSet = statement.executeQuery("select * from APP.fooMorph");
                JDBC.assertEmpty(resultSet);
                resultSet.close();
                connection = xAConnection.getConnection();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select * from APP.fooMorph where A >= 2000");
                stringArray = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
                JDBC.assertFullResultSet(resultSet, stringArray);
                xid = XATestUtil.getXid(1003, 27, 9);
                try {
                    xAResource.start(xid, 0);
                    XATest.fail((String)"FAIL XAResource.start on a global transaction with an active local transaction (autocommit false)");
                }
                catch (XAException xAException) {
                    if (xAException.errorCode == -9) break block26;
                    throw xAException;
                }
            }
            connection.commit();
            xAResource.start(xid, 0);
            if (XATest.usingEmbedded()) {
                try {
                    xAConnection.getConnection();
                    XATest.fail((String)"FAIL: getConnection with active global xact");
                }
                catch (SQLException sQLException) {
                    XATest.assertSQLState("XJ059", sQLException);
                }
            }
            statement = connection.createStatement();
            statement.executeUpdate("delete from APP.fooMorph");
            resultSet = statement.executeQuery("select * from APP.fooMorph where A >= 2000");
            JDBC.assertEmpty(resultSet);
            resultSet.close();
            try {
                xAResource.end(xid, 0x20000000);
            }
            catch (XAException xAException) {
                if (xAException.errorCode == 100) break block27;
                throw xAException;
            }
        }
        xAResource.rollback(xid);
        connection = xAConnection.getConnection();
        statement = connection.createStatement();
        resultSet = statement.executeQuery("select * from APP.fooMorph where A >= 2000");
        stringArray = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet.close();
        statement.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby4310PreparedStatement() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(1, 93, 18);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE foo4310_PS (I INT)");
        connection.createStatement().executeUpdate("insert into APP.foo4310_PS values (0)");
        connection.createStatement().executeUpdate("insert into APP.foo4310_PS values (1)");
        connection.createStatement().executeUpdate("insert into APP.foo4310_PS values (2)");
        connection.commit();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM APP.foo4310_PS");
        preparedStatement.executeQuery().close();
        xAResource.start(xid, 0);
        xAResource.end(xid, 0x4000000);
        Connection connection2 = this.getConnection();
        Statement statement2 = connection2.createStatement();
        statement2.execute("DROP TABLE foo4310_PS");
        connection2.commit();
        connection2.close();
        try {
            preparedStatement.close();
        }
        finally {
            xAResource.rollback(xid);
            connection.close();
            xAConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby4310CallableStatement() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(1, 93, 18);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE PROCEDURE ZA() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.XATest.zeroArg' PARAMETER STYLE JAVA");
        connection.commit();
        CallableStatement callableStatement = connection.prepareCall("CALL ZA()");
        callableStatement.execute();
        xAResource.start(xid, 0);
        xAResource.end(xid, 0x4000000);
        Connection connection2 = this.getConnection();
        Statement statement2 = connection2.createStatement();
        statement2.execute("DROP PROCEDURE ZA");
        connection2.commit();
        connection2.close();
        try {
            callableStatement.close();
        }
        finally {
            xAResource.rollback(xid);
            connection.close();
            xAConnection.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testDerby966() throws SQLException, XAException {
        void var29_34;
        Statement statement = this.getConnection().createStatement();
        statement.execute("create table foo966 (a int)");
        statement.executeUpdate("insert into APP.foo966 values (0)");
        statement.executeUpdate("insert into APP.foo966 values (1)");
        statement.executeUpdate("insert into APP.foo966 values (2)");
        statement.executeUpdate("insert into APP.foo966 values (3)");
        statement.executeUpdate("insert into APP.foo966 values (4)");
        statement.executeUpdate("insert into APP.foo966 values (2001)");
        statement.executeUpdate("insert into APP.foo966 values (2002)");
        statement.executeUpdate("insert into APP.foo966 values (2003)");
        statement.executeUpdate("insert into APP.foo966 values (2005)");
        statement.executeUpdate("insert into APP.foo966 values (2007)");
        statement.close();
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(996, 9, 48);
        Connection connection = xAConnection.getConnection();
        XATest.assertEquals((int)1, (int)connection.getHoldability());
        Statement statement2 = connection.createStatement();
        XATest.assertEquals((int)1, (int)statement2.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement2, statement2.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM APP.foo966");
        PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99");
        XATest.assertEquals((int)1, (int)preparedStatement.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement, preparedStatement.executeQuery());
        Statement statement3 = connection.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)1, (int)statement3.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement3, statement3.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement3 = connection.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
        PreparedStatement preparedStatement4 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 1);
        XATest.assertEquals((int)1, (int)statement3.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement3, preparedStatement3.executeQuery());
        Statement statement4 = connection.createStatement(1003, 1007, 2);
        XATest.assertEquals((int)2, (int)statement4.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement4, statement4.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement5 = connection.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 2);
        PreparedStatement preparedStatement6 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 2);
        XATest.assertEquals((int)2, (int)preparedStatement6.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement5, preparedStatement5.executeQuery());
        connection.setHoldability(2);
        Statement statement5 = connection.createStatement();
        XATest.assertEquals((int)2, (int)statement5.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement5, statement5.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement7 = connection.prepareStatement("SELECT * FROM APP.foo966");
        PreparedStatement preparedStatement8 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99");
        XATest.assertEquals((int)2, (int)preparedStatement7.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement7, preparedStatement7.executeQuery());
        Statement statement6 = connection.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)2, (int)preparedStatement7.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement6, statement6.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement9 = connection.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
        PreparedStatement preparedStatement10 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 1);
        XATest.assertEquals((int)1, (int)preparedStatement9.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement9, preparedStatement9.executeQuery());
        Statement statement7 = connection.createStatement(1003, 1007, 2);
        XATest.assertEquals((int)2, (int)statement7.getResultSetHoldability());
        XATest.checkHeldRS(connection, statement7, statement7.executeQuery("select * from app.foo966"));
        PreparedStatement preparedStatement11 = connection.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 2);
        PreparedStatement preparedStatement12 = connection.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 2);
        XATest.assertEquals((int)2, (int)preparedStatement11.getResultSetHoldability());
        XATest.checkHeldRS(connection, preparedStatement11, preparedStatement11.executeQuery());
        connection.setHoldability(1);
        ResultSet resultSet = statement2.executeQuery("SELECT * FROM APP.foo966");
        resultSet.next();
        XATest.assertEquals((int)0, (int)resultSet.getInt(1));
        connection.commit();
        resultSet.next();
        XATest.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement2.executeQuery("SELECT * FROM APP.foo966");
        xAResource.start(xid, 0);
        statement2.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        statement3.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        statement4.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        arrayList.add(statement2.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(statement3.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(statement4.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(preparedStatement.executeQuery());
        arrayList.add(preparedStatement3.executeQuery());
        arrayList.add(preparedStatement5.executeQuery());
        preparedStatement2.executeUpdate();
        preparedStatement4.executeUpdate();
        preparedStatement6.executeUpdate();
        statement5.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        statement6.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        statement7.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        arrayList.add(statement5.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(statement6.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(statement7.executeQuery("SELECT * FROM APP.foo966"));
        arrayList.add(preparedStatement7.executeQuery());
        arrayList.add(preparedStatement9.executeQuery());
        arrayList.add(preparedStatement11.executeQuery());
        preparedStatement8.executeUpdate();
        preparedStatement10.executeUpdate();
        preparedStatement12.executeUpdate();
        int n = 0;
        for (ResultSet autoCloseable : arrayList) {
            autoCloseable.clearWarnings();
            ++n;
        }
        XATest.assertEquals((String)"Incorrect number of open result sets", (int)12, (int)n);
        try {
            connection.setHoldability(1);
            XATest.fail((String)"FAIL - set holdability in global xact.");
        }
        catch (SQLException sQLException) {
            XATest.assertSQLState("XJ05C", sQLException);
        }
        Statement statement8 = connection.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)2, (int)statement8.getResultSetHoldability());
        statement8.close();
        if (!XATest.usingDerbyNetClient()) {
            PreparedStatement n2 = connection.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
            XATest.assertEquals((int)2, (int)n2.getResultSetHoldability());
            n2.close();
            XATest.assertEquals((int)2, (int)statement2.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)statement4.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement3.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement5.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)statement5.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)statement6.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)statement7.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement2.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement4.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)preparedStatement6.getResultSetHoldability());
        }
        xAResource.end(xid, 0x4000000);
        if (xAResource.prepare(xid) != 3) {
            XATest.fail((String)"FAIL prepare didn't indicate r/o");
        }
        boolean bl = false;
        for (ResultSet resultSet2 : arrayList) {
            try {
                resultSet2.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++var29_34;
        }
        XATest.assertEquals((String)"After global transaction closed ResultSets ", (int)12, (int)var29_34);
        XATest.assertEquals((int)1, (int)statement2.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)statement3.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)statement4.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)preparedStatement.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)preparedStatement3.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)preparedStatement5.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)statement5.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)statement6.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)statement7.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)preparedStatement2.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)preparedStatement4.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)preparedStatement6.getResultSetHoldability());
        connection.rollback();
        connection.close();
    }

    public void testXATempTableD4731_RawStore() throws SQLException, XAException {
        this.doXATempTableD4731Work(true, false, XATestUtil.getXid(997, 9, 49));
    }

    public void xtestXATempTableD4735_Assert() throws SQLException, XAException {
        this.doXATempTableD4731Work(false, false, XATestUtil.getXid(999, 11, 51));
        this.doXATempTableD4731Work(false, true, XATestUtil.getXid(1000, 12, 52));
    }

    public void testXATempTableD4743() throws SQLException, XAException {
        this.doXATempTableD4731Work(true, true, XATestUtil.getXid(998, 10, 50));
    }

    public void testXALockTimeout() throws SQLException, XAException {
        AutoCloseable autoCloseable;
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(998, 10, 50);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        xAResource.start(xid, 0);
        statement.executeUpdate("INSERT INTO TABLT VALUES(2)");
        XAConnection xAConnection2 = xADataSource.getXAConnection();
        XAResource xAResource2 = xAConnection2.getXAResource();
        Xid xid2 = XATestUtil.getXid(999, 11, 51);
        Connection connection2 = xAConnection2.getConnection();
        connection2.setTransactionIsolation(8);
        xAResource2.start(xid2, 0);
        Statement statement2 = connection2.createStatement();
        statement2.executeUpdate("INSERT INTO TABLT VALUES(3)");
        this.assertGlobalXactCount(2);
        try {
            autoCloseable = statement2.executeQuery("SELECT * FROM TABLT");
            XATest.fail((String)"Should have gotten lock timeout error: 40XL1");
        }
        catch (SQLException sQLException) {
            XATest.assertSQLState(LOCKTIMEOUT, sQLException);
        }
        this.assertGlobalXactCount(1);
        XATest.assertConnOK(connection);
        XATest.assertConnOK(connection2);
        xAResource.end(xid, 0x4000000);
        xAResource.prepare(xid);
        xAResource.commit(xid, false);
        try {
            xAResource2.end(xid2, 0x4000000);
            XATest.fail((String)"Should have gotten exception ending xid2");
        }
        catch (XAException xAException) {
            XATest.assertEquals((int)106, (int)xAException.errorCode);
        }
        autoCloseable = this.createStatement();
        autoCloseable.executeUpdate("DROP TABLE TABLT");
        this.assertGlobalXactCount(0);
        xAResource2.rollback(xid2);
        xAResource.start(xid, 0);
        statement.executeUpdate("CREATE TABLE TABLT (I INT)");
        statement.executeUpdate("INSERT INTO TABLT VALUES(1)");
        xAResource.end(xid, 0x4000000);
        xAResource.prepare(xid);
        xAResource.commit(xid, false);
        xAResource2.start(xid2, 0);
        statement2.executeUpdate("INSERT INTO TABLT VALUES(2)");
        xAResource2.end(xid2, 0x4000000);
        xAResource.prepare(xid2);
        xAResource.commit(xid2, false);
        this.assertGlobalXactCount(0);
        connection.close();
        xAConnection.close();
        connection2.close();
        xAConnection2.close();
    }

    public void testDerby6879() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        Connection connection = J2EEDataSource.getConnectionPoolDataSource().getPooledConnection().getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("LOCK TABLE TABLT IN EXCLUSIVE MODE");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        xAResource.setTransactionTimeout(2);
        Xid xid = XATestUtil.getXid(6879, 11, 51);
        Connection connection2 = xAConnection.getConnection();
        connection2.setTransactionIsolation(8);
        xAResource.start(xid, 0);
        Statement statement2 = connection2.createStatement();
        this.assertGlobalXactCount(1);
        DeadlockWatchdog deadlockWatchdog = new DeadlockWatchdog(30000L);
        deadlockWatchdog.start();
        try {
            ResultSet resultSet = statement2.executeQuery("SELECT * FROM TABLT");
            XATest.fail((String)"Should have gotten lock timeout error: 40XL1");
        }
        catch (SQLException sQLException) {
            XATest.assertSQLState(LOCKTIMEOUT, sQLException);
        }
        deadlockWatchdog.stop();
        try {
            xAResource.end(xid, 0x4000000);
            XATest.fail((String)"Should have gotten exception ending xid2");
        }
        catch (XAException xAException) {
            XATest.assertTrue((xAException.errorCode >= -9 || xAException.errorCode <= -2 ? 1 : 0) != 0);
        }
        connection.commit();
        connection.close();
        connection2.close();
        xAConnection.close();
    }

    private void doXATempTableD4731Work(boolean bl, boolean bl2, Xid xid) throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        xAResource.start(xid, 0);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        if (bl) {
            this.makeARealTable(statement);
        }
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.T1 ( XWSID INT, XCTID INT, XIID CHAR(26), XVID SMALLINT, XLID CHAR(8) FOR BIT DATA) ON COMMIT DELETE ROWS NOT LOGGED ON ROLLBACK DELETE ROWS");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO SESSION.T1 VALUES (?,?,?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setString(3, "hello");
        preparedStatement.setShort(4, (short)1);
        preparedStatement.setBytes(5, new byte[]{0, 1});
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM SESSION.t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet.close();
        xAResource.end(xid, 0x4000000);
        XATest.assertEquals((int)(bl ? 0 : 3), (int)xAResource.prepare(xid));
        if (bl) {
            xAResource.commit(xid, false);
        }
        if (bl2) {
            XATest.assertStatementError("42X05", statement, "SELECT count(*) FROM SESSION.t1");
            connection.commit();
        }
        statement.close();
        connection.close();
        xAConnection.close();
    }

    private void makeARealTable(Statement statement) throws SQLException {
        try {
            statement.executeUpdate("DROP TABLE REALTABLE1");
        }
        catch (SQLException sQLException) {
            statement.executeUpdate("CREATE TABLE REALTABLE1 (i int)");
        }
    }

    private static void checkHeldRS(Connection connection, Statement statement, ResultSet resultSet) throws SQLException {
        if (!XATest.usingDerbyNetClient() && statement.getConnection() != connection) {
            XATest.fail((String)"FAIL - mismatched statement & Connection");
        }
        if (resultSet.getStatement() != statement) {
            XATest.fail((String)("FAIL - mismatched statement & ResultSet  Statement class " + String.valueOf(statement.getClass()) + " ResultSet' Statements class " + String.valueOf(resultSet.getStatement().getClass())));
        }
        boolean bl = 1 == statement.getResultSetHoldability();
        resultSet.next();
        XATest.assertEquals((int)0, (int)resultSet.getInt(1));
        connection.commit();
        try {
            resultSet.next();
        }
        catch (SQLException sQLException) {
            boolean bl2;
            boolean bl3 = bl2 = !bl;
            if (bl2) {
                XATest.assertSQLState("XCL16", sQLException);
            }
            XATest.fail((String)"Held cursor closed on commit");
        }
        resultSet.close();
        connection.commit();
    }

    public static void zeroArg() {
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(XATest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                XATestUtil.createXATransactionView(statement);
                statement.executeUpdate("CREATE TABLE TABLT (I INT)");
                statement.executeUpdate("INSERT INTO TABLT VALUES(1)");
            }
        };
    }

    private static void assertConnOK(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("VALUES(1)");
        JDBC.assertSingleValueResultSet(resultSet, "1");
    }

    private void assertGlobalXactCount(int n) throws SQLException {
        Connection connection = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM syscs_diag.transaction_table WHERE GLOBAL_XID IS NOT NULL");
        resultSet.next();
        int n2 = resultSet.getInt(1);
        if (TestConfiguration.getCurrent().isVerbose()) {
            System.out.println("assertGlobalXactCount(" + n + "): Full Transaction Table ...");
            Utilities.showResultSet(statement.executeQuery("SELECT * FROM syscs_diag.transaction_table"));
        }
        XATest.assertTrue((String)("Expected " + n + "global transactions but saw " + n2), (n == n2 ? 1 : 0) != 0);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XATest");
        if (JDBC.vmSupportsJSR169()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(XATest.baseSuite("XATest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(XATest.baseSuite("XATest:client")));
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 3, 5);
        test = XATest.decorateWithPolicy(test);
        return test;
    }

    private static Test decorateWithPolicy(Test test) {
        return test;
    }
}

