/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DestroySlaveDB
extends BaseJDBCTestCase {
    private static String slaveServerHost = null;
    private static ReplicationRun repRun = new ReplicationRun("DestroySlaveDB");

    public DestroySlaveDB(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        System.out.println("**** DestroySlaveDB.suite()");
        System.out.println("'DestroySlaveDB' can not be run outside the 'ReplicationRun' framework.");
        BaseTestSuite baseTestSuite = new BaseTestSuite("DestroySlaveDB");
        String string = System.getProperty("test.serverHost", "localhost");
        int n = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        repRun.initEnvironment();
        slaveServerHost = ReplicationRun.slaveServerHost;
        baseTestSuite.addTest(DestroySlaveDB.suite(string, n));
        return baseTestSuite;
    }

    public static Test suite(String string, int n) {
        System.out.println("*** DestroySlaveDB.suite(" + string + "," + n + ")");
        Test test = TestConfiguration.existingServerSuite(DestroySlaveDB.class, false, string, n);
        System.out.println("*** Done TestConfiguration.existingServerSuite(DestroySlaveDB.class,false," + string + "," + n + ")");
        return test;
    }

    public void testDestroySlaveDB() throws SQLException, IOException, InterruptedException {
        System.out.println("**** DestroySlaveDB.testDestroySlaveDB() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "i" + i);
            preparedStatement.execute();
            System.out.println("i: " + i);
            if (i != 500) continue;
            repRun.destroySlaveDB(slaveServerHost);
        }
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        System.out.println("count: " + n);
    }
}

