/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.OnlineBackup;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackupTest1 {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String TEST_TABLE_NAME = "emp";
    private static final String TEST_TABLE_NAME_1 = "emp_1";
    private static final String TEST_TABLE_NAME_2 = "emp_2";
    private static final String BACKUP_PATH = "extinout/onlinebackuptest1";

    public static void main(String[] stringArray) throws Throwable {
        OnlineBackupTest1 onlineBackupTest1 = new OnlineBackupTest1();
        ij.getPropertyArg((String[])stringArray);
        try {
            onlineBackupTest1.runTest();
        }
        catch (SQLException sQLException) {
            OnlineBackupTest1.dumpSQLException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest() throws Exception {
        this.logMessage("Begin Online Backup Test1");
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        DatabaseActions databaseActions = new DatabaseActions(connection);
        databaseActions.createTable(TEST_TABLE_NAME);
        databaseActions.createTable(TEST_TABLE_NAME_1);
        databaseActions.createTable(TEST_TABLE_NAME_2);
        connection.commit();
        databaseActions.startUnloggedAction(TEST_TABLE_NAME_1);
        this.logMessage("First Transaction with Unlogged Operation Started");
        Connection connection2 = ij.startJBMS();
        connection2.setAutoCommit(false);
        DatabaseActions databaseActions2 = new DatabaseActions(connection2);
        databaseActions2.startUnloggedAction(TEST_TABLE_NAME_2);
        this.logMessage("Second Transaction with Unlogged Operation Started");
        OnlineBackup onlineBackup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread thread = new Thread((Runnable)onlineBackup, "BACKUP");
        Connection connection3 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        DatabaseActions databaseActions3 = new DatabaseActions(1, connection3);
        Thread thread2 = new Thread((Runnable)databaseActions3, "DML_THREAD");
        Connection connection4 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        DatabaseActions databaseActions4 = new DatabaseActions(2, connection4);
        Thread thread3 = new Thread((Runnable)databaseActions4, "DDL_THREAD");
        try {
            thread.start();
            onlineBackup.waitForBackupToBegin();
            this.logMessage("BACKUP STARTED");
            thread2.start();
            thread3.start();
            Thread.sleep(50000L);
            if (!onlineBackup.isRunning()) {
                this.logMessage("Backup is not waiting for unlogged actions to commit");
            }
            databaseActions.endUnloggedAction(TEST_TABLE_NAME_1);
            databaseActions2.endUnloggedAction(TEST_TABLE_NAME_2);
            onlineBackup.waitForBackupToEnd();
        }
        finally {
            thread.join();
            databaseActions3.stopActivity();
            databaseActions4.stopActivity();
            thread2.join();
            thread3.join();
        }
        connection.close();
        connection2.close();
        connection3.close();
        connection4.close();
        this.shutdown(TEST_DATABASE_NAME);
        onlineBackup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        this.runConsistencyChecker(TEST_DATABASE_NAME);
        this.logMessage("Consistency Check is Done");
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Online Backup Test1");
    }

    void runConsistencyChecker(String string) throws SQLException {
        Connection connection = TestUtil.getConnection(string, null);
        Statement statement = connection.createStatement();
        statement.execute("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP',  'EMP')");
        DatabaseActions databaseActions = new DatabaseActions(connection);
        databaseActions.select(TEST_TABLE_NAME);
        databaseActions.select(TEST_TABLE_NAME_1);
        databaseActions.select(TEST_TABLE_NAME_2);
        connection.close();
    }

    void shutdown(String string) {
        try {
            TestUtil.getConnection(string, "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            OnlineBackupTest1.dumpSQLException(sQLException);
        }
    }

    void logMessage(String string) {
        System.out.println(string);
    }

    private static void dumpSQLException(SQLException sQLException) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        sQLException.printStackTrace(System.out);
    }

    class DatabaseActions
    implements Runnable {
        public static final int DMLACTIONS = 1;
        public static final int CREATEDROPS = 2;
        private static final int COMMIT = 1;
        private static final int ROLLBACK = 2;
        private static final int OPENTX = 3;
        private int action = 0;
        private volatile boolean stopActivity = false;
        private Connection conn;

        DatabaseActions(Connection connection) {
            this.conn = connection;
        }

        DatabaseActions(int n, Connection connection) {
            this.action = n;
            this.conn = connection;
        }

        public void stopActivity() {
            this.stopActivity = true;
        }

        @Override
        public void run() {
            try {
                this.conn.setAutoCommit(false);
                switch (this.action) {
                    case 1: {
                        this.performDmlActions();
                        break;
                    }
                    case 2: {
                        this.performCreateDropTables();
                    }
                }
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
                sQLException.printStackTrace(System.out);
            }
        }

        void performDmlActions() throws SQLException {
            while (!this.stopActivity) {
                this.insert(OnlineBackupTest1.TEST_TABLE_NAME, 100, 1, 10);
                this.insert(OnlineBackupTest1.TEST_TABLE_NAME, 100, 2, 10);
                this.update(OnlineBackupTest1.TEST_TABLE_NAME, 50, 2, 10);
                this.select(OnlineBackupTest1.TEST_TABLE_NAME);
            }
        }

        void startUnloggedAction(String string) throws SQLException {
            this.insert(string, 100, 1, 10);
            Statement statement = this.conn.createStatement();
            statement.executeUpdate("create index " + string + "_name_idx on " + string + "(name) ");
            statement.close();
        }

        void endUnloggedAction(String string) throws SQLException {
            this.insert(string, 1000, 3, 10);
            this.conn.commit();
        }

        void performCreateDropTables() throws SQLException {
            Statement statement = this.conn.createStatement();
            while (!this.stopActivity) {
                String string;
                int n;
                for (n = 0; n < 10; ++n) {
                    string = OnlineBackupTest1.TEST_TABLE_NAME + n;
                    this.createTable(string);
                    this.insert(string, 100, 3, 10);
                    if (n % 2 == 0) {
                        this.conn.commit();
                        continue;
                    }
                    this.conn.rollback();
                }
                for (n = 0; n < 10; n += 2) {
                    string = OnlineBackupTest1.TEST_TABLE_NAME + n;
                    statement.executeUpdate("drop TABLE emp" + n);
                    this.conn.commit();
                }
            }
            statement.close();
        }

        void insert(String string, int n, int n2, int n3) throws SQLException {
            PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO " + string + " VALUES(?,?,?)");
            for (int i = 0; i < n; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.setString(2, "skywalker" + i);
                preparedStatement.setFloat(3, i * 2000);
                preparedStatement.executeUpdate();
                if (i % n3 != 0) continue;
                this.endTransaction(n2);
            }
            this.endTransaction(n2);
            preparedStatement.close();
        }

        void endTransaction(int n) throws SQLException {
            switch (n) {
                case 1: {
                    this.conn.commit();
                    break;
                }
                case 2: {
                    this.conn.rollback();
                    break;
                }
            }
        }

        void update(String string, int n, int n2, int n3) throws SQLException {
            PreparedStatement preparedStatement = this.conn.prepareStatement("update " + string + " SET name = ?  where id=?");
            for (int i = 0; i < n; ++i) {
                preparedStatement.setString(1, "moonwalker" + i);
                preparedStatement.setInt(2, i);
                preparedStatement.executeUpdate();
                if (i % n3 != 0) continue;
                this.endTransaction(n2);
            }
            this.endTransaction(n2);
            preparedStatement.close();
        }

        void select(String string) throws SQLException {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT ID, name from " + string + " order by id");
            int n = 0;
            int n2 = 0;
            while (resultSet.next()) {
                int n3 = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                if (string2.equals("skywalker" + n2) && n3 != n2) {
                    OnlineBackupTest1.this.logMessage("DATA IN THE TABLE IS NOT AS EXPECTED");
                    OnlineBackupTest1.this.logMessage("Got :ID=" + n3 + " Name=:" + string2);
                    OnlineBackupTest1.this.logMessage("Expected: ID=" + n2 + "Name=skywalker" + n2);
                }
                ++n2;
                ++n;
            }
            resultSet.close();
            statement.close();
            this.conn.commit();
        }

        void createTable(String string) throws SQLException {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate("CREATE TABLE " + string + "(id INT,name CHAR(200),salary float)");
            statement.executeUpdate("create index " + string + "_id_idx on " + string + "(id)");
            statement.close();
        }
    }
}

