/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CleanDatabaseTestSetup
extends BaseJDBCTestSetup {
    private JDBCClient jdbcClient = null;
    private String hostName = null;
    private int portNo = -1;
    private static final String[] CLEAR_DB_PROPERTIES = new String[]{"derby.database.classpath"};
    private static final String[] COMPRESS_DB_OBJECTS = new String[]{"SYS.SYSDEPENDS"};

    public CleanDatabaseTestSetup(Test test) {
        super(test);
    }

    public CleanDatabaseTestSetup(Test test, boolean bl, String string, int n) {
        super(test);
        if (bl) {
            this.jdbcClient = JDBCClient.DERBYNETCLIENT;
        }
        this.hostName = string;
        this.portNo = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        Object object;
        Object object2;
        if (this.jdbcClient != null) {
            object2 = TestConfiguration.getCurrent();
            object = new TestConfiguration((TestConfiguration)object2, this.jdbcClient, this.hostName, this.portNo);
            TestConfiguration.setCurrent((TestConfiguration)object);
        }
        object2 = this.getConnection();
        object2.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase((Connection)object2, true);
        object = object2.createStatement();
        try {
            this.decorateSQL((Statement)object);
            object.close();
            object2.commit();
        }
        finally {
            block9: {
                try {
                    this.clearConnection();
                }
                catch (SQLException sQLException) {
                    if (!this.getTestConfiguration().isVerbose()) break block9;
                    this.println("clearing connection failed: " + sQLException.getMessage());
                    sQLException.printStackTrace(System.err);
                }
            }
        }
    }

    protected void decorateSQL(Statement statement) throws SQLException {
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        boolean bl = true;
        if (connection.isReadOnly()) {
            connection.setReadOnly(false);
            bl = false;
        }
        CleanDatabaseTestSetup.cleanDatabase(connection, false);
        super.tearDown();
        if (!bl) {
            CleanDatabaseTestSetup.fail((String)"the test that was just run left the conn read-only");
        }
    }

    public static void cleanDatabase(Connection connection, boolean bl) throws SQLException {
        CleanDatabaseTestSetup.clearProperties(connection);
        CleanDatabaseTestSetup.removeObjects(connection);
        if (bl) {
            CleanDatabaseTestSetup.compressObjects(connection);
        }
        CleanDatabaseTestSetup.removeRoles(connection);
        CleanDatabaseTestSetup.removeUsers(connection);
    }

    private static void clearProperties(Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        for (int i = 0; i < CLEAR_DB_PROPERTIES.length; ++i) {
            callableStatement.setString(1, CLEAR_DB_PROPERTIES[i]);
            callableStatement.executeUpdate();
        }
        callableStatement.close();
        connection.commit();
    }

    private static void removeObjects(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        SQLException sQLException = null;
        for (int i = 0; i < 5; ++i) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_SCHEM");
                if (string.startsWith("SYS") || string.equals("SQLJ") || string.equals("NULLID")) continue;
                arrayList.add(string);
            }
            resultSet.close();
            sQLException = null;
            for (String string : arrayList) {
                try {
                    JDBC.dropSchema(databaseMetaData, string);
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                }
            }
            if (sQLException != null) continue;
            return;
        }
        throw sQLException;
    }

    private static void removeRoles(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select roleid from sys.sysroles where cast(isdef as char(1)) = 'Y'");
        while (resultSet.next()) {
            statement2.executeUpdate("DROP ROLE " + JDBC.escape(resultSet.getString(1)));
        }
        statement.close();
        statement2.close();
        connection.commit();
    }

    private static void removeUsers(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select username from sys.sysusers");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("call syscs_util.syscs_drop_user( ? )");
        for (int i = 0; i < arrayList.size(); ++i) {
            preparedStatement.setString(1, (String)arrayList.get(i));
            try {
                preparedStatement.executeUpdate();
                continue;
            }
            catch (SQLException sQLException) {
                if ("4251F".equals(sQLException.getSQLState())) continue;
                throw sQLException;
            }
        }
        preparedStatement.close();
        connection.commit();
    }

    private static void compressObjects(Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        for (int i = 0; i < COMPRESS_DB_OBJECTS.length; ++i) {
            int n = COMPRESS_DB_OBJECTS[i].indexOf(".");
            callableStatement.setString(1, COMPRESS_DB_OBJECTS[i].substring(0, n));
            callableStatement.setString(2, COMPRESS_DB_OBJECTS[i].substring(n + 1));
            callableStatement.execute();
        }
        callableStatement.close();
        connection.commit();
    }
}

