/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.run;

import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.system.oe.load.ThreadInsert;
import org.apache.derbyTesting.system.oe.run.Checks;
import org.apache.derbyTesting.system.oe.run.Schema;

public class Populate
extends JDBCPerfTestCase {
    static short scale = 1;
    static int loaderThreads;
    private static boolean createConstraintsBeforeLoad;
    private static boolean doChecks;

    public Populate(String string) {
        super(string);
    }

    public static void main(String[] stringArray) throws Exception {
        Populate.parseArgs(stringArray);
        String[] stringArray2 = new String[]{"org.apache.derbyTesting.system.oe.run.Populate"};
        TestRunner.main((String[])stringArray2);
    }

    static void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-scale")) {
                scale = Short.parseShort(stringArray[++i]);
                continue;
            }
            if (string.equals("-createConstraintsBeforeLoad")) {
                createConstraintsBeforeLoad = !stringArray[++i].equals("false");
                continue;
            }
            if (string.equals("-doChecks")) {
                doChecks = !stringArray[++i].equals("false");
                continue;
            }
            if (string.equals("-loaderThreads")) {
                loaderThreads = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (string.equals("-help")) {
                Populate.printUsage();
                System.exit(0);
                continue;
            }
            System.err.println("Invalid option: " + stringArray[i]);
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.derbyTesting.system.oe.run.Populate options");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -scale warehouse scaling factor. Takes a short value. If not specified defaults to 1");
        System.out.println("  -createConstraintsBeforeLoad create constraints before initial load of data, takes a boolean value. If not specified, defaults to true)");
        System.out.println("  -doChecks check consistency of data, takes a boolean value. If not specified, defaults to true)");
        System.out.println("  -loaderThreads number of threads used to populate database, defaults to number of cpu cores)");
        System.out.println("  -help prints usage");
        System.out.println();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Order Entry");
        baseTestSuite.addTest((Test)new Populate("testCreateDB"));
        Schema.addBaseSchema(baseTestSuite);
        if (createConstraintsBeforeLoad) {
            Schema.addConstraints(baseTestSuite);
        }
        baseTestSuite.addTest((Test)new Populate("testLoad"));
        if (!createConstraintsBeforeLoad) {
            Schema.addConstraints(baseTestSuite);
        }
        if (doChecks) {
            baseTestSuite.addTest(Checks.checkAllRowCounts(scale));
            baseTestSuite.addTest(Checks.consistencyChecks());
        }
        return baseTestSuite;
    }

    public void testCreateDB() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        dataSource.getConnection().close();
    }

    public void testLoad() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        ThreadInsert threadInsert = new ThreadInsert(dataSource);
        threadInsert.setupLoad(this.getConnection(), scale);
        if (loaderThreads > 0) {
            threadInsert.setThreadCount(loaderThreads);
        }
        threadInsert.populateAllTables();
    }

    static {
        createConstraintsBeforeLoad = true;
        doChecks = true;
    }
}

