/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import junit.framework.Test;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class UTF8UtilTest
extends BaseTestCase {
    private static final String TYPENAME = "VARCHAR";
    private static final int HEADER_LENGTH = 2;

    public UTF8UtilTest(String string) {
        super(string);
    }

    public void testEqualityOfModifedUTF8AndASCII() throws IOException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(12706L);
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(12706L), 12706, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        readerToUTF8Stream.skip(2L);
        UTF8UtilTest.assertEquals(loopingAlphabetStream, (InputStream)readerToUTF8Stream);
    }

    public void testSkipUntilEOFOnZeroLengthStream() throws IOException {
        UTF8UtilTest.assertEquals((long)0L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(0L)));
    }

    public void testSkipUntilEOFOnShortStreamASCII() throws IOException {
        UTF8UtilTest.assertEquals((long)5L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(5L)));
    }

    public void testSkipUntilEOFOnShortStreamCJK() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(5L, CharAlphabet.cjkSubset()), 5, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        readerToUTF8Stream.skip(2L);
        UTF8UtilTest.assertEquals((long)5L, (long)UTF8Util.skipUntilEOF((InputStream)readerToUTF8Stream));
    }

    public void testSkipUntilEOFOnLongStreamASCII() throws IOException {
        UTF8UtilTest.assertEquals((long)127019L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(127019L)));
    }

    public void testSkipUntilEOFOnLongStreamCJK() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(127019L, CharAlphabet.cjkSubset()), 127019, 0, TYPENAME, (StreamHeaderGenerator)new ClobStreamHeaderGenerator(true));
        readerToUTF8Stream.skip(2L);
        UTF8UtilTest.assertEquals((long)127019L, (long)UTF8Util.skipUntilEOF((InputStream)readerToUTF8Stream));
    }

    public void testSkipFullyOnValidLongStreamCJK() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.cjkSubset()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        readerToUTF8Stream.skip(2L);
        UTF8UtilTest.assertEquals((long)483057L, (long)UTF8Util.skipFully((InputStream)readerToUTF8Stream, (long)161019L));
    }

    public void testSkipFullyOnTooShortStreamCJK() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.cjkSubset()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new ClobStreamHeaderGenerator(true));
        readerToUTF8Stream.skip(2L);
        try {
            UTF8Util.skipFully((InputStream)readerToUTF8Stream, (long)161119L);
            UTF8UtilTest.fail((String)"Should have failed because of too short stream.");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testSkipFullyOnInvalidStreamCJK() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(10L, CharAlphabet.cjkSubset()), 10, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        readerToUTF8Stream.skip(2L);
        readerToUTF8Stream.skip(1L);
        try {
            UTF8Util.skipFully((InputStream)readerToUTF8Stream, (long)10L);
            UTF8UtilTest.fail((String)"Should have failed because of UTF error.");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMixedSkipOnStreamTamil() throws IOException {
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.tamil()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        readerToUTF8Stream.skip(2L);
        int n = 10078;
        UTF8UtilTest.assertEquals((long)(n * 3), (long)UTF8Util.skipFully((InputStream)readerToUTF8Stream, (long)n));
        UTF8UtilTest.assertEquals((long)(161019 - n), (long)UTF8Util.skipUntilEOF((InputStream)readerToUTF8Stream));
        try {
            UTF8Util.skipFully((InputStream)readerToUTF8Stream, (long)1L);
            UTF8UtilTest.fail((String)"Should have failed because the stream has been drained.");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testMissingSecondByteOfTwo() throws IOException {
        byte[] byArray = new byte[]{97, -33};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            UTF8Util.skipFully((InputStream)byteArrayInputStream, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMissingSecondByteOfThree() throws IOException {
        byte[] byArray = new byte[]{97, -17};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            UTF8Util.skipFully((InputStream)byteArrayInputStream, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMissingThirdByteOfThree() throws IOException {
        byte[] byArray = new byte[]{97, -17, -72};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            UTF8Util.skipFully((InputStream)byteArrayInputStream, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testInvalidUTF8Encoding() throws IOException {
        byte[] byArray = new byte[]{97, 98, 99, -8, 101, 102};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            UTF8Util.skipFully((InputStream)byteArrayInputStream, (long)6L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testSkippingInvalidEncodingWorks() throws IOException {
        byte[] byArray = new byte[]{97, -17, -72, 97, 97};
        byte[] byArray2 = new byte[]{0, 5, 97, -17, -72, 97, 97};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        UTF8Util.skipFully((InputStream)byteArrayInputStream, (long)3L);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
        try {
            dataInputStream.readUTF();
            UTF8UtilTest.fail((String)"UTF-8 expected to be invalid, read should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new BaseTestSuite(UTF8UtilTest.class, "UTF8Util tests");
    }
}

