/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.lucene.store.IndexOutput;

class DerbyIndexOutput
extends IndexOutput {
    private StorageFile _file;
    private DerbyLuceneDir _parentDir;
    private StorageRandomAccessFile _sraf;
    private final CRC32 _crc = new CRC32();

    DerbyIndexOutput(StorageFile storageFile, DerbyLuceneDir derbyLuceneDir) throws IOException {
        this._file = storageFile;
        this._parentDir = derbyLuceneDir;
        this._sraf = this._file.getRandomAccessFile("rw");
    }

    public void close() throws IOException {
        this._sraf.close();
        this._parentDir.removeIndexOutput(this._file.getName());
        this._file = null;
        this._parentDir = null;
        this._sraf = null;
    }

    public long getFilePointer() {
        try {
            return this._sraf.getFilePointer();
        }
        catch (IOException iOException) {
            throw this.wrap(iOException);
        }
    }

    @Deprecated
    public void seek(long l) throws IOException {
        this._sraf.seek(l);
    }

    public void flush() throws IOException {
        this._sraf.sync();
    }

    public long length() throws IOException {
        return this._sraf.length();
    }

    public long getChecksum() {
        return this._crc.getValue();
    }

    public void writeByte(byte by) throws IOException {
        this._sraf.writeByte((int)by);
        this._crc.update(by);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this._sraf.write(byArray, n, n2);
        this._crc.update(byArray, n, n2);
    }

    private RuntimeException wrap(Throwable throwable) {
        return new RuntimeException(throwable.getMessage(), throwable);
    }
}

