/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.derbyTesting.functionTests.harness.GRFileFilter;
import org.apache.derbyTesting.functionTests.harness.PropertyUtil;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;

public class GenerateReport {
    static final String DASHLINE = "------------------------------------------------------";
    static String passFileName;
    static String failFileName;
    static String diffFileName;
    static String skipFileName;
    static String propFileName;
    static PrintWriter passFile;
    static PrintWriter failFile;
    static PrintWriter diffFile;
    static PrintWriter skipFile;
    static PrintWriter propFile;
    static PrintWriter reportFile;
    static FilenameFilter fileFilter;
    static int NumPass;
    static int NumFail;
    static int NumRun;
    static int NumSkip;
    static int PercentPass;
    static int PercentFail;
    static Timestamp TestStart;
    static Time TestDuration;
    static String SuiteName;

    static void CollectProperties() {
        Properties properties = System.getProperties();
        char[] cArray = new char[]{' '};
        propFile.println(PropertyUtil.sortProperties(properties, cArray));
    }

    static void CalculateRunLength() {
        String string = System.getProperty("outputdir");
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        BufferedReader bufferedReader = null;
        String string2 = null;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(new File(string), SuiteName + ".sum")));
            String string4 = string2 = bufferedReader.readLine();
            while (string4 != null) {
                string3 = string4;
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        int n = 22 + SuiteName.length();
        int n2 = string2.length() - 8;
        TestStart = Timestamp.valueOf(string2.substring(n, n2));
        Timestamp timestamp = Timestamp.valueOf(string3.substring(n -= 2, n2 -= 2));
        long l = timestamp.getTime() - TestStart.getTime();
        int n3 = (int)(l / 1000L);
        int n4 = n3 / 60;
        int n5 = n4 / 60;
        n3 -= n4 * 60;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, n5);
        gregorianCalendar.set(12, n4 -= n5 * 60);
        gregorianCalendar.set(13, n3);
        TestDuration = new Time(gregorianCalendar.getTime().getTime());
    }

    static void CollectPassFailStats() {
        String string = System.getProperty("outputdir");
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        GenerateReport.CollectPassFailStats(new File(string), "");
    }

    static void addLines(PrintWriter printWriter, File file, String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                printWriter.print(string);
                printWriter.print(":");
                printWriter.println(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    static void addDiff(PrintWriter printWriter, File file, String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            printWriter.print("********* Diff file ");
            printWriter.println(string);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                printWriter.println(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    static void CollectPassFailStats(File file, String string) {
        for (String string2 : file.list(fileFilter)) {
            File file2 = new File(file, string2);
            if (string2.endsWith(".pass")) {
                GenerateReport.addLines(passFile, file2, string + "/" + string2);
                continue;
            }
            if (string2.endsWith(".fail")) {
                GenerateReport.addLines(failFile, file2, string + "/" + string2);
                continue;
            }
            if (string2.endsWith(".skip")) {
                GenerateReport.addLines(skipFile, file2, string + "/" + string2);
                continue;
            }
            if (string2.endsWith(".diff")) {
                GenerateReport.addDiff(diffFile, file2, string + "/" + string2);
                continue;
            }
            Object object = string.length() > 0 ? string + "/" + string2 : string2;
            GenerateReport.CollectPassFailStats(file2, (String)object);
        }
    }

    static void CalculatePassFailStats() {
        NumPass = GenerateReport.CountLines(passFileName);
        NumFail = GenerateReport.CountLines(failFileName);
        NumRun = NumPass + NumFail;
        NumSkip = GenerateReport.CountLines(skipFileName);
        PercentPass = (int)Math.floor(100.0 * ((double)NumPass / (double)NumRun));
        PercentFail = (int)Math.ceil(100.0 * ((double)NumFail / (double)NumRun));
    }

    static int CountLines(String string) {
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                ++n;
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        return n;
    }

    static void OutputFile(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                reportFile.println(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    static PrintWriter setupFile(String string) {
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(string);
            if (file.exists()) {
                System.out.println("WARNING: removing " + string);
                file.delete();
            }
            printWriter = new PrintWriter(new FileWriter(string, true));
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        return printWriter;
    }

    public static void main(String[] stringArray) {
        SuiteName = stringArray[0];
        String string = stringArray[1];
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        String string4 = stringArray[4];
        String string5 = stringArray[5];
        boolean bl = true;
        if (string5.toLowerCase().startsWith("false")) {
            bl = false;
        }
        String string6 = SuiteName + "_report.txt";
        reportFile = GenerateReport.setupFile(string6);
        reportFile.print("Generating report for RunSuite ");
        for (int i = 0; i < stringArray.length; ++i) {
            reportFile.print(stringArray[i] + " ");
        }
        reportFile.println();
        passFileName = SuiteName + "_pass.txt";
        failFileName = SuiteName + "_fail.txt";
        diffFileName = SuiteName + "_diff.txt";
        skipFileName = SuiteName + "_skip.txt";
        propFileName = SuiteName + "_prop.txt";
        passFile = GenerateReport.setupFile(passFileName);
        failFile = GenerateReport.setupFile(failFileName);
        diffFile = GenerateReport.setupFile(diffFileName);
        skipFile = GenerateReport.setupFile(skipFileName);
        propFile = GenerateReport.setupFile(propFileName);
        SysInfoLog sysInfoLog = new SysInfoLog();
        try {
            sysInfoLog.exec(string, string2, string3, string4, reportFile, bl);
        }
        catch (Exception exception) {
            System.out.println("SysInfoLog Exception: " + exception.getMessage());
        }
        reportFile.println("Test environment information:");
        reportFile.print("COMMAND LINE STYLE: ");
        String string7 = System.getProperty("jvm");
        if (string7 == null) {
            string7 = "jdk13";
        }
        reportFile.println(string7);
        reportFile.print("TEST CANONS: ");
        String string8 = System.getProperty("canondir");
        if (string8 == null) {
            string8 = "master";
        }
        reportFile.println(string8);
        reportFile.println(DASHLINE);
        reportFile.println(DASHLINE);
        reportFile.println("Summary results:");
        GenerateReport.CalculateRunLength();
        GenerateReport.CollectPassFailStats();
        GenerateReport.CollectProperties();
        passFile.close();
        failFile.close();
        skipFile.close();
        diffFile.close();
        propFile.close();
        GenerateReport.CalculatePassFailStats();
        reportFile.println();
        reportFile.println("Test Run Started: " + String.valueOf(TestStart));
        reportFile.println("Test Run Duration: " + String.valueOf(TestDuration));
        reportFile.println();
        reportFile.println(NumRun + " Tests Run");
        if (PercentPass < 10) {
            reportFile.print(" ");
        }
        reportFile.println(PercentPass + "% Pass (" + NumPass + " tests passed)");
        if (PercentFail < 10) {
            reportFile.print(" ");
        }
        reportFile.println(PercentFail + "% Fail (" + NumFail + " tests failed)");
        reportFile.println(NumSkip + " Suites skipped");
        reportFile.println(DASHLINE);
        if (NumFail > 0) {
            reportFile.println("Failed tests in: " + failFileName);
            reportFile.println(DASHLINE);
        }
        if (NumPass > 0) {
            reportFile.println("Passed tests in: " + passFileName);
            reportFile.println(DASHLINE);
        }
        if (NumSkip > 0) {
            reportFile.println("Skipped suites in: " + skipFileName);
            reportFile.println(DASHLINE);
        }
        reportFile.println("System properties in: " + propFileName);
        reportFile.println(DASHLINE);
        reportFile.println(DASHLINE);
        if (NumFail > 0) {
            reportFile.println("Failure Details:");
            GenerateReport.OutputFile(diffFileName);
        } else {
            reportFile.println("No Failures.");
        }
        reportFile.println(DASHLINE);
        reportFile.close();
        System.out.println("Generated report: " + string6);
    }

    static {
        fileFilter = new GRFileFilter();
    }
}

