/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derbyTesting.functionTests.tests.jdbc4.BlobClobTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ExemptBlobMD;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobTest
extends BaseJDBCTestCase {
    private Blob blob = null;
    private static final ExemptBlobMD[] emd = new ExemptBlobMD[]{new ExemptBlobMD("getBinaryStream", new Class[]{Long.TYPE, Long.TYPE}, true, true), new ExemptBlobMD("setBinaryStream", new Class[]{Long.TYPE}, false, true), new ExemptBlobMD("setBytes", new Class[]{Long.TYPE, byte[].class}, false, true), new ExemptBlobMD("setBytes", new Class[]{Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}, false, true), new ExemptBlobMD("truncate", new Class[]{Long.TYPE}, false, true), new ExemptBlobMD("free", null, true, true)};
    private HashMap<Method, ExemptBlobMD> excludedMethodSet = new HashMap();
    private static final String LOCK_TIMEOUT = "40XL1";

    public BlobTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.blob != null) {
            this.blob.free();
            this.blob = null;
        }
        this.excludedMethodSet = null;
        super.tearDown();
    }

    void buildHashSet() {
        Class<Blob> clazz = Blob.class;
        for (int i = 0; i < emd.length; ++i) {
            try {
                Method method = clazz.getMethod(emd[i].getMethodName(), emd[i].getParams());
                this.excludedMethodSet.put(method, emd[i]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                BlobTest.fail((String)"The method could not be found in the interface");
            }
        }
    }

    public void testFreeandMethodsAfterCallingFree() throws SQLException {
        this.blob = BlobClobTestSetup.getSampleBlob(this.getConnection());
        this.buildHashSet();
        this.blob.free();
        this.blob.free();
        this.buildMethodList(this.blob);
    }

    void buildMethodList(Object object) {
        int n;
        boolean bl = true;
        Vector<Method> vector = new Vector<Method>();
        Class<Blob> clazz = Blob.class;
        Method[] methodArray = clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (this.checkIfExempted(methodArray[n])) continue;
            bl = this.checkIfMethodThrowsSQLException(object, methodArray[n]);
            if (!bl) {
                vector.add(methodArray[n]);
            }
            bl = true;
        }
        if (!vector.isEmpty()) {
            n = 0;
            Object object2 = "The Following methods don't throw required exception - ";
            for (Method method : vector) {
                if (++n == vector.size() && n != 1) {
                    object2 = (String)object2 + " & ";
                } else if (n != 1) {
                    object2 = (String)object2 + " , ";
                }
                object2 = (String)object2 + method.getName();
            }
            BlobTest.fail((String)object2);
        }
    }

    boolean checkIfExempted(Method method) {
        ExemptBlobMD exemptBlobMD = this.excludedMethodSet.get(method);
        if (exemptBlobMD != null && BlobTest.usingDerbyNetClient()) {
            return exemptBlobMD.getIfClientFramework();
        }
        if (exemptBlobMD != null && BlobTest.usingEmbedded()) {
            return exemptBlobMD.getIfEmbeddedFramework();
        }
        return false;
    }

    boolean checkIfMethodThrowsSQLException(Object object, Method method) {
        block3: {
            try {
                method.invoke(object, this.getNullValues(method.getParameterTypes()));
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof InvocationTargetException)) break block3;
                Throwable throwable2 = throwable.getCause();
                if (throwable2 instanceof SQLException) {
                    SQLException sQLException = (SQLException)throwable2;
                    return sQLException.getSQLState().equals("XJ215");
                }
                return false;
            }
        }
        return false;
    }

    Object[] getNullValues(Class<?>[] classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = this.getNullValueForType(classArray[i]);
        }
        return objectArray;
    }

    Object getNullValueForType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        BlobTest.fail((String)("Don't know how to handle type " + String.valueOf(clazz)));
        return null;
    }

    public void testGetBinaryStreamLong() throws Exception {
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        InputStream inputStream = blob.getBinaryStream(2L, 5L);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray, 1, 5);
        BlobTest.assertEquals(byteArrayInputStream2, inputStream);
        resultSet.close();
        statement.close();
    }

    public void testGetBinaryStreamLongLastByte() throws IOException, SQLException {
        int n = 5000;
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int n2 = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n2);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(n), n);
        preparedStatement.execute();
        preparedStatement.close();
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n);
        loopingAlphabetStream.skip(n - 1);
        int n3 = ((InputStream)loopingAlphabetStream).read();
        BlobTest.assertTrue((((InputStream)loopingAlphabetStream).read() == -1 ? 1 : 0) != 0);
        int n4 = 5000;
        preparedStatement = this.prepareStatement("select BLOBDATA from BLOBCLOB where ID=?");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        InputStream inputStream = resultSet.getBlob(1).getBinaryStream(n - n4 + 1, n4);
        int n5 = BlobTest.getLastByteInStream(inputStream, n4);
        BlobTest.assertEquals((int)n3, (int)n5);
        inputStream.close();
        resultSet.close();
        n4 = 2000;
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        inputStream = resultSet.getBlob(1).getBinaryStream(n - n4 + 1, n4);
        BlobTest.assertEquals((int)n3, (int)n5);
        inputStream.close();
        resultSet.close();
        n4 = 1;
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        inputStream = resultSet.getBlob(1).getBinaryStream(n - n4 + 1, n4);
        BlobTest.assertEquals((int)n3, (int)n5);
        inputStream.close();
        resultSet.close();
    }

    public void testGetBinaryStreamLongExceptionConditions() throws SQLException {
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.getBinaryStream(-2L, 5L);
            BlobTest.fail((String)"FAIL: Expected SQLException for pos being negative not thrown");
        }
        catch (SQLException sQLException) {
            BlobTest.assertSQLState("XJ070", sQLException);
        }
        try {
            blob.getBinaryStream(blob.length() + 1L, 5L);
            BlobTest.fail((String)"FAIL: Expected SQLException for position being greater than length of LOB not thrown");
        }
        catch (SQLException sQLException) {
            BlobTest.assertSQLState("XJ087", sQLException);
        }
        try {
            blob.getBinaryStream(2L, -5L);
            BlobTest.fail((String)"Fail: expected exception for the length being negative not thrown");
        }
        catch (SQLException sQLException) {
            BlobTest.assertSQLState("XJ071", sQLException);
        }
        try {
            blob.getBinaryStream(blob.length() - 4L, 10L);
            BlobTest.fail((String)"Fail: expected exception for the sum of position and length being greater than the LOB size not thrown");
        }
        catch (SQLException sQLException) {
            BlobTest.assertSQLState("XJ087", sQLException);
        }
    }

    public void testGetBinaryStreamLongDrain() throws IOException, SQLException {
        this.initializeLongBlob();
        InputStream inputStream = this.blob.getBinaryStream(2000L, 5000L);
        byte[] byArray = new byte[256];
        while (inputStream.read(byArray, 0, byArray.length) != -1) {
        }
        inputStream.close();
        this.blob.free();
    }

    public void testGetBinaryStreamCreateBlob() throws Exception {
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Blob blob = this.getConnection().createBlob();
        InputStream inputStream = blob.getBinaryStream();
        blob.setBytes(1L, byArray);
        BlobTest.assertEquals(byteArrayInputStream, inputStream);
    }

    public void testGetBinaryStreamBlobUpdates() throws Exception {
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        byte[] byArray2 = new byte[]{101, 102, 103, 104, 105, 101, 102, 103, 104, 105};
        Blob blob = this.getConnection().createBlob();
        InputStream inputStream = blob.getBinaryStream();
        OutputStream outputStream = blob.setBinaryStream(1L);
        outputStream.write(byArray);
        blob.setBytes(byArray.length + 1, byArray2);
        InputStream inputStream2 = blob.getBinaryStream();
        BlobTest.assertEquals(inputStream, inputStream2);
    }

    public void testSetBytesReturnValueSmall() throws SQLException {
        Blob blob = this.getConnection().createBlob();
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 101, 102, 103, 104, 105};
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(1L, byArray));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(1L, byArray));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(4L, byArray));
    }

    public void testSetBytesReturnValueLarge() throws IOException, SQLException {
        Blob blob = this.getConnection().createBlob();
        OutputStream outputStream = blob.setBinaryStream(1L);
        BlobTest.transferAlphabetData(outputStream, 0x100000L);
        byte[] byArray = new byte[]{101, 102, 103, 104, 105, 101, 102, 103, 104, 105};
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(1L, byArray));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(1L, byArray));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(4L, byArray));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)byArray.length, (int)blob.setBytes(524288L, byArray));
    }

    public void testSetBytesReturnValueLargeStateChange() throws IOException, SQLException {
        this.initializeLongBlob();
        BlobTest.assertEquals((String)"Wrong insertion count", (int)1, (int)this.blob.setBytes(30000L, new byte[]{105}));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)1, (int)this.blob.setBytes(1L, new byte[]{105}));
        BlobTest.assertEquals((String)"Wrong insertion count", (int)2, (int)this.blob.setBytes(1235L, new byte[]{105, 105}));
    }

    public void testLockingAfterFree() throws SQLException {
        int n = this.initializeLongBlob();
        this.executeParallelUpdate(n, true);
        this.blob.free();
        this.executeParallelUpdate(n, false);
        this.commit();
    }

    public void testLockingAfterFreeWithRR() throws SQLException {
        this.getConnection().setTransactionIsolation(4);
        int n = this.initializeLongBlob();
        this.executeParallelUpdate(n, true);
        this.blob.free();
        this.executeParallelUpdate(n, true);
        this.commit();
        this.executeParallelUpdate(n, false);
    }

    public void testLockingAfterFreeWithDirtyReads() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        int n = this.initializeLongBlob();
        this.executeParallelUpdate(n, true);
        this.blob.free();
        this.executeParallelUpdate(n, false);
        this.commit();
    }

    public void testDerby_7143() throws Exception {
        byte[] byArray = new byte[]{0, 1, 2, 3, 4};
        HarmonySerialBlob harmonySerialBlob = new HarmonySerialBlob(byArray);
        InputStream inputStream = harmonySerialBlob.getBinaryStream(1L, harmonySerialBlob.length());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BlobTest.assertEquals(byteArrayInputStream, inputStream);
    }

    public void testFreeAfterImplicitFree() throws SQLException {
        Connection connection = this.getConnection();
        this.blob = BlobClobTestSetup.getSampleBlob(connection);
        connection.commit();
        this.blob.free();
    }

    private int initializeLongBlob() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(40000L), 40000);
        preparedStatement.execute();
        preparedStatement.close();
        this.commit();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        this.blob = resultSet.getBlob(1);
        resultSet.close();
        statement.close();
        return n;
    }

    private void executeParallelUpdate(int n, boolean bl) throws SQLException {
        Connection connection = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("update BLOBCLOB set CLOBDATA = 'New' where id=" + n);
            statement.close();
            connection.commit();
            connection.close();
            if (bl) {
                BlobTest.fail((String)"FAIL - should have gotten lock timeout");
            }
        }
        catch (SQLException sQLException) {
            statement.close();
            connection.rollback();
            connection.close();
            if (bl) {
                BlobTest.assertSQLState(LOCK_TIMEOUT, sQLException);
            }
            throw sQLException;
        }
    }

    public static void transferAlphabetData(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(l);
        while ((n = loopingAlphabetStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static int getLastByteInStream(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[256];
        BlobTest.assertTrue((byArray.length > 0 ? 1 : 0) != 0);
        while (true) {
            int n3;
            if ((n3 = inputStream.read(byArray, 0, byArray.length)) < 0) {
                BlobTest.assertTrue((String)"Invalid return value from stream", (n3 == -1 ? 1 : 0) != 0);
                BlobTest.fail((String)("Reached EOF prematurely, expected " + n + ", got " + n2));
            } else if (n3 == 0) {
                BlobTest.fail((String)("Stream breaks contract, read zero bytes " + String.valueOf(inputStream)));
            }
            if ((n2 += n3) == n) {
                return byArray[n3 - 1];
            }
            if (n2 <= n) continue;
            BlobTest.fail((String)("Too many bytes in stream, expected " + n + "have " + n2 + "(EOF not reached/confirmed)"));
        }
    }

    public static Test suite() {
        return new BlobClobTestSetup(DatabasePropertyTestSetup.setLockTimeouts(TestConfiguration.defaultSuite(BlobTest.class, false), 2, 4));
    }
}

