/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.Permission;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class GrantRevokeDDLTest
extends BaseJDBCTestCase {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static String[] users = new String[]{"TEST_DBO", "george", "sam", "monica", "swiper", "sam", "satheesh", "bar", "mamta4", "mamta3", "mamta2", "mamta1", "sammy", "user5", "user4", "user3", "user2", "user1", "RUTH"};
    public static final String NO_GENERIC_PERMISSION = "42504";
    public static final String NO_SELECT_OR_UPDATE_PERMISSION = "42502";
    public static final String NO_TABLE_PERMISSION = "42500";

    public GrantRevokeDDLTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("GrantRevokeDDLTest");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite(GrantRevokeDDLTest.class, "GrantRevokeDDL Test");
        TestSetup testSetup = new SupportFilesSetup((Test)baseTestSuite);
        testSetup = new CleanDatabaseTestSetup((Test)testSetup);
        testSetup = DatabasePropertyTestSetup.builtinAuthentication((Test)testSetup, users, "grantrevokeddl");
        testSetup = TestConfiguration.sqlAuthorizationDecorator((Test)testSetup);
        return testSetup;
    }

    public void testGrantRevokeDDL() throws Exception {
        ResultSet resultSet;
        ResultSet resultSet2 = null;
        SQLWarning sQLWarning = null;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        Connection connection = this.openUserConnection("satheesh");
        Statement statement2 = connection.createStatement();
        callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        statement.executeUpdate(" grant execute on procedure SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS to satheesh");
        callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        statement.executeUpdate("revoke execute on procedure SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS from satheesh restrict");
        callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        statement = this.createStatement();
        statement.executeUpdate("create schema authorization satheesh");
        statement2.executeUpdate("create table satheesh.tsat(i int not null primary key, j int, noselect int)");
        statement2.executeUpdate(" create index tsat_ind on satheesh.tsat(j)");
        statement2.executeUpdate(" create table satheesh.table1 (a int, b int, c char(10))");
        statement2.executeUpdate(" grant select on satheesh.tsat to public");
        statement2.executeUpdate(" grant insert on satheesh.tsat to foo");
        statement2.executeUpdate(" grant delete on satheesh.tsat to foo");
        statement2.executeUpdate(" grant update on satheesh.tsat to foo");
        statement2.executeUpdate(" grant update(i) on satheesh.tsat to bar");
        resultSet2 = statement2.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms ORDER BY GRANTEE, GRANTOR");
        String[] stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        Object[][] objectArray = new String[][]{{"FOO", "SATHEESH", "N", "y", "y", "y", "N", "N"}, {"PUBLIC", "SATHEESH", "y", "N", "N", "N", "N", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        Connection connection2 = this.openUserConnection("bar");
        Statement statement3 = connection2.createStatement();
        GrantRevokeDDLTest.assertStatementError("42506", statement3, "revoke select on satheesh.tsat from public");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, " revoke insert on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, " revoke update(i) on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, " revoke update on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, " revoke delete on satheesh.tsat from foo");
        statement2.executeUpdate("revoke trigger on satheesh.tsat from foo");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate(" revoke references on satheesh.tsat from foo");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate("revoke insert on satheesh.tsat from foo, bar");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate("revoke insert on satheesh.tsat from foo, bar");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate(" grant insert on satheesh.tsat to foo");
        statement2.executeUpdate("revoke update on satheesh.tsat from foo");
        statement2.executeUpdate(" revoke delete on satheesh.tsat from foo");
        resultSet2 = statement2.executeQuery("select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"FOO", "SATHEESH", "N", "N", "y", "N", "N", "N"}, {"PUBLIC", "SATHEESH", "y", "N", "N", "N", "N", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement2.executeUpdate(" revoke insert on satheesh.tsat from foo");
        statement2.executeUpdate(" revoke select on satheesh.tsat from public");
        resultSet2 = statement2.executeQuery("select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms ORDER BY GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement2.executeUpdate("CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement2.executeUpdate("revoke execute on function F_ABS(int) from bar RESTRICT");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate(" grant execute on function F_ABS to foo");
        statement2.executeUpdate(" grant execute on function F_ABS(int) to bar");
        statement2.executeUpdate(" revoke execute on function F_ABS(int) from bar RESTRICT");
        statement2.executeUpdate(" drop function f_abs");
        statement2.executeUpdate("CREATE FUNCTION F_4714(P1 BOOLEAN) RETURNS BOOLEAN NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.booleanValue' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement2.executeUpdate(" grant execute on function F_4714(boolean) to bar");
        statement2.executeUpdate(" revoke execute on function F_4714(boolean) from bar restrict");
        statement2.executeUpdate(" drop function F_4714");
        statement2.executeUpdate("create view v1 as select * from tsat");
        statement2.executeUpdate(" grant select on v1 to bar");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant insert on v1 to foo");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant update on v1 to public");
        statement2.executeUpdate("create synonym mySym for satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, "grant select on mySym to bar");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, " grant insert on mySym to foo");
        statement2.executeUpdate(" CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        resultSet2 = statement2.executeQuery(" values f_abs(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        this.getConnection().createStatement().executeUpdate("CREATE SCHEMA MYDODO AUTHORIZATION DODO");
        this.getConnection().createStatement().executeUpdate(" CREATE SCHEMA AUTHORIZATION DERBY");
        resultSet2 = statement2.executeQuery(" select SCHEMANAME, AUTHORIZATIONID from sys.sysschemas where schemaname not like 'SYS%' and schemaname not like 'TEST_DBO%' ORDER BY SCHEMANAME");
        stringArray = new String[]{"SCHEMANAME", "AUTHORIZATIONID"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"APP", "APP"}, {"DERBY", "DERBY"}, {"MYDODO", "DODO"}, {"NULLID", TEST_DBO}, {"SATHEESH", "SATHEESH"}, {"SQLJ", TEST_DBO}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        Connection connection3 = this.openUserConnection("swiper");
        Statement statement4 = connection3.createStatement();
        statement4.executeUpdate(" create table swiperTab (i int, j int)");
        statement4.executeUpdate(" insert into swiperTab values (1,1)");
        statement4.executeUpdate(" set schema satheesh");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, "create table NotMyTable (i int, j int)");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, " drop table tsat");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, " drop index tsat_ind");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, " create view myview as select * from satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, " CREATE FUNCTION FuncNotMySchema(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        GrantRevokeDDLTest.assertStatementError("42507", statement4, " alter table tsat add column k int");
        statement4.executeUpdate(" create table swiper.mytab ( i int, j int)");
        statement4.executeUpdate(" set schema swiper");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, "select * from satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement4, " insert into satheesh.tsat(i, j) values (1, 2)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " update satheesh.tsat set i=j");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " create table my_tsat (i int not null, c char(10), constraint fk foreign key(i) references satheesh.tsat)");
        statement2.executeUpdate(" grant select(i, j), update(j) on tsat to swiper");
        statement2.executeUpdate(" grant all privileges on table1 to swiper");
        statement2.executeUpdate(" grant references on tsat to swiper");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, "select * from satheesh.tsat");
        resultSet2 = statement4.executeQuery(" select i from satheesh.tsat");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " select i from satheesh.tsat where noselect=2");
        resultSet2 = statement4.executeQuery(" select i from satheesh.tsat where 2 > (select count(i) from satheesh.tsat)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " select i from satheesh.tsat where 2 > (select count(noselect) from satheesh.tsat)");
        resultSet2 = statement4.executeQuery(" select i from satheesh.tsat where 2 > (select count(*) from satheesh.tsat)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertUpdateCount(statement4, 0, " update satheesh.tsat set j=j+1");
        GrantRevokeDDLTest.assertUpdateCount(statement4, 0, " update satheesh.tsat set j=2 where i=2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " update satheesh.tsat set j=2 where noselect=1");
        resultSet2 = statement4.executeQuery(" select * from satheesh.table1");
        stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement4.executeQuery(" select c from satheesh.table1 t1, satheesh.tsat t2 where t1.a = t2.i");
        stringArray = new String[]{"C"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " select b from satheesh.table1 t1, satheesh.tsat t2 where t1.a = t2.noselect");
        resultSet2 = statement4.executeQuery(" select * from satheesh.table1, (select i from satheesh.tsat) table2");
        stringArray = new String[]{"A", "B", "C", "I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, " select * from satheesh.table1, (select noselect from satheesh.tsat) table2");
        statement4.executeUpdate("update satheesh.tsat set j=i");
        statement4.executeUpdate(" create table my_tsat (i int not null, c char(10), constraint fk foreign key(i) references satheesh.tsat)");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement4, "create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement4, " create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        statement2.executeUpdate(" grant trigger on tsat to swiper");
        statement4.executeUpdate(" create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        statement4.executeUpdate(" create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        statement4.executeUpdate(" drop trigger trig_sat1");
        statement4.executeUpdate(" drop trigger trig_sat2");
        statement2.executeUpdate(" revoke trigger on tsat from swiper");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement4, " create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement4, " create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        statement2.executeUpdate(" grant trigger on tsat to public");
        statement4.executeUpdate(" create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        statement4.executeUpdate(" create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        statement4.executeUpdate(" drop trigger trig_sat1");
        statement4.executeUpdate(" drop trigger trig_sat2");
        statement2.executeUpdate(" drop view v1");
        statement2.executeUpdate(" drop table tsat");
        statement2.executeUpdate(" drop table table1");
        resultSet2 = statement2.executeQuery(" values f_abs(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement2.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"4"}, {"4"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement4.executeUpdate(" set schema satheesh");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, " values f_abs(-5)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, " select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        statement2.executeUpdate(" grant execute on function f_abs to swiper");
        resultSet2 = statement4.executeQuery("values f_abs(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement4.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"4"}, {"4"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement2.executeUpdate(" revoke execute on function f_abs from swiper RESTRICT");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, " values f_abs(-5)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, " select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        statement2.executeUpdate(" grant execute on function f_abs to public");
        resultSet2 = statement4.executeQuery("values f_abs(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement4.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"4"}, {"4"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement2.executeUpdate("drop synonym satheesh.mySym");
        statement2.executeUpdate("drop function satheesh.f_abs");
        GrantRevokeDDLTest.assertStatementError("42508", statement4, "create schema myFriend");
        GrantRevokeDDLTest.assertStatementError("42508", statement4, " create schema mySchema authorization me");
        GrantRevokeDDLTest.assertStatementError("42508", statement4, " create schema myschema authorization swiper");
        Connection connection4 = this.openUserConnection("sam");
        Statement statement5 = connection4.createStatement();
        GrantRevokeDDLTest.assertStatementError("42508", statement5, " create schema sam authorization swiper");
        statement5.executeUpdate("create schema authorization sam");
        Connection connection5 = this.openUserConnection("george");
        Statement statement6 = connection5.createStatement();
        statement6.executeUpdate(" create schema george");
        statement.executeUpdate(" create schema myFriend");
        statement.executeUpdate(" create schema mySchema authorization me");
        statement.executeUpdate(" create schema authorization testSchema");
        resultSet2 = statement.executeQuery(" select SCHEMANAME, AUTHORIZATIONID from sys.sysschemas where schemaname not like 'TEST_DBO%' order by SCHEMANAME");
        stringArray = new String[]{"SCHEMANAME", "AUTHORIZATIONID"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"APP", "APP"}, {"DERBY", "DERBY"}, {"GEORGE", "GEORGE"}, {"MYDODO", "DODO"}, {"MYFRIEND", TEST_DBO}, {"MYSCHEMA", "ME"}, {"NULLID", TEST_DBO}, {"SAM", "SAM"}, {"SATHEESH", "SATHEESH"}, {"SQLJ", TEST_DBO}, {"SWIPER", "SWIPER"}, {"SYS", TEST_DBO}, {"SYSCAT", TEST_DBO}, {"SYSCS_DIAG", TEST_DBO}, {"SYSCS_UTIL", TEST_DBO}, {"SYSFUN", TEST_DBO}, {"SYSIBM", TEST_DBO}, {"SYSPROC", TEST_DBO}, {"SYSSTAT", TEST_DBO}, {"TESTSCHEMA", "TESTSCHEMA"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate("drop schema satheesh restrict");
        GrantRevokeDDLTest.assertStatementError("42508", statement4, " create table mywork.t1(i int)");
        GrantRevokeDDLTest.assertStatementError("42508", statement4, " create view mywork.v1 as select * from swiper.swiperTab");
        Connection connection6 = this.openUserConnection("monica");
        Statement statement7 = connection6.createStatement();
        GrantRevokeDDLTest.assertStatementError("42508", statement7, " create table mywork.t1 ( i int)");
        statement7.executeUpdate(" create table monica.shouldPass(c char(10))");
        statement4.executeUpdate(" set schema swiper");
        statement4.executeUpdate(" revoke select on swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement4 != null) {
                sQLWarning = statement4.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection3.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement4.executeUpdate(" revoke insert on swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement4 != null) {
                sQLWarning = statement4.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection3.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        resultSet2 = statement.executeQuery("select * from swiper.swiperTab order by i,j");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate(" insert into swiper.swiperTab values (2,2)");
        resultSet2 = statement.executeQuery(" select * from swiper.swiperTab order by i,j");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate(" grant select on swiper.swiperTab to sam");
        statement.executeUpdate(" revoke insert on swiper.swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement != null) {
                sQLWarning = statement.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = this.getConnection().getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42509", statement, "grant select on sys.systables to sam");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " grant delete on sys.syscolumns to sam");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " grant update(alias) on sys.sysaliases to swiper");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " revoke all privileges on sys.systableperms from public");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " revoke trigger on sys.sysroutineperms from sam");
        GrantRevokeDDLTest.assertStatementError("42509", statement, "grant execute on procedure sysibm.sqlprocedures to sam");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " revoke execute on procedure sysibm.sqlcamessage from public restrict");
        Connection connection7 = this.openUserConnection("sam");
        Statement statement8 = connection7.createStatement();
        statement8.executeUpdate(" create table samTable(i int)");
        statement8.executeUpdate(" insert into samTable values 1,2,3,4,5,6,7");
        callableStatement = connection7.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        resultSet2 = statement8.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 1);
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SAM','SAMTABLE',null)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('SAM', 'SAMTABLE', 1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE('SAM', 'SAMTABLE', 1, 1, 1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        callableStatement = connection7.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('SWIPER', 'MYTAB', 1)");
        GrantRevokeDDLTest.assertStatementError("38000", callableStatement);
        callableStatement.close();
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE('SWIPER', 'MYTAB', 1, 1, 1)");
        GrantRevokeDDLTest.assertStatementError("38000", callableStatement);
        callableStatement.close();
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SWIPER','MYTAB',null)");
        GrantRevokeDDLTest.assertStatementError("38000", callableStatement);
        callableStatement.close();
        callableStatement = connection7.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE('SAM', 'SAMTABLE' , 'extinout/table.dat', null, null, null)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement8, " values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.pageSize')");
        PreparedStatement preparedStatement = connection7.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_USER_ACCESS(CURRENT_USER)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, preparedStatement);
        preparedStatement.close();
        callableStatement = connection7.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_USER_ACCESS(CURRENT_USER, NULL)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        callableStatement = connection7.prepareCall("CALL SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement.close();
        statement.executeUpdate(" grant execute on procedure SYSCS_UTIL.SYSCS_EXPORT_TABLE to public");
        statement.executeUpdate(" grant execute on procedure SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY to sam");
        statement.executeUpdate(" grant execute on function SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY to sam");
        callableStatement = connection7.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE('SAM', 'SAMTABLE' , 'extinout/table.dat', null, null, null)");
        callableStatement = connection7.prepareCall(" call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        resultSet2 = statement8.executeQuery(" values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.pageSize')");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"4096"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate(" revoke execute on procedure SYSCS_UTIL.SYSCS_EXPORT_TABLE from public restrict");
        statement.executeUpdate(" revoke execute on procedure SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY from sam restrict");
        statement.executeUpdate(" revoke execute on function SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY from sam restrict");
        Connection connection8 = this.openUserConnection("mamta1");
        Statement statement9 = connection8.createStatement();
        statement9.executeUpdate(" create table t11 (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11 values(1)");
        statement9.executeUpdate(" grant select on t11 to mamta2");
        statement9.executeUpdate(" grant insert on t11 to mamta3");
        statement9.executeUpdate(" grant insert on t11 to mamta2, mamta3, mamta4");
        Connection connection9 = this.openUserConnection("mamta2");
        Statement statement10 = connection9.createStatement();
        resultSet2 = statement10.executeQuery(" select * from mamta1.t11");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" insert into mamta1.t11 values(2)");
        resultSet2 = statement10.executeQuery(" select * from mamta1.t11 order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        Connection connection10 = this.openUserConnection("mamta3");
        Statement statement11 = connection10.createStatement();
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta1.t11");
        statement11.executeUpdate(" insert into mamta1.t11 values(3)");
        Connection connection11 = this.openUserConnection("mamta4");
        Statement statement12 = connection11.createStatement();
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement12, "select * from mamta1.t11");
        statement12.executeUpdate(" insert into mamta1.t11 values(4)");
        statement9.executeUpdate(" revoke all privileges on t11 from PUBLIC");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        resultSet2 = statement9.executeQuery(" select * from mamta1.t11 order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" drop table t11");
        statement9.executeUpdate(" create table t11 (c111 int not null primary key, c112 int, c113 int, c114 int)");
        statement9.executeUpdate(" insert into t11 values(1,1,1,1)");
        statement9.executeUpdate(" grant select(c111) on t11 to mamta2");
        statement9.executeUpdate(" grant select(c112) on t11 to mamta2, mamta3");
        statement9.executeUpdate(" grant update(c112) on t11 to mamta2, mamta3, mamta4");
        statement9.executeUpdate(" grant update on t11 to mamta2");
        GrantRevokeDDLTest.assertUpdateCount(statement10, 1, " update mamta1.t11 set c113 = 2 where c111=1");
        resultSet2 = statement10.executeQuery(" select c111,c112 from mamta1.t11");
        stringArray = new String[]{"C111", "C112"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement10, "select * from mamta1.t11");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "update mamta1.t11 set c113=3");
        resultSet2 = statement11.executeQuery(" select c112 from mamta1.t11");
        stringArray = new String[]{"C112"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement12, "select c112 from mamta1.t11");
        resultSet2 = statement9.executeQuery(" select * from mamta1.t11");
        stringArray = new String[]{"C111", "C112", "C113", "C114"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1", "2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" revoke select on t11 from mamta2, mamta3, mamta4");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement9.executeUpdate(" revoke update(c111, c112) on t11 from mamta2, mamta3, mamta4");
        statement9.executeUpdate(" drop table t11");
        statement9.executeUpdate(" create table t11 (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11 values(1)");
        statement9.executeUpdate(" insert into t11 values(2)");
        resultSet2 = statement9.executeQuery(" select * from t11 order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" create table t12 (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12 values (1,'1')");
        resultSet2 = statement9.executeQuery(" select * from t12");
        stringArray = new String[]{"C121", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" create table t13 (c131 int, c132 char)");
        statement9.executeUpdate(" insert into t13 values (1,'1')");
        resultSet2 = statement9.executeQuery(" select * from t13");
        stringArray = new String[]{"C131", "C132"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" grant select on t12 to mamta2");
        statement9.executeUpdate(" grant select on t11 to public");
        statement10.executeUpdate("create view v21 as select t1.c111, t2.c122 from mamta1.t11 as t1, mamta1.t12 as t2");
        statement10.executeUpdate(" create view v22 as select * from mamta1.t11");
        statement10.executeUpdate(" create view v23 as select * from mamta1.t12");
        statement9.executeUpdate("create view v23 as select * from mamta1.t12");
        statement.executeUpdate("create view v11 as select * from mamta2.v22");
        statement11.executeUpdate(" create table t31(c311 int)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v31 as select * from mamta2.v22");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v32 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v33 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11, mamta2.v21");
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, "grant select on v22 to mamta3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v31 as select * from mamta2.v22");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v32 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v33 as select v22.c111 as a, t12.c121 as b from mamta2.v22 v22, mamta1.t12 t12");
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, " grant select on v23 to mamta3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create view v34 as select * from mamta2.v23");
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, "create view v35 as select * from v34");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop function f_abs1");
        statement9.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        resultSet2 = statement9.executeQuery(" values f_abs1(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", statement9, " drop view v11");
        statement9.executeUpdate(" create view v11(c111) as values mamta1.f_abs1(-5)");
        statement9.executeUpdate(" grant select on v11 to mamta2");
        resultSet2 = statement9.executeQuery(" select * from v11");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v24");
        statement10.executeUpdate(" create view v24 as select * from mamta1.v11");
        resultSet2 = statement10.executeQuery(" select * from v24");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v25");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement10, "create view v25(c251) as (values mamta1.f_abs1(-1))");
        statement9.executeUpdate(" grant execute on function f_abs1 to mamta2");
        statement10.executeUpdate("create view v25(c251) as (values mamta1.f_abs1(-1))");
        resultSet2 = statement10.executeQuery(" select * from v25");
        stringArray = new String[]{"C251"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("X0Y23", statement9, "revoke execute on function f_abs1 from mamta2 restrict");
        statement10.executeUpdate(" drop view v25");
        statement9.executeUpdate("revoke execute on function f_abs1 from mamta2 restrict");
        resultSet2 = statement10.executeQuery("select * from v24");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate("drop view v24");
        statement9.executeUpdate(" drop view v11");
        statement9.executeUpdate(" drop function f_abs1");
        statement9.executeUpdate(" create table t14(c141 int, c142 int)");
        statement9.executeUpdate(" insert into t14 values (1,1), (2,2)");
        statement9.executeUpdate(" grant select(c141) on t14 to mamta2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement10, "create view v26 as (select * from mamta1.t14 where c142=1)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement10, "create view v26 as (select c141 from mamta1.t14 where c142=1)");
        statement10.executeUpdate("create view v27 as (select c141 from mamta1.t14)");
        resultSet2 = statement10.executeQuery(" select * from v27 order by c141");
        stringArray = new String[]{"C141"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("grant select on t14 to mamta2");
        statement10.executeUpdate("create view v26 as (select c141 from mamta1.t14 where c142=1)");
        resultSet2 = statement10.executeQuery(" select * from v26");
        stringArray = new String[]{"C141"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" create table t15(c151 int, c152 int)");
        statement9.executeUpdate(" insert into t15 values(1,1),(2,2)");
        statement9.executeUpdate(" grant select(c151) on t15 to mamta2");
        statement9.executeUpdate(" grant select(c152) on t15 to public");
        statement10.executeUpdate(" create view v28 as (select c152 from mamta1.t15 where c151=1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12ViewTest");
        statement9.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12ViewTest values (1,'1')");
        statement9.executeUpdate("grant select on t12ViewTest to mamta2");
        statement9.executeUpdate(" grant select on t11ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate("create view v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        resultSet2 = statement10.executeQuery(" select * from v21ViewTest order by c111, c122");
        stringArray = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select on t11ViewTest from public");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement9.executeUpdate("revoke select on t12ViewTest from mamta2");
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, " select * from v21ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        statement9.executeUpdate(" drop table t12ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, "drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12ViewTest");
        statement9.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12ViewTest values (1,'1')");
        statement.executeUpdate("create view mamta2.v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        resultSet2 = statement.executeQuery("select * from mamta2.v21ViewTest order by c111");
        stringArray = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement10.executeQuery("select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, "grant select on v21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta2.v21ViewTest");
        statement.executeUpdate("revoke select on mamta2.v21ViewTest from mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement != null) {
                sQLWarning = statement.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = this.getConnection().getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta2.v21ViewTest");
        statement10.executeUpdate(" drop view v21ViewTest");
        statement9.executeUpdate(" drop table t12ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12ViewTest");
        statement9.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12ViewTest values (1,'1')");
        statement9.executeUpdate(" grant select (c111) on t11ViewTest to mamta3");
        statement9.executeUpdate(" grant select (c121, c122) on t12ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ViewTest");
        statement10.executeUpdate(" create table t21ViewTest (c211 int)");
        statement10.executeUpdate(" insert into t21ViewTest values(1)");
        statement10.executeUpdate(" grant select on t21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement11, " drop view v31ViewTest");
        statement11.executeUpdate(" create view v31ViewTest as select t2.c122, t1.*, t3.* from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2,mamta2.t21ViewTest as t3 where t1.c111 = t3.c211");
        resultSet2 = statement11.executeQuery(" select * from v31ViewTest");
        stringArray = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select(c122) on t12ViewTest from public");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, "select * from v31ViewTest");
        statement10.executeUpdate(" drop table t21ViewTest");
        statement9.executeUpdate(" drop table t12ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12ViewTest");
        statement9.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12ViewTest values (1,'1')");
        statement9.executeUpdate(" grant select (c111) on t11ViewTest to mamta3, public");
        statement9.executeUpdate(" grant select (c121, c122) on t12ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ViewTest");
        statement10.executeUpdate(" create table t21ViewTest (c211 int)");
        statement10.executeUpdate(" insert into t21ViewTest values(1)");
        statement10.executeUpdate(" grant select on t21ViewTest to mamta3, mamta5");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement11, " drop view v31ViewTest");
        statement11.executeUpdate(" create view v31ViewTest as select t2.c122, t1.*, t3.* from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2,mamta2.t21ViewTest as t3 where t1.c111 = t3.c211");
        resultSet2 = statement11.executeQuery(" select * from v31ViewTest");
        stringArray = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select(c111) on t11ViewTest from public");
        resultSet2 = statement11.executeQuery("select * from v31ViewTest");
        stringArray = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select(c111) on t11ViewTest from mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, "select * from v31ViewTest");
        statement10.executeUpdate(" drop table t21ViewTest");
        statement9.executeUpdate(" drop table t12ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key, c112 int)");
        statement9.executeUpdate(" insert into t11ViewTest values(1,1)");
        statement9.executeUpdate(" grant select (c111, c112) on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate(" create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        statement9.executeUpdate("revoke select (c111) on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, " select * from v21ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerTest");
        statement9.executeUpdate(" create table t11TriggerTest (c111 int not null primary key, c112 int)");
        statement9.executeUpdate(" insert into t11TriggerTest values(1,1)");
        statement9.executeUpdate(" insert into t11TriggerTest values(2,2)");
        statement9.executeUpdate(" grant select on t11TriggerTest to mamta2");
        statement10.executeUpdate(" create view v21ViewTest as select * from mamta1.t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, "grant select on v21ViewTest to mamta3");
        resultSet2 = statement10.executeQuery(" select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111", "C112"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31TriggerTest");
        statement11.executeUpdate(" create table t31TriggerTest (c311 int)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t32TriggerTest");
        statement11.executeUpdate(" create table t32TriggerTest (c321 int)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "create trigger tr31t31TriggerTest after insert on t31TriggerTest for each statement insert into t32TriggerTest values (select c111 from mamta2.v21ViewTest where c112=1)");
        statement11.executeUpdate(" insert into t31TriggerTest values(1)");
        resultSet2 = statement11.executeQuery(" select * from t31TriggerTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement11.executeQuery(" select * from t32TriggerTest");
        stringArray = new String[]{"C321"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("revoke select on t11TriggerTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, " select * from v21ViewTest");
        statement11.executeUpdate("insert into t31TriggerTest values(1)");
        resultSet2 = statement11.executeQuery(" select * from t31TriggerTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement11.executeQuery(" select * from t32TriggerTest");
        stringArray = new String[]{"C321"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement11.executeUpdate(" drop table t31TriggerTest");
        statement11.executeUpdate(" drop table t32TriggerTest");
        statement9.executeUpdate(" drop table t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        statement9.executeUpdate(" grant select on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate(" create view v21ViewTest as select * from mamta1.t11ViewTest");
        resultSet2 = statement10.executeQuery(" select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("grant select on t11ViewTest to PUBLIC");
        statement9.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement10.executeUpdate("create view v21ViewTest as select * from mamta1.t11ViewTest");
        resultSet2 = statement10.executeQuery("select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select on t11ViewTest from PUBLIC");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        statement9.executeUpdate(" grant select(c111) on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate(" create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        statement9.executeUpdate("grant select on t11ViewTest to mamta2");
        statement9.executeUpdate("revoke select(c111) on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement10.executeUpdate("create view v21ViewTest as select * from mamta1.t11ViewTest");
        resultSet2 = statement10.executeQuery("select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        statement9.executeUpdate(" grant select(c111) on t11ViewTest to mamta2");
        statement9.executeUpdate(" grant select on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate("create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        statement9.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ViewTest");
        statement9.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ViewTest values(1)");
        statement9.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12ViewTest");
        statement9.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        statement9.executeUpdate(" insert into t12ViewTest values (1,'1')");
        statement9.executeUpdate("grant select on t11ViewTest to mamta2");
        statement9.executeUpdate(" grant select on t12ViewTest to mamta2");
        statement10.executeUpdate(" create view v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        resultSet2 = statement10.executeQuery(" select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, "grant select on v21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, " create view v31ViewTest as select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, " select * from v31ViewTest");
        statement9.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement11, "drop view v31ViewTest");
        statement9.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21ViewTest");
        statement9.executeUpdate(" drop table t12ViewTest");
        statement9.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c211 int references mamta1.t11ConstraintTest, c212 int)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", statement10, "insert into t21ConstraintTest values(3,1)");
        statement9.executeUpdate(" revoke references on t11ConstraintTest from mamta2");
        statement10.executeUpdate("insert into t21ConstraintTest values(3,1)");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        statement10.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31ConstraintTest");
        statement11.executeUpdate(" create table t31ConstraintTest (c311 int references mamta1.t11ConstraintTest, c312 int references mamta2.t21ConstraintTest)");
        resultSet2 = statement11.executeQuery(" select * from t31ConstraintTest");
        stringArray = new String[]{"C311", "C312"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement11.executeUpdate(" insert into t31ConstraintTest values(1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values(1,3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values(3,1)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values(3,4)");
        statement10.executeUpdate("revoke references on t21ConstraintTest from mamta3");
        statement11.executeUpdate("insert into t31ConstraintTest values(1,3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values(3,1)");
        statement9.executeUpdate("revoke references on t11ConstraintTest from mamta3");
        statement11.executeUpdate("insert into t31ConstraintTest values(3,1)");
        statement11.executeUpdate("insert into t31ConstraintTest values(3,3)");
        statement11.executeUpdate("drop table t31ConstraintTest");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key references mamta1.t11ConstraintTest)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", statement10, "insert into t21ConstraintTest values(3)");
        statement10.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31ConstraintTest");
        statement11.executeUpdate(" create table t31ConstraintTest (c311 int references mamta2.t21ConstraintTest)");
        resultSet2 = statement11.executeQuery(" select * from t31ConstraintTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement11.executeUpdate(" insert into t31ConstraintTest values (1)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values (4)");
        statement9.executeUpdate("revoke references on t11ConstraintTest from mamta2");
        statement10.executeUpdate("insert into t21ConstraintTest values(3)");
        statement11.executeUpdate("insert into t31ConstraintTest values(3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement11, "insert into t31ConstraintTest values(4)");
        statement11.executeUpdate(" drop table t31ConstraintTest");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111) references mamta1.t11ConstraintTest)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", statement10, "insert into t21ConstraintTest values(3)");
        statement9.executeUpdate("grant references on t11ConstraintTest to mamta2");
        statement9.executeUpdate("revoke references on t11ConstraintTest from PUBLIC");
        statement10.executeUpdate("insert into t21ConstraintTest values(3)");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to PUBLIC");
        statement9.executeUpdate(" grant select on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111)   references mamta1.t11ConstraintTest)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", statement10, "insert into t21ConstraintTest values(3)");
        statement9.executeUpdate("revoke select on t11ConstraintTest from PUBLIC");
        statement10.executeUpdate("insert into t21ConstraintTest values(3)");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key, c112 int not null unique, c113 int)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1,1,1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2,2,1)");
        statement9.executeUpdate(" grant references(c111, c112) on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111)   references mamta1.t11ConstraintTest(c112))");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", statement10, "insert into t21ConstraintTest values(3)");
        statement9.executeUpdate("revoke references(c111) on t11ConstraintTest from PUBLIC");
        statement10.executeUpdate("insert into t21ConstraintTest values(3)");
        statement10.executeUpdate(" drop table t21ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11MiscTest");
        statement9.executeUpdate(" create table t11MiscTest (c111 int, c112 int, c113 int)");
        statement9.executeUpdate(" grant select, update, trigger on t11MiscTest to mamta2, mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12MiscTest");
        statement9.executeUpdate(" create table t12MiscTest (c121 int, c122 int)");
        statement9.executeUpdate(" grant select on t12MiscTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21MiscTest");
        statement10.executeUpdate(" create view v21MiscTest as select * from mamta1.t11MiscTest, mamta1.t12MiscTest where c111=c121");
        resultSet2 = statement10.executeQuery(" select * from v21MiscTest");
        stringArray = new String[]{"C111", "C112", "C113", "C121", "C122"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError("X0X05", statement11, " drop view v31MiscTest");
        statement11.executeUpdate(" create view v31MiscTest as select c111 from mamta1.t11MiscTest");
        resultSet2 = statement11.executeQuery(" select * from v31MiscTest");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("revoke select, update on t11MiscTest from mamta2, mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement9 != null) {
                sQLWarning = statement9.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection8.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01501", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement10, "select * from v21MiscTest");
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, "select * from v31MiscTest");
        statement9.executeUpdate(" drop table t11MiscTest");
        statement9.executeUpdate(" drop table t12MiscTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerTest");
        statement9.executeUpdate(" create table t11TriggerTest (c111 int not null primary key, c112 int)");
        statement9.executeUpdate(" insert into t11TriggerTest values(1,1)");
        statement9.executeUpdate(" insert into t11TriggerTest values(2,2)");
        statement9.executeUpdate(" grant select(c111) on t11TriggerTest to mamta2");
        statement9.executeUpdate(" grant select(c112) on t11TriggerTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21TriggerTest");
        statement10.executeUpdate(" create table t21TriggerTest (c211 int)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t22TriggerTest");
        statement10.executeUpdate(" create table t22TriggerTest (c221 int)");
        statement10.executeUpdate("create trigger tr21t21TriggerTest after insert on t21TriggerTest for each statement insert into t22TriggerTest values (select c111 from mamta1.t11TriggerTest where c112=1)");
        statement10.executeUpdate(" insert into t21TriggerTest values(1)");
        resultSet2 = statement10.executeQuery(" select * from t21TriggerTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement10.executeQuery(" select * from t22TriggerTest");
        stringArray = new String[]{"C221"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" drop table t21TriggerTest");
        statement10.executeUpdate(" drop table t22TriggerTest");
        statement9.executeUpdate(" drop table t11TriggerTest");
        statement9.executeUpdate(" create table t11TriggerTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11TriggerTest values(1)");
        statement9.executeUpdate(" insert into t11TriggerTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12RoutineTest");
        statement9.executeUpdate(" create table t12RoutineTest (c121 int)");
        statement9.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        statement9.executeUpdate(" grant select on t11TriggerTest to mamta2");
        statement9.executeUpdate(" grant insert on t12RoutineTest to mamta2");
        resultSet2 = statement9.executeQuery(" select * from t11TriggerTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12RoutineTest order by c121");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" create table t21TriggerTest (c211 int)");
        statement10.executeUpdate("create trigger tr21t21TriggerTest after insert on t21TriggerTest for each statement insert into mamta1.t12RoutineTest values (select c111 from mamta1.t11TriggerTest where c111=1)");
        statement10.executeUpdate("insert into t21TriggerTest values(1)");
        resultSet2 = statement10.executeQuery(" select * from t21TriggerTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t11TriggerTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12RoutineTest order by c121");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement10, "create trigger tr11t11TriggerTest after insert on mamta1.t11TriggerTest for each statement insert into mamta1.t12RoutineTest values (1)");
        statement9.executeUpdate(" grant trigger on t11TriggerTest to mamta2");
        statement10.executeUpdate("create trigger tr11t11TriggerTest after insert on mamta1.t11TriggerTest for each statement insert into mamta1.t12RoutineTest values (1)");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement10, "insert into mamta1.t11TriggerTest values(3)");
        GrantRevokeDDLTest.assertUpdateCount(statement9, 2, " delete from t11TriggerTest");
        GrantRevokeDDLTest.assertUpdateCount(statement9, 3, " delete from t12RoutineTest");
        statement9.executeUpdate(" insert into mamta1.t11TriggerTest values(3)");
        resultSet2 = statement9.executeQuery(" select * from t11TriggerTest");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12RoutineTest");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" drop trigger tr21t21TriggerTest");
        statement9.executeUpdate(" drop table t11TriggerTest");
        statement9.executeUpdate(" drop table t12RoutineTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12RoutineTest");
        statement9.executeUpdate(" create table t12RoutineTest (c121 int)");
        statement9.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t13TriggerTest");
        statement9.executeUpdate(" create table t13TriggerTest (c131 int)");
        statement9.executeUpdate(" insert into t13TriggerTest values (1),(2)");
        statement9.executeUpdate(" grant select on t12RoutineTest to mamta3");
        statement9.executeUpdate(" grant insert on t13TriggerTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop function selectFromSpecificSchema");
        statement9.executeUpdate(" CREATE FUNCTION selectFromSpecificSchema (P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement9.executeUpdate(" grant execute on function selectFromSpecificSchema to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31TriggerTest");
        statement11.executeUpdate(" create table t31TriggerTest(c11 int)");
        statement11.executeUpdate("create trigger tr31t31 after insert on t31TriggerTest for each statement insert into mamta1.t13TriggerTest values (values mamta1.selectFromSpecificSchema(1))");
        statement11.executeUpdate("insert into t31TriggerTest values(1)");
        resultSet2 = statement11.executeQuery(" select * from t31TriggerTest");
        stringArray = new String[]{"C11"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12RoutineTest order by c121");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t13TriggerTest order by c131");
        stringArray = new String[]{"C131"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement10, "insert into mamta3.t31TriggerTest values(1)");
        statement11.executeUpdate(" grant insert on t31TriggerTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("38000", statement10, "insert into mamta3.t31TriggerTest values(1)");
        statement9.executeUpdate(" grant select on t12RoutineTest to mamta2");
        statement10.executeUpdate("insert into mamta3.t31TriggerTest values(1)");
        resultSet2 = statement11.executeQuery(" select * from t31TriggerTest");
        stringArray = new String[]{"C11"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12RoutineTest order by c121");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t13TriggerTest order by c131");
        stringArray = new String[]{"C131"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"1"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement9, 4, " delete from t13TriggerTest");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement9, "revoke execute on function selectFromSpecificSchema from mamta3 restrict");
        statement10.executeUpdate(" insert into mamta3.t31TriggerTest values(1)");
        resultSet2 = statement9.executeQuery("select * from t13TriggerTest");
        stringArray = new String[]{"C131"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement11.executeUpdate("drop trigger tr31t31");
        statement9.executeUpdate("revoke execute on function selectFromSpecificSchema from mamta3 restrict");
        statement11.executeUpdate("drop table t31TriggerTest");
        statement9.executeUpdate("drop table t12RoutineTest");
        statement9.executeUpdate(" drop table t13TriggerTest");
        statement9.executeUpdate(" drop function selectFromSpecificSchema");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12RoutineTest");
        statement9.executeUpdate(" create table t12RoutineTest (c121 int)");
        statement9.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        statement9.executeUpdate(" grant select on t12RoutineTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop function selectFromSpecificSchema");
        statement9.executeUpdate(" CREATE FUNCTION selectFromSpecificSchema (P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement9.executeUpdate(" grant execute on function selectFromSpecificSchema to mamta3");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement11, " drop view v21ViewTest");
        statement11.executeUpdate("create view v21ViewTest(c211) as values mamta1.selectFromSpecificSchema(1)");
        resultSet2 = statement11.executeQuery(" select * from v21ViewTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("4250A", statement11, " grant select on v21ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement10, "select * from mamta3.v21ViewTest");
        statement9.executeUpdate(" grant select  on t12RoutineTest to mamta2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement10, "select * from mamta3.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerTest");
        statement9.executeUpdate(" create table t11TriggerTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11TriggerTest values(1)");
        statement9.executeUpdate(" insert into t11TriggerTest values(2)");
        statement9.executeUpdate(" grant select on t11TriggerTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement10, " drop view v21ViewTest");
        statement10.executeUpdate(" create view v21ViewTest as select * from mamta1.t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("4250A", statement10, " grant select on v21ViewTest to mamta4");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31TriggerTest");
        statement11.executeUpdate(" create table t31TriggerTest (c311 int)");
        statement11.executeUpdate(" grant insert on t31TriggerTest to mamta4");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement12, " drop table t41TriggerTest");
        statement12.executeUpdate(" create table t41TriggerTest (c411 int)");
        GrantRevokeDDLTest.assertStatementError("42X94", statement12, " drop trigger tr41t41");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement12, " create trigger tr41t41 after insert on t41TriggerTest for each statement insert into mamta3.t31TriggerTest (select * from mamta2.v21ViewTest)");
        statement12.executeUpdate(" insert into t41TriggerTest values(1)");
        statement12.executeUpdate(" insert into t41TriggerTest values(2)");
        resultSet2 = statement12.executeQuery(" select * from t41TriggerTest order by c411");
        stringArray = new String[]{"C411"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t11TriggerTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement10.executeQuery(" select * from v21ViewTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement11.executeQuery(" select * from t31TriggerTest");
        stringArray = new String[]{"C311"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement11, "insert into mamta4.t41TriggerTest values(1)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select * from mamta1.t11TriggerTest");
        statement12.executeUpdate(" grant insert on t41TriggerTest to mamta3");
        statement11.executeUpdate("insert into mamta4.t41TriggerTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(1)");
        statement9.executeUpdate(" insert into t11ConstraintTest values(2)");
        statement9.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21ConstraintTest");
        statement10.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(1)");
        statement10.executeUpdate(" insert into t21ConstraintTest values(2)");
        statement10.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        statement11.executeUpdate(" create table t31ConstraintTest (c311 int references mamta1.t11ConstraintTest, c312 int references mamta2.t21ConstraintTest)");
        statement11.executeUpdate(" drop table t31ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        statement9.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31ConstraintTest");
        statement11.executeUpdate(" create table t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.t11ConstraintTest)");
        statement11.executeUpdate(" drop table t31ConstraintTest");
        statement9.executeUpdate(" drop table t11ConstraintTest");
        statement9.executeUpdate(" create table t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        statement9.executeUpdate(" grant references(c111) on t11ConstraintTest to mamta3");
        statement9.executeUpdate(" grant references(c112) on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table t31ConstraintTest");
        statement11.executeUpdate(" create table t31ConstraintTest (c311 int,  c312 int, foreign key(c311, c312) references mamta1.t11ConstraintTest)");
        statement11.executeUpdate(" drop table t31ConstraintTest");
        statement11.executeUpdate("create table t31constrainttest(c311 int, c312 int)");
        statement11.executeUpdate(" alter table t31constrainttest add foreign key (c311, c312) references mamta1.t11constrainttest");
        statement11.executeUpdate(" drop table t31ConstraintTest");
        statement11.executeUpdate("create table t31constrainttest(c311 int, c312 int, c313 int references mamta2.t21ConstraintTest)");
        statement11.executeUpdate(" alter table t31constrainttest add foreign key (c311, c312) references mamta1.t11constrainttest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerRevokeTest");
        statement9.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        statement9.executeUpdate("grant TRIGGER on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21TriggerRevokeTest");
        statement10.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        statement10.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(3)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(4)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement10, "create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        statement9.executeUpdate(" grant trigger on t11TriggerRevokeTest to mamta2");
        statement10.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        resultSet2 = statement10.executeQuery(" select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(5)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}, {"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" drop trigger tr11t11");
        statement10.executeUpdate(" drop table t21TriggerRevokeTest");
        statement9.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(6)");
        statement9.executeUpdate("drop table t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerRevokeTest");
        statement9.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key)");
        statement9.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        statement9.executeUpdate(" grant SELECT on t11TriggerRevokeTest to mamta2");
        statement9.executeUpdate("grant TRIGGER on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21TriggerRevokeTest");
        statement10.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        statement10.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(3)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke SELECT on t11TriggerRevokeTest from mamta2");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(4)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(5)");
        resultSet2 = statement10.executeQuery("select * from t21TriggerRevokeTest");
        stringArray = new String[]{"C211"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}, {"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" drop trigger tr11t11");
        statement10.executeUpdate(" drop table t21TriggerRevokeTest");
        statement9.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(6)");
        statement9.executeUpdate("drop table t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t11TriggerRevokeTest");
        statement9.executeUpdate(" create table t11TriggerRevokeTest (c111 int)");
        statement9.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        statement9.executeUpdate(" grant INSERT on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement9, " drop table t12TriggerRevokeTest");
        statement9.executeUpdate(" create table t12TriggerRevokeTest (c121 int)");
        statement9.executeUpdate(" insert into t12TriggerRevokeTest values(1),(2)");
        statement9.executeUpdate(" grant INSERT on t12TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement10, " drop table t21TriggerRevokeTest");
        statement10.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        statement10.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        statement10.executeUpdate("create trigger tr211t21 after insert on t21TriggerRevokeTest for each statement insert into mamta1.t11TriggerRevokeTest values(99)");
        statement10.executeUpdate("create trigger tr212t21 after insert on t21TriggerRevokeTest for each statement insert into mamta1.t12TriggerRevokeTest values(99)");
        statement10.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        resultSet2 = statement9.executeQuery("select * from t11TriggerRevokeTest order by c111");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12TriggerRevokeTest");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement9, 3, " delete from t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertUpdateCount(statement9, 3, " delete from t12TriggerRevokeTest");
        statement9.executeUpdate("revoke insert on t11TriggerRevokeTest from mamta2");
        statement10.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        resultSet2 = statement9.executeQuery("select * from t11TriggerRevokeTest");
        stringArray = new String[]{"C111"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement9.executeQuery("select * from t12TriggerRevokeTest");
        stringArray = new String[]{"C121"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"99"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement10.executeUpdate(" drop table t21TriggerRevokeTest");
        statement9.executeUpdate(" drop table t12TriggerRevokeTest");
        statement9.executeUpdate(" drop table t11TriggerRevokeTest");
        statement9.executeUpdate("create table newTable(i int, j int, k int)");
        statement9.executeUpdate(" grant select, update(j) on newTable to sammy");
        statement9.executeUpdate(" grant references, delete on newTable to user1");
        statement9.executeUpdate("create view myView as select * from newTable");
        statement9.executeUpdate(" grant select on myView to sammy");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1' order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"USER1", "MAMTA1", "N", "y", "N", "N", "y", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY' or grantee='USER1'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "u", "{1}"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" drop view myView");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1' order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"USER1", "MAMTA1", "N", "y", "N", "N", "y", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" drop table newTable");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY' or grantee='USER1'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("CREATE FUNCTION newFunction(P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema'LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement9.executeUpdate(" grant execute on function newFunction to sammy");
        statement9.executeUpdate(" grant execute on function newFunction(INT) to user3");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY' or grantee='USER3' order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "N"}, {"USER3", "MAMTA1", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" drop function newFunction");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY' or grantee='USER3'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement9.executeUpdate("create table newTable(i int, j int, k int)");
        statement9.executeUpdate(" grant select(i,j), delete on newTable to sammy");
        statement9.executeUpdate(" CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement9.executeUpdate(" grant execute on function f_abs to sammy");
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "s", "{0, 1}"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"SAMMY", "MAMTA1", "N", "y", "N", "N", "N", "N"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        Connection connection12 = this.openUserConnection("sammy");
        Statement statement13 = connection12.createStatement();
        statement13.executeUpdate(" set schema mamta1");
        resultSet2 = statement13.executeQuery(" select i,j from newTable");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement13.executeQuery(" values f_abs(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" drop table newTable");
        statement9.executeUpdate(" drop function f_abs");
        resultSet2 = statement9.executeQuery("select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement9.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY'");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        resultSet2 = statement9.executeQuery("VALUES { fn ACOS(0.0707) }");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1.5000372950430991"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" VALUES ACOS(0.0707)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1.5000372950430991"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" VALUES PI()");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"3.141592653589793"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" create table SYSFUN_MATH_TEST (d double)");
        statement9.executeUpdate(" insert into SYSFUN_MATH_TEST values null");
        statement9.executeUpdate(" insert into SYSFUN_MATH_TEST values 0.67");
        statement9.executeUpdate(" insert into SYSFUN_MATH_TEST values 1.34");
        resultSet2 = statement9.executeQuery(" select cast (ATAN(d) as DECIMAL(6,3)) AS ATAN FROM SYSFUN_MATH_TEST order by atan");
        stringArray = new String[]{"ATAN"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"0.590"}, {"0.929"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select cast (COS(d) as DECIMAL(6,3)) AS COS FROM SYSFUN_MATH_TEST order by cos");
        stringArray = new String[]{"COS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"0.228"}, {"0.783"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select cast (SIN(d) as DECIMAL(6,3)) AS SIN FROM SYSFUN_MATH_TEST order by sin");
        stringArray = new String[]{"SIN"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"0.620"}, {"0.973"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select cast (TAN(d) as DECIMAL(6,3)) AS TAN FROM SYSFUN_MATH_TEST order by tan");
        stringArray = new String[]{"TAN"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"0.792"}, {"4.255"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select cast (DEGREES(d) as DECIMAL(6,3)) AS DEGREES FROM SYSFUN_MATH_TEST order by degrees");
        stringArray = new String[]{"DEGREES"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"38.388"}, {"76.776"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select cast (RADIANS(d) as DECIMAL(6,3)) AS RADIANS FROM SYSFUN_MATH_TEST order by radians");
        stringArray = new String[]{"RADIANS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"0.011"}, {"0.023"}, {null}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement9.executeUpdate(" create table mamta1Table ( i int, j int)");
        GrantRevokeDDLTest.assertStatementError("42509", statement9, "grant select on mamta1Table to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement9, " revoke select on mamta1Table from mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement9, " grant execute on function f_abs to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement9, " revoke execute on function f_abs from mamta1 restrict");
        statement.executeUpdate(" set schema mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " grant select on mamta1Table to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " revoke select on mamta1Table from mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " grant execute on function f_abs to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", statement, " revoke execute on function f_abs from mamta1 restrict");
        statement.executeUpdate("grant select on mamta1Table to randy");
        statement.executeUpdate(" revoke select on mamta1Table from randy");
        statement.executeUpdate(" grant execute on function f_abs to randy");
        statement.executeUpdate(" revoke execute on function f_abs from randy restrict");
        statement9.executeUpdate(" drop table mamta1Table");
        statement9.executeUpdate(" drop function f_abs");
        Connection connection13 = this.openUserConnection("user1");
        Statement statement14 = connection13.createStatement();
        statement14.executeUpdate(" create table t100 (i int)");
        Connection connection14 = this.openUserConnection("user2");
        Statement statement15 = connection14.createStatement();
        connection14.setAutoCommit(false);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement15, "lock table user1.t100 in exclusive mode");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement15, " lock table user1.t100 in share mode");
        connection13.commit();
        statement14.executeUpdate(" grant select on t100 to user2");
        statement15.executeUpdate("lock table user1.t100 in exclusive mode");
        statement15.executeUpdate(" lock table user1.t100 in share mode");
        connection13.commit();
        statement14.executeUpdate(" revoke select on t100 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement15, "lock table user1.t100 in exclusive mode");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement15, " lock table user1.t100 in share mode");
        connection14.commit();
        connection14.setAutoCommit(true);
        statement14.executeUpdate(" create table t1 (i int)");
        statement14.executeUpdate(" insert into t1 values 1,2,3");
        statement14.executeUpdate(" grant select on t1 to user2");
        statement15.executeUpdate(" create view v1 as select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError("42506", statement15, "grant select on user1.t1 to user3");
        GrantRevokeDDLTest.assertStatementError("4250A", statement15, "grant select on v1 to user3");
        statement15.executeUpdate(" drop view v1");
        statement14.executeUpdate(" drop table t1");
        connection14.setAutoCommit(true);
        connection14.setAutoCommit(true);
        statement9.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key, c12 int)");
        statement9.executeUpdate(" insert into t11TriggerRevokeTest values (1, 101), (2, 202), (3, 303)");
        statement9.executeUpdate(" grant TRIGGER on t11TriggerRevokeTest to mamta2");
        statement9.executeUpdate(" create table t12TriggerRevokeTest (c121 int, c122 int, c123 int)");
        statement9.executeUpdate(" insert into t12TriggerRevokeTest values (10, 1010, 2010),(20,1020,2020)");
        statement9.executeUpdate(" grant UPDATE(c122, c121) on t12TriggerRevokeTest to mamta2");
        statement10.executeUpdate(" create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement update mamta1.t12TriggerRevokeTest set c122 = 99");
        resultSet2 = statement9.executeQuery(" select * from t11TriggerRevokeTest order by c111");
        stringArray = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12TriggerRevokeTest order by c121");
        stringArray = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"10", "1010", "2010"}, {"20", "1020", "2020"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("insert into t11TriggerRevokeTest values(4, 404)");
        resultSet2 = statement9.executeQuery(" select * from t11TriggerRevokeTest order by c111");
        stringArray = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}, {"4", "404"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12TriggerRevokeTest order by c121");
        stringArray = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"10", "99", "2010"}, {"20", "99", "2020"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate("revoke TRIGGER on t11TriggerRevokeTest from mamta2");
        GrantRevokeDDLTest.assertUpdateCount(statement9, 2, " update t12TriggerRevokeTest set c122 = 42");
        statement9.executeUpdate("insert into t11TriggerRevokeTest values (5,505)");
        resultSet2 = statement9.executeQuery(" select * from t11TriggerRevokeTest order by c111");
        stringArray = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}, {"4", "404"}, {"5", "505"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement9.executeQuery(" select * from t12TriggerRevokeTest order by c121");
        stringArray = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"10", "42", "2010"}, {"20", "42", "2020"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" create table t1001 (c varchar(1))");
        statement9.executeUpdate(" insert into t1001 values 'a', 'b', 'c'");
        connection8.setAutoCommit(false);
        statement9.executeUpdate(" grant select on t1001 to mamta3");
        statement10.executeUpdate(" create table ttt1 (i int)");
        statement10.executeUpdate(" insert into ttt1 values 1");
        statement10.executeUpdate(" grant all privileges on ttt1 to mamta1");
        resultSet2 = statement9.executeQuery(" select * from mamta2.ttt1");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement9.executeUpdate(" insert into mamta2.ttt1 values 2");
        GrantRevokeDDLTest.assertUpdateCount(statement9, 2, " update mamta2.ttt1 set i = 888");
        connection8.commit();
        connection8.setAutoCommit(true);
        statement9.executeUpdate(" create table d1589t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        statement9.executeUpdate(" grant references on d1589t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement11, " drop table d1589t31ConstraintTest");
        statement11.executeUpdate(" create table d1589t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.d1589t11ConstraintTest)");
        statement11.executeUpdate(" drop table d1589t31ConstraintTest");
        statement9.executeUpdate(" drop table d1589t11ConstraintTest");
        statement9.executeUpdate(" create table d1589t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        statement9.executeUpdate(" grant references(c111) on d1589t11ConstraintTest to mamta3");
        statement9.executeUpdate(" grant references(c112) on d1589t11ConstraintTest to PUBLIC");
        statement11.executeUpdate(" create table d1589t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.d1589t11ConstraintTest)");
        statement.executeUpdate("CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate(" grant execute on function f_abs to mamta3");
        statement11.executeUpdate(" create table dhw(i int check(mamta1.f_abs(i) > 0))");
        GrantRevokeDDLTest.assertStatementError("23513", statement11, "insert into dhw values 0");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs from mamta3 restrict");
        statement11.executeUpdate(" drop table dhw");
        statement.executeUpdate("CREATE FUNCTION F_ABS2(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate(" grant execute on function f_abs to mamta3");
        statement.executeUpdate(" grant execute on function f_abs2 to mamta3");
        statement11.executeUpdate("create table dhw(i int constraint a1 check(mamta1.f_abs(i) > 0),j int constraint a2 check(mamta1.f_abs2(j) > 0))");
        GrantRevokeDDLTest.assertStatementError("23513", statement11, "insert into dhw values (0,0)");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs from mamta3 restrict");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs2 from mamta3 restrict");
        statement11.executeUpdate("alter table dhw drop constraint a2");
        statement.executeUpdate("revoke execute on function f_abs2 from mamta3 restrict");
        GrantRevokeDDLTest.assertStatementError("23513", statement11, "insert into dhw values (0,1)");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs from mamta3 restrict");
        statement11.executeUpdate("alter table dhw drop constraint a1");
        statement.executeUpdate("revoke execute on function f_abs from mamta3 restrict");
        statement11.executeUpdate("insert into dhw values (0,0)");
        statement11.executeUpdate(" drop table dhw");
        statement.executeUpdate(" grant execute on function f_abs to mamta3");
        statement.executeUpdate(" grant execute on function f_abs2 to mamta3");
        statement11.executeUpdate(" create table dhw(i int constraint a check(mamta1.f_abs(i) + mamta1.f_abs2(i) > 0))");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs from mamta3 restrict");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "revoke execute on function f_abs2 from mamta3 restrict");
        statement11.executeUpdate("alter table dhw drop constraint a");
        statement.executeUpdate("revoke execute on function f_abs from mamta3 restrict");
        statement.executeUpdate("revoke execute on function f_abs2 from mamta3 restrict");
        statement11.executeUpdate(" drop table dhw");
        statement.executeUpdate("DROP FUNCTION F_ABS");
        statement.executeUpdate("DROP FUNCTION F_ABS2");
        statement10.executeUpdate(" create table t1Derby1847 (c1 int, c2 int)");
        statement10.executeUpdate(" grant select(c1,c2) on t1Derby1847 to mamta3");
        statement10.executeUpdate(" alter table t1Derby1847 add c3 int");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select c3 from mamta2.t1Derby1847");
        statement10.executeUpdate(" grant select on t1Derby1847 to mamta3");
        resultSet2 = statement11.executeQuery("select c3 from mamta2.t1Derby1847");
        stringArray = new String[]{"C3"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement10.executeUpdate(" revoke select on t1Derby1847 from mamta3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement11, "select c3 from mamta2.t1Derby1847");
        statement10.executeUpdate(" grant select(c3) on t1Derby1847 to mamta3");
        resultSet2 = statement11.executeQuery("select c3 from mamta2.t1Derby1847");
        stringArray = new String[]{"C3"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertEmpty(resultSet2);
        statement10.executeUpdate(" drop table t1Derby1847");
        GrantRevokeDDLTest.assertStatementError("42X05", statement11, " select c3 from mamta2.t1Derby1847");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement14, " drop table t1");
        statement14.executeUpdate(" create table t1 (c varchar(1))");
        statement14.executeUpdate(" insert into t1 values 'a', 'b', 'c'");
        statement14.executeUpdate(" grant select on t1 to user2");
        connection14.setAutoCommit(false);
        statement14.executeUpdate(" grant select on t1 to user2");
        connection14.setAutoCommit(false);
        PreparedStatement preparedStatement2 = connection14.prepareStatement("select * from user1.t1");
        ResultSet resultSet3 = preparedStatement2.executeQuery();
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"a", (String)resultSet3.getString(1));
        statement14.executeUpdate("revoke select on t1 from user2");
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"b", (String)resultSet3.getString(1));
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"c", (String)resultSet3.getString(1));
        resultSet3.close();
        preparedStatement2.close();
        connection14.commit();
        PreparedStatement preparedStatement3 = connection14.prepareStatement("select * from user1.t1");
        try {
            resultSet = preparedStatement3.executeQuery();
        }
        catch (SQLException sQLException) {
            GrantRevokeDDLTest.assertSQLState(NO_SELECT_OR_UPDATE_PERMISSION, sQLException);
        }
        connection14.setAutoCommit(true);
        statement14.executeUpdate(" grant select on t1 to user2");
        connection14.setAutoCommit(false);
        preparedStatement2 = connection14.prepareStatement("select * from user1.t1");
        resultSet3 = preparedStatement2.executeQuery();
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"a", (String)resultSet3.getString(1));
        statement14.executeUpdate("revoke select on t1 from user2");
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"b", (String)resultSet3.getString(1));
        resultSet3.next();
        GrantRevokeDDLTest.assertEquals((String)"c", (String)resultSet3.getString(1));
        resultSet3.close();
        preparedStatement2.close();
        connection14.commit();
        preparedStatement3 = connection14.prepareStatement("select * from user1.t1");
        try {
            resultSet = preparedStatement3.executeQuery();
        }
        catch (SQLException sQLException) {
            GrantRevokeDDLTest.assertSQLState(NO_SELECT_OR_UPDATE_PERMISSION, sQLException);
        }
        connection13.setAutoCommit(true);
        statement14.executeUpdate("create table d1847_c (a int, b int, c int)");
        statement14.executeUpdate(" grant select (a) on d1847_c to first_user");
        statement14.executeUpdate(" grant update (b) on d1847_c to second_user");
        statement14.executeUpdate(" grant select (c) on d1847_c to third_user");
        resultSet2 = statement14.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1847_C' order by grantee");
        stringArray = new String[]{"GRANTEE", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"FIRST_USER", "s", "{0}"}, {"SECOND_USER", "u", "{1}"}, {"THIRD_USER", "s", "{2}"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement14.executeUpdate(" alter table d1847_c add column d int");
        resultSet2 = statement14.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1847_C' order by GRANTEE");
        stringArray = new String[]{"GRANTEE", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"FIRST_USER", "s", "{0}"}, {"SECOND_USER", "u", "{1}"}, {"THIRD_USER", "s", "{2}"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate("DROP VIEW TEST_DBO.V11");
        statement.executeUpdate("DROP VIEW MAMTA1.V23");
        statement.executeUpdate("DROP VIEW MAMTA2.V21");
        statement.executeUpdate("DROP VIEW MAMTA2.V21VIEWTEST");
        statement.executeUpdate("DROP VIEW MAMTA2.V22");
        statement.executeUpdate("DROP VIEW MAMTA2.V23");
        statement.executeUpdate("DROP VIEW MAMTA2.V26");
        statement.executeUpdate("DROP VIEW MAMTA2.V27");
        statement.executeUpdate("DROP VIEW MAMTA2.V28");
        statement.executeUpdate("DROP VIEW MAMTA3.V21VIEWTEST");
        statement.executeUpdate("DROP FUNCTION MAMTA1.SELECTFROMSPECIFICSCHEMA");
        statement.executeUpdate("DROP TABLE MAMTA4.T41TRIGGERTEST");
        statement.executeUpdate("DROP TABLE MAMTA3.D1589T31CONSTRAINTTEST");
        statement.executeUpdate("DROP TABLE MAMTA3.T31");
        statement.executeUpdate("DROP TABLE MAMTA3.T31CONSTRAINTTEST");
        statement.executeUpdate("DROP TABLE MAMTA3.T31TRIGGERTEST");
        statement.executeUpdate("DROP TABLE MAMTA2.T21CONSTRAINTTEST");
        statement.executeUpdate("DROP TABLE MAMTA2.T21TRIGGERTEST");
        statement.executeUpdate("DROP TABLE MAMTA2.TTT1");
        statement.executeUpdate("DROP TABLE MAMTA1.SYSFUN_MATH_TEST");
        statement.executeUpdate("DROP TABLE MAMTA1.D1589T11CONSTRAINTTEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T11CONSTRAINTTEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T11TRIGGERREVOKETEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T11TRIGGERTEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T11");
        statement.executeUpdate("DROP TABLE MAMTA1.T12");
        statement.executeUpdate("DROP TABLE MAMTA1.T12ROUTINETEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T12TRIGGERREVOKETEST");
        statement.executeUpdate("DROP TABLE MAMTA1.T13");
        statement.executeUpdate("DROP TABLE MAMTA1.T14");
        statement.executeUpdate("DROP TABLE MAMTA1.T15");
        statement.executeUpdate("DROP TABLE MAMTA1.T1001");
        statement.executeUpdate("DROP TABLE MONICA.SHOULDPASS");
        statement.executeUpdate("DROP TABLE SAM.SAMTABLE");
        statement.executeUpdate("DROP TABLE SWIPER.MYTAB");
        statement.executeUpdate("DROP TABLE SWIPER.MY_TSAT");
        statement.executeUpdate("DROP TABLE SWIPER.SWIPERTAB");
        statement.executeUpdate("DROP TABLE USER1.D1847_C");
        statement.executeUpdate("DROP TABLE USER1.T1");
        statement.executeUpdate("DROP TABLE USER1.T100");
        statement.executeUpdate("DROP SCHEMA DERBY RESTRICT");
        statement.executeUpdate("DROP SCHEMA GEORGE RESTRICT");
        statement.executeUpdate("DROP SCHEMA MAMTA1 RESTRICT");
        statement.executeUpdate("DROP SCHEMA MAMTA2 RESTRICT");
        statement.executeUpdate("DROP SCHEMA MAMTA3 RESTRICT");
        statement.executeUpdate("DROP SCHEMA MAMTA4 RESTRICT");
        statement.executeUpdate("DROP SCHEMA MONICA RESTRICT");
        statement.executeUpdate("DROP SCHEMA MYDODO RESTRICT");
        statement.executeUpdate("DROP SCHEMA MYFRIEND RESTRICT");
        statement.executeUpdate("DROP SCHEMA MYSCHEMA RESTRICT");
        statement.executeUpdate("DROP SCHEMA SAM RESTRICT");
        statement.executeUpdate("DROP SCHEMA SWIPER RESTRICT");
        statement.executeUpdate("DROP SCHEMA TESTSCHEMA RESTRICT");
        statement.executeUpdate("DROP SCHEMA TEST_DBO RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER1 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER2 RESTRICT");
        statement3.close();
        statement5.close();
        statement6.close();
        statement9.close();
        statement10.close();
        statement11.close();
        statement12.close();
        statement7.close();
        statement8.close();
        statement4.close();
        statement2.close();
        statement13.close();
        statement14.close();
        statement15.close();
        statement.close();
        connection2.close();
        connection4.close();
        connection5.close();
        connection8.close();
        connection9.close();
        connection10.close();
        connection11.close();
        connection6.close();
        connection7.close();
        connection12.close();
        connection.close();
        connection3.close();
        connection13.close();
        connection14.close();
    }

    public void testGrantRevokeDDL2() throws SQLException {
        ResultSet resultSet = null;
        SQLWarning sQLWarning = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SCHEMA AUTHORIZATION USER1");
        statement.executeUpdate("CREATE SCHEMA AUTHORIZATION USER2");
        Connection connection = this.openUserConnection("user1");
        Statement statement2 = connection.createStatement();
        Connection connection2 = this.openUserConnection("user2");
        Statement statement3 = connection2.createStatement();
        Connection connection3 = this.openUserConnection("user3");
        Statement statement4 = connection3.createStatement();
        Connection connection4 = this.openUserConnection("user4");
        Statement statement5 = connection4.createStatement();
        Connection connection5 = this.openUserConnection("user5");
        Statement statement6 = connection5.createStatement();
        statement2.executeUpdate(" create table t1 (i int primary key, b char(15))");
        statement2.executeUpdate(" insert into t1 values (1, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (2, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (3, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (4, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (5, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (6, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (7, 'XYZ')");
        statement2.executeUpdate(" insert into t1 values (8, 'XYZ')");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, "drop table t2");
        statement2.executeUpdate(" create table t2 (x integer, y integer)");
        statement2.executeUpdate(" create procedure grant_select_proc1() parameter style java dynamic result sets 0 language java NO SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        statement2.executeUpdate(" create procedure grant_select_proc2() parameter style java dynamic result sets 0 language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        statement2.executeUpdate(" create procedure grant_select_proc3() parameter style java dynamic result sets 0 language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        statement2.executeUpdate(" create procedure grant_select_proc4() parameter style java dynamic result sets 0 language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        statement2.executeUpdate(" create procedure revoke_select_proc1() parameter style java dynamic result sets 0 language java NO SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        statement2.executeUpdate(" create procedure revoke_select_proc2() parameter style java dynamic result sets 0 language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        statement2.executeUpdate(" create procedure revoke_select_proc3() parameter style java dynamic result sets 0 language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        statement2.executeUpdate(" create procedure revoke_select_proc4() parameter style java dynamic result sets 0 language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        statement2.executeUpdate("create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc1()");
        GrantRevokeDDLTest.assertStatementError("38001", statement2, "delete from t1 where i = 1");
        resultSet = statement2.executeQuery("select * from t1 where i = 1");
        String[] stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t1 where i = 1");
        statement2.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc2()");
        GrantRevokeDDLTest.assertStatementError("38002", statement2, "delete from t1 where i = 2");
        resultSet = statement2.executeQuery("select * from t1 where i = 2");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t1 where i = 1");
        statement2.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc3()");
        GrantRevokeDDLTest.assertStatementError("38002", statement2, "delete from t1 where i = 3");
        resultSet = statement2.executeQuery("select * from t1 where i = 3");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t1 where i = 1");
        statement2.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc4()");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 1, "delete from t1 where i = 4");
        resultSet = statement2.executeQuery("select * from t1 where i = 4");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement2.executeUpdate(" drop trigger grant_select_trig");
        resultSet = statement3.executeQuery("select * from user1.t1 where i = 1");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc1()");
        GrantRevokeDDLTest.assertStatementError("38001", statement2, "delete from t1 where i = 5");
        resultSet = statement2.executeQuery("select * from t1 where i = 5");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger revoke_select_trig");
        resultSet = statement3.executeQuery("select * from user1.t1 where i = 1");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc2()");
        GrantRevokeDDLTest.assertStatementError("38002", statement2, "delete from t1 where i = 6");
        resultSet = statement2.executeQuery("select * from t1 where i = 6");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger revoke_select_trig");
        resultSet = statement3.executeQuery("select * from user1.t1 where i = 1");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc3()");
        GrantRevokeDDLTest.assertStatementError("38002", statement2, "delete from t1 where i = 7");
        resultSet = statement2.executeQuery("select * from t1 where i = 7");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"7", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" drop trigger revoke_select_trig");
        resultSet = statement3.executeQuery("select * from user1.t1 where i = 1");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc4()");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 1, "delete from t1 where i = 8");
        resultSet = statement2.executeQuery("select * from t1 where i = 8");
        stringArray = new String[]{"I", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement2.executeUpdate(" drop trigger revoke_select_trig");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t1 where i = 1");
        statement2.executeUpdate(" drop table t2");
        statement2.executeUpdate(" drop table t1");
        statement2.executeUpdate(" create table t1 (c1 int primary key not null, c2 varchar(10))");
        statement2.executeUpdate(" create table t2 (c1 int primary key not null, c2 varchar(10), c3 int)");
        statement2.executeUpdate(" create index idx1 on t1(c2)");
        statement2.executeUpdate(" insert into t1 values (1, 'a'), (2, 'b'), (3, 'c')");
        statement2.executeUpdate(" insert into t2 values (1, 'Yip', 10)");
        resultSet = statement2.executeQuery(" select * from t1 order by C1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        resultSet = statement2.executeQuery(" values f_abs1(-5)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, "grant select on table t0 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, "revoke select on table t0 from user2");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "grant select on t0, t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "revoke select on t0, t1 from user2");
        statement2.executeUpdate("revoke select,insert,update,delete,trigger,references on t1 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "grant select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, " revoke select on t1 to user2");
        statement2.executeUpdate("grant select, select on t1 to user2");
        statement2.executeUpdate(" revoke select, select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "insert into user1.t1(c1) values 4");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "update user1.t1 set c1=10");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "delete from user1.t1");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "create table t2 (c1 int primary key not null, c2 int references user1.t1)");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "create trigger trigger1 after update on user1.t1 for each statement values integer('123')");
        GrantRevokeDDLTest.assertStatementError("42507", statement3, "drop index user1.idx1");
        GrantRevokeDDLTest.assertStatementError("42507", statement3, "drop table user1.t1");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, "grant select,insert,delete,update,references,trigger on user1.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, "grant select,insert,delete,update,references,trigger on user1.t1 to public");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, "grant ALL PRIVILEGES on user1.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42506", statement3, "grant ALL PRIVILEGES on user1.t1 to public");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "revoke select,insert,delete,update,references,trigger on user1.t1 from user1");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "revoke ALL PRIVILEGES on user1.t1 from user1");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "revoke execute on function user1.f1 from user1 restrict");
        statement3.executeUpdate(" create table t2 (c1 int)");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "revoke select on t2 from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "grant select on t2 to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "grant insert on t2 to user2,user2,user2");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement3, "values user1.F_ABS1(-9)");
        resultSet = statement2.executeQuery(" select * from sys.systableperms");
        stringArray = new String[]{"TABLEPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement2.executeQuery(" select * from sys.syscolperms");
        stringArray = new String[]{"COLPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement2.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" grant select,update on table t1 to user2, user3");
        statement2.executeUpdate(" grant execute on function F_ABS1 to user2");
        resultSet = statement2.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"USER2", "USER1", "y", "N", "N", "y", "N", "N"}, {"USER3", "USER1", "y", "N", "N", "y", "N", "N"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement2.executeQuery(" select * from sys.syscolperms");
        stringArray = new String[]{"COLPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement2.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms order by GRANTEE, GRANTOR");
        stringArray = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"PUBLIC", TEST_DBO, "N"}, {"USER2", "USER1", "N"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement3.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "insert into user1.t1 values (5, 'e')");
        resultSet = statement3.executeQuery("values user1.F_ABS1(-8)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement3, 3, "update user1.t1 set c2 = 'user2'");
        statement2.executeUpdate("alter table t1 add column c3 varchar(10)");
        resultSet = statement3.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "user2", null}, {"2", "user2", null}, {"3", "user2", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "insert into user1.t1 values (2, 'abc', 'ABC')");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 3, "update user1.t1 set c3 = 'XYZ'");
        resultSet = statement4.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "user2", "XYZ"}, {"2", "user2", "XYZ"}, {"3", "user2", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, "values user1.F_ABS1(-8)");
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, "update user1.t1 set c2 = 'user3'");
        statement2.executeUpdate("revoke update(c2) on t1 from user3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate(" revoke select(c2) on t1 from user3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertUpdateCount(statement3, 3, "update user1.t1 set c2 = 'user2'");
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, "update user1.t1 set c2 = 'user3'");
        resultSet = statement4.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement4.executeQuery("select c2 from user1.t1");
        stringArray = new String[]{"C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"user3"}, {"user3"}, {"user3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" grant select, update on t1 to PUBLIC");
        resultSet = statement4.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, "update user1.t1 set c2 = 'user3'");
        statement2.executeUpdate(" grant select on t1 to user3");
        statement2.executeUpdate("revoke select on t1 from PUBLIC");
        resultSet = statement4.executeQuery("select * from user1.t1 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, "update user1.t1 set c2 = 'user3'");
        statement2.executeUpdate(" revoke select, update on t1 from user3");
        statement2.executeUpdate(" revoke update on t1 from PUBLIC");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, "select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, "update user1.t1 set c2 = 'user3'");
        GrantRevokeDDLTest.assertUpdateCount(statement, 0, " declare global temporary table SESSION.t1(c1 int) not logged");
        GrantRevokeDDLTest.assertStatementError("XCL51", statement, "grant select on session.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("XCL51", statement, " revoke select on session.t1 from user2");
        statement2.executeUpdate(" create table t3 (c1 int, c2 varchar(10), c3 int)");
        statement2.executeUpdate(" create table t4 (c1 int, c2 varchar(10), c3 int)");
        statement2.executeUpdate("grant select, update on t3 to user2");
        statement2.executeUpdate("revoke select(c1) on t3 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        statement2.executeUpdate(" revoke update(c2) on t3 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01006", sQLWarning);
            sQLWarning = null;
        }
        resultSet = statement3.executeQuery(" select * from user1.t3");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement2.executeUpdate(" grant select (c2, c3), update (c2), insert on t4 to user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select * from user1.t4");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select c1 from user1.t4");
        resultSet = statement3.executeQuery("select c2, c3 from user1.t4");
        stringArray = new String[]{"C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "update user1.t4 set c1=10, c3=100");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 0, "update user1.t4 set c2='XYZ'");
        statement2.executeUpdate("revoke select, update on t4 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select c2 from user1.t4");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "update user1.t4 set c2='ABC'");
        GrantRevokeDDLTest.assertStatementError("42508", statement3, "create table myschema.t5 (i int)");
        statement3.executeUpdate("create table user2.t5 (i int)");
        GrantRevokeDDLTest.assertStatementError("42508", statement3, "CREATE SCHEMA w3 AUTHORIZATION user2");
        GrantRevokeDDLTest.assertStatementError("42508", statement3, " create table w3.t1 (i int)");
        GrantRevokeDDLTest.assertStatementError("X0Y68", statement3, "CREATE SCHEMA AUTHORIZATION user2");
        GrantRevokeDDLTest.assertStatementError("42508", statement3, "CREATE SCHEMA myschema");
        GrantRevokeDDLTest.assertStatementError("X0Y68", statement3, "CREATE SCHEMA user2");
        statement.executeUpdate("CREATE SCHEMA w3 AUTHORIZATION user2");
        statement.executeUpdate(" CREATE SCHEMA AUTHORIZATION user6");
        statement.executeUpdate(" CREATE SCHEMA myschema");
        GrantRevokeDDLTest.assertStatementError("42507", statement6, "DROP SCHEMA w3 RESTRICT");
        statement.executeUpdate("create view user1.sv1 as select * from sys.systables");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "select tablename from user1.sv1");
        statement.executeUpdate(" grant select on user1.sv1 to user2");
        resultSet = statement3.executeQuery("select tablename from user1.sv1 order by tablename");
        stringArray = new String[]{"TABLENAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"SV1"}, {"SYSALIASES"}, {"SYSCHECKS"}, {"SYSCOLPERMS"}, {"SYSCOLUMNS"}, {"SYSCONGLOMERATES"}, {"SYSCONSTRAINTS"}, {"SYSDEPENDS"}, {"SYSDUMMY1"}, {"SYSFILES"}, {"SYSFOREIGNKEYS"}, {"SYSKEYS"}, {"SYSPERMS"}, {"SYSROLES"}, {"SYSROUTINEPERMS"}, {"SYSSCHEMAS"}, {"SYSSEQUENCES"}, {"SYSSTATEMENTS"}, {"SYSSTATISTICS"}, {"SYSTABLEPERMS"}, {"SYSTABLES"}, {"SYSTRIGGERS"}, {"SYSUSERS"}, {"SYSVIEWS"}, {"T1"}, {"T2"}, {"T2"}, {"T3"}, {"T4"}, {"T5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create table ta (i int)");
        statement2.executeUpdate(" insert into ta values 1,2,3");
        statement2.executeUpdate(" create view sva as select * from ta");
        statement2.executeUpdate(" create table tb (j int)");
        statement2.executeUpdate(" insert into tb values 2,3,4");
        statement2.executeUpdate(" create view svb as select * from tb");
        statement2.executeUpdate(" grant select on sva to user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "create view svc (i) as select * from user1.sva union select * from user1.svb");
        statement2.executeUpdate(" grant select on svb to user2");
        statement3.executeUpdate("create view svc (i) as select * from user1.sva union select * from user1.svb");
        resultSet = statement3.executeQuery(" select * from svc order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" create table t01ap (i int)");
        statement2.executeUpdate(" insert into t01ap values 1");
        statement2.executeUpdate(" grant all privileges on t01ap to user2");
        statement3.executeUpdate("create view v02ap as select * from user1.t01ap");
        resultSet = statement3.executeQuery("select * from v02ap");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("4250A", statement3, "grant select on user2.v02ap to user3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement4, "create view v03ap as select * from user2.v02ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement4, " select * from v03ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement4, "grant all privileges on v03ap to user4");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement5, "create view v04ap as select * from user3.v03ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement5, " select * from v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement5, "grant select on v04ap to user2");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement3, " select * from user4.v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement5, "revoke select on v04ap from user2");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement3, "select * from user4.v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table user1.rt1");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table user2.rt2");
        statement2.executeUpdate(" create table rt1 (c1 int not null primary key, c2 int not null)");
        statement2.executeUpdate(" insert into rt1 values (1, 10)");
        statement2.executeUpdate(" insert into rt1 values (2, 20)");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "create table rt2 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt2fk foreign key(c1) references user1.rt1)");
        statement2.executeUpdate(" grant references on rt1 to user2");
        statement3.executeUpdate("create table rt2 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt2fk foreign key(c2) references user1.rt1)");
        statement3.executeUpdate(" insert into rt2 values (1,1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", statement3, "insert into rt2 values (3,3,3)");
        statement2.executeUpdate(" revoke references on rt1 from user2");
        statement3.executeUpdate("insert into rt2 values (3,3,3)");
        resultSet = statement3.executeQuery(" select * from rt2 order by C1, C2, C3");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}, {"3", "3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, "create table rt3 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt3fk foreign key(c1) references user1.rt1)");
        GrantRevokeDDLTest.assertStatementError("42Y07", statement, " drop table user3.rt3");
        statement.executeUpdate(" drop table user2.rt2");
        statement.executeUpdate(" drop table user1.rt1");
        statement2.executeUpdate(" create table rt1 (c1 int primary key not null, c2 int)");
        statement2.executeUpdate(" insert into rt1 values (1,1), (2,2)");
        statement2.executeUpdate(" grant references on rt1 to PUBLIC, user2, user3");
        statement3.executeUpdate(" create table rt2 (c1 int primary key not null, constraint rt2fk foreign key(c1) references user1.rt1)");
        statement3.executeUpdate(" insert into rt2 values (1), (2)");
        statement4.executeUpdate(" create table rt3 (c1 int primary key not null, constraint rt3fk foreign key(c1) references user1.rt1)");
        statement4.executeUpdate(" insert into rt3 values (1), (2)");
        statement2.executeUpdate("revoke references on rt1 from PUBLIC");
        statement2.executeUpdate("revoke references on rt1 from user3");
        GrantRevokeDDLTest.assertStatementError("23503", statement3, "insert into rt2 values (3)");
        statement4.executeUpdate("insert into rt3 values (3)");
        statement4.executeUpdate("drop table user3.rt3");
        statement3.executeUpdate("drop table user2.rt2");
        statement2.executeUpdate("drop table user1.rt1");
        statement2.executeUpdate("create table rt1 (c1 int primary key not null, c2 int)");
        statement2.executeUpdate("insert into rt1 values (1,1), (2,2)");
        statement2.executeUpdate("grant references on rt1 to PUBLIC, user2, user3");
        statement3.executeUpdate("create table rt2 (c1 int primary key not null, constraint rt2fk foreign key(c1) references user1.rt1)");
        statement3.executeUpdate("insert into rt2 values (1), (2)");
        statement3.executeUpdate("grant references on rt2 to PUBLIC, user3");
        statement4.executeUpdate("create table rt3 (c1 int primary key not null, constraint rt3fk1 foreign key(c1) references user1.rt1, constraint rt3fk2 foreign key(c1) references user2.rt2)");
        statement4.executeUpdate("insert into rt3 values (1), (2)");
        statement2.executeUpdate("revoke references on rt1 from PUBLIC");
        statement2.executeUpdate("revoke references on rt1 from user3");
        statement3.executeUpdate("revoke references on rt2 from PUBLIC");
        GrantRevokeDDLTest.assertStatementError("23503", statement3, "insert into rt2 values (3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement4, "insert into rt3 values (3)");
        statement3.executeUpdate("revoke references on rt2 from user3");
        statement4.executeUpdate("insert into rt3 values (3) ");
        statement2.executeUpdate(" CREATE FUNCTION F_ABS2(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "grant execute on F_ABS2 to user2");
        GrantRevokeDDLTest.assertStatementError("42Y03", statement2, "grant execute on procedure F_ABS2 to user2");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement3, "values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        statement2.executeUpdate("grant execute on function F_ABS2 to user2");
        resultSet = statement3.executeQuery("values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"20"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42509", statement3, "revoke execute on function ABS from user2 restrict");
        GrantRevokeDDLTest.assertStatementError("42X01", statement3, " revoke execute on function AVG from user2 restrict");
        GrantRevokeDDLTest.assertStatementError("42509", statement3, " revoke execute on function LENGTH from user2 restrict");
        statement2.executeUpdate("revoke execute on function F_ABS2 from user2 restrict");
        statement2.executeUpdate(" revoke execute on function F_ABS1 from user2 restrict");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement3, "values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        statement2.executeUpdate("grant execute on function F_ABS1 to PUBLIC");
        statement2.executeUpdate(" grant execute on function F_ABS2 to PUBLIC");
        resultSet = statement3.executeQuery("values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"20"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42509", statement2, "grant ALL PRIVILEGES on sys.sysaliases to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.syschecks to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.syscolperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.syscolumns to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysconglomerates to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysconstraints to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysdepends to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysfiles to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysforeignkeys to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.syskeys to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysroutineperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysschemas to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysstatistics to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysstatements to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.systableperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.systables to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.systriggers to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on sys.sysviews to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant ALL PRIVILEGES on syscs_diag.lock_table to user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysaliases to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.syschecks to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.syscolperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.syscolumns to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysconglomerates to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysconstraints to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysdepends to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysfiles to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysforeignkeys to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.syskeys to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysroutineperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysschemas to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysstatistics to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysstatements to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.systableperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.systables to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.systriggers to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on sys.sysviews to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " grant select on syscs_diag.lock_table to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysaliases from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.syschecks from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.syscolperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.syscolumns from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysconglomerates from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysconstraints from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysdepends from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysfiles from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysforeignkeys from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.syskeys from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysroutineperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysschemas from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysstatistics from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysstatements from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.systableperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.systables from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.systriggers from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on sys.sysviews from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke ALL PRIVILEGES on syscs_diag.lock_table from user2");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysaliases from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.syschecks from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.syscolperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.syscolumns from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysconglomerates from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysconstraints from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysdepends from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysfiles from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysforeignkeys from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.syskeys from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysroutineperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysschemas from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysstatistics from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysstatements from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.systableperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.systables from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.systriggers from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on sys.sysviews from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, " revoke select on syscs_diag.lock_table from user2, public");
        CallableStatement callableStatement = connection3.prepareCall("CALL SQLJ.INSTALL_JAR ('bogus.jar','user2.bogus',0)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SQLJ.REPLACE_JAR ('bogus1.jar', 'user2.bogus')");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SQLJ.REMOVE_JAR  ('user2.bogus', 0)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE('backup1')");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE('backup3', 1)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT('backup4', 1)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall("CALL SYSCS_UTIL.SYSCS_FREEZE_DATABASE()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE(1)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        CallableStatement callableStatement2 = connection2.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement2, 0);
        callableStatement2 = connection2.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement2, 0);
        resultSet = statement3.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Statement Name:"}, {"null"}, {"Statement Text:"}, {"CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)"}, {"Parse Time: 0"}, {"Bind Time: 0"}, {"Optimize Tim&"}};
        JDBC.assertDrainResults(resultSet, 1);
        callableStatement2 = connection2.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement2, 0);
        callableStatement2 = connection2.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement2, 0);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement4.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Statement Name:"}, {"null"}, {"Statement Text:"}, {"CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)"}, {"Parse Time: 0"}, {"Bind Time: 0"}, {"Optimize Tim&"}};
        JDBC.assertDrainResults(resultSet, 1);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        statement4.executeUpdate("create table TABLEIMP1 (i int)");
        statement4.executeUpdate(" create table TABLEEXP1 (i int)");
        statement4.executeUpdate(" insert into TABLEEXP1 values 1,2,3,4,5");
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE ('USER3', 'TABLEEXP1', 'myfile.del', null, null, null)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE ('USER3', 'TABLEIMP1', 'myfile.del', null, null, null, 0)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from user3.TABLEEXP1','myfile.del', null, null, null)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_DATA ('USER3', 'TABLEIMP1', null, '1,3,4', 'myfile.del', null, null, null,0)");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        callableStatement = connection3.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.locks.deadlockTimeout', '10')");
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, callableStatement);
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, " VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.locks.deadlockTimeout')");
        callableStatement = connection3.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE('USER3', 'TABLEEXP1', 1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        callableStatement = connection3.prepareCall(" call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE('USER3', 'TABLEEXP1', 1, 1, 1)");
        GrantRevokeDDLTest.assertUpdateCount(callableStatement, 0);
        GrantRevokeDDLTest.assertStatementError(NO_GENERIC_PERMISSION, statement4, "VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('USER3', 'TABLEEXP1')");
        statement2.executeUpdate(" create synonym s1 for user1.t1");
        statement2.executeUpdate(" create index ii1 on user1.t1(c2)");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sQLWarning == null && statement2 != null) {
                sQLWarning = statement2.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = connection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            GrantRevokeDDLTest.assertSQLState("01504", sQLWarning);
            sQLWarning = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, "grant select on s1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, " grant insert on s1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, " revoke select on s1 from user2");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, " revoke insert on s1 from user2");
        GrantRevokeDDLTest.assertStatementError("42507", statement3, "drop synonym user1.s1");
        GrantRevokeDDLTest.assertStatementError("42X65", statement3, " drop index user1.ii1");
        statement2.executeUpdate(" create table t1000 (i int)");
        connection.setAutoCommit(false);
        statement2.executeUpdate(" grant select on t1000 to user2");
        connection.commit();
        resultSet = statement3.executeQuery("select * from user1.t1000");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement2.executeUpdate(" revoke select on t1000 from user2");
        connection.commit();
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, " select * from user1.t1000");
        connection2.setAutoCommit(false);
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "lock table user1.t1000 in share mode");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement3, "lock table user1.t1000 in exclusive mode");
        connection2.commit();
        connection2.setAutoCommit(true);
        statement2.executeUpdate(" grant select on t1000 to user2");
        connection.rollback();
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement3, " select * from user1.t1000");
        statement2.executeUpdate(" grant select on t1000 to user2");
        connection.commit();
        statement2.executeUpdate(" revoke select on t1000 from user2");
        connection.rollback();
        resultSet = statement3.executeQuery(" select * from user1.t1000");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        connection.setAutoCommit(true);
        statement2.executeUpdate(" drop table t1000");
        statement2.executeUpdate(" create table t1000 (c varchar(1))");
        statement2.executeUpdate(" insert into t1000 values 'a', 'b', 'c'");
        statement2.executeUpdate(" grant select on t1000 to user3");
        statement3.executeUpdate(" create table t1001 (i int)");
        statement3.executeUpdate(" insert into t1001 values 1");
        resultSet = statement.executeQuery(" select * from user2.t1001");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into user2.t1001 values 2");
        GrantRevokeDDLTest.assertUpdateCount(statement, 2, " update user2.t1001 set i = 888");
        statement.executeUpdate(" drop table user1.t1000");
        statement.executeUpdate(" drop table user2.t1001");
        connection.commit();
        connection.setAutoCommit(true);
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table user1.rta");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table user2.rtb");
        statement2.executeUpdate(" create table rta (i int)");
        statement2.executeUpdate(" grant select on rta to user2");
        resultSet = statement3.executeQuery(" select * from user1.rta");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement2.executeUpdate(" rename table rta to rtb");
        GrantRevokeDDLTest.assertStatementError("42X05", statement2, "select * from user1.rta");
        resultSet = statement2.executeQuery("select * from user1.rtb");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        GrantRevokeDDLTest.assertStatementError("42X05", statement3, "select * from user1.rta");
        resultSet = statement3.executeQuery("select * from user1.rtb");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement3.executeUpdate(" create table ttt1 (i int)");
        statement3.executeUpdate(" insert into ttt1 values 1");
        statement4.executeUpdate(" create table ttt1 (i int)");
        statement4.executeUpdate(" insert into ttt1 values 10");
        resultSet = statement.executeQuery("select * from user2.ttt1");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into user2.ttt1 values 2");
        GrantRevokeDDLTest.assertUpdateCount(statement, 2, " update user2.ttt1 set i = 888");
        GrantRevokeDDLTest.assertUpdateCount(statement, 2, " delete from user2.ttt1");
        statement.executeUpdate(" drop table user2.ttt1");
        resultSet = statement.executeQuery(" select * from user3.ttt1");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into user3.ttt1 values 20");
        GrantRevokeDDLTest.assertUpdateCount(statement, 2, " update user3.ttt1 set i = 999");
        GrantRevokeDDLTest.assertUpdateCount(statement, 2, " delete from user3.ttt1");
        statement.executeUpdate(" drop table user3.ttt1");
        statement5.executeUpdate(" create table ttt1 (i int)");
        statement.executeUpdate(" drop table user4.ttt1");
        GrantRevokeDDLTest.assertStatementError("42507", statement3, "drop schema user4 restrict");
        statement.executeUpdate("drop schema user4 restrict");
        statement2.executeUpdate(" create table ttt2 (i int)");
        statement2.executeUpdate(" insert into ttt2 values 8");
        PreparedStatement preparedStatement = connection2.prepareStatement("select * from user1.ttt2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, preparedStatement);
        statement2.executeUpdate(" grant select on ttt2 to user2");
        preparedStatement = connection2.prepareStatement("select * from user1.ttt2");
        resultSet = preparedStatement.executeQuery();
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" revoke select on ttt2 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, preparedStatement);
        statement2.executeUpdate(" grant select(i) on ttt2 to user2");
        preparedStatement = connection2.prepareStatement("select * from user1.ttt2");
        resultSet = preparedStatement.executeQuery();
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" revoke select(i) on ttt2 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, preparedStatement);
        statement3.executeUpdate(" create table tshared0 (i int)");
        GrantRevokeDDLTest.assertStatementError("42509", statement2, "revoke select on user2.tshared0 from user2");
        resultSet = statement3.executeQuery(" select * from user2.tshared0");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement3.executeUpdate(" create table tshared1 (i int)");
        statement3.executeUpdate(" grant select, insert, delete, update on tshared1 to user3, user4, user5");
        statement4.executeUpdate(" create table tshared1 (i int)");
        statement4.executeUpdate(" grant select, insert, delete, update on tshared1 to user2, user4, user5");
        statement3.executeUpdate(" insert into user3.tshared1 values 1,2,3");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 3, " update user3.tshared1 set i = 888");
        resultSet = statement3.executeQuery(" select * from user3.tshared1");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"888"}, {"888"}, {"888"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement3, 3, " delete from user3.tshared1");
        statement3.executeUpdate(" insert into user3.tshared1 values 1,2,3");
        statement4.executeUpdate(" insert into user2.tshared1 values 3,2,1");
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, " update user2.tshared1 set i = 999");
        resultSet = statement4.executeQuery(" select * from user2.tshared1");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"999"}, {"999"}, {"999"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertUpdateCount(statement4, 3, " delete from user2.tshared1");
        statement4.executeUpdate(" insert into user2.tshared1 values 3,2,1");
        GrantRevokeDDLTest.assertUpdateCount(statement, 3, " update user2.tshared1 set i = 1000");
        GrantRevokeDDLTest.assertUpdateCount(statement, 3, " update user3.tshared1 set i = 1001");
        GrantRevokeDDLTest.assertUpdateCount(statement, 3, " delete from user2.tshared1");
        GrantRevokeDDLTest.assertUpdateCount(statement, 3, " delete from user3.tshared1");
        statement.executeUpdate(" insert into user2.tshared1 values 0,1,2,3");
        statement.executeUpdate(" insert into user3.tshared1 values 4,3,2,1");
        resultSet = statement5.executeQuery(" select * from user2.tshared1 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement5.executeQuery(" select * from user3.tshared1 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement5.executeUpdate(" create view vshared1 as select * from user2.tshared1 union select * from user3.tshared1");
        statement5.executeUpdate(" create view vshared2 as select * from user2.tshared1 intersect select * from user3.tshared1");
        statement5.executeUpdate(" create view vshared3 as select * from user2.tshared1 except select * from user3.tshared1");
        statement5.executeUpdate(" create view vshared4(i) as select * from user3.tshared1 union values 0");
        statement5.executeUpdate(" insert into user2.tshared1 select * from user3.tshared1");
        resultSet = statement5.executeQuery(" select * from vshared1 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement5.executeQuery(" select * from vshared2 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement5.executeQuery(" select * from vshared3");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement5.executeQuery(" select * from vshared4 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("4250A", statement5, "grant select on vshared1 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", statement5, " grant select on vshared2 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", statement5, " grant select on vshared3 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", statement5, " grant select on vshared4 to user5");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement6, " select * from user4.vshared1");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement6, " select * from user4.vshared2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement6, " select * from user4.vshared3");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement6, " select * from user4.vshared4");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "create trigger tt0a after insert on t1 for each statement grant select on t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X01", statement2, "create trigger tt0b after insert on t1 for each statement revoke select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, "drop table t6");
        statement2.executeUpdate(" create table t6 (c1 int not null primary key, c2 int)");
        statement2.executeUpdate(" grant trigger on t6 to user2");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement3, " drop table t7");
        statement3.executeUpdate(" create table t7 (c1 int, c2 int, c3 int)");
        statement3.executeUpdate(" insert into t7 values (1,1,1)");
        statement3.executeUpdate(" create trigger tt1 after insert on user1.t6 for each statement update user2.t7 set c2 = 888");
        statement3.executeUpdate(" create trigger tt2 after insert on user1.t6 for each statement insert into user2.t7 values (2,2,2)");
        statement2.executeUpdate(" insert into t6 values (1, 10)");
        resultSet = statement.executeQuery(" select * from user2.t7 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "888", "1"}, {"2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table t8");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table t9");
        statement2.executeUpdate(" create table t8 (c1 int not null primary key, c2 int)");
        statement2.executeUpdate(" create table t9 (c1 int, c2 int, c3 int)");
        statement2.executeUpdate(" insert into user1.t8 values (1,1)");
        statement2.executeUpdate(" insert into user1.t9 values (10,10,10)");
        statement2.executeUpdate(" grant trigger on t8 to user2");
        statement2.executeUpdate(" grant update(c2, c1), insert on t9 to user2");
        statement3.executeUpdate(" create trigger tt3 after insert on user1.t8 for each statement update user1.t9 set c2 = 888");
        statement3.executeUpdate(" create trigger tt4 after insert on user1.t8 for each statement insert into user1.t9 values (2,2,2)");
        GrantRevokeDDLTest.assertStatementError("23505", statement2, "insert into user1.t8 values (1, 10)");
        statement2.executeUpdate("insert into user1.t8 values (2, 20)");
        resultSet = statement2.executeQuery(" select * from user1.t9 order by C1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "2", "2"}, {"10", "888", "10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, "drop table t10");
        GrantRevokeDDLTest.assertStatementError("42Y55", statement2, " drop table t11");
        statement2.executeUpdate(" create table t10 (i int, j int)");
        statement2.executeUpdate(" insert into t10 values (1,1), (2,2)");
        statement2.executeUpdate(" create table t11 (i int)");
        statement2.executeUpdate(" grant all privileges on t10 to user2");
        statement2.executeUpdate(" grant all privileges on t11 to user2");
        statement3.executeUpdate("create trigger tt5 after update on user1.t10 for each statement insert into user1.t11 values 1");
        statement3.executeUpdate(" create trigger tt6 after update of i on user1.t10 for each statement insert into user1.t11 values 2");
        statement3.executeUpdate(" create trigger tt7 after update of j on user1.t10 for each statement insert into user1.t11 values 3");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 2, " update user1.t10 set i=10");
        resultSet = statement3.executeQuery(" select * from user1.t10 order by I, J");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"10", "1"}, {"10", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement3.executeQuery(" select * from user1.t11 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate("revoke trigger on t10 from user2");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 2, " update user1.t10 set i=20");
        resultSet = statement3.executeQuery(" select * from user1.t10 order by I, J");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"20", "1"}, {"20", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement3.executeQuery(" select * from user1.t11 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement2.executeUpdate(" grant trigger on t10 to user2");
        statement3.executeUpdate(" create trigger tt8 after update of j on user1.t10 for each statement delete from user1.t11");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 2, " update user1.t10 set j=100");
        resultSet = statement3.executeQuery(" select * from user1.t10");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"20", "100"}, {"20", "100"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement3.executeQuery(" select * from user1.t11");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        GrantRevokeDDLTest.assertUpdateCount(statement3, 2, " delete from user1.t10");
        GrantRevokeDDLTest.assertUpdateCount(statement3, 0, " delete from user1.t11");
        statement2.executeUpdate(" drop function F_ABS1");
        statement2.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement2.executeUpdate(" grant execute on function F_ABS1 to user5");
        statement2.executeUpdate(" grant trigger,insert,update,delete,select on t10 to user5");
        statement2.executeUpdate(" grant trigger,insert,update,delete,select on t11 to user5");
        GrantRevokeDDLTest.assertStatementError("X0X05", statement2, " drop view v");
        statement2.executeUpdate(" create view v(i) as values 888");
        statement2.executeUpdate(" grant select on v to user5");
        statement6.executeUpdate(" create trigger tt9 after insert on user1.t10 for each statement insert into user1.t11 values (user1.F_ABS1(-5))");
        statement6.executeUpdate(" create trigger tt10 after insert on user1.t10 for each statement insert into user1.t11 select * from user1.v");
        statement6.executeUpdate(" insert into user1.t10 values (1,1)");
        resultSet = statement6.executeQuery(" select * from user1.t10");
        stringArray = new String[]{"I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement6.executeQuery(" select * from user1.t11 order by I");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5"}, {"888"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC1");
        statement.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC2");
        statement.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC3");
        statement.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC4");
        statement.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC1");
        statement.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC2");
        statement.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC3");
        statement.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC4");
        statement.executeUpdate("DROP TRIGGER USER2.TT1");
        statement.executeUpdate("DROP TRIGGER USER2.TT2");
        statement.executeUpdate("DROP TRIGGER USER2.TT3");
        statement.executeUpdate("DROP TRIGGER USER2.TT4");
        statement.executeUpdate("DROP TRIGGER USER2.TT8");
        statement.executeUpdate("DROP TRIGGER USER5.TT9");
        statement.executeUpdate("DROP TRIGGER USER5.TT10");
        statement.executeUpdate("DROP FUNCTION USER1.F_ABS1");
        statement.executeUpdate("DROP FUNCTION USER1.F_ABS2");
        statement.executeUpdate("DROP VIEW USER4.VSHARED4");
        statement.executeUpdate("DROP VIEW USER4.VSHARED3");
        statement.executeUpdate("DROP VIEW USER4.VSHARED2");
        statement.executeUpdate("DROP VIEW USER4.VSHARED1");
        statement.executeUpdate("DROP VIEW USER2.V02AP");
        statement.executeUpdate("DROP VIEW USER2.SVC");
        statement.executeUpdate("DROP VIEW USER1.SVB");
        statement.executeUpdate("DROP VIEW USER1.SVA");
        statement.executeUpdate("DROP VIEW USER1.SV1");
        statement.executeUpdate("DROP VIEW USER1.V");
        statement.executeUpdate("DROP SYNONYM USER1.S1");
        statement.executeUpdate("DROP TABLE USER3.RT3");
        statement.executeUpdate("DROP TABLE USER3.TSHARED1");
        statement.executeUpdate("DROP TABLE USER3.TABLEEXP1");
        statement.executeUpdate("DROP TABLE USER3.TABLEIMP1");
        statement.executeUpdate("DROP TABLE USER2.T5");
        statement.executeUpdate("DROP TABLE USER2.T2");
        statement.executeUpdate("DROP TABLE USER2.TSHARED0");
        statement.executeUpdate("DROP TABLE USER2.T7");
        statement.executeUpdate("DROP TABLE USER2.TSHARED1");
        statement.executeUpdate("DROP TABLE USER2.RT2");
        statement.executeUpdate("DROP TABLE USER1.T4");
        statement.executeUpdate("DROP TABLE USER1.RTB");
        statement.executeUpdate("DROP TABLE USER1.TA ");
        statement.executeUpdate("DROP TABLE USER1.T10");
        statement.executeUpdate("DROP TABLE USER1.T2");
        statement.executeUpdate("DROP TABLE USER1.TB");
        statement.executeUpdate("DROP TABLE USER1.T6");
        statement.executeUpdate("DROP TABLE USER1.T8");
        statement.executeUpdate("DROP TABLE USER1.TTT2");
        statement.executeUpdate("DROP TABLE USER1.T11");
        statement.executeUpdate("DROP TABLE USER1.T9");
        statement.executeUpdate("DROP TABLE USER1.T01AP");
        statement.executeUpdate("DROP TABLE USER1.T1 ");
        statement.executeUpdate("DROP TABLE USER1.T3");
        statement.executeUpdate("DROP TABLE USER1.RT1");
        statement.executeUpdate("DROP SCHEMA USER1 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER2 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER3 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER4 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER5 RESTRICT");
        statement.executeUpdate("DROP SCHEMA USER6 RESTRICT");
        statement.executeUpdate("DROP SCHEMA MYSCHEMA RESTRICT");
        statement.executeUpdate("DROP SCHEMA W3 RESTRICT");
        statement6.close();
        statement5.close();
        statement4.close();
        statement3.close();
        statement2.close();
        statement.close();
        connection5.close();
        connection4.close();
        connection3.close();
        connection2.close();
        connection.close();
    }

    public void testRevokeDropsFKWithSharedConglom() throws SQLException {
        Connection connection = this.openUserConnection("mamta1");
        Statement statement = connection.createStatement();
        statement.execute("create table pkt1 (i int not null, j int not null)");
        statement.execute("alter table pkt1 add constraint pkOne primary key (i, j)");
        statement.execute("insert into pkt1 values (1, 2), (3, 4)");
        statement.execute("grant references on pkt1 to mamta2");
        statement.execute("create table pkt2 (i int not null, j int not null)");
        statement.execute("alter table pkt2 add constraint pkTwo primary key (i, j)");
        statement.execute("insert into pkt2 values (1, 2), (2, 3)");
        statement.execute("grant references on pkt2 to mamta2");
        Connection connection2 = this.openUserConnection("mamta2");
        Statement statement2 = connection2.createStatement();
        statement2.execute("create table fkt2 (i int, j int)");
        statement2.execute("alter table fkt2 add constraint fkOne foreign key (i, j) references mamta1.pkt1");
        statement2.execute("alter table fkt2 add constraint fkDup foreign key (i, j) references mamta1.pkt2");
        statement2.execute("insert into fkt2 values(1, 2)");
        GrantRevokeDDLTest.assertStatementError("23503", statement2, "insert into fkt2 values (2, 3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement2, "insert into fkt2 values (3, 4)");
        statement.execute("revoke references on pkt1 from mamta2");
        statement2.execute("insert into fkt2 values (2, 3)");
        GrantRevokeDDLTest.assertStatementError("23503", statement2, "insert into fkt2 values (3, 4)");
        JDBC.assertUnorderedResultSet(statement2.executeQuery("select * from fkt2 --DERBY-PROPERTIES constraint=FKDUP"), new String[][]{{"1", "2"}, {"2", "3"}});
        statement2.execute("drop table fkt2");
        statement2.execute("drop schema mamta2 restrict");
        statement.execute("drop table pkt2");
        statement.execute("drop table pkt1");
        statement.execute("drop schema mamta1 restrict");
        statement2.close();
        statement.close();
        connection2.close();
        connection.close();
    }

    public void testMinimumSelectPrivilegeRequirement() throws SQLException {
        String string;
        int n;
        Connection connection = this.openUserConnection("user1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.openUserConnection("user2");
        Statement statement2 = connection2.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("create table t4191(x int, y int)");
        statement.executeUpdate("create table t4191_table2(z int)");
        statement.executeUpdate("create table t4191_table3(c31 int, c32 int)");
        statement.executeUpdate("create view view_t4191_table3(v31, v32) as select c31, c32 from t4191_table3");
        statement.execute("grant update on t4191_table3 to public");
        statement.execute("grant insert on t4191_table3 to public");
        statement.execute("grant delete on t4191_table3 to public");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191_table3 set c31 = ( select max(v31) from user1.view_t4191_table3 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191_table3 set c31 = ( select count(*) from user1.view_t4191_table3 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191_table3 set c31 = ( select 1 from user1.view_t4191_table3 )");
        statement2.execute("delete from user1.t4191_table3");
        statement.execute("grant select on view_t4191_table3 to public");
        statement2.execute("update user1.t4191_table3 set c31 = ( select max(v31) from user1.view_t4191_table3 )");
        statement2.execute("update user1.t4191_table3 set c31 = ( select count(*) from user1.view_t4191_table3 )");
        statement2.execute("update user1.t4191_table3 set c31 = ( select 1 from user1.view_t4191_table3 )");
        Object[][] objectArrayArray = new Object[][]{{"select count(*) from user1.t4191", new String[][]{{"0"}}}, {"select count(1) from user1.t4191", new String[][]{{"0"}}}, {"select 1 from user1.t4191", new String[0][]}, {"select 1 from user1.t4191 for update", new String[0][]}, {"select 1 from user1.t4191 union values 2", new String[][]{{"2"}}}, {"values 1 union select 1 from user1.t4191", new String[][]{{"1"}}}, {"values (select count(*) from user1.t4191)", new String[][]{{"0"}}}, {"values (select count(1) from user1.t4191)", new String[][]{{"0"}}}, {"values ((select 1 from user1.t4191))", new String[][]{{null}}}, {"values exists(select 1 from user1.t4191)", new String[][]{{"false"}}}, {"values exists(select * from user1.t4191)", new String[][]{{"false"}}}, {"select count(*) from (select 1 from user1.t4191) s", new String[][]{{"0"}}}, {"insert into user1.t4191_table3 select 1, 2 from user1.t4191", 0}, {"update user1.t4191_table3 set c31 = 1 where exists (select * from user1.t4191)", 0}, {"delete from user1.t4191_table3 where exists (select * from user1.t4191)", 0}};
        for (n = 0; n < objectArrayArray.length; ++n) {
            string = (String)objectArrayArray[n][0];
            GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement2, string);
        }
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "select count(y) from user1.t4191");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x=0");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select z from user1.t4191_table2 )");
        statement.execute("grant select(x) on t4191 to user2");
        for (n = 0; n < objectArrayArray.length; ++n) {
            string = (String)objectArrayArray[n][0];
            Object object = objectArrayArray[n][1];
            if (object instanceof Integer) {
                GrantRevokeDDLTest.assertUpdateCount(statement2, (Integer)object, string);
                continue;
            }
            JDBC.assertFullResultSet(statement2.executeQuery(string), (String[][])object);
        }
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "select count(y) from user1.t4191");
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement2, "select x from user1.t4191_table2, user1.t4191");
        statement.execute("grant select(z) on t4191_table2 to user2");
        resultSet = statement2.executeQuery("select x from user1.t4191_table2, user1.t4191");
        JDBC.assertEmpty(resultSet);
        statement.execute("revoke select(x) on t4191 from user2");
        statement.execute("revoke select(z) on t4191_table2 from user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x=0");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select z from user1.t4191_table2 )");
        statement.execute("grant update on t4191 to user2");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 0, "update user1.t4191 set x=0");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select z from user1.t4191_table2 )");
        statement.execute("grant select(y) on t4191 to user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        statement.execute("grant select(x) on t4191 to user2");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 0, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select z from user1.t4191_table2 )");
        statement.execute("grant select on t4191_table2 to user2");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 0, "update user1.t4191 set x= ( select z from user1.t4191_table2 )");
        statement.execute("revoke select(x) on t4191 from user2");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 0, "update user1.t4191 set x=0");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        statement.execute("grant select(y) on t4191 to user2");
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        resultSet = statement2.executeQuery("select count(*) from user1.t4191");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet = statement2.executeQuery("select count(1) from user1.t4191");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet = statement2.executeQuery("select 1 from user1.t4191");
        JDBC.assertEmpty(resultSet);
        resultSet = statement2.executeQuery("select count(y) from user1.t4191");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        statement.execute("grant select(x) on t4191 to user2");
        GrantRevokeDDLTest.assertUpdateCount(statement2, 0, "update user1.t4191 set x= ( select max(x) + 2 from user1.t4191 )");
        statement.execute("drop table t4191");
        statement.execute("drop table t4191_table2");
        statement.execute("drop view view_t4191_table3");
        statement.execute("drop table t4191_table3");
        statement.execute("drop schema user1 restrict");
        connection.close();
        connection2.close();
    }

    public void testGlobalTempTables() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        Connection connection2 = this.openUserConnection("george");
        Statement statement2 = connection2.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("declare global temporary table t1(i int, j int) on commit preserve rows not logged");
        statement.executeUpdate("insert into session.t1 values (1,1),(1,1)");
        resultSet = statement.executeQuery("select * from session.t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}, {"1", "1"}});
        statement.executeUpdate("drop table session.t1");
        statement.executeUpdate("create schema session");
        statement.executeUpdate("create table session.t2(i int)");
        statement.executeUpdate("insert into session.t2 values 2,22");
        resultSet = statement.executeQuery("select * from session.t2 order by I");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}, {"22"}});
        statement.executeUpdate("declare global temporary table t2(i int, j int) on commit preserve rows not logged");
        statement.executeUpdate("insert into session.t2 values (222,222),(2,2)");
        resultSet = statement.executeQuery("select * from session.t2 order by i");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "2"}, {"222", "222"}});
        GrantRevokeDDLTest.assertStatementError(NO_SELECT_OR_UPDATE_PERMISSION, statement2, "select * from session.t2");
        GrantRevokeDDLTest.assertStatementError("42507", statement2, "create table session.t3(i int)");
        statement2.executeUpdate("declare global temporary table t4(i int, j int) on commit preserve rows not logged");
        statement2.executeUpdate("insert into session.t4 values (4,4),(44,44)");
        resultSet = statement2.executeQuery("select * from session.t4 order by i");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"4", "4"}, {"44", "44"}});
        Connection connection3 = this.openUserConnection("monica");
        Statement statement3 = connection3.createStatement();
        GrantRevokeDDLTest.assertStatementError("42X05", statement3, "select * from session.t4");
        statement2.executeUpdate("drop table session.t4");
        connection.close();
        connection = this.getConnection();
        statement = connection.createStatement();
        resultSet = statement.executeQuery("select * from session.t2 order by i");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}, {"22"}});
        resultSet.close();
        statement.execute("drop table session.t2");
        statement.execute("drop schema session restrict");
        statement.close();
        statement2.close();
        statement3.close();
        connection.close();
        connection2.close();
        connection3.close();
    }

    public void test_derby_4502() throws Exception {
        Connection connection = this.openUserConnection("mamta1");
        Statement statement = connection.createStatement();
        statement.execute("create view v_4502( a ) as select tablename from sys.systables");
        statement.execute("drop view v_4502");
        statement.execute("drop schema mamta1 restrict");
    }

    public void testAlterTablePrivilegesIntace() throws Exception {
        Connection connection = this.openUserConnection("user1");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table user1.t11 (c111 int, c112 int, c113 int)");
        statement.executeUpdate("create table user1.t12 (c121 int, c122 int)");
        statement.executeUpdate("create table user1.t13 (c131 int, c132 int)");
        statement.executeUpdate(" insert into user1.t11 values(1,2,3)");
        statement.executeUpdate(" grant trigger on user1.t12 to user2");
        statement.executeUpdate(" grant update(c112, c113) on user1.t11 to user2");
        statement.executeUpdate(" grant select on user1.t11 to user2");
        statement.executeUpdate(" grant insert on user1.t13 to user2");
        Connection connection2 = this.openUserConnection("user2");
        Statement statement2 = connection2.createStatement();
        statement2.executeUpdate("create trigger tr1t12 after insert on user1.t12 for each row mode db2sql update user1.t11 set c112=222");
        statement2.executeUpdate("create trigger tr2t12 after insert on user1.t12 for each row mode db2sql insert into user1.t13(c131, c132) select c111, c113 from user1.t11");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "2", "3"}});
        JDBC.assertEmpty(statement.executeQuery(" select * from user1.t13"));
        statement.executeUpdate(" insert into user1.t12 values(91,91)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "222", "3"}});
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t13"), new String[][]{{"1", "3"}});
        statement.executeUpdate("delete from user1.t11");
        statement.executeUpdate("delete from user1.t13");
        statement.executeUpdate(" insert into user1.t11 values(1,2,3)");
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "alter table t11 drop column c112 restrict");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "2", "3"}});
        JDBC.assertEmpty(statement.executeQuery(" select * from user1.t13"));
        statement.executeUpdate(" insert into user1.t12 values(92,92)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "222", "3"}});
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t13"), new String[][]{{"1", "3"}});
        statement.executeUpdate("delete from user1.t11");
        statement.executeUpdate("delete from user1.t13");
        statement.executeUpdate(" insert into user1.t11 values(1,2,3)");
        statement.executeUpdate("alter table t11 drop column c112");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "3"}});
        JDBC.assertEmpty(statement.executeQuery(" select * from user1.t13"));
        statement.executeUpdate(" insert into user1.t12 values(93,93)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "3"}});
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t13"), new String[][]{{"1", "3"}});
        statement.executeUpdate("delete from user1.t11");
        statement.executeUpdate("delete from user1.t13");
        statement.executeUpdate(" insert into user1.t11 values(1,3)");
        statement.executeUpdate("revoke insert on table user1.t13 from user2");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "3"}});
        JDBC.assertEmpty(statement.executeQuery(" select * from user1.t13"));
        statement.executeUpdate(" insert into user1.t12 values(94,94)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{"1", "3"}});
        JDBC.assertEmpty(statement.executeQuery(" select * from user1.t13"));
        statement.executeUpdate("drop table user1.t11");
        statement.executeUpdate("drop table user1.t12");
        statement.executeUpdate("drop table user1.t13");
        statement.executeUpdate("drop schema user1 restrict");
        statement2.executeUpdate("drop schema user2 restrict");
    }

    public void testAlterTableWithPrivileges() throws Exception {
        Connection connection = this.openUserConnection("user1");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table user1.t11 (c111 int, c112 int)");
        statement.executeUpdate("create table user1.t12 (c121 int, c122 int)");
        Connection connection2 = this.openUserConnection("user2");
        Statement statement2 = connection2.createStatement();
        GrantRevokeDDLTest.assertStatementError(NO_TABLE_PERMISSION, statement2, "create trigger tr1t12 after insert on user1.t12 for each row mode db2sql insert into user1.t11(c112) values (1)");
        statement.executeUpdate(" grant insert on user1.t11 to user2");
        statement.executeUpdate(" grant trigger on user1.t12 to user2");
        statement2.executeUpdate("create trigger tr1t12 after insert on user1.t12 for each row mode db2sql insert into user1.t11(c112) values (1)");
        statement.executeUpdate(" insert into user1.t12 values(91,91)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11 order by c111"), new String[][]{{null, "1"}});
        GrantRevokeDDLTest.assertStatementError("X0Y25", statement, "alter table t11 drop column c112 restrict");
        statement.executeUpdate(" insert into user1.t12 values(92,92)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{null, "1"}, {null, "1"}});
        statement.executeUpdate("alter table t11 drop column c112");
        statement.executeUpdate(" insert into user1.t12 values(93,93)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from user1.t11"), new String[][]{{null}, {null}});
        statement.executeUpdate("drop table user1.t11");
        statement.executeUpdate("drop table user1.t12");
        statement.executeUpdate("drop schema user1 restrict");
        statement2.executeUpdate("drop schema user2 restrict");
    }

    public void test_6429_tables() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create table t1_simple_6429(x int, y int, z int)");
        this.goodStatement(connection, "create view v1_simple_6429(a, b) as select x, y from t1_simple_6429");
        this.goodStatement(connection, "create type SelectHashMap_6429 external name 'java.util.HashMap' language java\n");
        this.goodStatement(connection, "create type CheckHashMap_6429 external name 'java.util.HashMap' language java\n");
        this.goodStatement(connection, "create type WhereHashMap_6429 external name 'java.util.HashMap' language java\n");
        this.goodStatement(connection, "create function generationFunction_6429( rawValue int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "create function setFunction_6429( hashMap SelectHashMap_6429, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function checkFunction_6429( hashMap CheckHashMap_6429, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function whereFunction_6429( hashMap WhereHashMap_6429, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create derby aggregate setAggregate_6429 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create derby aggregate whereAggregate_6429 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create procedure addHistoryRow_6429\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(connection, "create table primaryTable_6429\n(\n    key1 int,\n    key2 int,\n    primary key( key1, key2 )\n)\n");
        this.goodStatement(connection, "create table setTable_6429\n(\n    a int\n)\n");
        this.goodStatement(connection, "create table whereTable_6429\n(\n    a int\n)\n");
        this.goodStatement(connection, "create table updateTable_6429\n(\n    updateColumn int,\n    selectColumn SelectHashMap_6429,\n    untouchedGenerationSource int,\n    generatedColumn generated always as ( updateColumn + generationFunction_6429( untouchedGenerationSource ) ),\n    untouchedCheckSource CheckHashMap_6429,\n    untouchedForeignSource int,\n    untouchedBeforeTriggerSource int,\n    untouchedAfterTriggerSource int,\n    whereColumn WhereHashMap_6429,\n    check ( updateColumn > checkFunction_6429( untouchedCheckSource, 'foo' ) ),\n    foreign key ( updateColumn, untouchedForeignSource ) references primaryTable_6429( key1, key2 )\n)\n");
        this.goodStatement(connection, "create trigger beforeUpdateTrigger_6429\nno cascade before update of updateColumn on updateTable_6429\nreferencing old as old\nfor each row\ncall addHistoryRow_6429( 'before', old.updateColumn + old.untouchedBeforeTriggerSource )\n");
        this.goodStatement(connection, "create trigger afterUpdateTrigger_6429\nafter update of updateColumn on updateTable_6429\nreferencing old as old\nfor each row\ncall addHistoryRow_6429( 'before', old.updateColumn + old.untouchedAfterTriggerSource )\n");
        this.goodStatement(connection, "grant update on t1_simple_6429 to ruth");
        for (Permission permission : permissionArray = new Permission[]{new Permission("execute on function setFunction_6429", NO_GENERIC_PERMISSION), new Permission("execute on function whereFunction_6429", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate setAggregate_6429", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate whereAggregate_6429", NO_GENERIC_PERMISSION), new Permission("update ( updateColumn ) on updateTable_6429", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( selectColumn ) on updateTable_6429", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( whereColumn ) on updateTable_6429", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( a ) on setTable_6429", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select( a ) on whereTable_6429", NO_SELECT_OR_UPDATE_PERMISSION)}) {
            this.grant_6429(connection, permission.text);
        }
        this.expectExecutionError(connection2, NO_SELECT_OR_UPDATE_PERMISSION, "update test_dbo.t1_simple_6429 set x = y");
        String string = "update test_dbo.t1_simple_6429\n  set x =\n  ( select b from test_dbo.v1_simple_6429 where a = 1 )\n";
        this.expectExecutionError(connection2, NO_SELECT_OR_UPDATE_PERMISSION, string);
        this.goodStatement(connection, "grant select on v1_simple_6429 to ruth");
        this.goodStatement(connection2, string);
        String string2 = "update test_dbo.t1_simple_6429 g\n  set x =\n  ( select b from test_dbo.v1_simple_6429 where a = g.z )\n";
        this.expectExecutionError(connection2, NO_SELECT_OR_UPDATE_PERMISSION, string2);
        this.goodStatement(connection, "grant select( z ) on t1_simple_6429 to ruth");
        this.goodStatement(connection2, string2);
        String string3 = "update test_dbo.updateTable_6429\n    set updateColumn =\n        test_dbo.setFunction_6429( selectColumn, 'foo' ) +\n        ( select test_dbo.setAggregate_6429( a ) from test_dbo.setTable_6429 )\nwhere\n    test_dbo.whereFunction_6429( whereColumn, 'foo' ) >\n    ( select test_dbo.whereAggregate_6429( a ) from test_dbo.whereTable_6429 )\n";
        this.goodStatement(connection2, string3);
        for (Permission permission : permissionArray) {
            this.vetPermission_6429(permission, connection, connection2, string3);
        }
        this.goodStatement(connection, "drop view v1_simple_6429");
        this.goodStatement(connection, "drop table t1_simple_6429");
        this.goodStatement(connection, "drop table updateTable_6429");
        this.goodStatement(connection, "drop table whereTable_6429");
        this.goodStatement(connection, "drop table setTable_6429");
        this.goodStatement(connection, "drop table primaryTable_6429");
        this.goodStatement(connection, "drop procedure addHistoryRow_6429");
        this.goodStatement(connection, "drop derby aggregate whereAggregate_6429 restrict");
        this.goodStatement(connection, "drop derby aggregate setAggregate_6429 restrict");
        this.goodStatement(connection, "drop function whereFunction_6429");
        this.goodStatement(connection, "drop function checkFunction_6429");
        this.goodStatement(connection, "drop function setFunction_6429");
        this.goodStatement(connection, "drop function generationFunction_6429");
        this.goodStatement(connection, "drop type WhereHashMap_6429 restrict");
        this.goodStatement(connection, "drop type CheckHashMap_6429 restrict");
        this.goodStatement(connection, "drop type SelectHashMap_6429 restrict");
    }

    private void vetPermission_6429(Permission permission, Connection connection, Connection connection2, String string) throws Exception {
        this.revoke_6429(connection, permission.text);
        this.expectExecutionError(connection2, permission.sqlStateWhenMissing, string);
        this.grant_6429(connection, permission.text);
        this.goodStatement(connection2, string);
    }

    private void grant_6429(Connection connection, String string) throws Exception {
        String string2 = "grant " + string + " to ruth";
        this.goodStatement(connection, string2);
    }

    private void revoke_6429(Connection connection, String string) throws Exception {
        String string2 = "revoke " + string + " from ruth";
        if (string.startsWith("execute") || string.startsWith("usage")) {
            string2 = string2 + " restrict";
        }
        this.goodStatement(connection, string2);
    }

    public void test_6429_views() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type SelectHashMap_6429_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type CheckHashMap_6429_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type WhereHashMap_6429_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function generationFunction_6429_2( rawValue int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "create function setFunction_6429_2( hashMap SelectHashMap_6429_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function checkFunction_6429_2( hashMap CheckHashMap_6429_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function whereFunction_6429_2( hashMap WhereHashMap_6429_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create derby aggregate setAggregate_6429_2 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create derby aggregate whereAggregate_6429_2 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create table primaryTable_6429_2\n(\n    key1 int,\n    key2 int,\n    primary key( key1, key2 )\n)\n");
        this.goodStatement(connection, "create table setTable_6429_2\n(\n    a int\n)\n");
        this.goodStatement(connection, "create view setView_6429_2( setViewCol ) as select a from setTable_6429_2");
        this.goodStatement(connection, "create table whereTable_6429_2\n(\n    a int\n)\n");
        this.goodStatement(connection, "create view whereView_6429_2( whereViewCol ) as select a from whereTable_6429_2");
        this.goodStatement(connection, "create table updateTable_6429_2\n(\n    updateColumn int,\n    selectColumn SelectHashMap_6429_2,\n    untouchedGenerationSource int,\n    generatedColumn generated always as ( updateColumn + generationFunction_6429_2( untouchedGenerationSource ) ),\n    untouchedCheckSource CheckHashMap_6429_2,\n    untouchedForeignSource int,\n    untouchedBeforeTriggerSource int,\n    untouchedAfterTriggerSource int,\n    whereColumn WhereHashMap_6429_2,\n    check ( updateColumn > checkFunction_6429_2( untouchedCheckSource, 'foo' ) ),\n    foreign key ( updateColumn, untouchedForeignSource ) references primaryTable_6429_2( key1, key2 )\n)\n");
        for (Permission permission : permissionArray = new Permission[]{new Permission("execute on function setFunction_6429_2", NO_GENERIC_PERMISSION), new Permission("execute on function whereFunction_6429_2", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate setAggregate_6429_2", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate whereAggregate_6429_2", NO_GENERIC_PERMISSION), new Permission("update ( updateColumn ) on updateTable_6429_2", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( selectColumn ) on updateTable_6429_2", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( whereColumn ) on updateTable_6429_2", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( setViewCol ) on setView_6429_2", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select( whereViewCol ) on whereView_6429_2", NO_SELECT_OR_UPDATE_PERMISSION)}) {
            this.grant_6429(connection, permission.text);
        }
        String string = "update test_dbo.updateTable_6429_2\n    set updateColumn =\n        test_dbo.setFunction_6429_2( selectColumn, 'foo' ) +\n        ( select test_dbo.setAggregate_6429_2( setViewCol ) from test_dbo.setView_6429_2 )\nwhere\n    test_dbo.whereFunction_6429_2( whereColumn, 'foo' ) >\n    ( select test_dbo.whereAggregate_6429_2( whereViewCol ) from test_dbo.whereView_6429_2 )\n";
        this.goodStatement(connection2, string);
        for (Permission permission : permissionArray) {
            this.vetPermission_6429(permission, connection, connection2, string);
        }
        this.goodStatement(connection, "drop table updateTable_6429_2");
        this.goodStatement(connection, "drop view whereView_6429_2");
        this.goodStatement(connection, "drop table whereTable_6429_2");
        this.goodStatement(connection, "drop view setView_6429_2");
        this.goodStatement(connection, "drop table setTable_6429_2");
        this.goodStatement(connection, "drop table primaryTable_6429_2");
        this.goodStatement(connection, "drop derby aggregate whereAggregate_6429_2 restrict");
        this.goodStatement(connection, "drop derby aggregate setAggregate_6429_2 restrict");
        this.goodStatement(connection, "drop function whereFunction_6429_2");
        this.goodStatement(connection, "drop function checkFunction_6429_2");
        this.goodStatement(connection, "drop function setFunction_6429_2");
        this.goodStatement(connection, "drop function generationFunction_6429_2");
        this.goodStatement(connection, "drop type WhereHashMap_6429_2 restrict");
        this.goodStatement(connection, "drop type CheckHashMap_6429_2 restrict");
        this.goodStatement(connection, "drop type SelectHashMap_6429_2 restrict");
    }

    public void test_6429_tableFunctions() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type SelectHashMap_6429_3 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type CheckHashMap_6429_3 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type WhereHashMap_6429_3 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function generationFunction_6429_3( rawValue int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "create function setFunction_6429_3( hashMap SelectHashMap_6429_3, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function checkFunction_6429_3( hashMap CheckHashMap_6429_3, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function whereFunction_6429_3( hashMap WhereHashMap_6429_3, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create derby aggregate setAggregate_6429_3 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create derby aggregate whereAggregate_6429_3 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create table primaryTable_6429_3\n(\n    key1 int,\n    key2 int,\n    primary key( key1, key2 )\n)\n");
        this.goodStatement(connection, "create function setTableFunction_6429_3()\nreturns table( x int, y int, z int, w int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        this.goodStatement(connection, "create function whereTableFunction_6429_3()\nreturns table( x int, y int, z int, w int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        this.goodStatement(connection, "create table updateTable_6429_3\n(\n    updateColumn int,\n    selectColumn SelectHashMap_6429_3,\n    untouchedGenerationSource int,\n    generatedColumn generated always as ( updateColumn + generationFunction_6429_3( untouchedGenerationSource ) ),\n    untouchedCheckSource CheckHashMap_6429_3,\n    untouchedForeignSource int,\n    untouchedBeforeTriggerSource int,\n    untouchedAfterTriggerSource int,\n    whereColumn WhereHashMap_6429_3,\n    check ( updateColumn > checkFunction_6429_3( untouchedCheckSource, 'foo' ) ),\n    foreign key ( updateColumn, untouchedForeignSource ) references primaryTable_6429_3( key1, key2 )\n)\n");
        for (Permission permission : permissionArray = new Permission[]{new Permission("execute on function setFunction_6429_3", NO_GENERIC_PERMISSION), new Permission("execute on function whereFunction_6429_3", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate setAggregate_6429_3", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate whereAggregate_6429_3", NO_GENERIC_PERMISSION), new Permission("update ( updateColumn ) on updateTable_6429_3", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( selectColumn ) on updateTable_6429_3", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( whereColumn ) on updateTable_6429_3", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("execute on function setTableFunction_6429_3", NO_GENERIC_PERMISSION), new Permission("execute on function whereTableFunction_6429_3", NO_GENERIC_PERMISSION)}) {
            this.grant_6429(connection, permission.text);
        }
        String string = "update test_dbo.updateTable_6429_3\n  set updateColumn =\n    test_dbo.setFunction_6429_3( selectColumn, 'foo' ) + \n    ( select test_dbo.setAggregate_6429_3( x ) from table( test_dbo.setTableFunction_6429_3() ) stf )\nwhere test_dbo.whereFunction_6429_3( whereColumn, 'foo' ) >\n    ( select test_dbo.whereAggregate_6429_3( x ) from table ( test_dbo.whereTableFunction_6429_3() ) wtf )\n";
        this.goodStatement(connection2, string);
        for (Permission permission : permissionArray) {
            this.vetPermission_6429(permission, connection, connection2, string);
        }
        this.goodStatement(connection, "drop table updateTable_6429_3");
        this.goodStatement(connection, "drop function whereTableFunction_6429_3");
        this.goodStatement(connection, "drop function setTableFunction_6429_3");
        this.goodStatement(connection, "drop table primaryTable_6429_3");
        this.goodStatement(connection, "drop derby aggregate whereAggregate_6429_3 restrict");
        this.goodStatement(connection, "drop derby aggregate setAggregate_6429_3 restrict");
        this.goodStatement(connection, "drop function whereFunction_6429_3");
        this.goodStatement(connection, "drop function checkFunction_6429_3");
        this.goodStatement(connection, "drop function setFunction_6429_3");
        this.goodStatement(connection, "drop function generationFunction_6429_3");
        this.goodStatement(connection, "drop type WhereHashMap_6429_3 restrict");
        this.goodStatement(connection, "drop type CheckHashMap_6429_3 restrict");
        this.goodStatement(connection, "drop type SelectHashMap_6429_3 restrict");
    }

    public void test_6434_insert() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type GenerationType_6434 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type CheckType_6434 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type SelectType_6434 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function generationFunction_6434( hashMap GenerationType_6434, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function checkFunction_6434( hashMap CheckType_6434, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function selectFunction_6434( hashMap SelectType_6434, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create derby aggregate selectAggregate_6434 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create sequence sequence_6434");
        this.goodStatement(connection, "create procedure addHistoryRow_6434\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(connection, "create table primaryTable_6434\n(\n    key1 int primary key\n)\n");
        this.goodStatement(connection, "create table selectTable_6434\n(\n    selectColumn int,\n    selectColumn2 SelectType_6434\n)\n");
        this.goodStatement(connection, "create table insertTable_6434\n(\n    insertColumn int references primaryTable_6434( key1 ),\n    privatePrimaryColumn int primary key,\n    privateGenerationSource GenerationType_6434,\n    privateForeignSource int,\n    privateCheckSource CheckType_6434,\n    privateBeforeTriggerSource int,\n    privateAfterTriggerSource int,\n    generatedColumn generated always as ( insertColumn + generationFunction_6434( privateGenerationSource, 'foo' ) ),\n    check ( insertColumn > checkFunction_6434( privateCheckSource, 'foo' ) )\n)\n");
        this.goodStatement(connection, "create table foreignTable_6434\n(\n    key1 int references insertTable_6434( privatePrimaryColumn )\n)\n");
        this.goodStatement(connection, "create trigger beforeInsertTrigger_6434\nno cascade before insert on insertTable_6434\nreferencing new as new\nfor each row\ncall addHistoryRow_6434( 'before', new.insertColumn + new.privateBeforeTriggerSource )\n");
        this.goodStatement(connection, "create trigger afterInsertTrigger_6434\nafter insert on insertTable_6434\nreferencing new as new\nfor each row\ncall addHistoryRow_6434( 'before', new.insertColumn + new.privateAfterTriggerSource )\n");
        for (Permission permission : permissionArray = new Permission[]{new Permission("insert on insertTable_6434", NO_TABLE_PERMISSION), new Permission("usage on sequence sequence_6434", NO_GENERIC_PERMISSION), new Permission("execute on function selectFunction_6434", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate selectAggregate_6434", NO_GENERIC_PERMISSION), new Permission("select on selectTable_6434", NO_SELECT_OR_UPDATE_PERMISSION)}) {
            this.grant_6429(connection, permission.text);
        }
        String string = "insert into test_dbo.insertTable_6434( insertColumn, privatePrimaryColumn )\n    select next value for test_dbo.sequence_6434, test_dbo.selectFunction_6434( selectColumn2, 'foo' )\n    from test_dbo.selectTable_6434\n    where selectColumn > ( select test_dbo.selectAggregate_6434( selectColumn ) from test_dbo.selectTable_6434 )\n";
        this.goodStatement(connection2, string);
        for (Permission permission : permissionArray) {
            this.vetPermission_6429(permission, connection, connection2, string);
        }
        this.goodStatement(connection, "drop trigger afterInsertTrigger_6434");
        this.goodStatement(connection, "drop trigger beforeInsertTrigger_6434");
        this.goodStatement(connection, "drop table selectTable_6434");
        this.goodStatement(connection, "drop table foreignTable_6434");
        this.goodStatement(connection, "drop table insertTable_6434");
        this.goodStatement(connection, "drop table primaryTable_6434");
        this.goodStatement(connection, "drop procedure addHistoryRow_6434");
        this.goodStatement(connection, "drop sequence sequence_6434 restrict");
        this.goodStatement(connection, "drop derby aggregate selectAggregate_6434 restrict");
        this.goodStatement(connection, "drop function selectFunction_6434");
        this.goodStatement(connection, "drop function checkFunction_6434");
        this.goodStatement(connection, "drop function generationFunction_6434");
        this.goodStatement(connection, "drop type SelectType_6434 restrict");
        this.goodStatement(connection, "drop type CheckType_6434 restrict");
        this.goodStatement(connection, "drop type GenerationType_6434 restrict");
    }

    public void test_6434_delete() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type SelectType_6434_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type BeforeTriggerType_6434_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type AfterTriggerType_6434_2 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function selectFunction_6434_2( hashMap SelectType_6434_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function beforeTriggerFunction_6434_2( hashMap BeforeTriggerType_6434_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function afterTriggerFunction_6434_2( hashMap AfterTriggerType_6434_2, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create derby aggregate selectAggregate_6434_2 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection, "create procedure addHistoryRow_6434_2\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(connection, "create table primaryTable_6434_2\n(\n    key1 int primary key\n)\n");
        this.goodStatement(connection, "create table selectTable_6434_2\n(\n    selectColumn int,\n    selectColumn2 SelectType_6434_2\n)\n");
        this.goodStatement(connection, "create table deleteTable_6434_2\n(\n    privateForeignColumn int references primaryTable_6434_2( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_6434_2,\n    privateAfterTriggerSource AfterTriggerType_6434_2,\n    publicSelectColumn int\n)\n");
        this.goodStatement(connection, "create table foreignTable_6434_2\n(\n    key1 int references deleteTable_6434_2( privatePrimaryColumn )\n)\n");
        this.goodStatement(connection, "create trigger beforeDeleteTrigger_6434_2\nno cascade before delete on deleteTable_6434_2\nreferencing old as old\nfor each row\ncall addHistoryRow_6434_2( 'before', beforeTriggerFunction_6434_2( old.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(connection, "create trigger afterDeleteTrigger_6434_2\nafter delete on deleteTable_6434_2\nreferencing old as old\nfor each row\ncall addHistoryRow_6434_2( 'after', afterTriggerFunction_6434_2( old.privateAfterTriggerSource, 'foo' ) )\n");
        for (Permission permission : permissionArray = new Permission[]{new Permission("delete on deleteTable_6434_2", NO_TABLE_PERMISSION), new Permission("execute on function selectFunction_6434_2", NO_GENERIC_PERMISSION), new Permission("usage on derby aggregate selectAggregate_6434_2", NO_GENERIC_PERMISSION), new Permission("select on selectTable_6434_2", NO_SELECT_OR_UPDATE_PERMISSION), new Permission("select ( publicSelectColumn ) on deleteTable_6434_2", NO_SELECT_OR_UPDATE_PERMISSION)}) {
            this.grant_6429(connection, permission.text);
        }
        String string = "delete from test_dbo.deleteTable_6434_2\nwhere publicSelectColumn =\n(\n    select test_dbo.selectAggregate_6434_2( selectColumn )\n    from test_dbo.selectTable_6434_2\n    where test_dbo.selectFunction_6434_2( selectColumn2, 'foo' ) < 100\n)\n";
        this.goodStatement(connection2, string);
        for (Permission permission : permissionArray) {
            this.vetPermission_6429(permission, connection, connection2, string);
        }
        this.goodStatement(connection, "drop table foreignTable_6434_2");
        this.goodStatement(connection, "drop table deleteTable_6434_2");
        this.goodStatement(connection, "drop table selectTable_6434_2");
        this.goodStatement(connection, "drop table primaryTable_6434_2");
        this.goodStatement(connection, "drop procedure addHistoryRow_6434_2");
        this.goodStatement(connection, "drop derby aggregate selectAggregate_6434_2 restrict");
        this.goodStatement(connection, "drop function afterTriggerFunction_6434_2");
        this.goodStatement(connection, "drop function beforeTriggerFunction_6434_2");
        this.goodStatement(connection, "drop function selectFunction_6434_2");
        this.goodStatement(connection, "drop type AfterTriggerType_6434_2 restrict");
        this.goodStatement(connection, "drop type BeforeTriggerType_6434_2 restrict");
        this.goodStatement(connection, "drop type SelectType_6434_2 restrict");
    }

    public void test_6434_select() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type SourceValueType_6434_3 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type TargetValueType_6434_3 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function sourceValueExtractor_6434_3( hashMap SourceValueType_6434_3, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(connection, "create function sourceValueMaker_6434_3( hashKey varchar( 32672 ), hashValue int ) returns SourceValueType_6434_3\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(connection, "create function targetValueMaker_6434_3( hashKey varchar( 32672 ), hashValue int ) returns TargetValueType_6434_3\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(connection, "create table targetTable_6434_3( a TargetValueType_6434_3 )");
        this.goodStatement(connection, "create table sourceTable_6434_3( b SourceValueType_6434_3 )");
        this.goodStatement(connection, "grant insert on targetTable_6434_3 to ruth");
        this.goodStatement(connection, "grant execute on function sourceValueExtractor_6434_3 to ruth");
        this.goodStatement(connection, "grant execute on function sourceValueMaker_6434_3 to ruth");
        this.goodStatement(connection, "grant execute on function targetValueMaker_6434_3 to ruth");
        this.goodStatement(connection, "grant select on sourceTable_6434_3 to ruth");
        this.goodStatement(connection2, "insert into test_dbo.targetTable_6434_3\n  select test_dbo.targetValueMaker_6434_3( 'bar', test_dbo.sourceValueExtractor_6434_3( b, 'foo' ) )\n  from test_dbo.sourceTable_6434_3\n");
        this.expectExecutionError(connection2, NO_GENERIC_PERMISSION, "select * from test_dbo.sourceTable_6434_3\nwhere ( cast( null as test_dbo.SourceValueType_6434_3 ) ) is not null\n");
        this.goodStatement(connection, "drop table sourceTable_6434_3");
        this.goodStatement(connection, "drop table targetTable_6434_3");
        this.goodStatement(connection, "drop function targetValueMaker_6434_3");
        this.goodStatement(connection, "drop function sourceValueMaker_6434_3");
        this.goodStatement(connection, "drop function sourceValueExtractor_6434_3");
        this.goodStatement(connection, "drop type TargetValueType_6434_3 restrict");
        this.goodStatement(connection, "drop type SourceValueType_6434_3 restrict");
    }

    public void test_6432() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create function absoluteValue_6432( inputValue int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "create type hashmap_6432 external name 'java.util.HashMap' language java\n");
        this.goodStatement(connection, "create function makeHashmap_6432() returns hashmap_6432\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(connection, "create table t1_check_function_6432\n(\n    a int check ( absoluteValue_6432( a ) > 100 )\n)\n");
        this.goodStatement(connection, "create table t1_check_type_6432\n(\n    a hashmap_6432 check( (a is null) or (a is not null) )\n)\n");
        this.goodStatement(connection, "insert into t1_check_function_6432( a ) values -101");
        this.goodStatement(connection, "insert into t1_check_type_6432( a ) values ( makeHashmap_6432() )");
        this.goodStatement(connection, "grant insert on t1_check_function_6432 to ruth");
        this.goodStatement(connection, "grant update on t1_check_function_6432 to ruth");
        this.goodStatement(connection, "grant insert on t1_check_type_6432 to ruth");
        this.goodStatement(connection, "grant update on t1_check_type_6432 to ruth");
        this.goodStatement(connection2, "insert into test_dbo.t1_check_function_6432 values ( -102 )");
        this.goodStatement(connection2, "update test_dbo.t1_check_function_6432 set a = -103");
        this.goodStatement(connection2, "insert into test_dbo.t1_check_type_6432 values ( null )");
        this.goodStatement(connection2, "update test_dbo.t1_check_type_6432 set a = null");
        this.goodStatement(connection, "drop table t1_check_type_6432");
        this.goodStatement(connection, "drop table t1_check_function_6432");
        this.goodStatement(connection, "drop function makeHashmap_6432");
        this.goodStatement(connection, "drop type hashmap_6432 restrict");
        this.goodStatement(connection, "drop function absoluteValue_6432");
    }

    public void test_6433() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create function absoluteValue_6433( inputValue int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(connection, "create type hashmap_6433 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create function makeHashMap_6423() returns hashmap_6433\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(connection, "create table t1_generated_function_6433\n(\n    a int,\n    b int generated always as ( absoluteValue_6433( a ) )\n)\n");
        this.goodStatement(connection, "create table t1_generated_type_6433\n(\n    a hashmap_6433,\n    b boolean generated always as ( a is null )\n)\n");
        this.goodStatement(connection, "insert into t1_generated_function_6433( a ) values -101");
        this.goodStatement(connection, "insert into t1_generated_type_6433( a ) values ( makeHashMap_6423() )");
        this.goodStatement(connection, "grant insert on t1_generated_function_6433 to ruth");
        this.goodStatement(connection, "grant update on t1_generated_function_6433 to ruth");
        this.goodStatement(connection, "grant insert on t1_generated_type_6433 to ruth");
        this.goodStatement(connection, "grant update on t1_generated_type_6433 to ruth");
        this.goodStatement(connection2, "insert into test_dbo.t1_generated_function_6433( a ) values ( -102 )");
        this.goodStatement(connection2, "update test_dbo.t1_generated_function_6433 set a = -103");
        this.goodStatement(connection2, "insert into test_dbo.t1_generated_type_6433( a ) values ( null )");
        this.goodStatement(connection2, "update test_dbo.t1_generated_type_6433 set a = null");
        this.goodStatement(connection, "drop table t1_generated_type_6433");
        this.goodStatement(connection, "drop table t1_generated_function_6433");
        this.goodStatement(connection, "drop function makeHashMap_6423");
        this.goodStatement(connection, "drop type hashmap_6433 restrict");
        this.goodStatement(connection, "drop function absoluteValue_6433");
    }

    public void test_6491() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create type SourceUnreferencedType_6491 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create type SourceValueType_6491 external name 'java.util.HashMap' language java");
        this.goodStatement(connection, "create table sourceTable_6491\n(\n    sourceUnreferencedColumn SourceUnreferencedType_6491,\n    sourceValueColumn SourceValueType_6491\n)\n");
        this.goodStatement(connection, "grant select( sourceValueColumn ) on sourceTable_6491 to ruth");
        this.goodStatement(connection2, "select sourceValueColumn from test_dbo.sourceTable_6491");
        this.goodStatement(connection, "drop table sourceTable_6491");
        this.goodStatement(connection, "drop type SourceUnreferencedType_6491 restrict");
        this.goodStatement(connection, "drop type SourceValueType_6491 restrict");
    }
}

