/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class JMXTest
extends MBeanTest {
    public JMXTest(String string) {
        super(string);
    }

    public static Test suite() {
        return MBeanTest.suite(JMXTest.class, "JMXTest");
    }

    public void testDerbyRegisteredMBeansSimpleInfo() throws Exception {
        Set<ObjectName> set = this.getDerbyDomainMBeans();
        JMXTest.assertTrue((String)("Derby MBEan count:" + set.size()), (set.size() >= 2 ? 1 : 0) != 0);
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        for (ObjectName objectName : set) {
            String string = objectName.getKeyProperty("type");
            JMXTest.assertNotNull((Object)string);
            MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
            String string2 = mBeanInfo.getClassName();
            JMXTest.assertTrue((boolean)string2.startsWith("org.apache.derby.mbeans."));
            if ("Management".equals(string) && "org.apache.derby.mbeans.Management".equals(string2)) continue;
            JMXTest.assertTrue((boolean)string2.endsWith("MBean"));
            String string3 = string2.substring(string2.lastIndexOf(46) + 1);
            string3 = string3.substring(0, string3.length() - "MBean".length());
            JMXTest.assertEquals((String)string3, (String)string);
        }
    }
}

