/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.typemapping.JavaType;

final class FieldHelper {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";

    private FieldHelper() {
    }

    public static String getGetterName(String fieldName, String fieldType, ControllerState controllerState) {
        String getterName = controllerState.getBooleanOption((OptionName)TemplateOptionName.OM_USE_IS_FOR_BOOLEAN_GETTERS) && JavaType.BOOLEAN_PRIMITIVE.getClassName().equals(fieldType) ? IS + StringUtils.capitalize((String)fieldName) : GET + StringUtils.capitalize((String)fieldName);
        return getterName;
    }

    public static String getSetterName(String fieldName) {
        String setterName = SET + StringUtils.capitalize((String)fieldName);
        return setterName;
    }

    public static String getFieldNameFromSetterName(String setterName) {
        String fieldName = StringUtils.uncapitalize((String)setterName.substring(SET.length()));
        return fieldName;
    }

    public static String getAdderName(String fieldName, ControllerState controllerState) {
        String adderName = controllerState.getOption((OptionName)TemplateOptionName.OM_ADDER_PREFIX) + StringUtils.capitalize((String)fieldName) + controllerState.getOption((OptionName)TemplateOptionName.OM_ADDER_SUFFIX);
        return adderName;
    }

    public static String getInitializerName(String fieldName, ControllerState controllerState) {
        String initializerName = controllerState.getOption((OptionName)TemplateOptionName.OM_INITIALIZER_PREFIX) + StringUtils.capitalize((String)fieldName) + controllerState.getOption((OptionName)TemplateOptionName.OM_INITIALIZER_SUFFIX);
        return initializerName;
    }

    public static String getIsInitializedName(String fieldName, ControllerState controllerState) {
        String initializerName = controllerState.getOption((OptionName)TemplateOptionName.OM_IS_INITIALIZED_PREFIX) + StringUtils.capitalize((String)fieldName) + controllerState.getOption((OptionName)TemplateOptionName.OM_IS_INITIALIZED_SUFFIX);
        return initializerName;
    }

    public static String getFillerName(String fieldName, String distinctionPart, ControllerState controllerState) {
        String fillerName = controllerState.getOption((OptionName)TemplateOptionName.OM_FILLER_PREFIX) + distinctionPart + StringUtils.capitalize((String)fieldName) + controllerState.getOption((OptionName)TemplateOptionName.OM_FILLER_SUFFIX);
        return fillerName;
    }

    public static String getSetAndSaveMethodName(String fieldName, String distinctionPart, ControllerState controllerState) {
        String fillerName = controllerState.getOption((OptionName)TemplateOptionName.OM_SET_AND_SAVE_PREFIX) + distinctionPart + StringUtils.capitalize((String)fieldName) + controllerState.getOption((OptionName)TemplateOptionName.OM_SET_AND_SAVE_SUFFIX);
        return fillerName;
    }
}

