/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.ant.task;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.option.MapOptionsConfiguration;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.paths.CustomProjectPaths;
import org.apache.torque.generator.configuration.paths.DefaultTorqueGeneratorPaths;
import org.apache.torque.generator.configuration.paths.Maven2DirectoryProjectPaths;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;
import org.apache.torque.generator.control.Controller;

public class Torque4JDBCTransformTask
extends Task {
    private String packaging = "classpath";
    private File defaultOutputDir = new File("target/generated-schema");
    private File projectRootDir = new File(".");
    protected String xmlSchema = "schema.xml";
    private String loglevel;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    private String configPackage;
    private File configDir;

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void execute() throws BuildException {
        this.log("Torque - JDBCToXMLSchema starting");
        this.log("Your DB settings are:");
        this.log("driver : " + this.dbDriver);
        this.log("URL : " + this.dbUrl);
        try {
            this.generateXML();
            this.log("Target file:" + this.defaultOutputDir + "/" + this.xmlSchema);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Torque - JDBCToXMLSchema finished");
    }

    public void generateXML() throws Exception {
        Maven2DirectoryProjectPaths defaultProjectPaths;
        UnitDescriptor.Packaging packaging;
        Controller controller = new Controller();
        ArrayList<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
        HashMap<String, String> overrideOptions = new HashMap<String, String>();
        overrideOptions.put("torque.jdbc2schema.url", this.dbUrl);
        overrideOptions.put("torque.jdbc2schema.driver", this.dbDriver);
        overrideOptions.put("torque.jdbc2schema.user", this.dbUser);
        overrideOptions.put("torque.jdbc2schema.password", this.dbPassword);
        if ("directory".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.DIRECTORY;
        } else if ("classpath".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.CLASSPATH;
        } else {
            throw new IllegalArgumentException("Unknown packaging " + this.packaging + ", must be jar, directory or classpath");
        }
        this.log("Packaging is " + packaging, 4);
        if (UnitDescriptor.Packaging.DIRECTORY == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else {
            throw new IllegalStateException("Unknown packaging" + packaging);
        }
        CustomProjectPaths projectPaths = new CustomProjectPaths((ProjectPaths)defaultProjectPaths);
        if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            if (this.configPackage == null) {
                throw new BuildException("configPackage must be set for packaging =\"classpath\"");
            }
            projectPaths.setConfigurationPackage(this.configPackage);
            projectPaths.setConfigurationDir(null);
        } else if (this.configDir != null) {
            projectPaths.setConfigurationDir(this.configDir);
            this.log("Setting config dir to " + this.configDir.toString(), 4);
        }
        if (this.defaultOutputDir != null) {
            projectPaths.setOutputDirectory(null, this.defaultOutputDir);
            this.log("Setting defaultOutputDir to " + this.defaultOutputDir.getAbsolutePath(), 4);
        }
        this.log("ProjectPaths = " + projectPaths);
        Loglevel convertedLoglevel = null;
        if (this.loglevel != null) {
            convertedLoglevel = Loglevel.getByKey((String)this.loglevel);
        }
        UnitDescriptor unitDescriptor = new UnitDescriptor(packaging, (ProjectPaths)projectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions((OptionsConfiguration)new MapOptionsConfiguration(overrideOptions));
        unitDescriptor.setLoglevel(convertedLoglevel);
        unitDescriptors.add(unitDescriptor);
        try {
            this.log("Generation started", 4);
            controller.run(unitDescriptors);
            this.log("Generation successful", 2);
        }
        catch (GeneratorException e) {
            this.log("Error during jdbc3schema generation", e, 0);
            throw new BuildException(e.getMessage());
        }
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setDefaultOutputDir(File defaultOutputDir) {
        this.defaultOutputDir = defaultOutputDir;
    }

    public void setProjectRootDir(File projectRootDir) {
        this.projectRootDir = projectRootDir;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }
}

