/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.om.mapper.BigDecimalMapper;
import org.apache.torque.om.mapper.IntegerMapper;
import org.apache.torque.om.mapper.LongMapper;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.StringMapper;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.BasePeerImpl;

public abstract class AbstractIdGenerator
implements IdGenerator {
    protected Adapter adapter;
    protected String databaseName = null;

    public AbstractIdGenerator(Adapter adapter, String databaseName) {
        this.adapter = adapter;
        this.databaseName = databaseName;
    }

    @Override
    public int getIdAsInt(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new IntegerMapper());
    }

    @Override
    public long getIdAsLong(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new LongMapper());
    }

    @Override
    public BigDecimal getIdAsBigDecimal(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new BigDecimalMapper());
    }

    @Override
    public String getIdAsString(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new StringMapper());
    }

    @Override
    public abstract boolean isPriorToInsert();

    @Override
    public abstract boolean isPostInsert();

    @Override
    public abstract boolean isConnectionRequired();

    @Override
    public abstract boolean isGetGeneratedKeysSupported();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getId(Connection connection, Object keyInfo, RecordMapper<T> mapper) throws TorqueException {
        if (this.isGetGeneratedKeysSupported() && keyInfo instanceof Statement) {
            try (ResultSet generatedKeys = ((Statement)keyInfo).getGeneratedKeys();){
                if (!generatedKeys.next()) throw new SQLException("Could not obtain ID from statement, result set is empty");
                T t = mapper.processRow(generatedKeys, 0, null);
                return t;
            }
            catch (SQLException e) {
                throw new TorqueException("Error getting ID", e);
            }
        }
        String idSql = this.getIdSql(keyInfo);
        BasePeerImpl<T> peer = new BasePeerImpl<T>(mapper, null, this.databaseName);
        List<T> result = peer.doSelect(idSql, connection);
        return result.get(0);
    }

    public String getIdSql(Object keyInfo) throws TorqueException {
        String tableName = SqlBuilder.getFullTableName(String.valueOf(keyInfo), this.databaseName);
        String idSql = this.adapter.getIDMethodSQL(tableName);
        return idSql;
    }
}

