/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.outlet.copy.CopyOutlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CopyOutletSaxHandler
extends OutletSaxHandler {
    public CopyOutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException {
        super(outletName, configurationProvider, unitDescriptor, configurationHandlers);
    }

    @Override
    protected CopyOutlet createOutlet(QualifiedName outletName, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (outletName == null) {
            String nameAttribute = attributes.getValue("name");
            if (nameAttribute == null) {
                throw new SAXException("The attribute name must be set on the element " + rawName + " for Velocity Outlets");
            }
            outletName = new QualifiedName(nameAttribute);
        }
        String path = attributes.getValue("path");
        try {
            return new CopyOutlet(outletName, this.getConfigurationProvider(), path);
        }
        catch (ConfigurationException e) {
            throw new SAXException(e);
        }
    }
}

