/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class Table {
    private Collection<String> columns = new ArrayList<String>();
    private Collection<Collection<String>> values = new ArrayList<Collection<String>>();

    public Table withColumns(Collection<String> names) {
        this.columns.addAll(names);
        return this;
    }

    public Table withColumns(String ... names) {
        this.columns.addAll(Arrays.asList(names));
        return this;
    }

    public Table withLines(Collection<Collection<String>> lines) {
        for (Collection<String> line : lines) {
            this.withLine(line);
        }
        return this;
    }

    public Table withLine(Collection<String> line) {
        if (line.size() != this.columns.size()) {
            throw new IllegalArgumentException("Please set columns before lines");
        }
        this.values.add(line);
        return this;
    }

    public Table withLine(String ... line) {
        if (line.length != this.columns.size()) {
            throw new IllegalArgumentException("Please set columns before lines");
        }
        this.values.add(Arrays.asList(line));
        return this;
    }

    public Collection<String> getColumnNames() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public Collection<Collection<String>> getLines() {
        return Collections.unmodifiableCollection(this.values);
    }
}

