/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.resourceloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.apache.deltaspike.core.api.resourceloader.AbstractResourceProvider;
import org.apache.deltaspike.core.api.resourceloader.InjectableResource;

@ApplicationScoped
public class FileResourceProvider
extends AbstractResourceProvider {
    private static final Logger logger = Logger.getLogger(FileResourceProvider.class.getName());

    InputStream readFile(String name) {
        File f = new File(name);
        if (f.exists() && f.canRead() && f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Problem reading resource.", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream readStream(InjectableResource injectableResource) {
        return this.readFile(injectableResource.location());
    }
}

