/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.jsf;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.testcontrol.spi.ExternalContainer;
import org.apache.myfaces.test.mock.MockApplicationFactory;
import org.apache.myfaces.test.mock.MockExceptionHandlerFactory;
import org.apache.myfaces.test.mock.MockExternalContext;
import org.apache.myfaces.test.mock.MockFacesContext;
import org.apache.myfaces.test.mock.MockFacesContextFactory;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockPartialViewContextFactory;
import org.apache.myfaces.test.mock.MockRenderKit;
import org.apache.myfaces.test.mock.MockRenderKitFactory;
import org.apache.myfaces.test.mock.MockServletConfig;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory;
import org.apache.myfaces.test.mock.visit.MockVisitContextFactory;

@ApplicationScoped
public class MockedJsf2TestContainer
implements ExternalContainer {
    protected MockServletConfig servletConfig;
    protected MockServletContext servletContext;
    protected Lifecycle lifecycle;
    protected RenderKit renderKit;
    protected Application application;
    protected FacesContext facesContext;
    protected MockHttpServletRequest request;
    protected MockHttpServletResponse response;
    protected MockHttpSession session;
    protected Map<String, String> containerConfig;

    public void boot() {
        this.initContainerConfig();
        this.initServletObjects();
        this.initJsf();
    }

    protected void initContainerConfig() {
        this.containerConfig = new HashMap<String, String>();
        for (Map.Entry entry : ConfigResolver.getAllProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("org.apache.myfaces.") && !((String)entry.getKey()).startsWith("javax.faces.") && !((String)entry.getKey()).startsWith("facelets.")) continue;
            this.containerConfig.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void initServletObjects() {
        this.servletContext = new MockServletContext();
        this.servletConfig = new MockServletConfig((ServletContext)this.servletContext);
        this.applyContainerConfig();
    }

    protected void applyContainerConfig() {
        this.servletContext.addInitParameter("javax.faces.PROJECT_STAGE", "UnitTest");
        this.servletContext.addInitParameter("javax.faces.PARTIAL_STATE_SAVING", "true");
        this.servletContext.addInitParameter("javax.faces.FACELETS_REFRESH_PERIOD", "-1");
        this.servletContext.addInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE", "true");
        this.servletContext.addInitParameter("org.apache.myfaces.spi.InjectionProvider", "org.apache.myfaces.spi.impl.NoInjectionAnnotationInjectionProvider");
        this.servletContext.addInitParameter("org.apache.myfaces.config.annotation.LifecycleProvider", "org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider");
        this.servletConfig.addInitParameter("org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED", "false");
        this.servletContext.addInitParameter(ExpressionFactory.class.getName(), "org.apache.el.ExpressionFactoryImpl");
        for (Map.Entry<String, String> entry : this.containerConfig.entrySet()) {
            this.servletContext.addInitParameter(entry.getKey(), entry.getValue());
        }
    }

    protected void initJsf() {
        FactoryFinder.releaseFactories();
        this.onPreInitJsf();
        this.initLifecycle();
        this.initApplication();
        this.initRenderKit();
    }

    protected void onPreInitJsf() {
        this.addFactory("javax.faces.application.ApplicationFactory", MockApplicationFactory.class.getName());
        this.addFactory("javax.faces.context.FacesContextFactory", MockFacesContextFactory.class.getName());
        this.addFactory("javax.faces.lifecycle.LifecycleFactory", MockLifecycleFactory.class.getName());
        this.addFactory("javax.faces.render.RenderKitFactory", MockRenderKitFactory.class.getName());
        this.addFactory("javax.faces.context.ExceptionHandlerFactory", MockExceptionHandlerFactory.class.getName());
        this.addFactory("javax.faces.context.PartialViewContextFactory", MockPartialViewContextFactory.class.getName());
        this.addFactory("javax.faces.component.visit.VisitContextFactory", MockVisitContextFactory.class.getName());
    }

    protected void addFactory(String factoryName, String className) {
        FactoryFinder.setFactory((String)factoryName, (String)className);
    }

    protected void initLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
    }

    protected void initApplication() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
    }

    protected void initRenderKit() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.renderKit = new MockRenderKit();
        renderKitFactory.addRenderKit("HTML_BASIC", this.renderKit);
    }

    public void startScope(Class<? extends Annotation> scopeClass) {
        if (RequestScoped.class.equals(scopeClass)) {
            this.initRequest();
            this.initResponse();
            this.initFacesContext();
            this.initDefaultView();
        } else if (SessionScoped.class.equals(scopeClass)) {
            this.initSession();
        }
    }

    protected void initRequest() {
        this.request = new MockHttpServletRequest((HttpSession)this.session);
        this.request.setServletContext((ServletContext)this.servletContext);
    }

    protected void initResponse() {
        this.response = new MockHttpServletResponse();
    }

    protected void initFacesContext() {
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        this.facesContext = facesContextFactory.getFacesContext((Object)this.servletContext, (Object)this.request, (Object)this.response, this.lifecycle);
        ((MockFacesContext)this.facesContext).setApplication(this.application);
        ExceptionHandler exceptionHandler = ((ExceptionHandlerFactory)FactoryFinder.getFactory((String)"javax.faces.context.ExceptionHandlerFactory")).getExceptionHandler();
        this.facesContext.setExceptionHandler(exceptionHandler);
        ((MockFacesContext)this.facesContext).setExternalContext((ExternalContext)new MockExternalContext((ServletContext)this.servletContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response));
    }

    protected void initDefaultView() {
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/viewId");
        root.setLocale(this.getLocale());
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot(root);
    }

    protected void initSession() {
        if (this.request != null) {
            this.session = (MockHttpSession)this.request.getSession(true);
        } else {
            this.session = new MockHttpSession();
            this.session.setServletContext((ServletContext)this.servletContext);
        }
    }

    public void stopScope(Class<? extends Annotation> scopeClass) {
        if (RequestScoped.class.equals(scopeClass)) {
            if (this.facesContext != null) {
                this.facesContext.release();
            }
            this.facesContext = null;
            this.request = null;
            this.response = null;
        } else if (SessionScoped.class.equals(scopeClass)) {
            this.session = null;
        }
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    public void shutdown() {
        this.application = null;
        this.servletConfig = null;
        this.containerConfig = null;
        this.lifecycle = null;
        this.renderKit = null;
        this.servletContext = null;
        FactoryFinder.releaseFactories();
    }

    public int getOrdinal() {
        return 1000;
    }

    protected String getLifecycleId() {
        return "DEFAULT";
    }
}

