/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.core.api.config.view.metadata.CallbackDescriptor;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;

public abstract class AbstractConfigNode
implements ViewConfigNode {
    private final ViewConfigNode parent;
    private List<ViewConfigNode> children = new ArrayList<ViewConfigNode>();
    private Set<Annotation> metaData;
    private List<Annotation> inheritedMetaData = new ArrayList<Annotation>();
    private Map<Class<? extends Annotation>, List<CallbackDescriptor>> callbackDescriptors = new HashMap<Class<? extends Annotation>, List<CallbackDescriptor>>();

    protected AbstractConfigNode(ViewConfigNode parent, Set<Annotation> metaData) {
        this.parent = parent;
        this.metaData = new HashSet<Annotation>(metaData);
    }

    public ViewConfigNode getParent() {
        return this.parent;
    }

    public List<ViewConfigNode> getChildren() {
        return this.children;
    }

    public Set<Annotation> getMetaData() {
        return this.metaData;
    }

    public List<Annotation> getInheritedMetaData() {
        return this.inheritedMetaData;
    }

    public Map<Class<? extends Annotation>, List<CallbackDescriptor>> getCallbackDescriptors() {
        return this.callbackDescriptors;
    }

    public List<CallbackDescriptor> getCallbackDescriptors(Class<? extends Annotation> metaDataType) {
        List<CallbackDescriptor> result = this.callbackDescriptors.get(metaDataType);
        if (result == null) {
            result = new ArrayList<CallbackDescriptor>();
            this.callbackDescriptors.put(metaDataType, result);
        }
        return result;
    }

    public void registerCallbackDescriptors(Class<? extends Annotation> metaDataType, CallbackDescriptor callbackDescriptor) {
        if (!callbackDescriptor.getCallbackMethods().isEmpty()) {
            this.getCallbackDescriptors(metaDataType).add(callbackDescriptor);
        }
    }
}

