/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.spi.config.view.ConfigDescriptorValidator;
import org.apache.deltaspike.core.spi.config.view.ConfigNodeConverter;
import org.apache.deltaspike.core.spi.config.view.ViewConfigInheritanceStrategy;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.api.literal.FolderLiteral;
import org.apache.deltaspike.jsf.api.literal.ViewLiteral;
import org.apache.deltaspike.jsf.impl.util.ViewConfigUtils;

@Typed
public class DefaultViewConfigResolver
implements ViewConfigResolver {
    private Map<Class<? extends ViewConfig>, ViewConfigDescriptor> viewDefinitionToViewDefinitionEntryMapping;
    private Map<String, ViewConfigDescriptor> viewPathToViewDefinitionEntryMapping;
    private Map<Class, ConfigDescriptor> folderDefinitionToViewDefinitionEntryMapping;
    private Map<String, ConfigDescriptor> folderPathToViewDefinitionEntryMapping;
    private ViewConfigDescriptor defaultErrorView;

    public DefaultViewConfigResolver(ViewConfigNode rootViewConfigNode, ConfigNodeConverter configNodeConverter, ViewConfigInheritanceStrategy inheritanceStrategy, List<ConfigDescriptorValidator> configDescriptorValidators) {
        HashMap<Class, ViewConfigDescriptor> viewConfigs = new HashMap<Class, ViewConfigDescriptor>();
        HashMap<Class, ConfigDescriptor> folderConfigs = new HashMap<Class, ConfigDescriptor>();
        HashMap<String, Class> foundViewIds = new HashMap<String, Class>();
        Stack nodesToConvert = new Stack();
        nodesToConvert.addAll(rootViewConfigNode.getChildren());
        while (!nodesToConvert.empty()) {
            ViewConfigNode currentNode = (ViewConfigNode)nodesToConvert.pop();
            this.addOptionalMetaDataToConfig(currentNode);
            currentNode.getInheritedMetaData().addAll(inheritanceStrategy.resolveInheritedMetaData(currentNode));
            ConfigDescriptor currentConfigDescriptor = configNodeConverter.convert(currentNode);
            for (ConfigDescriptorValidator validator : configDescriptorValidators) {
                if (validator.isValid(currentConfigDescriptor)) continue;
                throw new IllegalStateException(currentConfigDescriptor.getConfigClass().getName() + " is invalid");
            }
            if (currentConfigDescriptor instanceof ViewConfigDescriptor) {
                ViewConfigDescriptor currentViewConfigDescriptor = (ViewConfigDescriptor)currentConfigDescriptor;
                if (foundViewIds.containsKey(currentViewConfigDescriptor.getViewId())) {
                    throw new IllegalStateException(currentViewConfigDescriptor.getViewId() + " is configured twice. That isn't allowed - see: " + currentConfigDescriptor.getConfigClass().getName() + " and " + ((Class)foundViewIds.get(currentViewConfigDescriptor.getViewId())).getName());
                }
                foundViewIds.put(currentViewConfigDescriptor.getViewId(), currentViewConfigDescriptor.getConfigClass());
                if (this.defaultErrorView == null) {
                    if (DefaultErrorView.class.isAssignableFrom(currentViewConfigDescriptor.getConfigClass())) {
                        this.defaultErrorView = currentViewConfigDescriptor;
                    }
                } else if (DefaultErrorView.class.isAssignableFrom(currentViewConfigDescriptor.getConfigClass())) {
                    throw new IllegalStateException("It isn't allowed to configure multiple default-error-views. Found default-error-views: " + this.defaultErrorView.getConfigClass() + " and " + currentViewConfigDescriptor.getConfigClass().getName());
                }
                if (!viewConfigs.containsKey(currentViewConfigDescriptor.getConfigClass())) {
                    viewConfigs.put(currentViewConfigDescriptor.getConfigClass(), currentViewConfigDescriptor);
                }
            } else if (!folderConfigs.containsKey(currentConfigDescriptor.getConfigClass())) {
                folderConfigs.put(currentConfigDescriptor.getConfigClass(), currentConfigDescriptor);
            }
            nodesToConvert.addAll(currentNode.getChildren());
        }
        this.viewDefinitionToViewDefinitionEntryMapping = Collections.unmodifiableMap(viewConfigs);
        this.folderDefinitionToViewDefinitionEntryMapping = Collections.unmodifiableMap(folderConfigs);
        this.initCaches();
    }

    protected void addOptionalMetaDataToConfig(ViewConfigNode currentNode) {
        Class sourceClass = currentNode.getSource();
        if (ViewConfigUtils.isFolderConfig(sourceClass)) {
            for (Annotation annotation : currentNode.getMetaData()) {
                if (!annotation.annotationType().equals(Folder.class)) continue;
                return;
            }
            currentNode.getMetaData().add(new FolderLiteral(true));
            return;
        }
        for (Annotation annotation : currentNode.getMetaData()) {
            if (!annotation.annotationType().equals(View.class)) continue;
            return;
        }
        currentNode.getMetaData().add(new ViewLiteral(true));
    }

    public ConfigDescriptor<?> getConfigDescriptor(String path) {
        if (path == null) {
            return null;
        }
        ConfigDescriptor result = this.folderPathToViewDefinitionEntryMapping.get(path);
        if (result == null) {
            result = this.getViewConfigDescriptor(path);
        }
        return result;
    }

    public ViewConfigDescriptor getViewConfigDescriptor(String viewId) {
        if (viewId == null) {
            return null;
        }
        return this.viewPathToViewDefinitionEntryMapping.get(viewId);
    }

    public ConfigDescriptor<?> getConfigDescriptor(Class configClass) {
        ViewConfigDescriptor result = null;
        if (ViewConfig.class.isAssignableFrom(configClass)) {
            result = this.getViewConfigDescriptor(configClass);
        }
        if (result == null) {
            result = this.folderDefinitionToViewDefinitionEntryMapping.get(configClass);
        }
        return result;
    }

    public List<ConfigDescriptor<?>> getConfigDescriptors() {
        ConfigDescriptor[] folderResult = this.folderDefinitionToViewDefinitionEntryMapping.values().toArray(new ConfigDescriptor[this.folderDefinitionToViewDefinitionEntryMapping.size()]);
        ConfigDescriptor[] viewResult = this.viewDefinitionToViewDefinitionEntryMapping.values().toArray(new ConfigDescriptor[this.viewDefinitionToViewDefinitionEntryMapping.size()]);
        ArrayList result = new ArrayList();
        result.addAll(Arrays.asList(folderResult));
        result.addAll(Arrays.asList(viewResult));
        return result;
    }

    public ViewConfigDescriptor getViewConfigDescriptor(Class<? extends ViewConfig> viewDefinitionClass) {
        if (DefaultErrorView.class.equals(viewDefinitionClass)) {
            return this.getDefaultErrorViewConfigDescriptor();
        }
        return this.viewDefinitionToViewDefinitionEntryMapping.get(viewDefinitionClass);
    }

    public List<ViewConfigDescriptor> getViewConfigDescriptors() {
        ViewConfigDescriptor[] result = this.viewDefinitionToViewDefinitionEntryMapping.values().toArray(new ViewConfigDescriptor[this.viewDefinitionToViewDefinitionEntryMapping.size()]);
        return new ArrayList<ViewConfigDescriptor>(Arrays.asList(result));
    }

    public ViewConfigDescriptor getDefaultErrorViewConfigDescriptor() {
        return this.defaultErrorView;
    }

    protected void initCaches() {
        HashMap<String, ConfigDescriptor> folderPathMapping = new HashMap<String, ConfigDescriptor>();
        for (ConfigDescriptor folderConfigDescriptor : this.folderDefinitionToViewDefinitionEntryMapping.values()) {
            if (folderPathMapping.containsKey(folderConfigDescriptor.toString())) {
                throw new IllegalStateException("Duplicated config for the same folder configured. See: " + ((ConfigDescriptor)folderPathMapping.get(folderConfigDescriptor.toString())).getConfigClass().getName() + " and " + folderConfigDescriptor.getConfigClass().getName());
            }
            folderPathMapping.put(folderConfigDescriptor.getPath(), folderConfigDescriptor);
        }
        this.folderPathToViewDefinitionEntryMapping = Collections.unmodifiableMap(folderPathMapping);
        HashMap<String, ViewConfigDescriptor> viewPathMapping = new HashMap<String, ViewConfigDescriptor>();
        for (ViewConfigDescriptor pageConfigDescriptor : this.viewDefinitionToViewDefinitionEntryMapping.values()) {
            if (viewPathMapping.containsKey(pageConfigDescriptor.getViewId())) {
                throw new IllegalStateException("Duplicated config for the same page configured. See: " + ((ViewConfigDescriptor)viewPathMapping.get(pageConfigDescriptor.getViewId())).getConfigClass().getName() + " and " + pageConfigDescriptor.getConfigClass().getName());
            }
            viewPathMapping.put(pageConfigDescriptor.getPath(), pageConfigDescriptor);
        }
        this.viewPathToViewDefinitionEntryMapping = Collections.unmodifiableMap(viewPathMapping);
    }
}

