/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.weld;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.jboss.weld.Container;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.util.reflection.Formats;

public class WeldContainerControl
implements CdiContainer {
    private static final Logger LOG = Logger.getLogger(WeldContainerControl.class.getName());
    private Weld weld;
    private WeldContainer weldContainer;
    private Bean<ContextControl> ctxCtrlBean = null;
    private CreationalContext<ContextControl> ctxCtrlCreationalContext = null;
    private ContextControl ctxCtrl = null;

    public BeanManager getBeanManager() {
        if (this.weldContainer == null) {
            return null;
        }
        return this.weldContainer.getBeanManager();
    }

    public synchronized void boot() {
        this.weld = new Weld();
        this.weldContainer = this.weld.initialize();
    }

    public void boot(Map<?, ?> properties) {
        this.weld = new Weld();
        this.setProperties(this.weld, WeldContainerControl.convertProperties(properties));
        this.weldContainer = this.weld.initialize();
    }

    private void setProperties(Weld weld, Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Method setPropertiesMethod = WeldContainerControl.extractMethod(Weld.class, "setProperties", Map.class);
        if (setPropertiesMethod != null) {
            if (!setPropertiesMethod.isAccessible()) {
                setPropertiesMethod.setAccessible(true);
            }
            try {
                setPropertiesMethod.invoke((Object)weld, properties);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            LOG.warning("No setProperties method available on this version of Weld - ignoring passed in properties!");
        }
    }

    private static Method extractMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz != null ? clazz.getMethod(methodName, parameterTypes) : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public synchronized void shutdown() {
        if (this.ctxCtrl != null) {
            try {
                this.ctxCtrl.stopContext(ConversationScoped.class);
                this.ctxCtrl.stopContext(RequestScoped.class);
                this.ctxCtrl.stopContext(SessionScoped.class);
                this.ctxCtrlBean.destroy((Object)this.ctxCtrl, this.ctxCtrlCreationalContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.weld.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.weld = null;
        this.ctxCtrl = null;
        this.ctxCtrlBean = null;
        this.ctxCtrlCreationalContext = null;
    }

    public synchronized ContextControl getContextControl() {
        if (this.ctxCtrl == null) {
            BeanManager beanManager = this.getBeanManager();
            if (beanManager == null) {
                LOG.warning("If the CDI-container was started by the environment, you can't use this helper.Instead you can resolve ContextControl manually (e.g. via BeanProvider.getContextualReference(ContextControl.class) ). If the container wasn't started already, you have to use CdiContainer#boot before.");
                return null;
            }
            Set beans = beanManager.getBeans(ContextControl.class, new Annotation[0]);
            this.ctxCtrlBean = beanManager.resolve(beans);
            this.ctxCtrlCreationalContext = this.getBeanManager().createCreationalContext(this.ctxCtrlBean);
            this.ctxCtrl = (ContextControl)this.getBeanManager().getReference(this.ctxCtrlBean, ContextControl.class, this.ctxCtrlCreationalContext);
        }
        return this.ctxCtrl;
    }

    public String toString() {
        return "WeldContainerControl [Weld " + Formats.version((Package)Container.class.getPackage()) + "]";
    }

    private static Map<String, Object> convertProperties(Map<?, ?> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
    }
}

