/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view.navigation;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.ViewRef;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.config.view.navigation.NavigationParameter;
import org.apache.deltaspike.core.api.config.view.navigation.NavigationParameterContext;
import org.apache.deltaspike.core.api.config.view.navigation.event.PreViewConfigNavigateEvent;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;

public class ViewConfigAwareNavigationHandler
extends NavigationHandler {
    private Set<String> otherOutcomes = new CopyOnWriteArraySet<String>();
    private Map<String, ViewConfigDescriptor> viewConfigs = new ConcurrentHashMap<String, ViewConfigDescriptor>();
    private final NavigationHandler navigationHandler;
    private volatile BeanManager beanManager;
    private NavigationParameterContext navigationParameterContext;
    private ViewConfigResolver viewConfigResolver;

    public ViewConfigAwareNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        this.lazyInit();
        if (outcome != null && outcome.contains(".")) {
            String originalOutcome = outcome;
            if (!this.otherOutcomes.contains(outcome)) {
                ViewConfigDescriptor entry;
                if (outcome.startsWith("class ")) {
                    outcome = outcome.substring(6);
                }
                if ((entry = this.viewConfigs.get(outcome)) == null && DefaultErrorView.class.getName().equals(originalOutcome)) {
                    entry = this.viewConfigResolver.getDefaultErrorViewConfigDescriptor();
                }
                boolean allowCaching = true;
                if (entry == null) {
                    Class loadedClass = ClassUtils.tryToLoadClassForName((String)outcome);
                    if (loadedClass == null) {
                        this.otherOutcomes.add(originalOutcome);
                    } else if (ViewConfig.class.isAssignableFrom(loadedClass)) {
                        if (loadedClass.getAnnotation(View.class) == null && loadedClass.getSuperclass().getAnnotation(View.class) != null) {
                            allowCaching = false;
                            this.addConfiguredViewParameters(loadedClass);
                            loadedClass = loadedClass.getSuperclass();
                        }
                        entry = this.viewConfigResolver.getViewConfigDescriptor(loadedClass);
                    }
                }
                if (entry != null) {
                    PreViewConfigNavigateEvent navigateEvent;
                    if (allowCaching) {
                        this.viewConfigs.put(outcome, entry);
                        this.addConfiguredViewParameters(entry.getConfigClass());
                    }
                    String oldViewId = null;
                    if (facesContext.getViewRoot() != null) {
                        oldViewId = facesContext.getViewRoot().getViewId();
                    }
                    if ((entry = this.tryToUpdateEntry(entry, navigateEvent = this.firePreViewConfigNavigateEvent(oldViewId, entry))) != null) {
                        outcome = this.convertEntryToOutcome(facesContext.getExternalContext(), entry);
                    }
                }
            }
        }
        this.navigationHandler.handleNavigation(facesContext, fromAction, outcome);
    }

    private void addConfiguredViewParameters(Class<?> viewConfigClass) {
        if (this.navigationParameterContext != null) {
            NavigationParameter navigationParameter = viewConfigClass.getAnnotation(NavigationParameter.class);
            if (navigationParameter != null) {
                this.addConfiguredPageParameter(navigationParameter);
            } else {
                NavigationParameter.List pageParameterList = viewConfigClass.getAnnotation(NavigationParameter.List.class);
                if (pageParameterList != null) {
                    for (NavigationParameter currentNavigationParameter : pageParameterList.value()) {
                        this.addConfiguredPageParameter(currentNavigationParameter);
                    }
                }
            }
        }
    }

    private void addConfiguredPageParameter(NavigationParameter viewParameter) {
        JsfUtils.addStaticNavigationParameter(this.navigationParameterContext, viewParameter.key(), viewParameter.value());
    }

    private String convertEntryToOutcome(ExternalContext externalContext, ViewConfigDescriptor entry) {
        View viewMetaData = (View)entry.getMetaData(View.class).iterator().next();
        boolean performRedirect = View.NavigationMode.REDIRECT.equals((Object)viewMetaData.navigation());
        boolean includeViewParameters = View.ViewParameterMode.INCLUDE.equals((Object)viewMetaData.viewParams());
        StringBuilder result = new StringBuilder(entry.getViewId());
        if (performRedirect) {
            result.append("?faces-redirect=true");
        }
        if (includeViewParameters) {
            if (performRedirect) {
                result.append("&");
            } else {
                result.append("?");
            }
            result.append("includeViewParams=true");
            return JsfUtils.addPageParameters(externalContext, result.toString(), false);
        }
        return result.toString();
    }

    private ViewConfigDescriptor tryToUpdateEntry(ViewConfigDescriptor viewConfigDescriptor, PreViewConfigNavigateEvent navigateEvent) {
        if (navigateEvent.getToView() == null) {
            return null;
        }
        if (navigateEvent.getToView().equals(viewConfigDescriptor.getConfigClass())) {
            return viewConfigDescriptor;
        }
        return this.viewConfigResolver.getViewConfigDescriptor(navigateEvent.getToView());
    }

    private PreViewConfigNavigateEvent firePreViewConfigNavigateEvent(String oldViewId, ViewConfigDescriptor newViewConfigDescriptor) {
        ViewConfigDescriptor oldViewConfigDescriptor = this.viewConfigResolver.getViewConfigDescriptor(oldViewId);
        PreViewConfigNavigateEvent navigateEvent = oldViewConfigDescriptor != null ? new PreViewConfigNavigateEvent(oldViewConfigDescriptor.getConfigClass(), newViewConfigDescriptor.getConfigClass()) : new PreViewConfigNavigateEvent(ViewRef.Manual.class, newViewConfigDescriptor.getConfigClass());
        this.beanManager.getEvent().fire((Object)navigateEvent);
        return navigateEvent;
    }

    private void lazyInit() {
        if (this.beanManager == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.beanManager == null) {
            this.navigationParameterContext = (NavigationParameterContext)BeanProvider.getContextualReference(NavigationParameterContext.class, (Annotation[])new Annotation[0]);
            this.viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0]);
            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
        }
    }
}

