/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.request;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.projectstage.TestStage;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.impl.config.view.DefaultErrorViewAwareExceptionHandlerWrapper;
import org.apache.deltaspike.jsf.impl.exception.control.BridgeExceptionHandlerWrapper;
import org.apache.deltaspike.jsf.impl.listener.request.DeltaSpikeApplicationWrapper;
import org.apache.deltaspike.jsf.impl.listener.request.DeltaSpikeExternalContextWrapper;
import org.apache.deltaspike.jsf.impl.listener.request.JsfRequestBroadcaster;
import org.apache.deltaspike.jsf.impl.message.FacesMessageEntry;
import org.apache.deltaspike.jsf.impl.navigation.NavigationHandlerAwareApplication;
import org.apache.deltaspike.jsf.impl.security.SecurityAwareViewHandler;

class DeltaSpikeFacesContextWrapper
extends FacesContextWrapper {
    private final FacesContext wrappedFacesContext;
    private BeanManager beanManager;
    private JsfRequestBroadcaster jsfRequestBroadcaster;
    private boolean defaultErrorViewExceptionHandlerActivated;
    private boolean bridgeExceptionHandlerActivated;
    private Annotation bridgeExceptionQualifier;
    private ExternalContext wrappedExternalContext;
    private JsfModuleConfig jsfModuleConfig;
    private volatile Boolean initialized;
    private volatile Boolean isNavigationAwareApplicationWrapperActivated;
    private boolean preDestroyViewMapEventFilterMode;
    private ProjectStage projectStage;

    DeltaSpikeFacesContextWrapper(FacesContext wrappedFacesContext) {
        this.wrappedFacesContext = wrappedFacesContext;
        this.wrappedExternalContext = ClassDeactivationUtils.isActivated(DeltaSpikeExternalContextWrapper.class) ? new DeltaSpikeExternalContextWrapper(wrappedFacesContext.getExternalContext()) : wrappedFacesContext.getExternalContext();
        DeltaSpikeFacesContextWrapper.setCurrentInstance((FacesContext)this);
    }

    public void release() {
        try {
            if (!this.wrappedFacesContext.getApplication().getResourceHandler().isResourceRequest(this.wrappedFacesContext)) {
                this.broadcastDestroyedJsfRequestEvent();
            }
        }
        finally {
            super.release();
        }
    }

    public ExceptionHandler getExceptionHandler() {
        this.lazyInit();
        Object exceptionHandler = this.wrappedFacesContext.getExceptionHandler();
        if (this.bridgeExceptionHandlerActivated) {
            exceptionHandler = new BridgeExceptionHandlerWrapper((ExceptionHandler)exceptionHandler);
        }
        if (this.defaultErrorViewExceptionHandlerActivated) {
            exceptionHandler = new DefaultErrorViewAwareExceptionHandlerWrapper((ExceptionHandler)exceptionHandler);
        }
        return exceptionHandler;
    }

    private void broadcastDestroyedJsfRequestEvent() {
        this.lazyInit();
        if (this.jsfRequestBroadcaster != null) {
            this.jsfRequestBroadcaster.broadcastDestroyedJsfRequestEvent((FacesContext)this);
        }
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            ViewConfigResolver viewConfigResolver;
            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
            this.jsfModuleConfig = (JsfModuleConfig)BeanProvider.getContextualReference((BeanManager)this.beanManager, JsfModuleConfig.class, (boolean)false, (Annotation[])new Annotation[0]);
            if (ClassDeactivationUtils.isActivated(JsfRequestBroadcaster.class)) {
                this.jsfRequestBroadcaster = (JsfRequestBroadcaster)BeanProvider.getContextualReference(JsfRequestBroadcaster.class, (boolean)true, (Annotation[])new Annotation[0]);
            }
            this.defaultErrorViewExceptionHandlerActivated = (viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0])).getDefaultErrorViewConfigDescriptor() != null && ClassDeactivationUtils.isActivated(DefaultErrorViewAwareExceptionHandlerWrapper.class);
            this.bridgeExceptionHandlerActivated = ClassDeactivationUtils.isActivated(BridgeExceptionHandlerWrapper.class);
            this.bridgeExceptionQualifier = AnnotationInstanceProvider.of((Class)this.jsfModuleConfig.getExceptionQualifier());
            this.preDestroyViewMapEventFilterMode = ClassDeactivationUtils.isActivated(SecurityAwareViewHandler.class);
            this.isNavigationAwareApplicationWrapperActivated = ClassDeactivationUtils.isActivated(NavigationHandlerAwareApplication.class);
            org.apache.deltaspike.core.api.projectstage.ProjectStage dsProjectStage = ProjectStageProducer.getInstance().getProjectStage();
            for (ProjectStage ps : ProjectStage.values()) {
                if (!ps.name().equals(dsProjectStage.getClass().getSimpleName())) continue;
                this.projectStage = ps;
                break;
            }
            if (this.projectStage == null && dsProjectStage instanceof TestStage) {
                this.projectStage = ProjectStage.Development;
            }
            if (this.projectStage == ProjectStage.Production) {
                this.projectStage = null;
            }
            this.initialized = true;
        }
    }

    public void addMessage(String componentId, FacesMessage facesMessage) {
        this.wrappedFacesContext.addMessage(componentId, facesMessage);
        Map requestMap = this.getExternalContext().getRequestMap();
        CopyOnWriteArrayList<FacesMessageEntry> facesMessageEntryList = (CopyOnWriteArrayList<FacesMessageEntry>)requestMap.get(FacesMessageEntry.class.getName());
        if (facesMessageEntryList == null) {
            facesMessageEntryList = new CopyOnWriteArrayList<FacesMessageEntry>();
            requestMap.put(FacesMessageEntry.class.getName(), facesMessageEntryList);
        }
        facesMessageEntryList.add(new FacesMessageEntry(componentId, facesMessage));
    }

    public ExternalContext getExternalContext() {
        return this.wrappedExternalContext;
    }

    public Application getApplication() {
        this.lazyInit();
        Object wrappedApplication = this.wrappedFacesContext.getApplication();
        if (this.isNavigationAwareApplicationWrapperActivated.booleanValue()) {
            wrappedApplication = new NavigationHandlerAwareApplication((Application)wrappedApplication);
        }
        return new DeltaSpikeApplicationWrapper((Application)wrappedApplication, this.jsfModuleConfig, this.preDestroyViewMapEventFilterMode, this.projectStage);
    }

    public FacesContext getWrapped() {
        return this.wrappedFacesContext;
    }
}

