/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.api.literal;

import jakarta.enterprise.util.AnnotationLiteral;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.api.config.view.View;

public class ViewLiteral
extends AnnotationLiteral<View>
implements View {
    private static final long serialVersionUID = 1582580975876369665L;
    private final String basePath;
    private final String name;
    private final String extension;
    private final View.NavigationMode navigation;
    private final View.ViewParameterMode viewParams;
    private final Class<? extends View.NameBuilder> basePathBuilder;
    private final Class<? extends View.NameBuilder> fileNameBuilder;
    private final Class<? extends View.NameBuilder> extensionBuilder;

    public ViewLiteral(boolean virtual) {
        if (virtual) {
            this.basePath = null;
            this.name = null;
            this.extension = null;
            this.navigation = null;
            this.viewParams = null;
        } else {
            this.basePath = "";
            this.name = "";
            this.extension = "";
            this.navigation = View.NavigationMode.FORWARD;
            this.viewParams = View.ViewParameterMode.DEFAULT;
        }
        String customDefaultBasePathBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_BASE_PATH_BUILDER;
        this.basePathBuilder = customDefaultBasePathBuilderClassName != null ? ClassUtils.tryToLoadClassForName((String)customDefaultBasePathBuilderClassName) : View.DefaultBasePathBuilder.class;
        String customDefaultFileNameBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_FILE_NAME_BUILDER;
        this.fileNameBuilder = customDefaultFileNameBuilderClassName != null ? ClassUtils.tryToLoadClassForName((String)customDefaultFileNameBuilderClassName) : View.DefaultFileNameBuilder.class;
        String customDefaultExtensionBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_EXTENSION_BUILDER;
        this.extensionBuilder = customDefaultExtensionBuilderClassName != null ? ClassUtils.tryToLoadClassForName((String)customDefaultExtensionBuilderClassName) : View.DefaultExtensionBuilder.class;
    }

    public ViewLiteral(String basePath, String name, String extension, View.NavigationMode navigation, View.ViewParameterMode viewParams, Class<? extends View.NameBuilder> basePathBuilder, Class<? extends View.NameBuilder> fileNameBuilder, Class<? extends View.NameBuilder> extensionBuilder) {
        this.basePath = basePath;
        this.name = name;
        this.extension = extension;
        this.navigation = navigation;
        this.viewParams = viewParams;
        this.basePathBuilder = basePathBuilder;
        this.fileNameBuilder = fileNameBuilder;
        this.extensionBuilder = extensionBuilder;
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String extension() {
        return this.extension;
    }

    @Override
    public View.NavigationMode navigation() {
        return this.navigation;
    }

    @Override
    public View.ViewParameterMode viewParams() {
        return this.viewParams;
    }

    @Override
    public Class<? extends View.NameBuilder> basePathBuilder() {
        return this.basePathBuilder;
    }

    @Override
    public Class<? extends View.NameBuilder> fileNameBuilder() {
        return this.fileNameBuilder;
    }

    @Override
    public Class<? extends View.NameBuilder> extensionBuilder() {
        return this.extensionBuilder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof ViewLiteral)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ViewLiteral that = (ViewLiteral)o;
        if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) {
            return false;
        }
        if (!this.basePathBuilder.equals(that.basePathBuilder)) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (!this.extensionBuilder.equals(that.extensionBuilder)) {
            return false;
        }
        if (!this.fileNameBuilder.equals(that.fileNameBuilder)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.navigation != that.navigation) {
            return false;
        }
        return this.viewParams == that.viewParams;
    }

    @Override
    public int hashCode() {
        int result = this.basePath != null ? this.basePath.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.navigation != null ? this.navigation.hashCode() : 0);
        result = 31 * result + (this.viewParams != null ? this.viewParams.hashCode() : 0);
        result = 31 * result + this.basePathBuilder.hashCode();
        result = 31 * result + this.fileNameBuilder.hashCode();
        result = 31 * result + this.extensionBuilder.hashCode();
        return result;
    }
}

