/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.result;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Iterator;
import java.util.List;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.impl.builder.OrderDirection;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.postprocessor.CountQueryPostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.FirstResultPostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.FlushModePostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.HintPostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.LockModePostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.MaxResultPostProcessor;
import org.apache.deltaspike.data.impl.builder.postprocessor.OrderByQueryStringPostProcessor;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.QueryStringPostProcessor;

public class DefaultQueryResult<T>
implements QueryResult<T> {
    private final QueryBuilder builder;
    private final CdiQueryInvocationContext context;
    private int page = 0;
    private int pageSize = 10;

    public DefaultQueryResult(QueryBuilder builder, CdiQueryInvocationContext context) {
        this.builder = builder;
        this.context = context;
    }

    public <X> QueryResult<T> orderAsc(SingularAttribute<T, X> attribute) {
        return this.orderAsc(attribute, true);
    }

    public <X> QueryResult<T> orderAsc(SingularAttribute<T, X> attribute, boolean appendEntityName) {
        this.context.addQueryStringPostProcessor(new OrderByQueryStringPostProcessor(attribute, OrderDirection.ASC, appendEntityName));
        return this;
    }

    public QueryResult<T> orderAsc(String attribute) {
        return this.orderAsc(attribute, true);
    }

    public QueryResult<T> orderAsc(String attribute, boolean appendEntityName) {
        this.context.addQueryStringPostProcessor(new OrderByQueryStringPostProcessor(attribute, OrderDirection.ASC, appendEntityName));
        return this;
    }

    public <X> QueryResult<T> orderDesc(SingularAttribute<T, X> attribute) {
        return this.orderDesc(attribute, true);
    }

    public <X> QueryResult<T> orderDesc(SingularAttribute<T, X> attribute, boolean appendEntityName) {
        this.context.addQueryStringPostProcessor(new OrderByQueryStringPostProcessor(attribute, OrderDirection.DESC, appendEntityName));
        return this;
    }

    public QueryResult<T> orderDesc(String attribute) {
        return this.orderDesc(attribute, true);
    }

    public QueryResult<T> orderDesc(String attribute, boolean appendEntityName) {
        this.context.addQueryStringPostProcessor(new OrderByQueryStringPostProcessor(attribute, OrderDirection.DESC, appendEntityName));
        return this;
    }

    public <X> QueryResult<T> changeOrder(final SingularAttribute<T, X> attribute) {
        this.changeOrder(new ChangeOrder(){

            @Override
            public boolean matches(OrderByQueryStringPostProcessor orderBy) {
                return orderBy.matches(attribute);
            }

            @Override
            public void addDefault() {
                DefaultQueryResult.this.orderAsc(attribute);
            }
        });
        return this;
    }

    public QueryResult<T> changeOrder(final String attribute) {
        this.changeOrder(new ChangeOrder(){

            @Override
            public boolean matches(OrderByQueryStringPostProcessor orderBy) {
                return orderBy.matches(attribute);
            }

            @Override
            public void addDefault() {
                DefaultQueryResult.this.orderAsc(attribute);
            }
        });
        return this;
    }

    public QueryResult<T> clearOrder() {
        Iterator<QueryStringPostProcessor> it = this.context.getQueryStringPostProcessors().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof OrderByQueryStringPostProcessor)) continue;
            it.remove();
        }
        return this;
    }

    public QueryResult<T> maxResults(int max) {
        this.context.addJpaQueryPostProcessor(new MaxResultPostProcessor(max));
        this.pageSize = max;
        return this;
    }

    public QueryResult<T> firstResult(int first) {
        this.context.addJpaQueryPostProcessor(new FirstResultPostProcessor(first));
        return this;
    }

    public QueryResult<T> lockMode(LockModeType lockMode) {
        this.context.addJpaQueryPostProcessor(new LockModePostProcessor(lockMode));
        return this;
    }

    public QueryResult<T> flushMode(FlushModeType flushMode) {
        this.context.addJpaQueryPostProcessor(new FlushModePostProcessor(flushMode));
        return this;
    }

    public QueryResult<T> hint(String hint, Object value) {
        this.context.addJpaQueryPostProcessor(new HintPostProcessor(hint, value));
        return this;
    }

    public List<T> getResultList() {
        return ((Query)this.builder.executeQuery(this.context)).getResultList();
    }

    public T getSingleResult() {
        return (T)((Query)this.builder.executeQuery(this.context)).getSingleResult();
    }

    public T getOptionalResult() {
        try {
            return this.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public T getAnyResult() {
        List<T> queryResult = this.getResultList();
        return !queryResult.isEmpty() ? (T)queryResult.get(0) : null;
    }

    public long count() {
        CountQueryPostProcessor counter = new CountQueryPostProcessor();
        this.context.addJpaQueryPostProcessor(counter);
        try {
            Long result = (Long)((Query)this.builder.executeQuery(this.context)).getSingleResult();
            long l = result.intValue();
            return l;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.context.removeJpaQueryPostProcessor(counter);
        }
    }

    public QueryResult<T> withPageSize(int pageSize) {
        return this.maxResults(pageSize);
    }

    public QueryResult<T> toPage(int page) {
        this.page = page;
        return this.firstResult(this.pageSize * page);
    }

    public QueryResult<T> nextPage() {
        ++this.page;
        return this.firstResult(this.pageSize * this.page);
    }

    public QueryResult<T> previousPage() {
        this.page = this.page > 0 ? this.page - 1 : this.page;
        return this.firstResult(this.pageSize * this.page);
    }

    public int countPages() {
        return (int)Math.ceil((double)this.count() / (double)this.pageSize);
    }

    public int currentPage() {
        return this.page;
    }

    public int pageSize() {
        return this.pageSize;
    }

    private <X> QueryResult<T> changeOrder(ChangeOrder changeOrder) {
        for (QueryStringPostProcessor processor : this.context.getQueryStringPostProcessors()) {
            OrderByQueryStringPostProcessor orderBy;
            if (!(processor instanceof OrderByQueryStringPostProcessor) || !changeOrder.matches(orderBy = (OrderByQueryStringPostProcessor)processor)) continue;
            orderBy.changeDirection();
            return this;
        }
        changeOrder.addDefault();
        return this;
    }

    private static abstract class ChangeOrder {
        private ChangeOrder() {
        }

        public abstract boolean matches(OrderByQueryStringPostProcessor var1);

        public abstract void addDefault();
    }
}

