/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.result;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessor;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

@ApplicationScoped
public class QueryProcessorFactory {
    private NoOpQueryProcessor noOp;
    private ListResultQueryProcessor listResult;
    private StreamResultQueryProcessor streamResult;
    private ExecuteUpdateQueryProcessor executeUpdate;
    private SingleResultQueryProcessor singleResult;

    @PostConstruct
    public void init() {
        this.noOp = new NoOpQueryProcessor();
        this.listResult = new ListResultQueryProcessor();
        this.streamResult = new StreamResultQueryProcessor();
        this.executeUpdate = new ExecuteUpdateQueryProcessor();
        this.singleResult = new SingleResultQueryProcessor();
    }

    public QueryProcessor build(RepositoryMethodMetadata methodMetadata) {
        if (ClassUtils.returns((Method)methodMetadata.getMethod(), QueryResult.class)) {
            return this.noOp;
        }
        if (ClassUtils.returns((Method)methodMetadata.getMethod(), List.class)) {
            return this.listResult;
        }
        if (methodMetadata.isReturnsStream()) {
            return this.streamResult;
        }
        if (this.isModifying(methodMetadata)) {
            return this.executeUpdate;
        }
        return this.singleResult;
    }

    private boolean isModifying(RepositoryMethodMetadata methodMetadata) {
        boolean matchesType = Void.TYPE.equals(methodMetadata.getMethod().getReturnType()) || Integer.TYPE.equals(methodMetadata.getMethod().getReturnType()) || Integer.class.equals(methodMetadata.getMethod().getReturnType());
        return methodMetadata.getMethod().isAnnotationPresent(Modifying.class) && matchesType || methodMetadata.getMethodPrefix().isDelete();
    }

    private static final class NoOpQueryProcessor
    implements QueryProcessor {
        private NoOpQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query;
        }
    }

    private static final class ListResultQueryProcessor
    implements QueryProcessor {
        private ListResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query.getResultList();
        }
    }

    private static final class StreamResultQueryProcessor
    implements QueryProcessor {
        private boolean initialized;
        private Method getResultStreamMethod;

        private StreamResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    this.getResultStreamMethod = query.getClass().getMethod("getResultStream", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getResultStreamMethod != null) {
                try {
                    return this.getResultStreamMethod.invoke((Object)query, new Object[0]);
                }
                catch (Exception e) {
                    throw new QueryInvocationException((Throwable)e, (QueryInvocationContext)context);
                }
            }
            return query.getResultList().stream();
        }
    }

    private static final class ExecuteUpdateQueryProcessor
    implements QueryProcessor {
        private ExecuteUpdateQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query.executeUpdate();
        }
    }

    private static final class SingleResultQueryProcessor
    implements QueryProcessor {
        private SingleResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            SingleResultType style = context.getRepositoryMethodMetadata().getSingleResultType();
            Object result = null;
            switch (style) {
                case JPA: {
                    return query.getSingleResult();
                }
                case OPTIONAL: {
                    try {
                        result = query.getSingleResult();
                    }
                    catch (NoResultException noResultException) {}
                    break;
                }
                default: {
                    List queryResult = query.getResultList();
                    Object object = result = !queryResult.isEmpty() ? (Object)queryResult.get(0) : null;
                }
            }
            if (context.getRepositoryMethodMetadata().isReturnsOptional()) {
                return Optional.ofNullable(result);
            }
            return result;
        }
    }
}

