/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.param;

import jakarta.persistence.Query;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;

public abstract class Parameter {
    private static final Logger LOG = Logger.getLogger(Parameter.class.getName());
    protected Object value;
    protected Object mappedValue = null;

    public Parameter(Object value) {
        this.value = value;
    }

    public abstract void apply(Query var1);

    public abstract boolean is(String var1);

    public void applyMapper(QueryInOutMapper<?> mapper) {
        if (mapper.mapsParameter(this.value)) {
            this.mappedValue = mapper.mapParameter(this.value);
            LOG.log(Level.FINE, "Converting param {0} to {1}", new Object[]{this.value, this.mappedValue});
        }
    }

    public void updateValue(Object newValue) {
        if (this.mappedValue != null) {
            this.mappedValue = newValue;
        } else {
            this.value = newValue;
        }
    }

    protected Object queryValue() {
        return this.mappedValue != null ? this.mappedValue : this.value;
    }
}

