/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.util.jpa;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.persistence.Query;
import org.apache.deltaspike.data.impl.util.jpa.EclipseLinkEjbQueryStringExtractor;
import org.apache.deltaspike.data.impl.util.jpa.Hibernate6QueryStringExtractor;
import org.apache.deltaspike.data.impl.util.jpa.HibernateQueryStringExtractor;
import org.apache.deltaspike.data.impl.util.jpa.OpenJpaQueryStringExtractor;
import org.apache.deltaspike.data.impl.util.jpa.ProviderSpecific;
import org.apache.deltaspike.data.impl.util.jpa.QueryStringExtractor;

@ApplicationScoped
public class QueryStringExtractorFactory {
    private final QueryStringExtractor[] extractors = new QueryStringExtractor[]{new HibernateQueryStringExtractor(), new Hibernate6QueryStringExtractor(), new EclipseLinkEjbQueryStringExtractor(), new OpenJpaQueryStringExtractor()};

    public String extract(Query query) {
        for (QueryStringExtractor extractor : this.extractors) {
            String compare = extractor.getClass().getAnnotation(ProviderSpecific.class).value();
            Object implQuery = QueryStringExtractorFactory.toImplQuery(compare, query);
            if (implQuery == null) continue;
            return extractor.extractFrom(implQuery);
        }
        throw new RuntimeException("Persistence provider not supported");
    }

    private static Object toImplQuery(String clazzName, Query query) {
        try {
            Class<?> toClass = Class.forName(clazzName);
            try {
                return query.unwrap(toClass);
            }
            catch (Exception e) {
                toClass.cast(query);
                return query;
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

