/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class ObjectNameSyntaxChecker
extends SyntaxChecker {
    private static final String REGEXP = "^([a-zA-Z][a-zA-Z0-9-;]*)$";
    private static final Pattern PATTERN = Pattern.compile("^([a-zA-Z][a-zA-Z0-9-;]*)$");
    public static final ObjectNameSyntaxChecker INSTANCE = new ObjectNameSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.6");

    private ObjectNameSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        boolean result = PATTERN.matcher(strValue).matches();
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
            } else {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<ObjectNameSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.6");
        }

        @Override
        public ObjectNameSyntaxChecker build() {
            return new ObjectNameSyntaxChecker(this.oid);
        }
    }
}

