/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class RegexSyntaxChecker
extends SyntaxChecker {
    private String[] expressions;

    private RegexSyntaxChecker(String oid, String[] matchExprArray) {
        super(oid);
        this.expressions = matchExprArray;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            for (String regexp : this.expressions) {
                if (str.matches(regexp)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                }
                return false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
        }
        return true;
    }

    public String[] getExpressions() {
        if (this.expressions == null) {
            return Strings.EMPTY_STRING_ARRAY;
        }
        String[] exprs = new String[this.expressions.length];
        System.arraycopy(this.expressions, 0, exprs, 0, this.expressions.length);
        return exprs;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<RegexSyntaxChecker> {
        private String[] expressions;

        private Builder() {
            super(null);
        }

        public Builder setExpressions(String[] expressions) {
            if (expressions != null && expressions.length > 0) {
                this.expressions = new String[expressions.length];
                System.arraycopy(expressions, 0, this.expressions, 0, expressions.length);
            }
            return this;
        }

        @Override
        public RegexSyntaxChecker build() {
            return new RegexSyntaxChecker(this.oid, this.expressions);
        }
    }
}

