/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;

public class UniqueMemberNormalizer
extends Normalizer {
    private transient SchemaManager schemaManager;

    public UniqueMemberNormalizer() {
        super("2.5.13.23");
    }

    @Override
    public String normalize(String value) throws LdapException {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        if (Strings.isEmpty(value)) {
            return null;
        }
        int sharpPos = value.lastIndexOf(35);
        if (sharpPos != -1) {
            if (value.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = value.substring(sharpPos + 1);
            if (sharpPos > 0) {
                Dn dn = new Dn(this.schemaManager, value.substring(0, sharpPos));
                return dn.getNormName() + '#' + uid;
            }
            throw new IllegalStateException(I18n.err(I18n.ERR_13725_CANNOT_HANDLE_NAME_AND_OPTIONAL_UID_NORM, value.getClass()));
        }
        return new Dn(this.schemaManager, value).getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

