/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class PostalAddressSyntaxChecker
extends SyntaxChecker {
    public static final PostalAddressSyntaxChecker INSTANCE = new PostalAddressSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.41");

    private PostalAddressSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
            return true;
        }
        int pos = 0;
        do {
            String address;
            if (Strings.isEmpty((String)(address = strValue.substring(pos, dollar)))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
                }
                return false;
            }
            pos = dollar + 1;
            if (pos != strValue.length()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        } while ((dollar = strValue.indexOf(36, pos)) > -1);
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<PostalAddressSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.41");
        }

        @Override
        public PostalAddressSyntaxChecker build() {
            return new PostalAddressSyntaxChecker(this.oid);
        }
    }
}

