/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.sourceeditor;

import java.util.ArrayList;
import org.apache.directory.studio.aciitemeditor.sourceeditor.ACITextAttributeProvider;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class ACICodeScanner
extends RuleBasedScanner {
    public static final String IDENTIFICATION_TAG_PARTITION = "identificationTag";
    public static final String PRECEDENCE_PARTITION = "precedence";
    public static final String AUTHENTICATION_LEVEL_PARTITION = "authenticationLevel";
    public static final String[] ITEM_OR_USER_FIRST_SECTION_PARTITION = new String[]{"itemOrUserFirst", "itemFirst", "userFirst"};
    public static final String[] USER_SECTION = new String[]{"userClasses", "userPermissions"};
    public static final String[] ACI_KEYWORDS = new String[]{"protectedItems", "itemPermissions", "entry", "allUserAttributeTypes", "attributeType", "allAttributeValues", "allUserAttributeTypesAndValues", "attributeValue", "selfValue", "rangeOfValues", "maxValueCount", "maxImmSub", "restrictedBy", "classes", "grantsAndDenials", "allUsers", "thisEntry", "name", "userGroup", "subtree", "type", "valuesIn", "none", "simple", "strong"};
    public static final String[] ACI_GRANT_VALUES = new String[]{"grantAdd", "grantDiscloseOnError", "grantRead", "grantRemove", "grantBrowse", "grantExport", "grantImport", "grantModify", "grantRename", "grantReturnDN", "grantCompare", "grantFilterMatch", "grantInvoke"};
    public static final String[] ACI_DENY_VALUES = new String[]{"denyAdd", "denyDiscloseOnError", "denyRead", "denyRemove", "denyBrowse", "denyExport", "denyImport", "denyModify", "denyRename", "denyReturnDN", "denyCompare", "denyFilterMatch", "denyInvoke"};

    public ACICodeScanner(ACITextAttributeProvider provider) {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = new Token((Object)provider.getAttribute("__pos_aci_keyword_attribute"));
        Token undefined = new Token((Object)provider.getAttribute("__pos_aci_default_attribute"));
        Token string = new Token((Object)provider.getAttribute("__pos_aci_string_attribute"));
        Token grantValue = new Token((Object)provider.getAttribute("__pos_aci_grant_value"));
        Token denyValue = new Token((Object)provider.getAttribute("__pos_aci_deny_value"));
        Token identification = new Token((Object)provider.getAttribute("__pos_aci_identification_attribute"));
        Token precedence = new Token((Object)provider.getAttribute("__pos_aci_precedence_attribute"));
        Token authenticationLevel = new Token((Object)provider.getAttribute("__pos_aci_authenticationlevel_attribute"));
        Token itemOrUserFirst = new Token((Object)provider.getAttribute("__pos_aci_itemoruserfirst_attribute"));
        Token user = new Token((Object)provider.getAttribute("__pos_aci_user_attribute"));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\u0000', true));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\u0000', true));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        WordRule worldRule = new WordRule((IWordDetector)new AciWordDetector(), (IToken)undefined);
        String[] stringArray = ACI_KEYWORDS;
        int n = ACI_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String aciKeyword = stringArray[n2];
            worldRule.addWord(aciKeyword, (IToken)keyword);
            ++n2;
        }
        stringArray = ACI_GRANT_VALUES;
        n = ACI_GRANT_VALUES.length;
        n2 = 0;
        while (n2 < n) {
            String aciGrantValue = stringArray[n2];
            worldRule.addWord(aciGrantValue, (IToken)grantValue);
            ++n2;
        }
        stringArray = ACI_DENY_VALUES;
        n = ACI_DENY_VALUES.length;
        n2 = 0;
        while (n2 < n) {
            String aciDenyValue = stringArray[n2];
            worldRule.addWord(aciDenyValue, (IToken)denyValue);
            ++n2;
        }
        stringArray = ITEM_OR_USER_FIRST_SECTION_PARTITION;
        n = ITEM_OR_USER_FIRST_SECTION_PARTITION.length;
        n2 = 0;
        while (n2 < n) {
            String itemOrUserFirstSectionPartitionValue = stringArray[n2];
            worldRule.addWord(itemOrUserFirstSectionPartitionValue, (IToken)itemOrUserFirst);
            ++n2;
        }
        stringArray = USER_SECTION;
        n = USER_SECTION.length;
        n2 = 0;
        while (n2 < n) {
            String userSectionValue = stringArray[n2];
            worldRule.addWord(userSectionValue, (IToken)user);
            ++n2;
        }
        worldRule.addWord(IDENTIFICATION_TAG_PARTITION, (IToken)identification);
        worldRule.addWord(PRECEDENCE_PARTITION, (IToken)precedence);
        worldRule.addWord(AUTHENTICATION_LEVEL_PARTITION, (IToken)authenticationLevel);
        rules.add(worldRule);
        IRule[] param = new IRule[rules.size()];
        rules.toArray(param);
        this.setRules(param);
    }

    static class AciWordDetector
    implements IWordDetector {
        AciWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#' || c == '@' || c == '~' || c == '.' || c == '?';
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c) || c == '.' || c == '_' || c == '?' || c == '$';
        }
    }
}

