/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.UserPermission;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.UserPermissionDialog;
import org.apache.directory.studio.aciitemeditor.model.ProtectedItemWrapper;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ACIItemUserPermissionsComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private TableViewer tableViewer = null;
    private Button editButton = null;
    private Button deleteButton = null;
    private List<UserPermissionWrapper> userPermissionWrappers = new ArrayList<UserPermissionWrapper>();

    public ACIItemUserPermissionsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(Messages.getString("ACIItemUserPermissionsComposite.descripton"));
        label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        Table table = new Table(this.composite, 2048);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)tableGridData);
        table.setLinesVisible(false);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput(this.userPermissionWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemUserPermissionsComposite.this.userPermissionSelected();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ACIItemUserPermissionsComposite.this.editUserPermission();
            }
        });
    }

    private void createButtonComposite() {
        GridData deleteButtonGridData = new GridData();
        deleteButtonGridData.horizontalAlignment = 4;
        deleteButtonGridData.grabExcessHorizontalSpace = false;
        deleteButtonGridData.verticalAlignment = 1;
        deleteButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData addButtonGridData = new GridData();
        addButtonGridData.horizontalAlignment = 4;
        addButtonGridData.grabExcessHorizontalSpace = false;
        addButtonGridData.verticalAlignment = 1;
        addButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)gridLayout);
        Button addButton = new Button(buttonComposite, 0);
        addButton.setText(Messages.getString("ACIItemUserPermissionsComposite.add.button"));
        addButton.setLayoutData((Object)addButtonGridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserPermissionsComposite.this.addUserPermission();
            }
        });
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemUserPermissionsComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserPermissionsComposite.this.editUserPermission();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setText(Messages.getString("ACIItemUserPermissionsComposite.delete.button"));
        this.deleteButton.setLayoutData((Object)deleteButtonGridData);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserPermissionsComposite.this.deleteUserPermission();
            }
        });
        this.deleteButton.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setUserPermissions(Collection<UserPermission> userPermissions) {
        this.userPermissionWrappers.clear();
        for (UserPermission userPermission : userPermissions) {
            UserPermissionWrapper userPermissionWrapper = new UserPermissionWrapper(userPermission);
            this.userPermissionWrappers.add(userPermissionWrapper);
        }
        this.tableViewer.refresh();
    }

    public Collection<UserPermission> getUserPermissions() {
        ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
        for (UserPermissionWrapper userPermissionWrapper : this.userPermissionWrappers) {
            userPermissions.add(userPermissionWrapper.userPermission);
        }
        return userPermissions;
    }

    private UserPermissionWrapper getSelectedUserPermissionWrapper() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof UserPermissionWrapper) {
            return (UserPermissionWrapper)element;
        }
        return null;
    }

    private void addUserPermission() {
        UserPermissionDialog dialog = new UserPermissionDialog(this.getShell(), null, this.context);
        if (dialog.open() == 0 && dialog.getUserPermission() != null) {
            UserPermissionWrapper userPermissionWrapper = new UserPermissionWrapper(dialog.getUserPermission());
            this.userPermissionWrappers.add(userPermissionWrapper);
            this.tableViewer.refresh();
        }
    }

    private void editUserPermission() {
        UserPermissionDialog dialog;
        UserPermissionWrapper oldUserPermissionWrapper = this.getSelectedUserPermissionWrapper();
        if (oldUserPermissionWrapper != null && (dialog = new UserPermissionDialog(this.getShell(), oldUserPermissionWrapper.userPermission, this.context)).open() == 0) {
            oldUserPermissionWrapper.userPermission = dialog.getUserPermission();
            this.tableViewer.refresh();
        }
    }

    private void deleteUserPermission() {
        UserPermissionWrapper userPermissionWrapper = this.getSelectedUserPermissionWrapper();
        if (userPermissionWrapper != null) {
            this.userPermissionWrappers.remove(userPermissionWrapper);
            this.tableViewer.refresh();
        }
    }

    private void userPermissionSelected() {
        UserPermissionWrapper userPermissionWrapper = this.getSelectedUserPermissionWrapper();
        if (userPermissionWrapper == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private class UserPermissionWrapper {
        private UserPermission userPermission;

        public UserPermissionWrapper(UserPermission userPermission) {
            this.userPermission = userPermission;
        }

        public String toString() {
            if (this.userPermission == null) {
                return "<UNKNOWN>";
            }
            StringBuilder buffer = new StringBuilder();
            if (this.userPermission.getPrecedence() != null && this.userPermission.getPrecedence() > -1) {
                buffer.append('(');
                buffer.append(this.userPermission.getPrecedence());
                buffer.append(") ");
            }
            boolean isFirst = true;
            for (ProtectedItem item : this.userPermission.getProtectedItems()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(ProtectedItemWrapper.CLASS_TO_DISPLAY_MAP.get(item.getClass()));
            }
            buffer.append(": ");
            isFirst = true;
            for (GrantAndDenial gd : this.userPermission.getGrantsAndDenials()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(',');
                }
                if (gd.isGrant()) {
                    buffer.append('+');
                } else {
                    buffer.append('-');
                }
                buffer.append(gd.getMicroOperation().getName());
            }
            String result = buffer.toString();
            result = result.replace('\r', ' ');
            result = result.replace('\n', ' ');
            if (buffer.length() > 50) {
                buffer.setLength(0);
                buffer.append(result.substring(0, 25));
                buffer.append("...");
                buffer.append(result.substring(result.length() - 25, result.length()));
                return buffer.toString();
            }
            return result;
        }
    }
}

